"""
/***************************************************************************
 lineswitch
                                 A QGIS plugin
 Switches the direction of a qgis polyline.
                              -------------------
        begin                : 2011-05-04
        copyright            : (C) 2011 by Nathan Woodrow
        email                : Woodrow.Nathan@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
# Initialize Qt resources from file resources.py
import resources
# Import the code for the dialog
from lineswitchdialog import lineswitchDialog

class lineswitch:

    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface

    def initGui(self):
        # Create action that will start plugin configuration
        self.action = QAction(QIcon(":/plugins/lineswitch/icon.png"), \
            "Swap line direction", self.iface.mainWindow())
        # connect the action to the run method
        QObject.connect(self.action, SIGNAL("triggered()"), self.run)

        # Add toolbar button and menu item
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu("&Swap line direction", self.action)

    def unload(self):
        # Remove the plugin menu item and icon
        self.iface.removePluginMenu("&Swap line direction",self.action)
        self.iface.removeToolBarIcon(self.action)

    # run method that performs all the real work
    def run(self):
        layer = self.iface.mapCanvas().currentLayer()
        if layer is None:
            return
        
        for feature in layer.selectedFeatures():
            geom = feature.geometry()
            if geom.wkbType() == QGis.WKBMultiLineString:
                nodes = geom.asMultiPolyline()
                for line in nodes:
                    line.reverse()    
                newgeom = QgsGeometry.fromMultiPolyline(nodes)
                layer.changeGeometry(feature.id(),newgeom)
            
            if geom.wkbType() == QGis.WKBLineString:
                nodes = geom.asPolyline()
                nodes.reverse()    
                newgeom = QgsGeometry.fromPolyline(nodes)
                layer.changeGeometry(feature.id(),newgeom)
        self.iface.mapCanvas().refresh()
