# -*- coding: utf-8 -*-
"""
/***************************************************************************
 LinesAroundPoints
                                 A QGIS plugin
 This Plugin creates lines around a point layer
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-04-13
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Andres Herrera
        email                : t763rm3n@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os
import sys
import math
import numpy as np
from PyQt5.QtWidgets import *
from PyQt5.QtGui import *
from PyQt5.QtCore import *
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon,QValidator,QDoubleValidator
from qgis.PyQt.QtWidgets import QAction,QMessageBox, QTableWidgetItem, QHeaderView, QAbstractItemView, QProgressBar, QProgressDialog
from qgis._core import Qgis, QgsGeometry,QgsPoint, QgsFeatureRequest, QgsFeature, QgsMapLayer, QgsRasterLayer, QgsVectorLayer, QgsProject,QgsMessageLog,QgsWkbTypes,QgsCoordinateReferenceSystem,QgsVectorFileWriter,QgsField

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .lines_around_point_dialog import LinesAroundPointsDialog
import os.path


class LinesAroundPoints:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'LinesAroundPoints_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Lines around Points')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('LinesAroundPoints', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToVectorMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/lines_around_point/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Lines around Point'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginVectorMenu(
                self.tr(u'&Lines around Points'),
                action)
            self.iface.removeToolBarIcon(action)

    def createLineFeatureAroundPoint(self,x,y,distance,segments):
        lineStart = QgsPoint(x,y)
        steps=float(360/segments)
        #TODO: odd-numbered segments bug fixed
        #range(0,360,steps):
        for n in np.arange(0,360,steps): 
            alpha = (n * math.pi) / 180
            xx = x + (distance * math.cos(alpha))
            yy = y + (distance * math.sin(alpha))
            lineEnd = QgsPoint(xx,yy)   
            # create a new feature
            seg = QgsFeature()
            # add the geometry to the feature, 
            seg.setGeometry(QgsGeometry.fromPolyline([lineStart, lineEnd]))
            # add the geometry to the layer
            self.pr.addFeatures( [ seg ] )
            
    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = LinesAroundPointsDialog()
            self.dlg.inputUnits.addItem("meters", "meters")
            self.dlg.inputUnits.addItem("kilometers", "kilometers")
            self.dlg.inputUnits.addItem("feet", "feet")
            self.dlg.inputUnits.addItem("miles", "miles")
            self.dlg.inputUnits.addItem("yards", "yards")
            self.dlg.inputDistance.setText("100")
            self.dlg.inputSegments.setValue(8)

        layers = QgsProject.instance().mapLayers().values()
        self.dlg.inputLayerPoint.clear()
        self.dlg.inputDistance.setValidator(QDoubleValidator())

        sridSelected = ""
        for layer in layers:
            if layer.type() == QgsMapLayer.VectorLayer and (layer.wkbType()==QgsWkbTypes.Point or layer.wkbType() == QgsWkbTypes.MultiPoint):
                srid=layer.crs().authid()
                if not layer.crs().isGeographic(): 
                    self.dlg.inputLayerPoint.addItem(layer.name()+'['+str(srid)+']', layer)
        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            if self.dlg.inputLayerPoint.currentText()=="":
                pass
                QMessageBox.critical( None,"Error", u"Point layer must be selected from list")
            else:
                strSelectedPointLayer = self.dlg.inputLayerPoint.currentText().split('[')[0]
                sridSelected = self.dlg.inputLayerPoint.currentText().split('[')[1].split(']')[0]
                QgsMessageLog.logMessage("Layer Selected with CRS: %s" % sridSelected)
                pointLayer = QgsProject.instance().mapLayersByName(strSelectedPointLayer)[0]
                #for selected features
                if self.dlg.checkFeaturesOnly.isChecked():
                    pointFeatures = pointLayer.selectedFeatures()
                else:
                    pointFeatures = pointLayer.getFeatures(QgsFeatureRequest())

                distance = self.dlg.inputDistance.text()
                units = self.dlg.inputUnits.currentText()
                segments=self.dlg.inputSegments.value()
                
                if len(distance)>0 and segments>0:
                    if units=="meters":
                        fdistance = float(distance)
                    elif units=="kilometers":
                        fdistance = (float(distance)*1000)
                    elif units=="feet":
                        fdistance = (float(distance)*0.3048)
                    elif units=="miles":
                        fdistance = (float(distance)*1609.34)
                    elif units=="yards":
                        fdistance = (float(distance)*0.9144)
                    # create a new memory layer
                    outpuLayer=self.dlg.outputLayerLines.text()
                    
                    if outpuLayer=="":
                        outpuLayer="output_lines"
                        QgsMessageLog.logMessage("Saving memory layer using default name")
                    else:
                        QgsMessageLog.logMessage("Saving memory layer")
                    
                    lineOutputLayer = QgsVectorLayer("LineString", outpuLayer, "memory")
                    QgsMessageLog.logMessage("Output layer with CRS: %s" % sridSelected)
                    lineOutputLayer.setCrs(QgsCoordinateReferenceSystem(sridSelected))
                    
                    self.pr = lineOutputLayer.dataProvider()

                    # now loop through the features, perform geometry computation and create the lines
                    for f in pointFeatures:
                        geom = f.geometry()
                        x = geom.asPoint().x()
                        y = geom.asPoint().y()
                        #execute createLineFeatureAroundPoint function 
                        self.createLineFeatureAroundPoint(x,y,fdistance,segments)

                    # update extent of the layer (not necessary)
                    lineOutputLayer.updateExtents()  
                    # show the line  
                    QgsProject.instance().addMapLayer(lineOutputLayer)       
                    #pass
                else:
                    QMessageBox.critical( None,"Error", u"The distance must be greater than 0.1 meters")
                    pass
