"""
Linear Referencing plugin
(c) Copyright 2008 Martin Dobias

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.       
"""

from qgis.core import *
from qgis.gui import *

from PyQt4.QtCore import QSettings, QVariant, QRect, QRectF, QPoint
from PyQt4.QtGui import QPainter, QColor, QBrush, QPolygon, QMessageBox


class MeasureMarker(QgsMapCanvasItem):
	""" shows measure value for a vertex on route """
	
	def __init__(self, canvas, measure):
		QgsMapCanvasItem.__init__(self, canvas)
		self.pos = None	
		self.measure = measure
		self.setZValue(5)
		
	def setPosition(self, pos):
		if pos:
			self.pos = pos
			self.setPos(self.toCanvasCoordinates(self.pos))
			self.show()
		else:
			self.hide()
	
	def boundingRect(self):
		
		return QRectF(-1,-21, 31, 22)
		#### how to get painter? p = QPainter(self.canvas())
		#r = p.boundingRect(QRectF(), 0, "%.1f" % self.measure)
		#print "r",r.x(), r.y(), r.width(), r.height()
		#return r

	def paint(self, p, xxx, xxx2):

		p.setRenderHint(QPainter.Antialiasing)
		
		#p.drawRect(self.boundingRect())
		
		p.drawLine(QPoint(0,0), QPoint(0,-10))
		
		p.setBrush(QBrush(QColor(0,255,0)))

		width = 30
		mmm = "%.1f" % self.measure
		width += 0 if len(mmm) <= 4 else (len(mmm)-4)*8

		poly = QPolygon( [ QPoint(0,-8), QPoint(0,-20), QPoint(width,-20), QPoint(width,-8) ] )
		p.drawPolygon(poly)
		
		#r = p.boundingRect(QRectF(), 0, mmm)
		#print "r",r.x(), r.y(), r.width(), r.height()
		
		p.drawText(QPoint(0,-10), mmm)

	def updatePosition(self):
		self.setPosition(self.pos)


class RouteInfoTool(QgsMapTool):
	
	def __init__(self, mapCanvas):
		QgsMapTool.__init__(self, mapCanvas)
		self.rubberband = QgsRubberBand(self.canvas(), True)
		self.m_markers = []
		
		#self.mm = MeasureMarker(self.canvas(), 34.2)
		#self.mm.setPosition(QgsPoint(1,1))
	
	def setDatabase(self, db):
		self.db = db

	
	def canvasPressEvent(self, e):
		layer = self.canvas().currentLayer()
		
		if not self.isRoute(layer):
			return
		
		# transform from screen to map coords
		mapPoint = self.canvas().getCoordinateTransform().toMapCoordinates(e.x(), e.y())
		
		layerPoint = self.toLayerCoordinates(layer, mapPoint)

		# get search rectangle and transform it to layer's coords (if it's being projected)
		r = self.toLayerCoordinates(layer, self.searchRectangle(mapPoint))
		
		# show selection rect
		#self.rubberband.reset(True) # polygon
		#self.rubberband.addPoint(QgsPoint(r.xMinimum(),r.yMinimum()), False)
		#self.rubberband.addPoint(QgsPoint(r.xMaximum(),r.yMinimum()), False)
		#self.rubberband.addPoint(QgsPoint(r.xMaximum(),r.yMaximum()), False)
		#self.rubberband.addPoint(QgsPoint(r.xMinimum(),r.yMaximum()), True)
		
		idx_route_name = layer.dataProvider().fieldNameIndex(self.route.id_column)

		layer.select(layer.pendingAllAttributesList(), r, True, True)
		f = QgsFeature()
		flist = []
		while layer.nextFeature(f):
			flist.append(QgsFeature(f))
		
		#print "count", len(flist)
		for f in flist:
			#print "feature", f.id()
			attrs = f.attributeMap()
			# show attributes
			#for i,att in attrs.iteritems():
			#	print i,"-",str(att.toString())
			
			route_name = str(attrs[idx_route_name].toString())
			self.showFeature(route_name)
		
	def showFeature(self, route_name):
		""" display feature's measurements """
		
		# first remove old ones (deleting doesn't help as they're owned by map canvas)
		for m in self.m_markers:
			self.canvas().scene().removeItem(m)
		self.m_markers = []

		for x, y, measure in self.db.get_route_m(self.route, route_name):
			mm = MeasureMarker(self.canvas(), measure)
			mm.setPosition(QgsPoint(x,y))
			self.m_markers.append(mm)
		
		
	def searchRectangle(self, point):
		""" return search rectangle in map coords for given point (in map coords) """
		settings = QSettings()
		identifyValue, ok = settings.value("/Map/identifyRadius", QVariant(QGis.DEFAULT_IDENTIFY_RADIUS)).toDouble()
		if not ok or identifyValue <= 0:
			identifyValue = 0.50
		
		searchRadius = self.canvas().extent().width() * (identifyValue / 100.0)
		#print searchRadius

		r = QgsRectangle()
		r.setXMinimum( point.x() - searchRadius )
		r.setXMaximum( point.x() + searchRadius )
		r.setYMinimum( point.y() - searchRadius )
		r.setYMaximum( point.y() + searchRadius )
		return r
	
	
	def isRoute(self, layer):
		""" check whether a layer is a route. we're pretty picky """
		
		if not layer:
			QMessageBox.warning(self.canvas(), "error", "no layer")
			return False
		
		if layer.type() != QgsMapLayer.VectorLayer:
			QMessageBox.warning(self.canvas(), "error", "not a vector layer")
			return False
		
		#if layer.geometryType() != QGis.Line:
		#	print "not a line layer"
		#	return False
		
		if layer.providerType() != "postgres":
			QMessageBox.warning(self.canvas(), "error", "not a postgresql layer")
			return False
		
		uri = QgsDataSourceURI(layer.dataProvider().dataSourceUri())
		table_name = str(uri.table())
		
		if self.db.get_layer_geometry_type(table_name) != "LINESTRINGM":
			QMessageBox.warning(self.canvas(), "error", "not a linestringM layer")
			return False
		
		self.route = self.db.get_route_info(table_name)
		if not self.route:
			QMessageBox.warning(self.canvas(), "error", "route '%s' not found" % table_name)
			return False
		return True

