"""
Linear Referencing plugin
(c) Copyright 2008 Martin Dobias

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.       
"""

from PyQt4.QtCore import *
from PyQt4.QtGui import *

from dlgaddrouteevents_ui import Ui_DlgAddRouteEvents

from dlgdberror import DlgDbError
import postgis

from qgis.core import QgsDataSourceURI


class DlgAddRouteEvents(QDialog, Ui_DlgAddRouteEvents):

	def __init__(self, db, iface, parent=None):
		QDialog.__init__(self, parent)
		self.db = db
		self.iface = iface
		
		self.setupUi(self)
		
		self.connect(self.buttonBox, SIGNAL("accepted()"), self.onOK)
		
		#self.connect(self.cboRefRoute, SIGNAL("currentIndexChanged(int)"), self.populateRouteIds)
		self.connect(self.cboEventsTable, SIGNAL("currentIndexChanged(int)"), self.populateEventsColumns)
		
		self.connect(self.radEventsPoint, SIGNAL("clicked()"), self.updateUi)
		self.connect(self.radEventsLinear, SIGNAL("clicked()"), self.updateUi)
		
		self.populateRoutes()
		self.populateEventsTables()
		self.updateUi()
		
		# TODO: add a warning if there are no available routes or events tables
		

	
	def updateUi(self):
		""" when checked point/linear event """
		isPoint = self.radEventsPoint.isChecked()
		self.labelMeasure2.setEnabled(not isPoint)
		self.cboEventsMeasure2.setEnabled(not isPoint)
		
	
	def populateRoutes(self):	
		""" populate combo box with available routes """
		routes = self.db.list_routes_2()
		#print routes
		
		self.cboRefRoute.clear()
		for route in sorted(routes):
			self.cboRefRoute.addItem(route)
	
	
	#def populateRouteIds(self):
	#	""" populate combo box with columns of selected route """
	#	table = self.cboRefRoute.currentText()
	#	routeIds = self.db.list_table_columns(table)
	#	print routeIds
	#
	#	self.cboRouteId.clear()
	#	for routeId in routeIds:
	#		self.cboRouteId.addItem(routeId)
			
	
	def populateEventsTables(self):
		""" populate combo box with possible events tables from database """
		tables = self.db.list_aspatial_tables()
		#print tables
		
		self.cboEventsTable.clear()
		for table in sorted(tables):
			self.cboEventsTable.addItem(table)
		for table in sorted(self.db.list_spatial_tables('POINT')):
			self.cboEventsTable.addItem(table)
	
	def populateEventsColumns(self):
		""" populate combo box with events table's columns """
		table = self.cboEventsTable.currentText()
		columns = self.db.list_table_columns(table)
		#print columns
		
		self.cboEventsMeasure.clear()
		self.cboEventsMeasure2.clear()
		self.cboEventsRoute.clear()
		for column in columns:
			self.cboEventsMeasure.addItem(column)
			self.cboEventsMeasure2.addItem(column)
			self.cboEventsRoute.addItem(column)
			
		# set suggested name
		self.editOutput.setText(table+"_events")
	
	
	def onOK(self):
		""" do the SKA """
		
		route_table = self.cboRefRoute.currentText()
		route = self.db.get_route_info(route_table)
		events_table = self.cboEventsTable.currentText()
		events_route_id = self.cboEventsRoute.currentText()
		is_point = self.radEventsPoint.isChecked()
		events_measure = self.cboEventsMeasure.currentText()
		events_measure2 = self.cboEventsMeasure2.currentText()
		create_table = self.radCreateTable.isChecked()
		output = self.editOutput.text()

		pk = self.db.get_table_primary_key(events_table)
		out_geom = "geom_event"

		if not create_table:
			if pk == None or pk == "":
				QMessageBox.critical(self, "error", u"No valid primary key found in table '%s', unable to load the events as dynamic layer" % events_table)
				return

		else:
			if self.db.table_exists(output):
				QMessageBox.critical(self, "error", "The output table exists already!")
				return
		
			if not route:
				QMessageBox.critical(self, "error", "Couldn't find info about route '%s'" % route_table)
				return
		
			# LEGACY CODE
			# find out route's geometry column
			#route_route_id = self.cboRouteId.currentText()
			#route_geom_column = self.db.get_route_geom_column(route_table)
			#route = postgis.Route(route_table, route_route_id, route_geom_column)
		
			QApplication.instance().setOverrideCursor(QCursor(Qt.WaitCursor))

			try:
				if is_point:
					self.db.create_table_with_located_points(route, events_table, events_route_id, events_measure, output)
				else:
					self.db.create_table_with_located_lines(route, events_table, events_route_id, events_measure, events_measure2, output)
			except postgis.DatabaseError, e:
				QApplication.instance().restoreOverrideCursor()
				DlgDbError.showError(e)
				return
	
			QApplication.instance().restoreOverrideCursor()
		
		# load new layer
		uri = QgsDataSourceURI()
		uri.setConnection(self.db.host, str(self.db.port), self.db.dbname, self.db.user, self.db.passwd)

		if create_table:
			# load the previous created table
			uri.setDataSource('public', output, out_geom)

		else:
			# use a query to load the layer
			data = {
				'r_geom' : self.db._quote(route.geom_column),
				'ev_m' : self.db._quote(events_measure),
				'ev_m_start' : self.db._quote(events_measure),
				'ev_m_end' : self.db._quote(events_measure2),
				'ev_table' : self.db._quote(events_table),
				'r_table' : self.db._quote(route.table),
				'ev_road_name' : self.db._quote(events_route_id),
				'r_road_name' : self.db._quote(route.id_column), 
				'out_geom' : self.db._quote(out_geom), 
			}

			if is_point:
				sql = """SELECT p.*, ST_locate_along_measure(r.%(r_geom)s, p.%(ev_m)s) AS %(out_geom)s 
FROM %(ev_table)s AS p, %(r_table)s AS r WHERE lower(p.%(ev_road_name)s) = lower(r.%(r_road_name)s)""" % data

			else:
				sql = """SELECT l.*, ST_locate_between_measures(r.%(r_geom)s, LEAST(l.%(ev_m_start)s,l.%(ev_m_end)s), GREATEST(l.%(ev_m_start)s,l.%(ev_m_end)s)) AS %(out_geom)s 
FROM %(ev_table)s AS l, %(r_table)s AS r  WHERE lower(l.%(ev_road_name)s) = lower(r.%(r_road_name)s)""" % data

			uri.setDataSource('', u"(%s\n)" % sql, out_geom, '', pk)

		self.iface.addVectorLayer(uri.uri(), output, "postgres")
		
		self.accept()
