# -*- coding: utf-8 -*-
"""
/***************************************************************************
 LidarTileMaker
                                 A QGIS plugin
 The plugin creates a vector file containing the polygons of the tiles of a lidar campaign starting from the raster data (DSM and DTM).
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-07-01
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Gter srl
        email                : assistenzagis@gter.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication, QDir
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QAction, QFileDialog, QMessageBox, QProgressBar, QDialog, QCheckBox
from qgis.gui import QgsMessageBar, QgsProjectionSelectionDialog
from qgis.core import *
from qgis.core import QgsMapLayerProxyModel
from qgis.utils import *
from qgis.analysis import QgsRasterCalculator, QgsRasterCalculatorEntry
import processing
from osgeo import gdal,ogr,osr
import os
import tempfile
import shutil
# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .lidar_tile_maker_dialog import LidarTileMakerDialog
import os.path
import numpy as np
import webbrowser

class LidarTileMaker:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'LidarTileMaker_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Lidar Tile Maker')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        #self.first_start = None
        
        self.pluginIsActive = False
        
        self.ext = []
        self.layer = ''
        self.dsm_path_folder = ''
        self.dtm_path_folder = ''
        self.tile_path_folder = ''
        self.demselectedcrs = ''
        self.tileselectedcrs = ''
        self.dem_code = ''
        self.tile_code = ''
        self.tile_out_tempdir = ''
        self.annoText = 0
        self.enteText = ''

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('LidarTileMaker', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/lidar_tile_maker/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'LIDAR tiles from DSM/DTM'),
            callback=self.pressIcon,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Lidar Tile Maker'),
                action)
            self.iface.removeToolBarIcon(action)
            
    def pressIcon(self):
        if not self.pluginIsActive:
            self.pluginIsActive = True
            self.dlg = LidarTileMakerDialog()

            self.dlg.OutFolderButton.clicked.connect(self.exportTileButton)
            self.dlg.DSMpushButton.clicked.connect(self.importDsmButton)
            self.dlg.DTMpushButton.clicked.connect(self.importDtmButton)
            self.dlg.InputCrsButton.clicked.connect(self.crsDemButton)
            self.dlg.OutputCrsButton.clicked.connect(self.crsTileButton)
            self.dlg.InputEnte.textChanged.connect(self.handleEnte)
            self.dlg.InputYear.valueChanged.connect(self.handleAnno)
            self.dlg.clearButton.clicked.connect(self.clearButton)
            self.dlg.helpButton.clicked.connect(self.openHelpButton)
            self.dlg.pushButtonOk.clicked.connect(self.run)
            self.dlg.rejected.connect(self.closePlugin)
            
            #self.prepRun()
            self.dlg.show()
        else:
            self.dlg.show()
            self.dlg.activateWindow()
            
    def closePlugin(self):
    
        print("** CLOSING Plugin **")
    
        self.dlg.OutFolderButton.clicked.disconnect(self.exportTileButton)
        self.dlg.DSMpushButton.clicked.disconnect(self.importDsmButton)
        self.dlg.DTMpushButton.clicked.disconnect(self.importDtmButton)
        self.dlg.InputCrsButton.clicked.disconnect(self.crsDemButton)
        self.dlg.OutputCrsButton.clicked.disconnect(self.crsTileButton)
        self.dlg.InputEnte.textChanged.disconnect(self.handleEnte)
        self.dlg.InputYear.valueChanged.disconnect(self.handleAnno)
        self.dlg.clearButton.clicked.disconnect(self.clearButton)
        self.dlg.helpButton.clicked.disconnect(self.openHelpButton)
        self.dlg.pushButtonOk.clicked.disconnect(self.run)
        self.dlg.rejected.disconnect(self.closePlugin)
        
        self.pluginIsActive = False
        
        self.ext = []
        self.layer = ''
        self.dsm_path_folder = ''
        self.dtm_path_folder = ''
        self.tile_path_folder = ''
        self.demselectedcrs = ''
        self.tileselectedcrs = ''
        self.dem_code = ''
        self.tile_code = ''
        self.annoText = 0
        self.enteText = ''
        if self.tile_out_tempdir != '':
            self.tile_out_tempdir.cleanup()
        
        from qgis.utils import reloadPlugin
        reloadPlugin("LidarTileMaker")
            
    def importDsmButton(self):
        self.dsm_folder = QFileDialog.getExistingDirectory()
        self.dsm_path_folder = QDir.toNativeSeparators(self.dsm_folder)
        print (self.dsm_folder)
        dsm_txt_folder = self.dlg.ImportDsm.setText(self.dsm_path_folder) #scrive semplicemente la url nel form della gui
        #print (dsm_sel_folder)
        #return dsm_folder
        
    def importDtmButton(self):
        self.dtm_folder = QFileDialog.getExistingDirectory()
        self.dtm_path_folder = QDir.toNativeSeparators(self.dtm_folder)
        print (self.dtm_folder)
        print (self.dtm_path_folder)
        dtm_txt_folder = self.dlg.ImportDtm.setText(self.dtm_path_folder) #scrive semplicemente la url nel form della gui
        #print (dsm_sel_folder)
        #return dsm_folder
        
    def exportTileButton(self):
        self.tile_folder = QFileDialog.getExistingDirectory()
        self.tile_path_folder = QDir.toNativeSeparators(self.tile_folder)
        print (self.tile_folder)
        print (self.tile_path_folder)
        tile_txt_folder = self.dlg.outFolder.setText(self.tile_path_folder) #scrive semplicemente la url nel form della gui
        
    def crsDemButton(self):
        self.crs_select = QgsProjectionSelectionDialog()
        self.crs_select.exec_()
        self.selectedcrsdef = self.crs_select.crs()
        print(self.selectedcrsdef)
        self.demselectedcrs = self.selectedcrsdef.authid()
        print(self.demselectedcrs)
        if self.demselectedcrs != '':
            self.dem_epsg_code = self.demselectedcrs.split(":")
            print(self.dem_epsg_code)
            self.dem_code = self.dem_epsg_code[1]
            print(self.dem_code)
        else:
            self.dem_epsg_code = ''
            print(self.dem_epsg_code)
            self.dem_code = ''
            print(self.dem_code)
            
    def crsTileButton(self):
        self.crs_select = QgsProjectionSelectionDialog()
        self.crs_select.exec_()
        self.selectedcrsdef = self.crs_select.crs()
        print(self.selectedcrsdef)
        self.tileselectedcrs = self.selectedcrsdef.authid()
        print(self.tileselectedcrs)
        if self.tileselectedcrs != '':
            self.tile_epsg_code = self.tileselectedcrs.split(":")
            print(self.tile_epsg_code)
            self.tile_code = self.tile_epsg_code[1]
            print(self.tile_code)
        else:
            self.tile_epsg_code = ''
            print(self.tile_epsg_code)
            self.tile_code = ''
            print(self.tile_code)
            
    # when translation will be available uncomment this function       
    def openHelpButton(self):
        if QgsSettings().value('locale/userLocale') == 'it':
            webbrowser.open('https://lidar-tile-maker-manuale.readthedocs.io/it/latest/')
        elif QgsSettings().value('locale/userLocale') == 'es':
            webbrowser.open('https://lidar-tile-maker-manuale.readthedocs.io/es/latest/')
        else:
            webbrowser.open('https://lidar-tile-maker-manuale.readthedocs.io/en/latest/')
            
    # def openHelpButton(self):
        # webbrowser.open('https://lidar-tile-maker-manuale.readthedocs.io/en/latest/')
            
    def handleEnte(self, val):
        self.enteText = val
        print(self.enteText)
        
    def handleAnno(self, val):
        self.annoText = val
        print(self.annoText)
        
    def clearButton(self):
        self.dlg.textLog.clear()
            
    def GetExtent(self, gt, cols, rows):
        self.ext = []
        xarr=[0,cols]
        #print(xarr)
        yarr=[0,rows]
        #print(yarr)
        for px in xarr:
            for py in yarr:
                x=gt[0]+(px*gt[1])+(py*gt[2])
                #print(x)
                y=gt[3]+(px*gt[4])+(py*gt[5])
                #print(y)
                self.ext.append([x,y])
            yarr.reverse()
        #append the first couple of coordinates to the list in order to have a closed polygon
        self.ext.append(self.ext[0])
        print (self.ext)
        #print([x,y])
        return self.ext
        
    def create_polygon(self, coords):
        ring = ogr.Geometry(ogr.wkbLinearRing)
        for coord in coords:
            ring.AddPoint(coord[0], coord[1])

        # Create polygon
        poly = ogr.Geometry(ogr.wkbPolygon)
        poly.AddGeometry(ring)
        #print(poly.ExportToWkt())
        return poly.ExportToWkt()
        
    def write_line_shapefile(self, defn, px_size, polys_dtm, file_name_dtm, file_name_dsm, p_base_txt, p_dtm_txt, p_dsm_txt, p_camp_txt, file_format):
        # Create a new feature (attribute and geometry)
        feat = ogr.Feature(defn)
        # feat.SetField('id', 123)
        # Make a geometry, from Shapely object
        geom = ogr.CreateGeometryFromWkt(polys_dtm)
        feat.SetGeometry(geom)
        feat.SetField('RISOLUZ_RA', px_size)
        feat.SetField('N_DTM', file_name_dtm)
        feat.SetField('N_DSM', file_name_dsm)
        feat.SetField('P_BASE', p_base_txt)
        feat.SetField('P_DTM', p_dtm_txt)
        feat.SetField('P_DSM', p_dsm_txt)
        feat.SetField('P_CAMPAGNA', p_camp_txt)
        feat.SetField('FORMATO', file_format)
        feat.SetField('ENTE', self.enteText)
        feat.SetField('ANNO', self.annoText)
        feat.SetField('SR_EPSG', int(self.dem_code))
        feat.SetField('COMPRESSIO', 'no')
        #print(file)
        self.layer.CreateFeature(feat)
        
    def reprojectGpkg(self, temp_out_geop, out_shp):
        tile_repr_temppathfile = os.path.join(self.tile_out_tempdir.name, 'tile_dsm_dtm.gpkg')
        if self.dem_code != self.tile_code:
            print('sto riproiettando')
            processing.run("native:reprojectlayer", {'INPUT': temp_out_geop,
                    'TARGET_CRS': None,
                    'TARGET_CRS': self.tileselectedcrs,
                    'OUTPUT': tile_repr_temppathfile})
                    
            shutil.move(tile_repr_temppathfile, out_shp)
        else:
            shutil.move(temp_out_geop, out_shp)
        

    def run(self):
        """Run method that performs all the real work"""
        self.dlg.textLog.setText(self.tr('PROCESS STARTED...\n'))
        QCoreApplication.processEvents()
        # Check input parameters
        
        if self.dsm_path_folder == '':
            self.dlg.textLog.append(self.tr('ERROR: no DSM input folder has been selected\n'))
            return
            
        if self.dtm_path_folder == '':
            self.dlg.textLog.append(self.tr('ERROR: no DTM input folder has been selected\n'))
            return
        
        if self.demselectedcrs == '':
            self.dlg.textLog.append(self.tr('ERROR: no CRS has been selected for input DSM and DTM\n'))
            return
            
        if self.tileselectedcrs == '':
            self.dlg.textLog.append(self.tr('WARNING: no CRS has been selected for the Vector Tile Layer. The DSM/DTM CRS will be used\n'))
            QCoreApplication.processEvents()
            self.tileselectedcrs = self.demselectedcrs
            self.tile_code = self.dem_code
            
        if self.enteText == '':
            self.dlg.textLog.append(self.tr('WARNING: no Authority has been specified. The related field will be empty\n'))
            QCoreApplication.processEvents()
            
        if self.annoText == 0:
            self.dlg.textLog.append(self.tr('WARNING: no Year has been specified. The related field will be empty\n'))
            QCoreApplication.processEvents()
            self.annoText = None
        
        # Run the dialog event loop
        result = True
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            #chm_out_tempdir = tempfile.TemporaryDirectory()
            # print(self.demselectedcrs)
            # print(self.tileselectedcrs)
            # print(self.tile_code)
            # print(self.dem_code)
            if self.tile_out_tempdir == '':
                self.tile_out_tempdir = tempfile.TemporaryDirectory()
            else:
                self.tile_out_tempdir.cleanup()
                self.tile_out_tempdir = tempfile.TemporaryDirectory()
                
            #check if both folders aren't empty
            if os.listdir(self.dtm_path_folder) and os.listdir(self.dsm_path_folder):
                p_base_t = "/".join(self.dtm_folder.split('/')[:-2])
                p_base_txt = QDir.toNativeSeparators(p_base_t) + os.path.sep
                p_dtm_txt = os.path.sep + os.path.basename(self.dtm_path_folder)
                dir_camp = os.path.dirname(self.dtm_path_folder)
                p_camp_txt = os.path.basename(dir_camp)
                p_dsm_txt = os.path.sep + os.path.basename(self.dsm_path_folder)
                temp_out_geop = os.path.join(self.tile_out_tempdir.name, 'temp_tile_dsm_dtm.gpkg')
                polys_dtm = []
                file_name_dtm = []
                file_format = []
                dict_dtm = {}
                check_dtm = 0
                for dtm in os.listdir(self.dtm_path_folder):
                    path_all_dtm = os.path.join(self.dtm_path_folder, dtm)
                    if os.path.isfile(path_all_dtm):
                        name_dtm = dtm.split('.')
                        print(name_dtm[0])
                        files_dtm = [p for p in os.listdir(self.dtm_path_folder) if p.startswith(name_dtm[0])]
                        print(files_dtm)
                        size_dtm = []
                        for p in files_dtm:
                            final_path_dtm = os.path.join(self.dtm_path_folder, p)
                            stats_dtm = os.path.getsize(final_path_dtm)
                            size_dtm.append(stats_dtm)
                            #print(size)
                            #print(stats)
                        print(size_dtm)
                        #print(max(size))
                        idx_dtm = np.argmax(size_dtm)
                        print(files_dtm[idx_dtm])
                        max_file_dtm = files_dtm[idx_dtm]
                        path_dtm = os.path.join(self.dtm_path_folder, max_file_dtm)
                        if dtm == max_file_dtm:
                        #if os.path.isfile(path):
                            try:
                                #print(max_file)
                                #print(path)
                                datafile = gdal.Open(path_dtm)
                                gt = datafile.GetGeoTransform()
                                #print (gt)
                                px_size = gt[1]
                                cols = datafile.RasterXSize
                                rows = datafile.RasterYSize
                                self.ext = self.GetExtent(gt,cols,rows)
                                print(self.ext)
                                poly = self.create_polygon(self.ext)
                                polys_dtm.append(poly)
                                file_name_dtm.append(max_file_dtm)
                                format = max_file_dtm.split('.')
                                file_format.append(format[1].lower())
                                dict_dtm[file_name_dtm[-1]] = (polys_dtm[-1], file_format[-1])
                                check_dtm = 1
                            except:
                                print('non riesco ad aprire il file')
                    else:
                        self.dlg.textLog.append(self.tr("WARNING: Unable to open item named '{}', it is not a file. Chek the input DTM folder\n").format(dtm))
                        QCoreApplication.processEvents()
                if check_dtm == 0:
                    self.dlg.textLog.append(self.tr('ATTENTION! No DTM file have been found. Chek the input DTM folder\n'))
                    QCoreApplication.processEvents()
                    return
                print(file_name_dtm)
                polys_dsm = []
                file_name_dsm = []
                dict_dsm = {}
                check_dsm = 0
                #print('for dsm')
                for dsm in os.listdir(self.dsm_path_folder):
                    path_all_dsm = os.path.join(self.dsm_path_folder, dsm)
                    if os.path.isfile(path_all_dsm):
                        name_dsm = dsm.split('.')
                        print(name_dsm[0])
                        files_dsm = [p for p in os.listdir(self.dsm_path_folder) if p.startswith(name_dsm[0])]
                        print(files_dsm)
                        size_dsm = []
                        for p in files_dsm:
                            final_path_dsm = os.path.join(self.dsm_path_folder, p)
                            stats_dsm = os.path.getsize(final_path_dsm)
                            size_dsm.append(stats_dsm)
                            #print(size)
                            #print(stats)
                        print(size_dsm)
                        #print(max(size))
                        idx_dsm = np.argmax(size_dsm)
                        print(files_dsm[idx_dsm])
                        max_file_dsm = files_dsm[idx_dsm]
                        path_dsm = os.path.join(self.dsm_path_folder, max_file_dsm)
                        if dsm == max_file_dsm:
                            #if os.path.isfile(path):
                            try:
                                datafile = gdal.Open(path_dsm)
                                #prj = datafile.GetProjection()
                                #print(prj)
                                gt = datafile.GetGeoTransform()
                                #print (gt)
                                px_size = gt[1]
                                cols = datafile.RasterXSize
                                rows = datafile.RasterYSize
                                self.ext = self.GetExtent(gt,cols,rows)
                                print(self.ext)
                                poly = self.create_polygon(self.ext)
                                polys_dsm.append(poly)
                                file_name_dsm.append(max_file_dsm)
                                print(max_file_dsm)
                                dict_dsm[file_name_dsm[-1]] = (polys_dsm[-1])
                                check_dsm = 1
                            except:
                                print('non riesco ad aprire il file')
                    else:
                        self.dlg.textLog.append(self.tr("WARNING: Unable to open item named '{}', it is not a file. Chek the input DSM folder\n").format(dsm))
                        QCoreApplication.processEvents()
                print(file_name_dsm)
                if check_dsm == 0:
                    self.dlg.textLog.append(self.tr('ATTENTION! No DSM file have been found. Chek the input DSM folder\n'))
                    QCoreApplication.processEvents()
                    return

                # qua la parte di creazione shape
                # Save a new GeoPackage
                driver = ogr.GetDriverByName('GPKG')
                ds = driver.CreateDataSource(temp_out_geop)
                # Create the output GeoPackage
                dest_srs = osr.SpatialReference()
                dest_srs.ImportFromEPSG(int(self.dem_code))
                self.layer = ds.CreateLayer('tile_dsm_dtm', dest_srs, ogr.wkbPolygon)
                # Add attributes
                ente = ogr.FieldDefn('ENTE', ogr.OFTString)
                ente.SetWidth(200)
                self.layer.CreateField(ente)
                anno = ogr.FieldDefn('ANNO', ogr.OFTInteger)
                self.layer.CreateField(anno)
                formato = ogr.FieldDefn('FORMATO', ogr.OFTString)
                formato.SetWidth(25)
                self.layer.CreateField(formato)
                compress = ogr.FieldDefn('COMPRESSIO', ogr.OFTString)
                compress.SetWidth(20)
                self.layer.CreateField(compress)
                srs_d = ogr.FieldDefn('SR_EPSG', ogr.OFTString)
                srs_d.SetWidth(10)
                self.layer.CreateField(srs_d)
                p_base = ogr.FieldDefn('P_BASE', ogr.OFTString)
                p_base.SetWidth(200)
                self.layer.CreateField(p_base)
                p_camp = ogr.FieldDefn('P_CAMPAGNA', ogr.OFTString)
                p_camp.SetWidth(200)
                self.layer.CreateField(p_camp)
                p_dtm = ogr.FieldDefn('P_DTM', ogr.OFTString)
                p_dtm.SetWidth(200)
                self.layer.CreateField(p_dtm)
                p_dsm = ogr.FieldDefn('P_DSM', ogr.OFTString)
                p_dsm.SetWidth(200)
                self.layer.CreateField(p_dsm)
                n_dtm = ogr.FieldDefn('N_DTM', ogr.OFTString)
                n_dtm.SetWidth(200)
                self.layer.CreateField(n_dtm)
                n_dsm = ogr.FieldDefn('N_DSM', ogr.OFTString)
                n_dsm.SetWidth(200)
                self.layer.CreateField(n_dsm)
                p_chm = ogr.FieldDefn('P_CHM', ogr.OFTString)
                p_chm.SetWidth(200)
                self.layer.CreateField(p_chm)
                n_chm = ogr.FieldDefn('N_CHM', ogr.OFTString)
                n_chm.SetWidth(200)
                self.layer.CreateField(n_chm)
                srs_c = ogr.FieldDefn('EPSG_CHM', ogr.OFTString)
                srs_c.SetWidth(200)
                self.layer.CreateField(srs_c)
                ris = ogr.FieldDefn('RISOLUZ_RA', ogr.OFTReal)
                ris.SetWidth(10)
                ris.SetPrecision(3)
                self.layer.CreateField(ris)

                defn = self.layer.GetLayerDefn()

                if len(polys_dtm) != len(polys_dsm):
                    self.dlg.textLog.append(self.tr('NB: the number of DTM and DSM file is different, only the tile with both DTM and DSM will be created\n'))
                    QCoreApplication.processEvents()
                
                i=0
                check_poly = 0
                count_tile = 0
                while i< len(polys_dtm):
                    k = 0
                    while k< len(polys_dsm):
                        if(polys_dtm[i]==polys_dsm[k]):
                            self.write_line_shapefile(defn, px_size, polys_dtm[i], file_name_dtm[i], file_name_dsm[k], p_base_txt, p_dtm_txt, p_dsm_txt, p_camp_txt, file_format[i])
                            check_poly = 1
                            count_tile+=1
                        k+=1
                    i+=1
                if check_poly == 0:
                    self.dlg.textLog.append(self.tr('ATTENTION! Impossible to create tiles polygons. Check DSM and DTM files, probably they have different extensions\n'))
                    QCoreApplication.processEvents()
                elif count_tile != len(polys_dtm) and count_tile != len(polys_dsm):
                    self.dlg.textLog.append(self.tr('ATTENTION! There are {} DTM and {} DSM but only {} DTM/DSM with the same extention have been found. Check the raster file extentions\n').format(len(polys_dtm), len(polys_dsm), count_tile))
                    QCoreApplication.processEvents()
                
                #chiudo lo shapefile
                feat = geom = None  # destroy these

                # Save and close everything
                ds = self.layer = feat = geom = None
                
                out_shp = os.path.join(self.tile_path_folder, 'tile_dsm_dtm.gpkg')
                self.reprojectGpkg(temp_out_geop, out_shp)
                tile_lyr = QgsVectorLayer(out_shp, 'tile_dsm_dtm')
                QgsProject.instance().addMapLayers([tile_lyr])
                
            else:
                if len(os.listdir(self.dtm_path_folder)) == 0 and len(os.listdir(self.dsm_path_folder)) != 0:
                    self.dlg.textLog.append(self.tr('ATTENTION! Impossible to create Tile Vector Layer, the input DTM folder is empty\n'))
                    QCoreApplication.processEvents()
                elif len(os.listdir(self.dtm_path_folder)) != 0 and len(os.listdir(self.dsm_path_folder)) == 0:
                    self.dlg.textLog.append(self.tr('ATTENTION! Impossible to create Tile Vector Layer, the input DSM folder is empty\n'))
                    QCoreApplication.processEvents()
                elif len(os.listdir(self.dtm_path_folder)) == 0 and len(os.listdir(self.dsm_path_folder)) == 0:
                    self.dlg.textLog.append(self.tr('ATTENTION! Impossible to create Tile Vector Layer, the input DSM and DTM folders are empty\n'))
                    QCoreApplication.processEvents()
            
            self.dlg.textLog.append(self.tr('PROCESS FINISHED...\n'))
            QCoreApplication.processEvents()
