# -*- coding: utf-8 -*-
"""
/***************************************************************************
 LidarCampaniaDialog
                                 A QGIS plugin
 importazione dati lidar Campania
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2021-11-29
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Enzo Cocca
        email                : enzo.ccc@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtWidgets import QDialog, QFileDialog, QMessageBox, QApplication
from qgis.PyQt.QtCore import QSettings
from qgis.core import QgsProject, QgsVectorLayer, QgsRasterLayer, QgsSettings, QgsCoordinateReferenceSystem
from osgeo import gdal

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'lidar_campania_dialog_base.ui'))


class LidarCampaniaDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(LidarCampaniaDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.toolButton.clicked.connect(self.setPath)

    def setPath(self):
        s = QgsSettings()
        dbpath = QFileDialog.getSaveFileName(
            self,
            "Set file name",
            '',
            " VRT (*.vrt)"
        )[0]
        if dbpath:
            self.lineEdit.setText(dbpath)
            s.setValue('lidar_campania/last_path', dbpath)

    def on_pushButton_2_pressed(self):
        plugin_path = os.path.dirname(os.path.realpath(__file__))
        file_ = os.path.join(plugin_path, 'quadro_unione_lidar_dsm.shp')
        layer = QgsVectorLayer(file_, "quadro_unione_lidar_dsm", "ogr")
        if layer.isValid():
            QgsProject.instance().addMapLayer(layer)
        else:
            QMessageBox.warning(
                self,
                "Errore",
                "Impossibile caricare il layer quadro_unione_lidar_dsm.shp",
                QMessageBox.StandardButton.Ok
            )

    def on_pushButton_pressed(self):
        # Check if layer exists
        layers = QgsProject.instance().mapLayersByName('quadro_unione_lidar_dsm')
        if not layers:
            QMessageBox.warning(
                self,
                "Errore",
                "Layer 'quadro_unione_lidar_dsm' non trovato. Caricalo prima.",
                QMessageBox.StandardButton.Ok
            )
            return

        layer = layers[0]
        selection = layer.selectedFeatures()

        if not selection:
            QMessageBox.warning(
                self,
                "BENVENUTO",
                "Non hai selezionato nessun elemento nel map canvas",
                QMessageBox.StandardButton.Ok
            )
            return

        # Check output path
        path = self.lineEdit.text()
        if not path:
            QMessageBox.warning(
                self,
                "Errore",
                "Seleziona prima un percorso per il file VRT di output",
                QMessageBox.StandardButton.Ok
            )
            return

        url_list = []
        total = len(selection)
        errors = []

        for i, feat in enumerate(selection):
            try:
                url = feat['url']
                if url:
                    url_list.append(url)
                # Update progress bar
                value = int(((i + 1) / total) * 100)
                self.progress_bar.setValue(value)
                QApplication.processEvents()
            except Exception as e:
                errors.append(f"Feature {i}: {str(e)}")

        self.progress_bar.reset()

        if not url_list:
            QMessageBox.warning(
                self,
                "Errore",
                "Nessun URL valido trovato nelle feature selezionate",
                QMessageBox.StandardButton.Ok
            )
            return

        # Build VRT
        try:
            vrt_options = gdal.BuildVRTOptions(resampleAlg='nearest')
            vrt_dataset = gdal.BuildVRT(path, url_list, options=vrt_options)
            if vrt_dataset is None:
                raise Exception("BuildVRT ha restituito None")
            vrt_dataset.FlushCache()
            vrt_dataset = None  # Close the dataset
        except Exception as e:
            QMessageBox.critical(
                self,
                "Errore",
                f"Errore nella creazione del VRT:\n{str(e)}",
                QMessageBox.StandardButton.Ok
            )
            return

        # Load the result
        try:
            raster_layer = QgsRasterLayer(path, 'lidar_merge')
            if raster_layer.isValid():
                QgsProject.instance().addMapLayer(raster_layer)
                msg = f"Dati caricati correttamente!\n{len(url_list)} tile processati."
                if errors:
                    msg += f"\n\nErrori durante il download ({len(errors)}):\n" + "\n".join(errors[:5])
                    if len(errors) > 5:
                        msg += f"\n... e altri {len(errors) - 5} errori"
                QMessageBox.information(
                    self,
                    "Completato",
                    msg,
                    QMessageBox.StandardButton.Ok
                )
            else:
                QMessageBox.warning(
                    self,
                    "Errore",
                    "Il file VRT e stato creato ma il layer non e valido",
                    QMessageBox.StandardButton.Ok
                )
        except Exception as e:
            QMessageBox.critical(
                self,
                "Errore",
                f"Errore nel caricamento del layer:\n{str(e)}",
                QMessageBox.StandardButton.Ok
            )

    def set_project_crs(self):
        # Set CRS to EPSG:32633 (UTM zone 33N)
        QgsProject.instance().setCrs(QgsCoordinateReferenceSystem('EPSG:32633'))
