# -*- coding: utf-8 -*-
"""
/***************************************************************************
 LidarCampaniaDialog
                                 A QGIS plugin
 importazione dati lidar Campania
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2021-11-29
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Enzo Cocca
        email                : enzo.ccc@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtGui import *
from qgis.PyQt.QtCore import *
from qgis.PyQt.QtWidgets import *
from qgis.utils import iface
from qgis.core import *
from osgeo import gdal
# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'lidar_campania_dialog_base.ui'))


class LidarCampaniaDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(LidarCampaniaDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.toolButton.clicked.connect(self.setPath)
    def setPath(self):
        s = QgsSettings()
        dbpath = QFileDialog.getSaveFileName(
            self,
            "Set file name",
            '',
            " VRT (*.vrt)"
        )[0]
        if dbpath:
            self.lineEdit.setText(dbpath)
            s.setValue('',dbpath)
    def on_pushButton_2_pressed(self):
            plugin_path = os.path.dirname(os.path.realpath(__file__))
            
            file_=os.path.join(plugin_path,'quadro_unione_lidar_dsm.shp')
            a= QgsVectorLayer(file_, "quadro_unione_lidar_dsm", "ogr")
            QgsProject().instance().addMapLayer(a)
    def on_pushButton_pressed(self):
        layer =sourceLYR = QgsProject.instance().mapLayersByName('quadro_unione_lidar_dsm')[0] #iface.activeLayer()
        selection = layer.selectedFeatures()
        if not selection:
            QMessageBox.warning(self,"BENVENUTO", "Non hai selezionato nessun elemento nel map canvas",
                                        QMessageBox.Ok)
        
        else:
            # try:
                # groupName="Lidar"
                # root = QgsProject.instance().layerTreeRoot()
                # group = root.addGroup(groupName)
                # group.setExpanded(False)
            list=[]
            for d in range(len(selection)):
                d=d
            for feat in selection:
                a=feat['url'].split('/')[-1]                
                s=QgsRasterLayer(feat['url'],'lidar_{}'.format(a).replace('.asc',''),'gdal')
                #t=group.insertChildNode(-1, QgsLayerTreeLayer(s))
                #QgsProject().instance().addMapLayer(s)
                value = (float(d)/float(len(selection)))*100
                self.progress_bar.setValue(value)
                QApplication.processEvents()
                list.append(feat['url'])
                    #QMessageBox.warning(self, "Errore",  str(list),  QMessageBox.Ok)
            # except Exception as e :
                # QMessageBox.warning(self, "Errore", "Error ! \n"+ str(e),  QMessageBox.Ok)
                # return 0
            self.progress_bar.reset()
            #source = QgsRasterLayer(a.source(),'raster','gdal')
            try:
                path = self.lineEdit.text() 
                t= gdal.BuildVRT(path, list)#execute("gdal_merge.py -n 0 -a_nodata 0 -of GTiff -o lidar_merge.tif {}".format(str(list)))
                t.FlushCache()
                
            except KeyError as p:
                print("something goes wrong : {}".format(p))
            
            try:
                n=QgsRasterLayer(path,'lidar_merge')
                if n.isValid():
                    QgsProject().instance().addMapLayer(n)
                    # QTimer.singleShot(10, self.set_project_crs())
                    QMessageBox.information(self, "Message", "Data Loaded")
            except:
                pass
            
    def set_project_crs(self):
        # Set CRS to EPSG:4326
        QgsProject.instance().setCrs(QgsCoordinateReferenceSystem('EPSG:32633'))    
        
        