# -*- coding: utf-8 -*-

"""
***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
"""
__author__ = 'Leandro França'
__date__ = '2022-09-05'
__copyright__ = '(C) 2022, Leandro França'

# Créditos
# Drewes H. and Sánchez L. (2020) Velocity model for SIRGAS 2017: VEMOS2017
# VEMOS2009 in ITRF2005 (Drewes and Heidbach 2009)

# Modelo de Velocidades
vemos2009 = {20: {-76: (0.0106, 0.0076), -75: (0.0112, 0.0075), -74: (0.0118, 0.0079), -73: (0.0124, 0.0084), -72: (0.013, 0.0083)}, 19: {-80: (0.008, 0.0062), -79: (0.0089, 0.0065), -78: (0.0097, 0.0068), -77: (0.0094, 0.0068), -76: (0.0103, 0.0076), -75: (0.0114, 0.0078), -74: (0.0119, 0.008), -73: (0.0123, 0.008), -72: (0.0125, 0.0073), -71: (0.0132, 0.0073), -70: (0.0128, 0.0072), -69: (0.0126, 0.008), -68: (0.0124, 0.0084), -67: (0.0122, 0.0089), -66: (0.0124, 0.009), -65: (0.0125, 0.0092), -64: (0.0129, 0.0088), -63: (0.0132, 0.009), -62: (0.0133, 0.0091)}, 18: {-81: (0.0102, 0.0061), -80: (0.0102, 0.0065), -79: (0.0102, 0.007), -78: (0.0098, 0.0071), -77: (0.0082, 0.0065), -76: (0.01, 0.0072), -75: (0.0115, 0.0078), -74: (0.0121, 0.0081), -73: (0.0123, 0.0076), -72: (0.0128, 0.0072), -71: (0.0133, 0.0066), -70: (0.0128, 0.0078), -69: (0.0127, 0.0079), -68: (0.0125, 0.0084), -67: (0.0122, 0.0094), -66: (0.0125, 0.0097), -65: (0.0125, 0.0107), -64: (0.0128, 0.0103), -63: (0.013, 0.0086), -62: (0.0133, 0.0083), -61: (0.0135, 0.0084), -60: (0.0137, 0.008)}, 17: {-85: (0.0074, 0.0038), -84: (0.0085, 0.0052), -83: (0.0094, 0.0059), -82: (0.0101, 0.0067), -81: (0.0103, 0.007), -80: (0.0107, 0.0075), -79: (0.0105, 0.0076), -78: (0.0104, 0.0081), -77: (0.01, 0.0077), -76: (0.011, 0.0081), -75: (0.0118, 0.0088), -74: (0.0123, 0.0086), -73: (0.0124, 0.0079), -72: (0.0127, 0.0082), -71: (0.0127, 0.0078), -70: (0.0129, 0.0077), -69: (0.0128, 0.0079), -68: (0.0127, 0.0081), -67: (0.0126, 0.0088), -66: (0.0126, 0.0093), -65: (0.0127, 0.0099), -64: (0.0129, 0.0094), -63: (0.0132, 0.0084), -62: (0.0133, 0.0073), -61: (0.0135, 0.0075), -60: (0.0137, 0.0077), -59: (0.014, 0.0078)}, 16: {-88: (0.0038, 0.0017), -87: (0.0052, 0.0034), -86: (0.0066, 0.0048), -85: (0.008, 0.0061), -84: (0.0088, 0.0068), -83: (0.0096, 0.0073), -82: (0.0101, 0.0078), -81: (0.0104, 0.0081), -80: (0.0109, 0.0085), -79: (0.0111, 0.0087), -78: (0.0112, 0.009), -77: (0.0116, 0.009), -76: (0.012, 0.009), -75: (0.0121, 0.0093), -74: (0.0123, 0.0086), -73: (0.0125, 0.0084), -72: (0.0129, 0.0081), -71: (0.0129, 0.0076), -70: (0.0129, 0.0079), -69: (0.0129, 0.0077), -68: (0.0129, 0.008), -67: (0.0128, 0.0082), -66: (0.0128, 0.0086), -65: (0.0129, 0.0085), -64: (0.013, 0.0085), -63: (0.0132, 0.0073), -62: (0.0133, 0.0071), -61: (0.0135, 0.0072), -60: (0.0136, 0.0073), -59: (0.0137, 0.0083)}, 15: {-89: (0.0045, 0.0035), -88: (0.0046, 0.0053), -87: (0.0056, 0.0067), -86: (0.0073, 0.0076), -85: (0.0086, 0.0083), -84: (0.0091, 0.0086), -83: (0.0096, 0.0091), -82: (0.0098, 0.0093), -81: (0.0105, 0.0096), -80: (0.0112, 0.0098), -79: (0.0117, 0.01), -78: (0.012, 0.0101), -77: (0.0124, 0.0097), -76: (0.0126, 0.0099), -75: (0.0124, 0.0094), -74: (0.0124, 0.0087), -73: (0.0127, 0.0087), -72: (0.0129, 0.0086), -71: (0.013, 0.0083), -70: (0.0131, 0.0078), -69: (0.0131, 0.008), -68: (0.0129, 0.0078), -67: (0.0128, 0.0081), -66: (0.0128, 0.0082), -65: (0.0129, 0.0082), -64: (0.0132, 0.0079), -63: (0.0133, 0.0074), -62: (0.0136, 0.0083), -61: (0.0137, 0.0087), -60: (0.0141, 0.0091), -59: (0.0133, 0.0099)}, 14: {-90: (0.0054, 0.0047), -89: (0.0066, 0.0063), -88: (0.0052, 0.009), -87: (0.0057, 0.0106), -86: (0.0086, 0.0109), -85: (0.0093, 0.0104), -84: (0.0096, 0.0105), -83: (0.0096, 0.0108), -82: (0.0096, 0.0111), -81: (0.0102, 0.0112), -80: (0.0114, 0.0114), -79: (0.0122, 0.0112), -78: (0.0124, 0.0112), -77: (0.0129, 0.0108), -76: (0.0127, 0.0111), -75: (0.0128, 0.0095), -74: (0.0126, 0.0097), -73: (0.0127, 0.0093), -72: (0.0129, 0.0086), -71: (0.013, 0.0085), -70: (0.0132, 0.0083), -69: (0.0132, 0.0084), -68: (0.013, 0.008), -67: (0.0127, 0.0088), -66: (0.0127, 0.0078), -65: (0.013, 0.0079), -64: (0.0133, 0.0082), -63: (0.0134, 0.0078), -62: (0.0137, 0.0091), -61: (0.0136, 0.0093), -60: (0.0142, 0.0115), -59: (0.0137, 0.0114), -58: (0.014, 0.0092)}, 13: {-89: (0.0074, 0.0081), -88: (0.0069, 0.0103), -87: (0.0078, 0.0127), -86: (0.0098, 0.0128), -85: (0.01, 0.0113), -84: (0.0101, 0.0117), -83: (0.0097, 0.0124), -82: (0.0084, 0.0133), -81: (0.0098, 0.013), -80: (0.0117, 0.0129), -79: (0.0124, 0.0127), -78: (0.0128, 0.0124), -77: (0.0131, 0.012), -76: (0.0128, 0.0117), -75: (0.0126, 0.0103), -74: (0.0127, 0.0097), -73: (0.0129, 0.0099), -72: (0.0132, 0.0093), -71: (0.0131, 0.0095), -70: (0.0135, 0.0094), -69: (0.0134, 0.0088), -68: (0.0132, 0.0079), -67: (0.0129, 0.0078), -66: (0.0127, 0.0081), -65: (0.0128, 0.0085), -64: (0.0134, 0.0081), -63: (0.0139, 0.009), -62: (0.014, 0.0099), -61: (0.0142, 0.0114), -60: (0.0146, 0.0127), -59: (0.0141, 0.0112), -58: (0.0135, 0.0096)}, 12: {-89: (0.0077, 0.0092), -88: (0.0081, 0.0099), -87: (0.0089, 0.0095), -86: (0.0096, 0.0079), -85: (0.011, 0.0109), -84: (0.0109, 0.0125), -83: (0.0107, 0.0134), -82: (0.0099, 0.0145), -81: (0.0102, 0.0154), -80: (0.0118, 0.0147), -79: (0.0129, 0.014), -78: (0.0132, 0.0133), -77: (0.0131, 0.013), -76: (0.0125, 0.0116), -75: (0.0124, 0.0108), -74: (0.013, 0.0101), -73: (0.0132, 0.0112), -72: (0.0133, 0.0103), -71: (0.0133, 0.011), -70: (0.014, 0.0119), -69: (0.0137, 0.0088), -68: (0.0134, 0.0071), -67: (0.0129, 0.0076), -66: (0.0126, 0.0084), -65: (0.0132, 0.0097), -64: (0.014, 0.0109), -63: (0.0141, 0.0103), -62: (0.014, 0.0098), -61: (0.0141, 0.0108), -60: (0.0141, 0.0087), -59: (0.0135, 0.0088), -58: (0.0133, 0.0085)}, 11: {-87: (0.0099, 0.0102), -86: (0.0118, 0.01), -85: (0.0131, 0.0114), -84: (0.0128, 0.014), -83: (0.012, 0.0159), -82: (0.0116, 0.0176), -81: (0.0119, 0.0178), -80: (0.0127, 0.0164), -79: (0.0131, 0.0155), -78: (0.0134, 0.0147), -77: (0.0131, 0.0136), -76: (0.0116, 0.0123), -75: (0.0119, 0.0107), -74: (0.0133, 0.0097), -73: (0.0136, 0.0102), -72: (0.0128, 0.01), -71: (0.0135, 0.0097), -70: (0.0142, 0.0093), -69: (0.0139, 0.0068), -68: (0.0134, 0.0051), -67: (0.0132, 0.0073), -66: (0.0124, 0.0072), -65: (0.0135, 0.0099), -64: (0.014, 0.0123), -63: (0.0139, 0.0122), -62: (0.0134, 0.0094), -61: (0.0134, 0.0086), -60: (0.0135, 0.0082), -59: (0.0132, 0.0075), -58: (0.0128, 0.0065)}, 10: {-86: (0.0126, 0.0127), -85: (0.0149, 0.0138), -84: (0.0174, 0.0144), -83: (0.0089, 0.023), -82: (0.0138, 0.0223), -81: (0.013, 0.02), -80: (0.0127, 0.0181), -79: (0.0129, 0.0168), -78: (0.0135, 0.0162), -77: (0.0128, 0.0143), -76: (0.0107, 0.0122), -75: (0.0113, 0.0103), -74: (0.0133, 0.0081), -73: (0.0141, 0.007), -72: (0.0135, 0.0068), -71: (0.0138, 0.0067), -70: (0.0148, 0.0064), -69: (0.0117, 0.0038), -68: (0.0111, 0.0029), -67: (0.0111, 0.0006), -66: (0.0123, 0.0031), -65: (0.0131, 0.0044), -64: (0.0126, 0.003), -63: (0.0125, 0.0034), -62: (0.0128, 0.0053), -61: (0.013, 0.0054), -60: (0.0116, 0.0054), -59: (0.012, 0.0048), -58: (0.0125, 0.0044)}, 9: {-84: (0.017, 0.0201), -83: (0.0178, 0.0223), -82: (0.0155, 0.0242), -81: (0.0133, 0.0224), -80: (0.012, 0.0198), -79: (0.0127, 0.0193), -78: (0.0135, 0.0188), -77: (0.0128, 0.0149), -76: (0.0095, 0.0124), -75: (0.0117, 0.0099), -74: (0.0133, 0.0073), -73: (0.0141, 0.0061), -72: (0.014, 0.0042), -71: (0.0137, 0.0027), -70: (0.0113, 0.0005), -69: (0.0112, 0.0012), -68: (0.0113, -0.0011), -67: (0.0118, -0.0016), -66: (0.0123, 0.0004), -65: (0.0127, 0.0011), -64: (0.0129, 0.0007), -63: (0.0127, 0.0014), -62: (0.0128, 0.0023), -61: (0.013, 0.0031), -60: (0.0132, 0.0036), -59: (0.0126, 0.003), -58: (0.0121, 0.0023)}, 8: {-83: (0.0164, 0.0228), -82: (0.0152, 0.0241), -81: (0.0133, 0.024), -80: (0.0126, 0.0232), -79: (0.0137, 0.0211), -78: (0.0136, 0.021), -77: (0.0126, 0.0138), -76: (0.0115, 0.0106), -75: (0.0124, 0.0076), -74: (0.0136, 0.0056), -73: (0.014, 0.0043), -72: (0.0132, 0.001), -71: (0.0122, -0.0006), -70: (0.0115, -0.0012), -69: (0.0116, -0.0004), -68: (0.0113, -0.001), -67: (0.0118, -0.001), -66: (0.0121, -0.0006), -65: (0.0124, -0.0003), -64: (0.0127, -0.0004), -63: (0.0127, 0.0), -62: (0.0125, 0.0008), -61: (0.0123, 0.0012), -60: (0.0122, 0.0012), -59: (0.0121, 0.001), -58: (0.012, 0.0007)}, 7: {-82: (0.0145, 0.021), -81: (0.0139, 0.0208), -80: (0.0137, 0.0199), -79: (0.0141, 0.0176), -78: (0.0138, 0.0144), -77: (0.0131, 0.01), -76: (0.013, 0.0067), -75: (0.0131, 0.0059), -74: (0.0137, 0.0042), -73: (0.0145, 0.003), -72: (0.0126, 0.0016), -71: (0.0122, 0.0004), -70: (0.0118, -0.0004), -69: (0.0116, -0.0006), -68: (0.0111, -0.0008), -67: (0.0112, -0.0012), -66: (0.0117, -0.0013), -65: (0.012, -0.0013), -64: (0.0122, -0.0013), -63: (0.0124, -0.0009), -62: (0.0119, -0.0005), -61: (0.012, -0.0002), -60: (0.012, -0.0002), -59: (0.0118, -0.0006), -58: (0.0117, -0.001), -57: (0.0116, -0.0013)}, 6: {-78: (0.0135, 0.0099), -77: (0.0137, 0.0075), -76: (0.0135, 0.0043), -75: (0.0142, 0.006), -74: (0.0134, 0.0037), -73: (0.0145, 0.0013), -72: (0.0121, -0.0004), -71: (0.012, 0.0001), -70: (0.0119, -0.0003), -69: (0.0115, -0.0012), -68: (0.0107, -0.0013), -67: (0.0105, -0.0013), -66: (0.0114, -0.0017), -65: (0.0116, -0.0021), -64: (0.0122, -0.0015), -63: (0.0122, -0.0016), -62: (0.0118, -0.0012), -61: (0.0118, -0.0011), -60: (0.0118, -0.0013), -59: (0.0117, -0.0017), -58: (0.0116, -0.0015), -57: (0.0114, -0.0025), -56: (0.0112, -0.0028), -55: (0.0109, -0.0031), -54: (0.0113, -0.0027), -53: (0.0117, -0.0026)}, 5: {-78: (0.0133, 0.0092), -77: (0.0135, 0.0062), -76: (0.0146, 0.0053), -75: (0.0159, 0.0037), -74: (0.0123, 0.0018), -73: (0.0122, -0.0014), -72: (0.0112, -0.0026), -71: (0.0119, -0.0011), -70: (0.0117, -0.0016), -69: (0.0112, -0.0025), -68: (0.0103, -0.0033), -67: (0.0105, -0.0028), -66: (0.011, -0.0026), -65: (0.0115, -0.0026), -64: (0.0117, -0.0026), -63: (0.0118, -0.0023), -62: (0.0117, -0.0018), -61: (0.0116, -0.0016), -60: (0.0117, -0.002), -59: (0.0115, -0.0024), -58: (0.0114, -0.0028), -57: (0.0113, -0.0032), -56: (0.011, -0.0035), -55: (0.011, -0.0036), -54: (0.0114, -0.0033), -53: (0.0119, -0.0032), -52: (0.0118, -0.0031)}, 4: {-78: (0.013, 0.0073), -77: (0.0132, 0.0054), -76: (0.0134, 0.0044), -75: (0.0143, 0.0016), -74: (0.0124, -0.0021), -73: (0.0108, -0.002), -72: (0.0117, -0.0015), -71: (0.0118, -0.0016), -70: (0.0114, -0.0023), -69: (0.0105, -0.0047), -68: (0.0095, -0.007), -67: (0.0108, -0.0048), -66: (0.0112, -0.0036), -65: (0.0115, -0.0031), -64: (0.0117, -0.0028), -63: (0.0117, -0.0027), -62: (0.0116, -0.0025), -61: (0.0116, -0.0025), -60: (0.0116, -0.0026), -59: (0.0115, -0.0029), -58: (0.0114, -0.0031), -57: (0.0113, -0.0034), -56: (0.0112, -0.0035), -55: (0.0113, -0.0035), -54: (0.0115, -0.0032), -53: (0.0118, -0.0031), -52: (0.0119, -0.0032), -51: (0.0118, -0.0031)}, 3: {-78: (0.0122, 0.007), -77: (0.0129, 0.0041), -76: (0.0127, 0.0028), -75: (0.0134, 0.0022), -74: (0.0124, 0.0003), -73: (0.0123, -0.0007), -72: (0.012, -0.0006), -71: (0.0117, -0.0017), -70: (0.0111, -0.0029), -69: (0.0107, -0.0046), -68: (0.0103, -0.0049), -67: (0.0111, -0.0045), -66: (0.0114, -0.0035), -65: (0.0116, -0.0032), -64: (0.0117, -0.0031), -63: (0.0117, -0.003), -62: (0.0116, -0.003), -61: (0.0116, -0.0031), -60: (0.0115, -0.0032), -59: (0.0114, -0.0034), -58: (0.0114, -0.0036), -57: (0.0115, -0.0036), -56: (0.0114, -0.0035), -55: (0.0116, -0.0036), -54: (0.0116, -0.0035), -53: (0.0118, -0.0034), -52: (0.0119, -0.0034), -51: (0.0118, -0.0033)}, 2: {-79: (0.0109, 0.0108), -78: (0.0114, 0.0076), -77: (0.0114, 0.0046), -76: (0.0107, 0.0019), -75: (0.0111, 0.0006), -74: (0.012, 0.0008), -73: (0.0121, -0.0001), -72: (0.012, -0.0002), -71: (0.0115, -0.0015), -70: (0.011, -0.003), -69: (0.0107, -0.0035), -68: (0.0107, -0.0039), -67: (0.0112, -0.0034), -66: (0.0115, -0.0033), -65: (0.0116, -0.0033), -64: (0.0116, -0.0033), -63: (0.0116, -0.0033), -62: (0.0115, -0.0034), -61: (0.0114, -0.0035), -60: (0.0115, -0.0036), -59: (0.0114, -0.0037), -58: (0.0115, -0.0037), -57: (0.0115, -0.0038), -56: (0.0115, -0.0037), -55: (0.0116, -0.0037), -54: (0.0118, -0.0037), -53: (0.0119, -0.0036), -52: (0.0119, -0.0035), -51: (0.0119, -0.0035), -50: (0.012, -0.0034)}, 1: {-80: (0.0123, 0.0153), -79: (0.0118, 0.0107), -78: (0.0118, 0.007), -77: (0.0112, 0.0055), -76: (0.0088, 0.0026), -75: (0.0104, 0.0015), -74: (0.0114, 0.0009), -73: (0.0119, 0.0002), -72: (0.0116, -0.0007), -71: (0.0112, -0.0019), -70: (0.011, -0.0027), -69: (0.0109, -0.0029), -68: (0.0111, -0.0029), -67: (0.0113, -0.003), -66: (0.0115, -0.0031), -65: (0.0115, -0.0033), -64: (0.0116, -0.0034), -63: (0.0116, -0.0036), -62: (0.0114, -0.0037), -61: (0.0114, -0.0038), -60: (0.0115, -0.0038), -59: (0.0114, -0.0038), -58: (0.0115, -0.0038), -57: (0.0116, -0.0038), -56: (0.0116, -0.0038), -55: (0.0117, -0.0037), -54: (0.0118, -0.0037), -53: (0.012, -0.0036), -52: (0.012, -0.0036), -51: (0.0121, -0.0036), -50: (0.0121, -0.0036)}, 0: {-80: (0.0114, 0.0119), -79: (0.0106, 0.0088), -78: (0.0109, 0.0038), -77: (0.0093, -0.0015), -76: (0.0094, 0.0014), -75: (0.0104, 0.0019), -74: (0.0111, 0.0014), -73: (0.0114, 0.0), -72: (0.0115, -0.0007), -71: (0.0111, -0.0019), -70: (0.0111, -0.0022), -69: (0.011, -0.0026), -68: (0.0112, -0.0027), -67: (0.0113, -0.0029), -66: (0.0114, -0.0031), -65: (0.0115, -0.0033), -64: (0.0115, -0.0035), -63: (0.0115, -0.0037), -62: (0.0114, -0.0038), -61: (0.0114, -0.0039), -60: (0.0115, -0.004), -59: (0.0114, -0.004), -58: (0.0115, -0.004), -57: (0.0116, -0.0039), -56: (0.0116, -0.0038), -55: (0.0117, -0.0038), -54: (0.0118, -0.0038), -53: (0.012, -0.0037), -52: (0.0121, -0.0037), -51: (0.0122, -0.0037), -50: (0.0123, -0.0039), -49: (0.0123, -0.004), -48: (0.0122, -0.004), -47: (0.0119, -0.0038)}, -1: {-81: (0.0118, 0.0131), -80: (0.0105, 0.0103), -79: (0.0092, 0.0054), -78: (0.0083, 0.0036), -77: (0.0092, 0.0025), -76: (0.0099, 0.0023), -75: (0.0105, 0.0022), -74: (0.0108, 0.0014), -73: (0.011, 0.0004), -72: (0.011, -0.001), -71: (0.0111, -0.0017), -70: (0.011, -0.0021), -69: (0.0111, -0.0024), -68: (0.0112, -0.0026), -67: (0.0113, -0.0029), -66: (0.0114, -0.0031), -65: (0.0114, -0.0033), -64: (0.0114, -0.0036), -63: (0.0114, -0.0037), -62: (0.0114, -0.0039), -61: (0.0114, -0.004), -60: (0.0115, -0.0041), -59: (0.0114, -0.0041), -58: (0.0115, -0.0041), -57: (0.0116, -0.004), -56: (0.0116, -0.0039), -55: (0.0118, -0.0039), -54: (0.0118, -0.0037), -53: (0.012, -0.0037), -52: (0.0121, -0.0038), -51: (0.0121, -0.004), -50: (0.0123, -0.0042), -49: (0.0126, -0.0046), -48: (0.0124, -0.0045), -47: (0.012, -0.0042), -46: (0.0119, -0.0039), -45: (0.0118, -0.0037)}, -2: {-81: (0.0103, 0.009), -80: (0.0087, 0.0076), -79: (0.0068, 0.004), -78: (0.0073, 0.0037), -77: (0.0089, 0.0032), -76: (0.0097, 0.0025), -75: (0.0103, 0.0018), -74: (0.0107, 0.0013), -73: (0.0107, 0.0001), -72: (0.0109, -0.0005), -71: (0.0112, -0.0013), -70: (0.0111, -0.0018), -69: (0.0111, -0.0022), -68: (0.0112, -0.0026), -67: (0.0113, -0.0028), -66: (0.0113, -0.0031), -65: (0.0114, -0.0034), -64: (0.0113, -0.0037), -63: (0.0114, -0.0038), -62: (0.0113, -0.0041), -61: (0.0114, -0.0043), -60: (0.0114, -0.0046), -59: (0.0113, -0.0044), -58: (0.0115, -0.0043), -57: (0.0116, -0.0041), -56: (0.0117, -0.004), -55: (0.0118, -0.0039), -54: (0.0119, -0.0039), -53: (0.012, -0.0039), -52: (0.012, -0.0039), -51: (0.0121, -0.004), -50: (0.0123, -0.0042), -49: (0.0125, -0.0044), -48: (0.0125, -0.0044), -47: (0.0122, -0.0042), -46: (0.012, -0.004), -45: (0.0119, -0.0038), -44: (0.0118, -0.0037), -43: (0.0117, -0.0036)}, -3: {-81: (0.009, 0.007), -80: (0.008, 0.0053), -79: (0.0071, 0.0041), -78: (0.0076, 0.0035), -77: (0.0089, 0.0031), -76: (0.0098, 0.0027), -75: (0.0103, 0.0019), -74: (0.0105, 0.0014), -73: (0.0107, 0.0006), -72: (0.0109, -0.0002), -71: (0.0109, -0.001), -70: (0.0109, -0.0017), -69: (0.0111, -0.0022), -68: (0.0113, -0.0024), -67: (0.0113, -0.0027), -66: (0.0114, -0.003), -65: (0.0113, -0.0033), -64: (0.0113, -0.0035), -63: (0.0113, -0.0039), -62: (0.0113, -0.0042), -61: (0.0113, -0.0047), -60: (0.0112, -0.0056), -59: (0.0114, -0.0047), -58: (0.0116, -0.0043), -57: (0.0117, -0.0041), -56: (0.0117, -0.004), -55: (0.0118, -0.0039), -54: (0.0119, -0.0038), -53: (0.012, -0.0039), -52: (0.012, -0.004), -51: (0.0121, -0.004), -50: (0.0122, -0.0041), -49: (0.0123, -0.0042), -48: (0.0123, -0.0042), -47: (0.0122, -0.0042), -46: (0.0121, -0.004), -45: (0.0119, -0.0039), -44: (0.0118, -0.0038), -43: (0.0117, -0.0037), -42: (0.0117, -0.0036), -41: (0.0117, -0.0035), -40: (0.0117, -0.0035), -39: (0.0118, -0.0035)}, -4: {-81: (0.0078, 0.0062), -80: (0.0071, 0.0044), -79: (0.0065, 0.0004), -78: (0.0082, 0.0029), -77: (0.0092, 0.0032), -76: (0.01, 0.0028), -75: (0.0104, 0.0018), -74: (0.0106, 0.0014), -73: (0.0106, 0.0011), -72: (0.0108, -0.0001), -71: (0.011, -0.0009), -70: (0.0109, -0.0016), -69: (0.0112, -0.002), -68: (0.0113, -0.0023), -67: (0.0114, -0.0026), -66: (0.0114, -0.0029), -65: (0.0113, -0.0032), -64: (0.0112, -0.0035), -63: (0.0113, -0.0037), -62: (0.0112, -0.0041), -61: (0.0112, -0.0044), -60: (0.0114, -0.0045), -59: (0.0115, -0.0044), -58: (0.0116, -0.0042), -57: (0.0117, -0.0041), -56: (0.0117, -0.004), -55: (0.0118, -0.0039), -54: (0.0118, -0.0039), -53: (0.0119, -0.0038), -52: (0.012, -0.0039), -51: (0.012, -0.0039), -50: (0.0121, -0.004), -49: (0.0122, -0.0041), -48: (0.0121, -0.0041), -47: (0.012, -0.0041), -46: (0.012, -0.004), -45: (0.0119, -0.0039), -44: (0.0118, -0.0038), -43: (0.0118, -0.0038), -42: (0.0117, -0.0037), -41: (0.0117, -0.0036), -40: (0.0117, -0.0036), -39: (0.0118, -0.0036), -38: (0.0118, -0.0036), -37: (0.0116, -0.0034)}, -5: {-81: (0.006, 0.0053), -80: (0.0064, 0.0042), -79: (0.0076, 0.0036), -78: (0.0088, 0.0034), -77: (0.0097, 0.0032), -76: (0.0103, 0.0025), -75: (0.0107, 0.0019), -74: (0.0108, 0.0012), -73: (0.0108, 0.0005), -72: (0.011, -0.0003), -71: (0.0111, -0.001), -70: (0.0111, -0.0015), -69: (0.0114, -0.0018), -68: (0.0114, -0.0021), -67: (0.0114, -0.0023), -66: (0.0114, -0.0026), -65: (0.0113, -0.0031), -64: (0.0113, -0.0033), -63: (0.0113, -0.0036), -62: (0.0112, -0.0038), -61: (0.0113, -0.004), -60: (0.0114, -0.004), -59: (0.0115, -0.0041), -58: (0.0116, -0.004), -57: (0.0118, -0.0039), -56: (0.0118, -0.0038), -55: (0.0119, -0.0038), -54: (0.0118, -0.0037), -53: (0.0119, -0.0038), -52: (0.012, -0.0039), -51: (0.012, -0.0039), -50: (0.0121, -0.0039), -49: (0.012, -0.004), -48: (0.012, -0.0042), -47: (0.0119, -0.0042), -46: (0.012, -0.0041), -45: (0.012, -0.004), -44: (0.0119, -0.0039), -43: (0.0118, -0.0037), -42: (0.0117, -0.0036), -41: (0.0117, -0.0036), -40: (0.0117, -0.0035), -39: (0.0118, -0.0034), -38: (0.0118, -0.0035), -37: (0.0117, -0.0035), -36: (0.0114, -0.0034), -35: (0.0113, -0.0033)}, -6: {-81: (0.0069, 0.0058), -80: (0.0073, 0.0051), -79: (0.0083, 0.0043), -78: (0.0093, 0.0038), -77: (0.0101, 0.0028), -76: (0.0105, 0.002), -75: (0.0107, 0.0014), -74: (0.0107, 0.0003), -73: (0.0109, -0.0002), -72: (0.0112, -0.0005), -71: (0.0113, -0.0009), -70: (0.0114, -0.0014), -69: (0.0115, -0.0016), -68: (0.0115, -0.0019), -67: (0.0115, -0.0022), -66: (0.0114, -0.0025), -65: (0.0113, -0.0029), -64: (0.0112, -0.0032), -63: (0.0112, -0.0035), -62: (0.0112, -0.0036), -61: (0.0113, -0.0037), -60: (0.0115, -0.0038), -59: (0.0115, -0.0038), -58: (0.0117, -0.0038), -57: (0.0118, -0.0037), -56: (0.0118, -0.0038), -55: (0.0119, -0.0037), -54: (0.0119, -0.0037), -53: (0.012, -0.0037), -52: (0.0119, -0.0038), -51: (0.0119, -0.0039), -50: (0.012, -0.0039), -49: (0.012, -0.004), -48: (0.0119, -0.004), -47: (0.0119, -0.0041), -46: (0.012, -0.004), -45: (0.0119, -0.0039), -44: (0.0119, -0.0039), -43: (0.0118, -0.0037), -42: (0.0118, -0.0036), -41: (0.0118, -0.0035), -40: (0.0117, -0.0034), -39: (0.0117, -0.0033), -38: (0.0117, -0.0033), -37: (0.0117, -0.0035), -36: (0.0115, -0.0034), -35: (0.0114, -0.0033)}, -7: {-80: (0.0082, 0.0055), -79: (0.0088, 0.0048), -78: (0.0094, 0.004), -77: (0.0102, 0.0029), -76: (0.0107, 0.0016), -75: (0.0107, 0.0), -74: (0.0108, -0.0009), -73: (0.0112, -0.0009), -72: (0.0115, -0.0009), -71: (0.0116, -0.001), -70: (0.0116, -0.0013), -69: (0.0116, -0.0015), -68: (0.0116, -0.0017), -67: (0.0115, -0.002), -66: (0.0115, -0.0023), -65: (0.0113, -0.0028), -64: (0.0111, -0.0031), -63: (0.0111, -0.0035), -62: (0.0112, -0.0035), -61: (0.0114, -0.0036), -60: (0.0115, -0.0036), -59: (0.0116, -0.0036), -58: (0.0117, -0.0036), -57: (0.0118, -0.0036), -56: (0.0118, -0.0036), -55: (0.0119, -0.0036), -54: (0.0119, -0.0036), -53: (0.012, -0.0037), -52: (0.0119, -0.0037), -51: (0.0119, -0.0037), -50: (0.012, -0.0038), -49: (0.0119, -0.0039), -48: (0.0119, -0.0039), -47: (0.0119, -0.0039), -46: (0.012, -0.0039), -45: (0.012, -0.0039), -44: (0.0119, -0.0038), -43: (0.0119, -0.0036), -42: (0.0118, -0.0036), -41: (0.0118, -0.0035), -40: (0.0117, -0.0032), -39: (0.0117, -0.0032), -38: (0.0117, -0.0033), -37: (0.0117, -0.0034), -36: (0.0115, -0.0033), -35: (0.0115, -0.0032)}, -8: {-80: (0.0086, 0.0066), -79: (0.0091, 0.006), -78: (0.0096, 0.0048), -77: (0.0104, 0.0033), -76: (0.0107, 0.0009), -75: (0.011, -0.0019), -74: (0.0111, -0.0021), -73: (0.0118, -0.0013), -72: (0.012, -0.0009), -71: (0.012, -0.0008), -70: (0.0121, -0.0009), -69: (0.0118, -0.0013), -68: (0.0116, -0.0016), -67: (0.0116, -0.0019), -66: (0.0114, -0.0025), -65: (0.0111, -0.003), -64: (0.0102, -0.0042), -63: (0.0109, -0.0038), -62: (0.0112, -0.0036), -61: (0.0114, -0.0034), -60: (0.0116, -0.0034), -59: (0.0117, -0.0034), -58: (0.0117, -0.0035), -57: (0.0119, -0.0035), -56: (0.0118, -0.0034), -55: (0.0119, -0.0035), -54: (0.0119, -0.0036), -53: (0.012, -0.0036), -52: (0.0119, -0.0036), -51: (0.0119, -0.0037), -50: (0.012, -0.0037), -49: (0.0119, -0.0038), -48: (0.012, -0.0038), -47: (0.0119, -0.0038), -46: (0.0121, -0.0039), -45: (0.012, -0.0039), -44: (0.012, -0.0037), -43: (0.012, -0.0036), -42: (0.0119, -0.0035), -41: (0.0119, -0.0035), -40: (0.0118, -0.0033), -39: (0.0117, -0.0033), -38: (0.0117, -0.0034), -37: (0.0117, -0.0034), -36: (0.0116, -0.0033), -35: (0.0117, -0.0031)}, -9: {-79: (0.0093, 0.0073), -78: (0.0097, 0.006), -77: (0.0104, 0.0045), -76: (0.0108, 0.0022), -75: (0.0111, -0.0003), -74: (0.0123, -0.0006), -73: (0.0126, -0.0004), -72: (0.0127, -0.0003), -71: (0.0126, -0.0004), -70: (0.0123, -0.0007), -69: (0.012, -0.0011), -68: (0.0117, -0.0014), -67: (0.0116, -0.0017), -66: (0.0114, -0.0024), -65: (0.0109, -0.0033), -64: (0.0097, -0.0046), -63: (0.0109, -0.0037), -62: (0.0113, -0.0033), -61: (0.0116, -0.0032), -60: (0.0117, -0.0032), -59: (0.0117, -0.0033), -58: (0.0118, -0.0033), -57: (0.0118, -0.0033), -56: (0.0118, -0.0033), -55: (0.0119, -0.0033), -54: (0.0119, -0.0033), -53: (0.012, -0.0035), -52: (0.0119, -0.0036), -51: (0.0119, -0.0036), -50: (0.012, -0.0037), -49: (0.012, -0.0037), -48: (0.012, -0.0037), -47: (0.012, -0.0038), -46: (0.0121, -0.0038), -45: (0.0121, -0.0038), -44: (0.0121, -0.0037), -43: (0.012, -0.0037), -42: (0.012, -0.0036), -41: (0.0119, -0.0036), -40: (0.0119, -0.0035), -39: (0.0118, -0.0034), -38: (0.0118, -0.0035), -37: (0.0118, -0.0035), -36: (0.0116, -0.0034), -35: (0.0116, -0.0034)}, -10: {-79: (0.0092, 0.0089), -78: (0.0097, 0.0079), -77: (0.0106, 0.0069), -76: (0.0114, 0.0053), -75: (0.0121, 0.0034), -74: (0.0129, 0.0022), -73: (0.0134, 0.0015), -72: (0.0135, 0.0007), -71: (0.0132, 0.0001), -70: (0.0128, -0.0003), -69: (0.0123, -0.0009), -68: (0.0122, -0.0009), -67: (0.0117, -0.0012), -66: (0.0116, -0.0012), -65: (0.0113, -0.0022), -64: (0.0108, -0.0028), -63: (0.0113, -0.0028), -62: (0.0115, -0.0029), -61: (0.0117, -0.0029), -60: (0.0117, -0.0031), -59: (0.0117, -0.0031), -58: (0.0118, -0.0032), -57: (0.0119, -0.0032), -56: (0.0119, -0.0032), -55: (0.0119, -0.0032), -54: (0.0119, -0.0034), -53: (0.012, -0.0033), -52: (0.0119, -0.0036), -51: (0.0119, -0.0036), -50: (0.012, -0.0036), -49: (0.012, -0.0037), -48: (0.012, -0.0037), -47: (0.012, -0.0037), -46: (0.0121, -0.0038), -45: (0.0122, -0.0038), -44: (0.0121, -0.0038), -43: (0.0121, -0.0037), -42: (0.012, -0.0036), -41: (0.012, -0.0036), -40: (0.0119, -0.0035), -39: (0.0118, -0.0035), -38: (0.0118, -0.0035), -37: (0.0118, -0.0035), -36: (0.0117, -0.0034)}, -11: {-78: (0.0101, 0.0114), -77: (0.011, 0.0106), -76: (0.0123, 0.009), -75: (0.0129, 0.0068), -74: (0.0136, 0.0047), -73: (0.0141, 0.0031), -72: (0.0142, 0.0018), -71: (0.0138, 0.0006), -70: (0.0133, -0.0001), -69: (0.0127, -0.0007), -68: (0.0123, -0.0009), -67: (0.0121, -0.0006), -66: (0.0118, 0.0008), -65: (0.0116, -0.0013), -64: (0.0115, -0.002), -63: (0.0115, -0.0023), -62: (0.0117, -0.0025), -61: (0.0117, -0.0026), -60: (0.0117, -0.0029), -59: (0.0118, -0.0029), -58: (0.0118, -0.0031), -57: (0.0119, -0.0031), -56: (0.0119, -0.0031), -55: (0.0119, -0.0033), -54: (0.0119, -0.0033), -53: (0.0119, -0.0034), -52: (0.012, -0.0034), -51: (0.012, -0.0035), -50: (0.0121, -0.0036), -49: (0.0121, -0.0036), -48: (0.0121, -0.0037), -47: (0.0121, -0.0037), -46: (0.0122, -0.0037), -45: (0.0123, -0.0038), -44: (0.0123, -0.0038), -43: (0.0123, -0.0038), -42: (0.0121, -0.0036), -41: (0.012, -0.0036), -40: (0.0119, -0.0035), -39: (0.0119, -0.0034), -38: (0.0118, -0.0035), -37: (0.0118, -0.0035)}, -12: {-78: (0.0111, 0.0159), -77: (0.0105, 0.0165), -76: (0.0129, 0.014), -75: (0.0133, 0.0093), -74: (0.0139, 0.0072), -73: (0.0146, 0.0043), -72: (0.015, 0.0021), -71: (0.0145, 0.0008), -70: (0.0137, -0.0004), -69: (0.0131, -0.0009), -68: (0.0128, -0.0011), -67: (0.0125, -0.0012), -66: (0.0122, -0.0007), -65: (0.0118, -0.0016), -64: (0.0117, -0.0017), -63: (0.0117, -0.0021), -62: (0.0117, -0.0023), -61: (0.0118, -0.0025), -60: (0.0118, -0.0027), -59: (0.0118, -0.0029), -58: (0.0118, -0.003), -57: (0.0119, -0.0031), -56: (0.0119, -0.0032), -55: (0.012, -0.0033), -54: (0.012, -0.0034), -53: (0.012, -0.0034), -52: (0.012, -0.0035), -51: (0.012, -0.0035), -50: (0.0121, -0.0035), -49: (0.0121, -0.0036), -48: (0.0121, -0.0036), -47: (0.0122, -0.0037), -46: (0.0122, -0.0038), -45: (0.0123, -0.0039), -44: (0.0125, -0.0039), -43: (0.0124, -0.0038), -42: (0.0122, -0.0037), -41: (0.012, -0.0036), -40: (0.0119, -0.0035), -39: (0.0118, -0.0033), -38: (0.0118, -0.0033), -37: (0.0118, -0.0034)}, -13: {-77: (0.0127, 0.0215), -76: (0.0125, 0.02), -75: (0.0128, 0.0138), -74: (0.0135, 0.0098), -73: (0.0144, 0.0059), -72: (0.0159, 0.0027), -71: (0.0149, 0.0005), -70: (0.0136, -0.0001), -69: (0.0136, -0.001), -68: (0.0135, -0.0013), -67: (0.0128, -0.0018), -66: (0.0124, -0.002), -65: (0.0121, -0.0018), -64: (0.0119, -0.0018), -63: (0.0118, -0.0019), -62: (0.0117, -0.0021), -61: (0.0118, -0.0023), -60: (0.0118, -0.0025), -59: (0.0118, -0.0028), -58: (0.0118, -0.0029), -57: (0.0119, -0.0031), -56: (0.0119, -0.0032), -55: (0.012, -0.0034), -54: (0.0119, -0.0033), -53: (0.012, -0.0034), -52: (0.012, -0.0034), -51: (0.012, -0.0034), -50: (0.0121, -0.0035), -49: (0.0121, -0.0035), -48: (0.0121, -0.0036), -47: (0.0121, -0.0036), -46: (0.0122, -0.0038), -45: (0.0124, -0.0038), -44: (0.0127, -0.0041), -43: (0.0126, -0.0041), -42: (0.0123, -0.0039), -41: (0.0121, -0.0036), -40: (0.012, -0.0034), -39: (0.0118, -0.0031), -38: (0.0118, -0.0032)}, -14: {-77: (0.0126, 0.0208), -76: (0.0114, 0.0216), -75: (0.0117, 0.0165), -74: (0.0121, 0.0117), -73: (0.0141, 0.0094), -72: (0.0154, 0.0067), -71: (0.0142, 0.0037), -70: (0.0134, 0.0016), -69: (0.0142, 0.0001), -68: (0.0141, -0.0017), -67: (0.0133, -0.0029), -66: (0.0131, -0.0022), -65: (0.0126, -0.0019), -64: (0.0125, -0.0018), -63: (0.012, -0.0018), -62: (0.0118, -0.002), -61: (0.0118, -0.0022), -60: (0.0118, -0.0023), -59: (0.0118, -0.0026), -58: (0.0119, -0.0028), -57: (0.012, -0.0031), -56: (0.012, -0.0033), -55: (0.012, -0.0034), -54: (0.012, -0.0033), -53: (0.012, -0.0034), -52: (0.012, -0.0034), -51: (0.012, -0.0034), -50: (0.0121, -0.0034), -49: (0.0121, -0.0035), -48: (0.0122, -0.0035), -47: (0.0121, -0.0036), -46: (0.0122, -0.0037), -45: (0.0123, -0.0037), -44: (0.0125, -0.0039), -43: (0.0126, -0.004), -42: (0.0124, -0.0039), -41: (0.0122, -0.0036), -40: (0.012, -0.0035), -39: (0.0119, -0.0034)}, -15: {-76: (0.0117, 0.0193), -75: (0.0107, 0.0184), -74: (0.0117, 0.0162), -73: (0.0139, 0.0126), -72: (0.0147, 0.0093), -71: (0.0148, 0.0055), -70: (0.0146, 0.0029), -69: (0.015, 0.0015), -68: (0.0148, -0.0013), -67: (0.0143, -0.0023), -66: (0.0142, -0.0017), -65: (0.0134, -0.0015), -64: (0.0128, -0.0016), -63: (0.0123, -0.0016), -62: (0.0119, -0.0018), -61: (0.0117, -0.002), -60: (0.0118, -0.0023), -59: (0.0118, -0.0025), -58: (0.0119, -0.0027), -57: (0.012, -0.0033), -56: (0.012, -0.0037), -55: (0.012, -0.0035), -54: (0.012, -0.0034), -53: (0.012, -0.0033), -52: (0.012, -0.0034), -51: (0.012, -0.0033), -50: (0.012, -0.0034), -49: (0.0122, -0.0036), -48: (0.0122, -0.0036), -47: (0.0121, -0.0036), -46: (0.0121, -0.0036), -45: (0.0121, -0.0036), -44: (0.0123, -0.0036), -43: (0.0123, -0.0037), -42: (0.0123, -0.0036), -41: (0.0122, -0.0036), -40: (0.0121, -0.0036), -39: (0.012, -0.0035)}, -16: {-75: (0.0112, 0.0196), -74: (0.0109, 0.0197), -73: (0.0127, 0.0173), -72: (0.014, 0.0127), -71: (0.015, 0.0082), -70: (0.0156, 0.0059), -69: (0.0151, 0.004), -68: (0.0157, 0.001), -67: (0.016, -0.0007), -66: (0.0152, -0.0011), -65: (0.014, -0.0014), -64: (0.0134, -0.0013), -63: (0.0127, -0.0013), -62: (0.012, -0.0015), -61: (0.0116, -0.0017), -60: (0.0117, -0.002), -59: (0.0118, -0.0024), -58: (0.0119, -0.0026), -57: (0.0119, -0.0031), -56: (0.012, -0.0036), -55: (0.0121, -0.0035), -54: (0.012, -0.0033), -53: (0.0121, -0.0033), -52: (0.012, -0.0033), -51: (0.0119, -0.0033), -50: (0.012, -0.0035), -49: (0.012, -0.0035), -48: (0.0124, -0.0038), -47: (0.0121, -0.0036), -46: (0.012, -0.0036), -45: (0.012, -0.0033), -44: (0.0119, -0.0033), -43: (0.0121, -0.0035), -42: (0.0123, -0.0035), -41: (0.0123, -0.0036), -40: (0.0122, -0.0035), -39: (0.012, -0.0036)}, -17: {-73: (0.0131, 0.0195), -72: (0.0141, 0.0177), -71: (0.0161, 0.0143), -70: (0.0165, 0.0096), -69: (0.0151, 0.0085), -68: (0.0156, 0.0066), -67: (0.0163, 0.003), -66: (0.016, -0.0013), -65: (0.0149, -0.0009), -64: (0.0142, -0.0004), -63: (0.0129, -0.0011), -62: (0.0118, -0.0014), -61: (0.0112, -0.0011), -60: (0.0115, -0.0017), -59: (0.0117, -0.0022), -58: (0.0118, -0.0025), -57: (0.0119, -0.0026), -56: (0.0119, -0.0029), -55: (0.012, -0.0031), -54: (0.012, -0.0032), -53: (0.0121, -0.0031), -52: (0.0119, -0.0032), -51: (0.0119, -0.0032), -50: (0.0119, -0.0033), -49: (0.0119, -0.0034), -48: (0.0119, -0.0034), -47: (0.0119, -0.0035), -46: (0.0119, -0.0035), -45: (0.0119, -0.0033), -44: (0.0118, -0.0032), -43: (0.012, -0.0033), -42: (0.0123, -0.0035), -41: (0.0123, -0.0036), -40: (0.0122, -0.0036), -39: (0.0121, -0.0037)}, -18: {-72: (0.0155, 0.0203), -71: (0.0168, 0.0197), -70: (0.018, 0.016), -69: (0.0177, 0.0126), -68: (0.017, 0.0105), -67: (0.0169, 0.0075), -66: (0.0154, 0.006), -65: (0.0147, 0.004), -64: (0.0147, 0.0016), -63: (0.0127, -0.0023), -62: (0.0118, -0.0017), -61: (0.0108, -0.0005), -60: (0.0112, -0.0008), -59: (0.0117, -0.002), -58: (0.0118, -0.0022), -57: (0.0119, -0.0024), -56: (0.0119, -0.0027), -55: (0.012, -0.0029), -54: (0.012, -0.003), -53: (0.0121, -0.0031), -52: (0.012, -0.0031), -51: (0.0119, -0.0032), -50: (0.0118, -0.0033), -49: (0.0116, -0.0033), -48: (0.0115, -0.0035), -47: (0.0117, -0.0035), -46: (0.0119, -0.0034), -45: (0.0119, -0.0034), -44: (0.012, -0.0033), -43: (0.0122, -0.0034), -42: (0.0124, -0.0036), -41: (0.0124, -0.0036), -40: (0.0122, -0.0037), -39: (0.0121, -0.0038)}, -19: {-71: (0.0157, 0.0205), -70: (0.0156, 0.0197), -69: (0.0172, 0.0189), -68: (0.0174, 0.0136), -67: (0.0166, 0.0098), -66: (0.0158, 0.008), -65: (0.0139, 0.0085), -64: (0.0137, 0.0046), -63: (0.0123, -0.0007), -62: (0.0119, -0.0014), -61: (0.0115, -0.0013), -60: (0.0116, -0.0014), -59: (0.0117, -0.0018), -58: (0.0118, -0.0022), -57: (0.0119, -0.0023), -56: (0.0118, -0.0025), -55: (0.012, -0.0027), -54: (0.0119, -0.0027), -53: (0.012, -0.0028), -52: (0.012, -0.003), -51: (0.0118, -0.003), -50: (0.0117, -0.0031), -49: (0.0114, -0.0034), -48: (0.0112, -0.0034), -47: (0.0115, -0.0034), -46: (0.0118, -0.0034), -45: (0.0119, -0.0034), -44: (0.012, -0.0034), -43: (0.0123, -0.0035), -42: (0.0127, -0.0037), -41: (0.0124, -0.0037), -40: (0.0122, -0.0038), -39: (0.0121, -0.0039)}, -20: {-71: (0.0168, 0.0232), -70: (0.0153, 0.0195), -69: (0.0178, 0.0216), -68: (0.0167, 0.0151), -67: (0.0173, 0.0086), -66: (0.016, 0.0064), -65: (0.0141, 0.0054), -64: (0.0123, 0.0035), -63: (0.0117, 0.001), -62: (0.0117, -0.0007), -61: (0.0117, -0.0013), -60: (0.0117, -0.0014), -59: (0.0117, -0.0017), -58: (0.0118, -0.002), -57: (0.0119, -0.0023), -56: (0.0118, -0.0023), -55: (0.012, -0.0026), -54: (0.012, -0.0026), -53: (0.012, -0.0027), -52: (0.0119, -0.0028), -51: (0.0118, -0.0029), -50: (0.0118, -0.0031), -49: (0.0115, -0.0032), -48: (0.0114, -0.0032), -47: (0.0115, -0.0033), -46: (0.0117, -0.0033), -45: (0.0118, -0.0034), -44: (0.012, -0.0035), -43: (0.0123, -0.0036), -42: (0.0124, -0.0036), -41: (0.0123, -0.0038), -40: (0.0122, -0.0039)}, -21: {-71: (0.0175, 0.0251), -70: (0.0201, 0.0269), -69: (0.0165, 0.0187), -68: (0.0143, 0.0146), -67: (0.0154, 0.0113), -66: (0.0147, 0.0081), -65: (0.0129, 0.0054), -64: (0.0116, 0.0025), -63: (0.0116, 0.0), -62: (0.0115, -0.0013), -61: (0.0118, -0.0014), -60: (0.0118, -0.0015), -59: (0.0117, -0.0016), -58: (0.0117, -0.0019), -57: (0.0118, -0.0022), -56: (0.0119, -0.0023), -55: (0.012, -0.0024), -54: (0.012, -0.0025), -53: (0.0121, -0.0026), -52: (0.012, -0.0026), -51: (0.0119, -0.0027), -50: (0.0118, -0.0029), -49: (0.0117, -0.003), -48: (0.0116, -0.0032), -47: (0.0115, -0.0032), -46: (0.0115, -0.0032), -45: (0.0117, -0.0034), -44: (0.012, -0.0035), -43: (0.0123, -0.0035), -42: (0.0123, -0.0037), -41: (0.0122, -0.0038), -40: (0.0121, -0.0039)}, -22: {-71: (0.0177, 0.0259), -70: (0.019, 0.0269), -69: (0.0163, 0.0202), -68: (0.0156, 0.016), -67: (0.0144, 0.0127), -66: (0.0135, 0.0092), -65: (0.0121, 0.0064), -64: (0.0116, 0.0031), -63: (0.0116, 0.0002), -62: (0.012, -0.0009), -61: (0.012, -0.001), -60: (0.0119, -0.0014), -59: (0.0118, -0.0016), -58: (0.0117, -0.0019), -57: (0.0119, -0.002), -56: (0.0119, -0.0021), -55: (0.0121, -0.0022), -54: (0.0121, -0.0023), -53: (0.0122, -0.0024), -52: (0.0121, -0.0025), -51: (0.0119, -0.0027), -50: (0.0119, -0.0027), -49: (0.0118, -0.0029), -48: (0.0117, -0.003), -47: (0.0116, -0.0032), -46: (0.0115, -0.0033), -45: (0.0117, -0.0032), -44: (0.012, -0.0035), -43: (0.0121, -0.0037), -42: (0.0121, -0.0038), -41: (0.0121, -0.0039)}, -23: {-71: (0.0183, 0.0233), -70: (0.0157, 0.0247), -69: (0.0155, 0.0207), -68: (0.0152, 0.0152), -67: (0.0144, 0.0115), -66: (0.0132, 0.0092), -65: (0.0125, 0.007), -64: (0.0123, 0.0045), -63: (0.0122, 0.0024), -62: (0.0121, 0.0008), -61: (0.012, -0.0003), -60: (0.0118, -0.001), -59: (0.0116, -0.0016), -58: (0.0118, -0.0017), -57: (0.0119, -0.0018), -56: (0.012, -0.002), -55: (0.0122, -0.0021), -54: (0.0122, -0.0022), -53: (0.0122, -0.0022), -52: (0.0121, -0.0024), -51: (0.012, -0.0026), -50: (0.012, -0.0027), -49: (0.0119, -0.0029), -48: (0.0118, -0.0031), -47: (0.0117, -0.0032), -46: (0.0116, -0.0033), -45: (0.0116, -0.0034), -44: (0.0119, -0.0036), -43: (0.0117, -0.0041), -42: (0.0119, -0.004)}, -24: {-71: (0.0177, 0.0218), -70: (0.0174, 0.0228), -69: (0.0141, 0.0173), -68: (0.0147, 0.0096), -67: (0.0141, 0.009), -66: (0.0131, 0.0074), -65: (0.0129, 0.006), -64: (0.0133, 0.0048), -63: (0.0128, 0.0033), -62: (0.0122, 0.0017), -61: (0.0118, 0.0002), -60: (0.0119, -0.0007), -59: (0.0116, -0.0015), -58: (0.0119, -0.0016), -57: (0.0121, -0.0017), -56: (0.0121, -0.0018), -55: (0.0123, -0.0019), -54: (0.0124, -0.0021), -53: (0.0123, -0.0022), -52: (0.0122, -0.0024), -51: (0.012, -0.0026), -50: (0.012, -0.0027), -49: (0.012, -0.003), -48: (0.012, -0.0031), -47: (0.0118, -0.0032), -46: (0.0116, -0.0034)}, -25: {-71: (0.0167, 0.0242), -70: (0.0178, 0.0225), -69: (0.0136, 0.0132), -68: (0.0149, 0.0096), -67: (0.0142, 0.008), -66: (0.0129, 0.0062), -65: (0.0135, 0.0052), -64: (0.0153, 0.005), -63: (0.0126, 0.0036), -62: (0.0122, 0.0019), -61: (0.0117, 0.0004), -60: (0.0116, -0.0008), -59: (0.0117, -0.0014), -58: (0.012, -0.0016), -57: (0.0122, -0.0017), -56: (0.0123, -0.0018), -55: (0.0126, -0.0018), -54: (0.0126, -0.0019), -53: (0.0124, -0.0021), -52: (0.0122, -0.0023), -51: (0.012, -0.0025), -50: (0.012, -0.0028), -49: (0.012, -0.003), -48: (0.0123, -0.0031), -47: (0.0119, -0.0031)}, -26: {-71: (0.0175, 0.0259), -70: (0.0176, 0.0204), -69: (0.0164, 0.0158), -68: (0.0157, 0.0119), -67: (0.0142, 0.0083), -66: (0.0132, 0.0058), -65: (0.0135, 0.0047), -64: (0.0139, 0.0041), -63: (0.0128, 0.003), -62: (0.012, 0.0018), -61: (0.0116, 0.0004), -60: (0.0118, -0.0004), -59: (0.0116, -0.0012), -58: (0.0119, -0.0014), -57: (0.0122, -0.0015), -56: (0.0123, -0.0016), -55: (0.0127, -0.0017), -54: (0.0126, -0.0019), -53: (0.0124, -0.002), -52: (0.0122, -0.0022), -51: (0.012, -0.0024), -50: (0.012, -0.0026), -49: (0.012, -0.0029), -48: (0.012, -0.003)}, -27: {-71: (0.0191, 0.025), -70: (0.017, 0.0207), -69: (0.0173, 0.0144), -68: (0.016, 0.0117), -67: (0.0129, 0.0059), -66: (0.0125, 0.0038), -65: (0.0118, 0.003), -64: (0.013, 0.0035), -63: (0.0123, 0.0028), -62: (0.0116, 0.0015), -61: (0.0116, 0.0004), -60: (0.0114, -0.0005), -59: (0.0117, -0.0009), -58: (0.0119, -0.0011), -57: (0.0121, -0.0013), -56: (0.0122, -0.0015), -55: (0.0124, -0.0016), -54: (0.0124, -0.0018), -53: (0.0123, -0.002), -52: (0.0122, -0.0022), -51: (0.012, -0.0024), -50: (0.012, -0.0026), -49: (0.012, -0.0027), -48: (0.012, -0.0028)}, -28: {-72: (0.0184, 0.0228), -71: (0.0196, 0.0246), -70: (0.0171, 0.0203), -69: (0.016, 0.0153), -68: (0.0138, 0.0095), -67: (0.0125, 0.0052), -66: (0.0129, 0.004), -65: (0.012, 0.0013), -64: (0.0134, 0.0053), -63: (0.0122, 0.0027), -62: (0.0115, 0.0014), -61: (0.0115, 0.0004), -60: (0.0117, 0.0001), -59: (0.0116, -0.0006), -58: (0.0118, -0.0008), -57: (0.012, -0.001), -56: (0.0121, -0.0013), -55: (0.0122, -0.0016), -54: (0.0121, -0.0019), -53: (0.0122, -0.002), -52: (0.0122, -0.0021), -51: (0.0121, -0.0023), -50: (0.0121, -0.0024), -49: (0.012, -0.0026), -48: (0.012, -0.0027)}, -29: {-72: (0.0188, 0.0216), -71: (0.0181, 0.0212), -70: (0.0167, 0.0192), -69: (0.0157, 0.0131), -68: (0.0131, 0.0084), -67: (0.0131, 0.0065), -66: (0.0131, 0.005), -65: (0.0137, 0.0033), -64: (0.0118, 0.002), -63: (0.0115, 0.0013), -62: (0.0115, 0.0008), -61: (0.0116, 0.0004), -60: (0.0117, -0.0001), -59: (0.0117, -0.0003), -58: (0.0116, -0.0005), -57: (0.0119, -0.0009), -56: (0.012, -0.0012), -55: (0.0121, -0.0016), -54: (0.0122, -0.0019), -53: (0.0122, -0.0019), -52: (0.0122, -0.002), -51: (0.0121, -0.0021), -50: (0.0122, -0.0022), -49: (0.012, -0.0025)}, -30: {-72: (0.0183, 0.0204), -71: (0.0179, 0.0178), -70: (0.0175, 0.0179), -69: (0.0153, 0.0116), -68: (0.0129, 0.0062), -67: (0.0129, 0.0057), -66: (0.0124, 0.0039), -65: (0.0123, 0.002), -64: (0.0099, -0.0004), -63: (0.0108, 0.0004), -62: (0.0116, 0.0007), -61: (0.0117, 0.0003), -60: (0.0125, 0.0005), -59: (0.0114, -0.0004), -58: (0.0125, -0.0003), -57: (0.0119, -0.0009), -56: (0.0119, -0.0012), -55: (0.012, -0.0016), -54: (0.0121, -0.0018), -53: (0.0122, -0.0019), -52: (0.0122, -0.002), -51: (0.0123, -0.0019), -50: (0.0122, -0.0022)}, -31: {-72: (0.0183, 0.0243), -71: (0.0175, 0.02), -70: (0.0169, 0.0167), -69: (0.0147, 0.0116), -68: (0.0131, 0.0077), -67: (0.0113, 0.0038), -66: (0.0118, 0.0027), -65: (0.0116, 0.0016), -64: (0.0117, 0.0019), -63: (0.0117, 0.0017), -62: (0.0118, 0.0011), -61: (0.0119, 0.0005), -60: (0.0118, -0.0001), -59: (0.0117, -0.0004), -58: (0.0118, -0.0006), -57: (0.0119, -0.0009), -56: (0.0119, -0.0012), -55: (0.0119, -0.0015), -54: (0.012, -0.0018), -53: (0.012, -0.0019), -52: (0.012, -0.002), -51: (0.0121, -0.0021), -50: (0.012, -0.0022)}, -32: {-72: (0.0192, 0.0232), -71: (0.0182, 0.0218), -70: (0.0168, 0.0169), -69: (0.0139, 0.0103), -68: (0.0124, 0.0063), -67: (0.0115, 0.0031), -66: (0.0108, 0.0021), -65: (0.0122, 0.0017), -64: (0.012, 0.0024), -63: (0.0119, 0.0021), -62: (0.012, 0.0013), -61: (0.0118, 0.0006), -60: (0.0119, 0.0001), -59: (0.0117, -0.0003), -58: (0.0118, -0.0006), -57: (0.0118, -0.0011), -56: (0.0117, -0.0013), -55: (0.0118, -0.0016), -54: (0.0118, -0.0018), -53: (0.0118, -0.002), -52: (0.0119, -0.002), -51: (0.0119, -0.0022)}, -33: {-72: (0.0205, 0.026), -71: (0.0178, 0.0232), -70: (0.0152, 0.0169), -69: (0.0131, 0.009), -68: (0.012, 0.0058), -67: (0.0102, 0.0028), -66: (0.012, 0.0025), -65: (0.0122, 0.0023), -64: (0.0119, 0.0025), -63: (0.0119, 0.0022), -62: (0.0116, 0.0013), -61: (0.0121, 0.0006), -60: (0.012, 0.0001), -59: (0.0117, -0.0003), -58: (0.0118, -0.0008), -57: (0.0117, -0.0012), -56: (0.0116, -0.0016), -55: (0.0116, -0.002), -54: (0.0116, -0.0023), -53: (0.0117, -0.0025), -52: (0.0118, -0.0024)}, -34: {-72: (0.0205, 0.0258), -71: (0.0184, 0.0208), -70: (0.0164, 0.0156), -69: (0.0146, 0.0095), -68: (0.0124, 0.0067), -67: (0.0114, 0.0048), -66: (0.0118, 0.0037), -65: (0.0127, 0.0026), -64: (0.0121, 0.0028), -63: (0.0118, 0.0021), -62: (0.0117, 0.0015), -61: (0.0117, 0.0008), -60: (0.0118, 0.0002), -59: (0.0117, -0.0004), -58: (0.0117, -0.0009), -57: (0.0116, -0.0015), -56: (0.0114, -0.0019), -55: (0.0115, -0.0023), -54: (0.0114, -0.0026), -53: (0.0117, -0.0026)}, -35: {-73: (0.0213, 0.0314), -72: (0.0215, 0.031), -71: (0.0187, 0.0249), -70: (0.0161, 0.0117), -69: (0.0132, 0.0071), -68: (0.0122, 0.0055), -67: (0.0116, 0.0049), -66: (0.0119, 0.0042), -65: (0.0138, 0.0045), -64: (0.0121, 0.0032), -63: (0.0117, 0.0024), -62: (0.0115, 0.0017), -61: (0.0113, 0.0009), -60: (0.0115, 0.0004), -59: (0.0116, -0.0002), -58: (0.0119, -0.001), -57: (0.0115, -0.0017), -56: (0.0113, -0.0024), -55: (0.0116, -0.0021), -54: (0.0116, -0.0021)}, -36: {-73: (0.0228, 0.0363), -72: (0.018, 0.0298), -71: (0.0147, 0.0203), -70: (0.0117, 0.0106), -69: (0.0114, 0.0078), -68: (0.011, 0.0042), -67: (0.0109, 0.0026), -66: (0.0116, 0.0034), -65: (0.0121, 0.0032), -64: (0.0117, 0.0028), -63: (0.0115, 0.0023), -62: (0.0112, 0.0019), -61: (0.0113, 0.0015), -60: (0.0113, 0.0009), -59: (0.0115, 0.0002), -58: (0.0116, -0.0005), -57: (0.0117, -0.0011), -56: (0.0116, -0.0014)}, -37: {-74: (0.0227, 0.034), -73: (0.0222, 0.0305), -72: (0.0158, 0.0249), -71: (0.012, 0.0169), -70: (0.0093, 0.01), -69: (0.0096, 0.0055), -68: (0.0099, 0.0034), -67: (0.0106, 0.0022), -66: (0.0113, 0.0026), -65: (0.0113, 0.0025), -64: (0.0111, 0.0022), -63: (0.0109, 0.0023), -62: (0.0106, 0.0022), -61: (0.0111, 0.0019), -60: (0.0111, 0.0014), -59: (0.0114, 0.0009), -58: (0.0118, 0.0), -57: (0.0119, -0.0007), -56: (0.0117, -0.001)}, -38: {-74: (0.0218, 0.0254), -73: (0.0195, 0.0193), -72: (0.0136, 0.0115), -71: (0.0091, 0.0075), -70: (0.0081, 0.0053), -69: (0.009, 0.0026), -68: (0.0101, 0.0024), -67: (0.0109, 0.0028), -66: (0.0107, 0.0021), -65: (0.0106, 0.0009), -64: (0.0109, 0.0013), -63: (0.0107, 0.0015), -62: (0.0096, 0.0036), -61: (0.0104, 0.0026), -60: (0.0107, 0.0015), -59: (0.011, 0.0009), -58: (0.0119, -0.0002), -57: (0.0122, -0.0006)}, -39: {-74: (0.0203, 0.0204), -73: (0.0183, 0.0142), -72: (0.0137, 0.0051), -71: (0.0086, 0.0005), -70: (0.007, 0.0004), -69: (0.0119, -0.0001), -68: (0.0116, 0.0016), -67: (0.0114, 0.0018), -66: (0.011, 0.0015), -65: (0.011, 0.001), -64: (0.0111, 0.0007), -63: (0.011, 0.0003), -62: (0.0108, 0.0002), -61: (0.0105, 0.001), -60: (0.0109, 0.0009), -59: (0.0112, 0.0005), -58: (0.0116, -0.0001)}, -40: {-74: (0.02, 0.0207), -73: (0.0189, 0.0112), -72: (0.0148, 0.0008), -71: (0.0108, -0.0027), -70: (0.0104, -0.0024), -69: (0.012, -0.0014), -68: (0.012, -0.0003), -67: (0.0119, 0.0008), -66: (0.0117, 0.001), -65: (0.0112, 0.0003), -64: (0.0115, 0.0004), -63: (0.0111, -0.0002), -62: (0.0111, -0.0001)}, -41: {-75: (0.0194, 0.0185), -74: (0.0205, 0.0178), -73: (0.0155, 0.0061), -72: (0.0134, -0.0016), -71: (0.0102, -0.0075), -70: (0.012, -0.0064), -69: (0.0122, -0.0027), -68: (0.0124, -0.001), -67: (0.0123, 0.0), -66: (0.0121, 0.0007), -65: (0.0115, -0.0005), -64: (0.0116, -0.0002), -63: (0.0115, -0.0007), -62: (0.0112, -0.0009)}, -42: {-75: (0.0187, 0.0144), -74: (0.0198, 0.0133), -73: (0.0147, 0.002), -72: (0.0121, -0.0047), -71: (0.0125, -0.0058), -70: (0.0126, -0.004), -69: (0.0127, -0.0024), -68: (0.0127, -0.0015), -67: (0.0124, -0.0008), -66: (0.0123, -0.0004), -65: (0.012, -0.0004), -64: (0.0119, -0.0002), -63: (0.0116, -0.0012), -62: (0.0115, -0.0013)}, -43: {-75: (0.017, 0.0101), -74: (0.0158, 0.0069), -73: (0.0134, 0.0026), -72: (0.0125, -0.0005), -71: (0.0128, -0.0021), -70: (0.0129, -0.0022), -69: (0.0129, -0.0016), -68: (0.0127, -0.0014), -67: (0.0126, -0.0012), -66: (0.0124, -0.0015), -65: (0.0119, -0.0016), -64: (0.012, -0.0003)}, -44: {-75: (0.0156, 0.0073), -74: (0.0145, 0.0045), -73: (0.0132, 0.0024), -72: (0.0125, 0.0004), -71: (0.0126, -0.0006), -70: (0.0128, -0.0016), -69: (0.0129, -0.0018), -68: (0.0128, -0.0017), -67: (0.0126, -0.0016), -66: (0.0125, -0.0015), -65: (0.0122, -0.0012)}, -45: {-75: (0.0147, 0.0058), -74: (0.0138, 0.0035), -73: (0.0128, 0.001), -72: (0.0118, -0.0012), -71: (0.0122, -0.002), -70: (0.0128, -0.0025), -69: (0.0133, -0.0029), -68: (0.013, -0.0032), -67: (0.0128, -0.002), -66: (0.0127, -0.0016), -65: (0.0125, -0.0012)}, -46: {-75: (0.0134, 0.0027), -74: (0.0131, 0.0022), -73: (0.0123, -0.0003), -72: (0.0121, -0.003), -71: (0.0126, -0.0027), -70: (0.0129, -0.0028), -69: (0.0132, -0.005), -68: (0.0132, -0.0051), -67: (0.0131, -0.0028), -66: (0.0129, -0.0018)}, -47: {-75: (0.0132, 0.0029), -74: (0.0126, 0.0023), -73: (0.0126, 0.0009), -72: (0.0128, -0.0003), -71: (0.0116, 0.0019), -70: (0.0125, -0.0005), -69: (0.013, -0.0019), -68: (0.0135, -0.0027), -67: (0.0132, -0.0022), -66: (0.0127, -0.0028), -65: (0.0127, -0.0022)}, -48: {-75: (0.0126, 0.004), -74: (0.0123, 0.0034), -73: (0.0114, 0.0039), -72: (0.012, 0.0023), -71: (0.0122, 0.002), -70: (0.0123, 0.0013), -69: (0.0124, 0.0007), -68: (0.0129, -0.0003), -67: (0.0129, -0.001), -66: (0.0126, -0.0022), -65: (0.0127, -0.0016)}, -49: {-75: (0.0124, 0.0041), -74: (0.0122, 0.0039), -73: (0.0118, 0.0036), -72: (0.012, 0.003), -71: (0.0121, 0.0026), -70: (0.0123, 0.0022), -69: (0.0124, 0.0016), -68: (0.0126, 0.0011), -67: (0.0127, 0.0006)}, -50: {-75: (0.0123, 0.0043), -74: (0.0121, 0.004), -73: (0.012, 0.0037), -72: (0.012, 0.0035), -71: (0.0118, 0.0036), -70: (0.0121, 0.0028), -69: (0.0123, 0.0025), -68: (0.0125, 0.002)}, -51: {-75: (0.0122, 0.0046), -74: (0.0122, 0.0043), -73: (0.0121, 0.004), -72: (0.0122, 0.0037), -71: (0.0122, 0.0036), -70: (0.0122, 0.0033), -69: (0.0122, 0.0031)}, -52: {-74: (0.0122, 0.0045), -73: (0.0123, 0.0042), -72: (0.0125, 0.0038), -71: (0.0129, 0.0032), -70: (0.0131, 0.0038), -69: (0.012, 0.0037)}, -53: {-74: (0.0122, 0.0049), -73: (0.0124, 0.0045), -72: (0.0125, 0.0046), -71: (0.0133, 0.0048), -70: (0.0126, 0.0042), -69: (0.0126, 0.0035), -68: (0.012, 0.0036)}, -54: {-72: (0.0126, 0.0046), -71: (0.013, 0.0042), -70: (0.0126, 0.0053), -69: (0.012, 0.0054), -68: (0.0117, 0.0053), -67: (0.0109, 0.0045)}, -55: {-70: (0.0125, 0.0062), -69: (0.0121, 0.0082), -68: (0.0113, 0.0092), -67: (0.0105, 0.0091), -66: (0.0107, 0.0071)}}

vemos2017 = {32: {-110: (-0.0079, -0.009), -109: (-0.0074, -0.0091), -108: (-0.0092, -0.0109), -107: (-0.0087, -0.011), -106: (-0.0082, -0.0111)}, 31: {-110: (-0.0079, -0.0084), -109: (-0.0074, -0.0085), -108: (-0.0084, -0.0093), -107: (-0.0087, -0.0104), -106: (-0.0082, -0.0105), -105: (-0.0077, -0.0106)}, 30: {-110: (-0.0079, -0.0078), -109: (-0.0089, -0.0085), -108: (-0.0088, -0.0088), -107: (-0.0083, -0.0088), -106: (-0.0074, -0.009), -105: (-0.0077, -0.01), -104: (-0.007, -0.0104)}, 29: {-110: (-0.0077, -0.0076), -109: (-0.0088, -0.0085), -108: (-0.0088, -0.0082), -107: (-0.0083, -0.0082), -106: (-0.0073, -0.0087), -105: (-0.0071, -0.01), -104: (-0.0076, -0.0102), -103: (-0.0071, -0.0103), -102: (-0.0066, -0.0103)}, 28: {-110: (-0.0077, -0.0071), -109: (-0.0072, -0.0072), -108: (-0.0067, -0.0073), -107: (-0.0078, -0.008), -106: (-0.008, -0.0092), -105: (-0.0071, -0.0094), -104: (-0.007, -0.0097), -103: (-0.0071, -0.0097), -102: (-0.0066, -0.0097), -101: (-0.0061, -0.0098)}, 27: {-110: (-0.0077, -0.0065), -109: (-0.0072, -0.0066), -108: (-0.0067, -0.0067), -107: (-0.0066, -0.0084), -106: (-0.0061, -0.0085), -105: (-0.0056, -0.0086), -104: (-0.0066, -0.009), -103: (-0.0052, -0.0091), -102: (-0.006, -0.0092), -101: (-0.0057, -0.0097), -100: (-0.0048, -0.0097)}, 26: {-110: (-0.0077, -0.0059), -109: (-0.0072, -0.006), -108: (-0.0071, -0.0078), -107: (-0.0066, -0.0078), -106: (-0.0061, -0.0079), -105: (-0.0056, -0.008), -104: (-0.0054, -0.0083), -103: (-0.0052, -0.0085), -102: (-0.004, -0.0089), -101: (-0.0041, -0.0089), -100: (-0.0041, -0.0091), -99: (-0.0036, -0.0091)}, 25: {-109: (-0.0073, -0.0059), -108: (-0.0071, -0.0072), -107: (-0.0066, -0.0073), -106: (-0.0061, -0.0073), -105: (-0.0056, -0.0074), -104: (-0.0055, -0.008), -103: (-0.0045, -0.0083), -102: (-0.004, -0.0083), -101: (-0.0035, -0.0084), -100: (-0.0041, -0.0085), -99: (-0.0036, -0.0085), -98: (-0.0031, -0.0086), -79: (0.002, -0.0081), -78: (0.0025, -0.0081), -77: (0.0031, -0.0079)}, 24: {-108: (-0.0071, -0.0066), -107: (-0.0062, -0.0069), -106: (-0.0055, -0.0072), -105: (-0.0053, -0.0072), -104: (-0.0046, -0.0074), -103: (-0.0041, -0.0076), -102: (-0.004, -0.0077), -101: (-0.0034, -0.0079), -100: (-0.0041, -0.0079), -99: (-0.0036, -0.0079), -98: (-0.0031, -0.008), -79: (0.0021, -0.0082), -78: (0.0026, -0.0081), -77: (0.003, -0.008), -76: (0.0035, -0.008), -75: (0.004, -0.0079)}, 23: {-107: (-0.006, -0.0067), -106: (-0.0055, -0.0067), -105: (-0.005, -0.0067), -104: (-0.0046, -0.0069), -103: (-0.0041, -0.007), -102: (-0.0037, -0.0072), -101: (-0.0032, -0.0073), -100: (-0.0039, -0.0073), -99: (-0.0036, -0.0074), -98: (-0.0031, -0.0074), -97: (-0.003, -0.0072), -79: (0.0021, -0.0073), -78: (0.0026, -0.0073), -77: (0.0031, -0.0072), -76: (0.0034, -0.0079), -75: (0.0038, -0.0078), -74: (0.0043, -0.0078), -73: (0.0044, -0.0077)}, 22: {-106: (-0.0042, -0.0053), -105: (-0.0029, -0.0053), -104: (-0.0036, -0.0057), -103: (-0.0042, -0.0066), -102: (-0.0035, -0.0066), -101: (-0.0033, -0.0067), -100: (-0.0033, -0.0068), -99: (-0.0035, -0.0067), -98: (-0.0035, -0.0064), -97: (-0.003, -0.0064), -96: (-0.0025, -0.0064), -80: (0.0017, -0.0064), -79: (0.0022, -0.0064), -78: (0.0028, -0.0068), -77: (0.0032, -0.007), -76: (0.0037, -0.0069), -75: (0.0039, -0.0071), -74: (0.0043, -0.0072), -73: (0.004, -0.0058), -72: (0.0043, -0.0051)}, 21: {-106: (-0.0034, -0.0047), -105: (-0.0029, -0.0047), -104: (-0.0025, -0.0048), -103: (-0.0022, -0.005), -102: (-0.0037, -0.006), -101: (-0.0034, -0.0061), -100: (-0.0037, -0.0058), -99: (-0.0042, -0.0059), -98: (-0.004, -0.0058), -97: (-0.0035, -0.0058), -96: (-0.003, -0.0058), -95: (-0.0026, -0.0063), -94: (-0.0021, -0.0068), -93: (-0.002, -0.0068), -92: (-0.0016, -0.0068), -91: (-0.0019, -0.0068), -90: (-0.0014, -0.0068), -89: (-0.0009, -0.0067), -88: (-0.001, -0.0068), -87: (-0.0007, -0.0068), -86: (-0.0002, -0.0068), -85: (0.0004, -0.0068), -84: (0.0004, -0.007), -83: (0.0003, -0.0061), -82: (0.0008, -0.006), -81: (0.0013, -0.006), -80: (0.0017, -0.0061), -79: (0.0022, -0.0057), -78: (0.0027, -0.0059), -77: (0.0033, -0.0062), -76: (0.0034, -0.0062), -75: (0.004, -0.0064), -74: (0.0037, -0.0043), -73: (0.0038, -0.0046), -72: (0.0045, -0.0035), -71: (0.0051, -0.0036)}, 20: {-106: (-0.0043, -0.0044), -105: (-0.0028, -0.0039), -104: (-0.0017, -0.0036), -103: (-0.0016, -0.0039), -102: (-0.0018, -0.0045), -101: (-0.0042, -0.0052), -100: (-0.0046, -0.0051), -99: (-0.0041, -0.005), -98: (-0.004, -0.0052), -97: (-0.0035, -0.0052), -96: (-0.0013, -0.0054), -95: (-0.0007, -0.0056), -94: (-0.0015, -0.0059), -93: (-0.0022, -0.0066), -92: (-0.0015, -0.0062), -91: (-0.0015, -0.0066), -90: (-0.0014, -0.0062), -89: (-0.0009, -0.0063), -88: (-0.001, -0.0064), -87: (-0.0007, -0.0062), -86: (-0.0002, -0.0062), -85: (0.0004, -0.0048), -84: (0.0005, -0.0053), -83: (0.0005, -0.0045), -82: (0.0008, -0.0054), -81: (0.0013, -0.0054), -80: (0.0018, -0.0053), -79: (0.0022, -0.0051), -78: (0.0027, -0.0051), -77: (0.0046, 0.0019), -76: (0.0041, -0.0026), -75: (0.0052, -0.0021), -74: (0.0037, -0.0037), -73: (0.0039, -0.0019), -72: (0.0049, -0.0006), -71: (0.0055, 0.0005)}, 19: {-105: (-0.0027, -0.0032), -104: (-0.0006, -0.0024), -103: (-0.003, -0.0031), -102: (-0.0023, -0.0034), -101: (-0.0024, -0.0037), -100: (-0.0046, -0.0045), -99: (-0.0034, -0.0045), -98: (-0.0039, -0.0043), -97: (-0.0017, -0.0044), -96: (-0.0012, -0.005), -95: (-0.0007, -0.005), -94: (-0.0003, -0.005), -93: (-0.0014, -0.0056), -92: (-0.0015, -0.0062), -91: (-0.001, -0.0063), -90: (-0.0013, -0.0062), -89: (-0.001, -0.0062), -88: (-0.0008, -0.0062), -87: (-0.0004, -0.0057), -86: (0.0, -0.0058), -85: (0.0004, -0.0042), -84: (0.0006, -0.0047), -83: (0.0006, -0.0038), -82: (0.0008, -0.005), -81: (0.0013, -0.0049), -80: (0.0018, -0.0047), -79: (0.0034, 0.0009), -78: (0.0052, 0.0075), -77: (0.0051, 0.0045), -76: (0.0058, 0.0055), -75: (0.0067, 0.0052), -74: (0.0052, 0.0035), -73: (0.0059, 0.0052), -72: (0.0055, 0.0031), -71: (0.0059, 0.0033), -70: (0.0067, 0.0024), -69: (0.0071, 0.0038), -68: (0.0103, 0.0088), -67: (0.0118, 0.0094), -66: (0.0125, 0.0099), -65: (0.0128, 0.0098), -64: (0.0133, 0.0099), -63: (0.0142, 0.0099)}, 18: {-103: (-0.0024, -0.0026), -102: (-0.0024, -0.0029), -101: (-0.0027, -0.0026), -100: (-0.0033, -0.0039), -99: (-0.0028, -0.0038), -98: (-0.0022, -0.0039), -97: (-0.0011, -0.0039), -96: (-0.0012, -0.0044), -95: (-0.0006, -0.0041), -94: (0.0001, -0.0042), -93: (-0.0011, -0.005), -92: (-0.0006, -0.0051), -91: (-0.0027, -0.0074), -90: (-0.0022, -0.0071), -89: (-0.0016, -0.0067), -88: (-0.0008, -0.0057), -87: (0.0013, -0.0015), -86: (0.0023, 0.0014), -85: (0.0029, 0.0014), -84: (0.0027, 0.0014), -83: (0.0008, -0.0028), -82: (0.0011, -0.0033), -81: (0.0013, -0.0042), -80: (0.0018, -0.0042), -79: (0.0034, 0.0012), -78: (0.0054, 0.0086), -77: (0.0059, 0.0086), -76: (0.0064, 0.0086), -75: (0.0073, 0.0088), -74: (0.0073, 0.009), -73: (0.0076, 0.0093), -72: (0.0068, 0.0074), -71: (0.0069, 0.0083), -70: (0.0069, 0.0063), -69: (0.0081, 0.0082), -68: (0.0105, 0.0094), -67: (0.0121, 0.0103), -66: (0.0124, 0.0104), -65: (0.0127, 0.0105), -64: (0.0133, 0.0105), -63: (0.0157, 0.0107), -62: (0.0167, 0.0107), -61: (0.0178, 0.0109)}, 17: {-101: (-0.0027, -0.002), -100: (-0.003, -0.0032), -99: (-0.0025, -0.0033), -98: (-0.0017, -0.0033), -97: (0.0007, -0.0035), -96: (-0.0012, -0.0038), -95: (0.0004, -0.0036), -94: (0.0004, -0.0036), -93: (-0.0018, -0.0048), -92: (-0.0021, -0.0057), -91: (-0.0023, -0.0061), -90: (-0.0023, -0.0065), -89: (-0.0014, -0.0057), -88: (0.0002, -0.0025), -87: (0.0028, 0.0025), -86: (0.0022, 0.0015), -85: (0.0033, 0.0042), -84: (0.0045, 0.0073), -83: (0.0023, 0.0016), -82: (0.002, -0.0001), -81: (0.0016, -0.0027), -80: (0.0026, 0.0), -79: (0.0049, 0.0091), -78: (0.0054, 0.0092), -77: (0.006, 0.0095), -76: (0.0065, 0.0096), -75: (0.0076, 0.0095), -74: (0.0073, 0.0096), -73: (0.0076, 0.0098), -72: (0.0068, 0.01), -71: (0.0073, 0.0101), -70: (0.0072, 0.0093), -69: (0.0078, 0.0087), -68: (0.0113, 0.0104), -67: (0.0122, 0.0108), -66: (0.0124, 0.011), -65: (0.0127, 0.0111), -64: (0.015, 0.011), -63: (0.0159, 0.0112), -62: (0.0162, 0.0114), -61: (0.0169, 0.0115), -60: (0.0155, 0.0117)}, 16: {-98: (-0.0019, -0.0027), -97: (-0.0011, -0.0027), -96: (-0.0011, -0.0029), -95: (0.0004, -0.003), -94: (-0.0029, -0.0045), -93: (-0.0026, -0.0046), -92: (-0.0014, -0.0044), -91: (-0.0022, -0.0052), -90: (-0.0023, -0.0057), -89: (-0.0012, -0.0043), -88: (0.0007, 0.0), -87: (0.0042, 0.0062), -86: (0.0035, 0.0065), -85: (0.004, 0.0079), -84: (0.0045, 0.0079), -83: (0.0036, 0.0073), -82: (0.0042, 0.0076), -81: (0.0047, 0.0077), -80: (0.0043, 0.0071), -79: (0.0054, 0.0111), -78: (0.0054, 0.0097), -77: (0.0061, 0.0102), -76: (0.0065, 0.01), -75: (0.0073, 0.0099), -74: (0.0073, 0.0102), -73: (0.0076, 0.0104), -72: (0.0068, 0.0105), -71: (0.0068, 0.0097), -70: (0.0077, 0.0103), -69: (0.0087, 0.0099), -68: (0.0113, 0.0109), -67: (0.0123, 0.0115), -66: (0.0123, 0.0121), -65: (0.0126, 0.0117), -64: (0.0162, 0.0118), -63: (0.0161, 0.0119), -62: (0.0163, 0.0121), -61: (0.0167, 0.0122), -60: (0.0145, 0.0126)}, 15: {-93: (-0.0022, -0.0039), -92: (-0.0015, -0.0031), -91: (-0.0006, -0.0026), -90: (-0.0007, -0.0016), -89: (0.0004, 0.0001), -88: (0.002, 0.0068), -87: (0.004, 0.0099), -86: (0.0046, 0.01), -85: (0.0053, 0.0106), -84: (0.0045, 0.0085), -83: (0.0039, 0.0096), -82: (0.0052, 0.0122), -81: (0.0057, 0.0122), -80: (0.0055, 0.012), -79: (0.0054, 0.011), -78: (0.0056, 0.0108), -77: (0.006, 0.0105), -76: (0.0065, 0.0105), -75: (0.0073, 0.0107), -74: (0.0094, 0.0112), -73: (0.0098, 0.0109), -72: (0.0102, 0.0118), -71: (0.0107, 0.0118), -70: (0.0101, 0.0116), -69: (0.0104, 0.0114), -68: (0.012, 0.0121), -67: (0.0121, 0.0122), -66: (0.0122, 0.0124), -65: (0.0144, 0.0122), -64: (0.0162, 0.0123), -63: (0.0165, 0.0125), -62: (0.0152, 0.0129), -61: (0.0141, 0.0132), -60: (0.0145, 0.0134), -59: (0.0148, 0.0131)}, 14: {-92: (0.0003, -0.0015), -91: (0.0022, 0.0012), -90: (0.0018, 0.0026), -89: (0.0015, 0.0044), -88: (0.002, 0.0076), -87: (0.0033, 0.009), -86: (0.0045, 0.0088), -85: (0.0052, 0.0095), -84: (0.0051, 0.0114), -83: (0.005, 0.0128), -82: (0.0052, 0.0128), -81: (0.0056, 0.0128), -80: (0.0062, 0.0128), -79: (0.006, 0.0126), -78: (0.0064, 0.0111), -77: (0.0086, 0.0104), -76: (0.0098, 0.0104), -75: (0.0123, 0.0098), -74: (0.0128, 0.0109), -73: (0.0133, 0.0109), -72: (0.0124, 0.0118), -71: (0.0114, 0.0123), -70: (0.0119, 0.0123), -69: (0.0123, 0.0124), -68: (0.012, 0.0127), -67: (0.0125, 0.0127), -66: (0.0126, 0.0128), -65: (0.0126, 0.0129), -64: (0.0125, 0.0134), -63: (0.0129, 0.0135), -62: (0.0134, 0.0135), -61: (0.0138, 0.0142), -60: (0.0145, 0.0138), -59: (0.0149, 0.0134), -58: (0.0154, 0.0136)}, 13: {-89: (0.0028, 0.0075), -88: (0.0021, 0.01), -87: (0.0038, 0.0095), -86: (0.0047, 0.0093), -85: (0.0051, 0.0107), -84: (0.0052, 0.0116), -83: (0.0047, 0.0133), -82: (0.0051, 0.0133), -81: (0.0055, 0.0134), -80: (0.0062, 0.0134), -79: (0.0086, 0.0147), -78: (0.0085, 0.0113), -77: (0.0102, 0.0101), -76: (0.0121, 0.0095), -75: (0.0126, 0.0095), -74: (0.013, 0.0109), -73: (0.0133, 0.0115), -72: (0.0124, 0.0123), -71: (0.0115, 0.0127), -70: (0.0117, 0.013), -69: (0.0121, 0.013), -68: (0.0128, 0.013), -67: (0.0133, 0.0123), -66: (0.0123, 0.0134), -65: (0.0122, 0.0138), -64: (0.0125, 0.0138), -63: (0.0126, 0.0137), -62: (0.0134, 0.0139), -61: (0.0137, 0.0139), -60: (0.0142, 0.0138), -59: (0.0149, 0.0138), -58: (0.0154, 0.014)}, 12: {-88: (0.0029, 0.0104), -87: (0.0053, 0.0089), -86: (0.0063, 0.0086), -85: (0.0069, 0.0086), -84: (0.011, 0.0111), -83: (0.006, 0.0146), -82: (0.0069, 0.0151), -81: (0.0065, 0.0151), -80: (0.0073, 0.0148), -79: (0.0088, 0.0154), -78: (0.0099, 0.0129), -77: (0.0102, 0.0106), -76: (0.0107, 0.0106), -75: (0.0117, 0.0109), -74: (0.0136, 0.0102), -73: (0.0138, 0.0112), -72: (0.0134, 0.0113), -71: (0.0125, 0.0119), -70: (0.0117, 0.0135), -69: (0.0119, 0.0136), -68: (0.013, 0.0127), -67: (0.0139, 0.0126), -66: (0.0123, 0.0139), -65: (0.0116, 0.0135), -64: (0.0121, 0.0136), -63: (0.0125, 0.0136), -62: (0.0129, 0.0133), -61: (0.0134, 0.0137), -60: (0.0138, 0.0136), -59: (0.0143, 0.0139), -58: (0.0147, 0.0138)}, 11: {-87: (0.0068, 0.0071), -86: (0.0104, 0.0099), -85: (0.0109, 0.0099), -84: (0.0124, 0.0125), -83: (0.0146, 0.0153), -82: (0.008, 0.0172), -81: (0.0082, 0.0167), -80: (0.0113, 0.0177), -79: (0.0118, 0.0177), -78: (0.0118, 0.0179), -77: (0.0102, 0.0112), -76: (0.011, 0.0114), -75: (0.0122, 0.0107), -74: (0.0136, 0.0109), -73: (0.0143, 0.0105), -72: (0.0139, 0.0113), -71: (0.0132, 0.0123), -70: (0.0125, 0.0128), -69: (0.0126, 0.0131), -68: (0.0132, 0.013), -67: (0.0138, 0.013), -66: (0.0124, 0.0143), -65: (0.0116, 0.0141), -64: (0.012, 0.0137), -63: (0.0124, 0.0137), -62: (0.0129, 0.0138), -61: (0.0133, 0.0138), -60: (0.0138, 0.014), -59: (0.0142, 0.0136), -58: (0.0147, 0.0137)}, 10: {-86: (0.0116, 0.0105), -85: (0.0133, 0.0127), -84: (0.0145, 0.0141), -83: (0.0094, 0.0184), -82: (0.014, 0.0213), -81: (0.0101, 0.0194), -80: (0.0108, 0.0196), -79: (0.012, 0.0196), -78: (0.0123, 0.0203), -77: (0.0107, 0.0174), -76: (0.0109, 0.013), -75: (0.0118, 0.0122), -74: (0.0125, 0.0105), -73: (0.0142, 0.0096), -72: (0.0144, 0.0098), -71: (0.0143, 0.0081), -70: (0.0119, 0.0026), -69: (0.012, 0.0026), -68: (0.0126, 0.0027), -67: (0.0124, 0.0014), -66: (0.0123, 0.0022), -65: (0.0124, 0.0023), -64: (0.0119, 0.0013), -63: (0.0119, 0.0003), -62: (0.0121, 0.0003), -61: (0.0121, -0.0001)}, 9: {-84: (0.015, 0.0172), -83: (0.0144, 0.0186), -82: (0.0128, 0.0215), -81: (0.0112, 0.0203), -80: (0.0107, 0.0198), -79: (0.0115, 0.0203), -78: (0.0121, 0.02), -77: (0.0112, 0.0175), -76: (0.0112, 0.0138), -75: (0.0118, 0.0123), -74: (0.0129, 0.0103), -73: (0.0136, 0.0081), -72: (0.0135, 0.0069), -71: (0.0127, 0.0038), -70: (0.0129, 0.0039), -69: (0.012, 0.0027), -68: (0.0122, 0.0022), -67: (0.0117, -0.0003), -66: (0.0117, 0.0001), -65: (0.0118, 0.0005), -64: (0.0118, -0.0001), -63: (0.0119, 0.0), -62: (0.0121, 0.0001), -61: (0.012, -0.0008)}, 8: {-83: (0.0161, 0.0227), -82: (0.0132, 0.0226), -81: (0.0108, 0.0209), -80: (0.0106, 0.0201), -79: (0.0114, 0.0204), -78: (0.0121, 0.0202), -77: (0.0118, 0.0184), -76: (0.0116, 0.0138), -75: (0.0134, 0.0089), -74: (0.0133, 0.0078), -73: (0.0135, 0.0061), -72: (0.0131, 0.0048), -71: (0.0122, 0.0007), -70: (0.0124, 0.0007), -69: (0.0121, 0.001), -68: (0.0129, 0.0031), -67: (0.0117, -0.0003), -66: (0.0117, 0.0), -65: (0.0118, 0.0003), -64: (0.0121, 0.0), -63: (0.0122, 0.0001), -62: (0.012, -0.0007), -61: (0.0122, -0.0017), -60: (0.0119, -0.0026), -59: (0.0116, -0.0034)}, 7: {-78: (0.0119, 0.0203), -77: (0.0131, 0.0101), -76: (0.0138, 0.0089), -75: (0.0142, 0.0063), -74: (0.0144, 0.006), -73: (0.0135, 0.0054), -72: (0.013, 0.0035), -71: (0.011, -0.0017), -70: (0.012, -0.0001), -69: (0.0127, 0.0015), -68: (0.0127, 0.0019), -67: (0.0117, -0.0003), -66: (0.0117, -0.0001), -65: (0.0117, -0.0007), -64: (0.0121, -0.0001), -63: (0.0122, -0.0001), -62: (0.0122, -0.0016), -61: (0.0121, -0.0019), -60: (0.0116, -0.0034), -59: (0.0116, -0.0034), -58: (0.0116, -0.0033)}, 6: {-78: (0.013, 0.01), -77: (0.0144, 0.0044), -76: (0.0145, 0.0049), -75: (0.0143, 0.0043), -74: (0.014, 0.0042), -73: (0.0134, 0.0033), -72: (0.0123, 0.0017), -71: (0.0113, 0.0005), -70: (0.0116, 0.0009), -69: (0.0119, 0.0011), -68: (0.0103, -0.0011), -67: (0.0104, -0.001), -66: (0.0117, -0.0001), -65: (0.012, -0.0002), -64: (0.0121, -0.0001), -63: (0.0119, -0.0009), -62: (0.0121, -0.0018), -61: (0.012, -0.0021), -60: (0.0116, -0.0033), -59: (0.0117, -0.0033), -58: (0.0116, -0.0034), -57: (0.0115, -0.0036), -56: (0.0118, -0.0032), -55: (0.0118, -0.0032), -54: (0.0119, -0.0033)}, 5: {-78: (0.014, 0.0058), -77: (0.014, 0.0048), -76: (0.0142, 0.0047), -75: (0.0141, 0.004), -74: (0.0138, 0.0029), -73: (0.013, 0.0014), -72: (0.0115, 0.0013), -71: (0.0103, -0.0012), -70: (0.0109, -0.0004), -69: (0.012, 0.0001), -68: (0.012, 0.0001), -67: (0.0106, -0.0015), -66: (0.0106, -0.0014), -65: (0.0119, -0.0017), -64: (0.012, -0.0017), -63: (0.012, -0.0017), -62: (0.012, -0.0019), -61: (0.0115, -0.0033), -60: (0.0116, -0.0033), -59: (0.0117, -0.0034), -58: (0.0116, -0.0032), -57: (0.0117, -0.0033), -56: (0.0118, -0.0032), -55: (0.0118, -0.0034), -54: (0.0119, -0.0033), -53: (0.0121, -0.0035), -52: (0.012, -0.0033)}, 4: {-78: (0.0132, 0.0057), -77: (0.0135, 0.0052), -76: (0.0137, 0.0042), -75: (0.0137, 0.0027), -74: (0.0132, 0.0016), -73: (0.0118, -0.0004), -72: (0.0101, -0.0025), -71: (0.01, -0.0026), -70: (0.0101, -0.0031), -69: (0.0102, -0.003), -68: (0.0102, -0.0024), -67: (0.0103, -0.0024), -66: (0.0105, -0.0025), -65: (0.0112, -0.0012), -64: (0.012, -0.0017), -63: (0.0119, -0.0022), -62: (0.0119, -0.0022), -61: (0.0115, -0.0032), -60: (0.0116, -0.0033), -59: (0.0117, -0.0033), -58: (0.0117, -0.0033), -57: (0.0117, -0.0032), -56: (0.0118, -0.0032), -55: (0.0119, -0.0032), -54: (0.0119, -0.0032), -53: (0.012, -0.0033), -52: (0.012, -0.0033), -51: (0.012, -0.0031)}, 3: {-78: (0.0129, 0.0086), -77: (0.0133, 0.0053), -76: (0.013, 0.0037), -75: (0.0131, 0.0029), -74: (0.0126, -0.0015), -73: (0.01, -0.0033), -72: (0.0101, -0.0033), -71: (0.0102, -0.0033), -70: (0.0104, -0.0033), -69: (0.0104, -0.0029), -68: (0.0105, -0.0028), -67: (0.0103, -0.0023), -66: (0.0105, -0.0024), -65: (0.0111, -0.003), -64: (0.0119, -0.0035), -63: (0.0119, -0.0034), -62: (0.0116, -0.0032), -61: (0.0118, -0.0034), -60: (0.0116, -0.0032), -59: (0.0117, -0.0032), -58: (0.0117, -0.0032), -57: (0.0117, -0.0031), -56: (0.0118, -0.0031), -55: (0.0119, -0.0032), -54: (0.0119, -0.0032), -53: (0.0119, -0.0031), -52: (0.0119, -0.0031), -51: (0.012, -0.003)}, 2: {-78: (0.0118, 0.001), -77: (0.0116, 0.0037), -76: (0.0118, 0.0003), -75: (0.0124, 0.0013), -74: (0.0115, -0.0022), -73: (0.01, -0.0032), -72: (0.0101, -0.0032), -71: (0.0102, -0.0032), -70: (0.0103, -0.0028), -69: (0.0104, -0.0028), -68: (0.0105, -0.0027), -67: (0.011, -0.0031), -66: (0.0117, -0.0034), -65: (0.0118, -0.0034), -64: (0.0119, -0.0034), -63: (0.012, -0.0034), -62: (0.0121, -0.0029), -61: (0.0119, -0.0032), -60: (0.012, -0.0032), -59: (0.0117, -0.0032), -58: (0.0117, -0.0032), -57: (0.0118, -0.0032), -56: (0.0118, -0.0031), -55: (0.0119, -0.0031), -54: (0.0118, -0.003), -53: (0.0119, -0.003), -52: (0.0119, -0.003), -51: (0.012, -0.003), -50: (0.0123, -0.003)}, 1: {-79: (0.0142, -0.0156), -78: (0.0129, -0.0124), -77: (0.0109, -0.0048), -76: (0.0108, -0.0029), -75: (0.0124, 0.0014), -74: (0.0115, -0.0021), -73: (0.0114, -0.0026), -72: (0.0101, -0.0031), -71: (0.0104, -0.003), -70: (0.0103, -0.0027), -69: (0.0104, -0.0027), -68: (0.0105, -0.0027), -67: (0.011, -0.0028), -66: (0.0117, -0.0033), -65: (0.0118, -0.0033), -64: (0.0119, -0.0033), -63: (0.0122, -0.0032), -62: (0.0124, -0.0034), -61: (0.0123, -0.0032), -60: (0.0121, -0.0031), -59: (0.0121, -0.0031), -58: (0.0121, -0.0031), -57: (0.0121, -0.003), -56: (0.0118, -0.003), -55: (0.0117, -0.0028), -54: (0.012, -0.0031), -53: (0.0121, -0.0031), -52: (0.0121, -0.003), -51: (0.0123, -0.003), -50: (0.0123, -0.003)}, 0: {-80: (0.0162, -0.0228), -79: (0.0152, -0.0148), -78: (0.0139, -0.0116), -77: (0.0118, -0.0126), -76: (0.0099, -0.0058), -75: (0.01, -0.0058), -74: (0.0103, -0.0056), -73: (0.0113, -0.0021), -72: (0.01, -0.0029), -71: (0.0101, -0.0026), -70: (0.0103, -0.0026), -69: (0.0104, -0.0026), -68: (0.011, -0.0028), -67: (0.0117, -0.0032), -66: (0.0117, -0.0032), -65: (0.0118, -0.0032), -64: (0.0119, -0.0033), -63: (0.0122, -0.0032), -62: (0.0124, -0.0034), -61: (0.0124, -0.0034), -60: (0.0126, -0.0032), -59: (0.0126, -0.0029), -58: (0.0126, -0.0029), -57: (0.0127, -0.0029), -56: (0.0124, -0.0029), -55: (0.0122, -0.0029), -54: (0.012, -0.003), -53: (0.0121, -0.003), -52: (0.0121, -0.003), -51: (0.0122, -0.003), -50: (0.0123, -0.003), -49: (0.0123, -0.003), -48: (0.0123, -0.003), -47: (0.0126, -0.003)}, -1: {-80: (0.014, -0.0104), -79: (0.0134, -0.0145), -78: (0.0136, -0.0103), -77: (0.0127, -0.0086), -76: (0.0109, -0.007), -75: (0.0103, -0.0069), -74: (0.0103, -0.0048), -73: (0.0104, -0.0032), -72: (0.0105, -0.0032), -71: (0.0109, -0.0027), -70: (0.0111, -0.0027), -69: (0.0114, -0.0031), -68: (0.0116, -0.0031), -67: (0.0117, -0.0031), -66: (0.0117, -0.0031), -65: (0.0118, -0.0031), -64: (0.0119, -0.0031), -63: (0.0123, -0.0031), -62: (0.0125, -0.0033), -61: (0.0125, -0.0033), -60: (0.0126, -0.0031), -59: (0.0126, -0.0027), -58: (0.0126, -0.0027), -57: (0.0127, -0.0029), -56: (0.0129, -0.0029), -55: (0.0122, -0.0028), -54: (0.012, -0.0029), -53: (0.0121, -0.0029), -52: (0.0121, -0.0029), -51: (0.0124, -0.003), -50: (0.0123, -0.0029), -49: (0.0123, -0.0029), -48: (0.0123, -0.0029), -47: (0.0131, -0.0027), -46: (0.0133, -0.003), -45: (0.0133, -0.003)}, -2: {-81: (0.0088, 0.0047), -80: (0.0095, 0.0028), -79: (0.0131, -0.006), -78: (0.0109, -0.0039), -77: (0.0124, -0.004), -76: (0.0101, -0.0051), -75: (0.0102, -0.0045), -74: (0.0102, -0.0043), -73: (0.0105, -0.0045), -72: (0.0105, -0.0031), -71: (0.0109, -0.0026), -70: (0.0113, -0.0029), -69: (0.0114, -0.0028), -68: (0.0116, -0.003), -67: (0.0117, -0.003), -66: (0.0117, -0.003), -65: (0.0118, -0.003), -64: (0.0119, -0.003), -63: (0.0124, -0.0032), -62: (0.0125, -0.0032), -61: (0.0126, -0.0032), -60: (0.0127, -0.003), -59: (0.0127, -0.0026), -58: (0.0127, -0.0026), -57: (0.0128, -0.0028), -56: (0.0129, -0.0028), -55: (0.0122, -0.0028), -54: (0.0123, -0.0031), -53: (0.0121, -0.0029), -52: (0.0121, -0.0029), -51: (0.0122, -0.0029), -50: (0.0123, -0.0029), -49: (0.0123, -0.0029), -48: (0.0129, -0.003), -47: (0.0133, -0.003), -46: (0.0133, -0.003), -45: (0.013, -0.003), -44: (0.0131, -0.0029), -43: (0.0134, -0.0033)}, -3: {-81: (0.0075, 0.0066), -80: (0.0087, 0.0034), -79: (0.0087, 0.0016), -78: (0.0103, 0.0002), -77: (0.0117, -0.0021), -76: (0.0101, -0.0044), -75: (0.0102, -0.0044), -74: (0.0102, -0.0034), -73: (0.011, -0.0038), -72: (0.0107, -0.0038), -71: (0.0108, -0.0029), -70: (0.011, -0.0021), -69: (0.0114, -0.0026), -68: (0.0116, -0.0029), -67: (0.0117, -0.0029), -66: (0.0117, -0.0029), -65: (0.0118, -0.0029), -64: (0.0121, -0.0028), -63: (0.0124, -0.0031), -62: (0.0125, -0.0031), -61: (0.0125, -0.0029), -60: (0.0129, -0.0032), -59: (0.0128, -0.003), -58: (0.0127, -0.0028), -57: (0.0128, -0.0028), -56: (0.0129, -0.0028), -55: (0.0124, -0.0027), -54: (0.0122, -0.0027), -53: (0.0124, -0.0029), -52: (0.0121, -0.0028), -51: (0.0126, -0.003), -50: (0.0131, -0.0033), -49: (0.0131, -0.0033), -48: (0.0132, -0.0033), -47: (0.0133, -0.0032), -46: (0.0132, -0.0031), -45: (0.0131, -0.0029), -44: (0.0132, -0.0028), -43: (0.013, -0.0029), -42: (0.0134, -0.0035), -41: (0.0137, -0.0037), -40: (0.0141, -0.0039), -39: (0.0141, -0.0038)}, -4: {-81: (0.0078, 0.0045), -80: (0.0075, 0.0028), -79: (0.0078, 0.0017), -78: (0.0077, 0.0015), -77: (0.0083, 0.0006), -76: (0.0098, -0.0015), -75: (0.0099, -0.0016), -74: (0.0103, -0.0025), -73: (0.0107, -0.0012), -72: (0.0108, -0.0012), -71: (0.0109, -0.0014), -70: (0.011, -0.0018), -69: (0.0114, -0.0025), -68: (0.0116, -0.0028), -67: (0.0117, -0.0028), -66: (0.0117, -0.0028), -65: (0.0118, -0.0028), -64: (0.0123, -0.003), -63: (0.0124, -0.003), -62: (0.0125, -0.003), -61: (0.0125, -0.0031), -60: (0.0128, -0.0031), -59: (0.0129, -0.003), -58: (0.0127, -0.0027), -57: (0.0128, -0.0027), -56: (0.0129, -0.0027), -55: (0.0124, -0.0026), -54: (0.0125, -0.0027), -53: (0.013, -0.0029), -52: (0.0126, -0.0027), -51: (0.0131, -0.0032), -50: (0.0131, -0.0032), -49: (0.0132, -0.0032), -48: (0.0132, -0.0033), -47: (0.0133, -0.003), -46: (0.0133, -0.003), -45: (0.0131, -0.0028), -44: (0.013, -0.0029), -43: (0.0129, -0.0029), -42: (0.0134, -0.0035), -41: (0.0137, -0.0037), -40: (0.0142, -0.0039), -39: (0.0141, -0.0038), -38: (0.0144, -0.0036)}, -5: {-81: (0.0069, 0.0031), -80: (0.007, 0.003), -79: (0.0072, 0.003), -78: (0.0079, 0.0018), -77: (0.0078, 0.0016), -76: (0.0088, 0.0002), -75: (0.0105, -0.001), -74: (0.0106, -0.0011), -73: (0.0107, -0.0011), -72: (0.0108, -0.0011), -71: (0.0109, -0.0011), -70: (0.011, -0.0017), -69: (0.0114, -0.0022), -68: (0.0116, -0.0024), -67: (0.0117, -0.0024), -66: (0.0118, -0.0029), -65: (0.0119, -0.0029), -64: (0.012, -0.0029), -63: (0.0123, -0.0028), -62: (0.0125, -0.003), -61: (0.0125, -0.003), -60: (0.0128, -0.0029), -59: (0.0128, -0.0028), -58: (0.0127, -0.0026), -57: (0.0128, -0.0027), -56: (0.0129, -0.0027), -55: (0.0129, -0.0027), -54: (0.0129, -0.0028), -53: (0.013, -0.0028), -52: (0.013, -0.0029), -51: (0.0131, -0.0032), -50: (0.0131, -0.0032), -49: (0.0132, -0.0032), -48: (0.013, -0.0032), -47: (0.0133, -0.003), -46: (0.0128, -0.0035), -45: (0.013, -0.003), -44: (0.0126, -0.0029), -43: (0.0124, -0.003), -42: (0.0128, -0.0035), -41: (0.0134, -0.0035), -40: (0.014, -0.0038), -39: (0.0144, -0.0036), -38: (0.0143, -0.0036), -37: (0.0141, -0.0036), -36: (0.0139, -0.0039), -35: (0.014, -0.0038)}, -6: {-81: (0.0069, 0.0032), -80: (0.007, 0.0032), -79: (0.0072, 0.0032), -78: (0.0073, 0.0032), -77: (0.0083, 0.0018), -76: (0.01, -0.0003), -75: (0.0105, -0.0009), -74: (0.0106, -0.0009), -73: (0.0107, -0.0009), -72: (0.0108, -0.001), -71: (0.0109, -0.001), -70: (0.0112, -0.0013), -69: (0.0113, -0.0015), -68: (0.0118, -0.0025), -67: (0.0118, -0.0024), -66: (0.0118, -0.0028), -65: (0.0119, -0.0028), -64: (0.012, -0.0028), -63: (0.0121, -0.0029), -62: (0.0124, -0.0028), -61: (0.0124, -0.0028), -60: (0.0126, -0.0023), -59: (0.0127, -0.0024), -58: (0.0129, -0.0025), -57: (0.013, -0.0025), -56: (0.013, -0.0026), -55: (0.0129, -0.0027), -54: (0.013, -0.0028), -53: (0.013, -0.0028), -52: (0.013, -0.0029), -51: (0.0131, -0.0031), -50: (0.0131, -0.0032), -49: (0.013, -0.0033), -48: (0.013, -0.0033), -47: (0.013, -0.0034), -46: (0.0128, -0.0035), -45: (0.0124, -0.0033), -44: (0.0124, -0.003), -43: (0.0123, -0.003), -42: (0.0127, -0.0033), -41: (0.0124, -0.003), -40: (0.0136, -0.0035), -39: (0.0142, -0.0032), -38: (0.014, -0.0036), -37: (0.0137, -0.0039), -36: (0.014, -0.0038), -35: (0.0133, -0.0038)}, -7: {-80: (0.007, 0.0033), -79: (0.0072, 0.0033), -78: (0.0086, 0.0018), -77: (0.0087, 0.0018), -76: (0.0104, -0.0008), -75: (0.0105, -0.0008), -74: (0.0106, -0.0008), -73: (0.0107, -0.0008), -72: (0.0108, -0.0009), -71: (0.0109, -0.0009), -70: (0.0112, -0.0012), -69: (0.0113, -0.0014), -68: (0.0114, -0.0017), -67: (0.0117, -0.002), -66: (0.0117, -0.002), -65: (0.0117, -0.0023), -64: (0.012, -0.0028), -63: (0.0123, -0.0026), -62: (0.0123, -0.0022), -61: (0.0126, -0.0022), -60: (0.0127, -0.0023), -59: (0.013, -0.0021), -58: (0.0129, -0.0024), -57: (0.013, -0.0024), -56: (0.0129, -0.0029), -55: (0.0129, -0.0027), -54: (0.0129, -0.0027), -53: (0.013, -0.0027), -52: (0.0129, -0.003), -51: (0.0129, -0.0031), -50: (0.013, -0.0031), -49: (0.0129, -0.0034), -48: (0.0128, -0.0035), -47: (0.0128, -0.0036), -46: (0.0126, -0.0033), -45: (0.0124, -0.0035), -44: (0.0121, -0.0036), -43: (0.0122, -0.0031), -42: (0.0124, -0.0031), -41: (0.0126, -0.0031), -40: (0.0133, -0.0034), -39: (0.0134, -0.0034), -38: (0.0133, -0.0035), -37: (0.013, -0.0043), -36: (0.0134, -0.004), -35: (0.0134, -0.004)}, -8: {-80: (0.0087, 0.0075), -79: (0.0098, 0.0065), -78: (0.0101, 0.0067), -77: (0.0102, 0.0053), -76: (0.0115, 0.0052), -75: (0.011, 0.0018), -74: (0.0106, -0.0007), -73: (0.0107, -0.0007), -72: (0.0108, -0.0008), -71: (0.011, -0.0007), -70: (0.0113, -0.0005), -69: (0.0113, -0.0007), -68: (0.0114, -0.0015), -67: (0.0115, -0.0015), -66: (0.0115, -0.0015), -65: (0.0114, -0.0018), -64: (0.0118, -0.0018), -63: (0.012, -0.0017), -62: (0.012, -0.0018), -61: (0.0123, -0.0019), -60: (0.0127, -0.0022), -59: (0.0128, -0.0022), -58: (0.0129, -0.0024), -57: (0.0129, -0.0027), -56: (0.013, -0.0027), -55: (0.013, -0.0027), -54: (0.0129, -0.0029), -53: (0.0129, -0.0029), -52: (0.0128, -0.0031), -51: (0.0129, -0.0032), -50: (0.013, -0.0032), -49: (0.0127, -0.0034), -48: (0.0125, -0.0037), -47: (0.0126, -0.0037), -46: (0.0125, -0.0031), -45: (0.0124, -0.0029), -44: (0.0123, -0.0033), -43: (0.0126, -0.0029), -42: (0.0126, -0.0029), -41: (0.013, -0.0028), -40: (0.0132, -0.0033), -39: (0.0133, -0.0034), -38: (0.0133, -0.0035), -37: (0.0128, -0.0042), -36: (0.0135, -0.0043), -35: (0.0134, -0.0044)}, -9: {-79: (0.0104, 0.0086), -78: (0.0105, 0.0086), -77: (0.0117, 0.0073), -76: (0.0116, 0.0061), -75: (0.0113, 0.0038), -74: (0.0112, 0.0028), -73: (0.0114, 0.0034), -72: (0.0109, -0.0003), -71: (0.011, -0.0005), -70: (0.0114, -0.0006), -69: (0.0113, -0.0006), -68: (0.0114, -0.0006), -67: (0.0115, -0.0014), -66: (0.0115, -0.0014), -65: (0.0116, -0.0014), -64: (0.0119, -0.0016), -63: (0.012, -0.0016), -62: (0.0121, -0.0016), -61: (0.0122, -0.0022), -60: (0.0123, -0.0022), -59: (0.0126, -0.0022), -58: (0.0129, -0.0025), -57: (0.0129, -0.0026), -56: (0.013, -0.0026), -55: (0.013, -0.0028), -54: (0.0129, -0.003), -53: (0.0132, -0.0031), -52: (0.0128, -0.0031), -51: (0.0127, -0.0031), -50: (0.0127, -0.0032), -49: (0.0127, -0.0032), -48: (0.0124, -0.0029), -47: (0.0124, -0.0031), -46: (0.0124, -0.0031), -45: (0.0125, -0.0027), -44: (0.0124, -0.0029), -43: (0.0126, -0.0026), -42: (0.0128, -0.0028), -41: (0.013, -0.0028), -40: (0.0131, -0.0031), -39: (0.0132, -0.0034), -38: (0.013, -0.004), -37: (0.013, -0.004), -36: (0.0128, -0.0045), -35: (0.0137, -0.0038)}, -10: {-79: (0.0104, 0.0087), -78: (0.0105, 0.0087), -77: (0.0121, 0.0094), -76: (0.012, 0.0081), -75: (0.0118, 0.0065), -74: (0.0117, 0.0056), -73: (0.0117, 0.0043), -72: (0.0109, 0.0), -71: (0.0112, -0.0004), -70: (0.0114, -0.0005), -69: (0.0113, -0.0005), -68: (0.0115, -0.0005), -67: (0.0116, -0.0009), -66: (0.0115, -0.0013), -65: (0.0116, -0.0013), -64: (0.0119, -0.0015), -63: (0.012, -0.0015), -62: (0.012, -0.0019), -61: (0.0122, -0.0021), -60: (0.0123, -0.0021), -59: (0.0126, -0.0022), -58: (0.0127, -0.0024), -57: (0.0128, -0.0024), -56: (0.0132, -0.0028), -55: (0.0131, -0.0029), -54: (0.0129, -0.003), -53: (0.0132, -0.003), -52: (0.0129, -0.0028), -51: (0.0127, -0.0031), -50: (0.0127, -0.0031), -49: (0.0127, -0.0032), -48: (0.0126, -0.0025), -47: (0.0125, -0.0029), -46: (0.0129, -0.0024), -45: (0.013, -0.002), -44: (0.013, -0.0021), -43: (0.0127, -0.0023), -42: (0.0128, -0.0028), -41: (0.0128, -0.0029), -40: (0.0129, -0.0029), -39: (0.0128, -0.0038), -38: (0.0129, -0.004), -37: (0.0128, -0.004), -36: (0.0129, -0.0043)}, -11: {-78: (0.0132, 0.0115), -77: (0.0133, 0.0116), -76: (0.0134, 0.0115), -75: (0.0134, 0.0106), -74: (0.0127, 0.0077), -73: (0.0124, 0.0058), -72: (0.011, 0.0001), -71: (0.0112, -0.0003), -70: (0.0112, -0.0004), -69: (0.0113, -0.0003), -68: (0.0114, -0.0004), -67: (0.0115, -0.0005), -66: (0.0115, -0.0012), -65: (0.0118, -0.0013), -64: (0.0119, -0.0014), -63: (0.012, -0.0014), -62: (0.0124, -0.0019), -61: (0.0122, -0.002), -60: (0.0121, -0.0021), -59: (0.0126, -0.0021), -58: (0.0125, -0.0026), -57: (0.0127, -0.0027), -56: (0.0129, -0.0028), -55: (0.0132, -0.0028), -54: (0.0132, -0.0028), -53: (0.0133, -0.0029), -52: (0.0131, -0.0029), -51: (0.013, -0.003), -50: (0.0127, -0.0031), -49: (0.0127, -0.0031), -48: (0.0127, -0.0026), -47: (0.0127, -0.0025), -46: (0.0129, -0.0024), -45: (0.0129, -0.0026), -44: (0.0128, -0.0021), -43: (0.0128, -0.0027), -42: (0.0128, -0.0028), -41: (0.0128, -0.0029), -40: (0.0128, -0.0033), -39: (0.0128, -0.0039), -38: (0.0127, -0.0038), -37: (0.0127, -0.0039)}, -12: {-78: (0.0141, 0.0156), -77: (0.0142, 0.0157), -76: (0.0144, 0.0154), -75: (0.0145, 0.0153), -74: (0.0146, 0.0151), -73: (0.0134, 0.0082), -72: (0.0135, 0.0077), -71: (0.0124, 0.0037), -70: (0.0119, 0.001), -69: (0.0113, -0.0002), -68: (0.0114, -0.0003), -67: (0.0115, -0.0004), -66: (0.0115, -0.0004), -65: (0.0118, -0.0012), -64: (0.0119, -0.0013), -63: (0.0118, -0.0014), -62: (0.0119, -0.0015), -61: (0.012, -0.0019), -60: (0.012, -0.002), -59: (0.0121, -0.002), -58: (0.0125, -0.0026), -57: (0.0125, -0.0026), -56: (0.0128, -0.0028), -55: (0.0131, -0.0027), -54: (0.0132, -0.0028), -53: (0.0133, -0.0029), -52: (0.0132, -0.0029), -51: (0.0131, -0.0029), -50: (0.0127, -0.003), -49: (0.0127, -0.0031), -48: (0.0127, -0.0031), -47: (0.0128, -0.0024), -46: (0.0129, -0.0025), -45: (0.0129, -0.0025), -44: (0.0129, -0.0026), -43: (0.0128, -0.0032), -42: (0.0128, -0.0031), -41: (0.0127, -0.0035), -40: (0.0128, -0.0033), -39: (0.0128, -0.0039), -38: (0.0127, -0.0039), -37: (0.0127, -0.004)}, -13: {-77: (0.0142, 0.0156), -76: (0.0144, 0.0154), -75: (0.0145, 0.0153), -74: (0.0146, 0.0153), -73: (0.0132, 0.0082), -72: (0.0131, 0.0075), -71: (0.0119, 0.0029), -70: (0.0119, 0.0019), -69: (0.0118, 0.0002), -68: (0.0114, -0.0002), -67: (0.0115, -0.0003), -66: (0.0115, -0.0003), -65: (0.0119, -0.0006), -64: (0.0117, -0.0013), -63: (0.0118, -0.0014), -62: (0.0119, -0.0018), -61: (0.0118, -0.002), -60: (0.0119, -0.002), -59: (0.0119, -0.0025), -58: (0.012, -0.0026), -57: (0.0125, -0.0027), -56: (0.0127, -0.0027), -55: (0.0129, -0.0028), -54: (0.0133, -0.0027), -53: (0.0133, -0.003), -52: (0.0131, -0.0028), -51: (0.0133, -0.0029), -50: (0.0132, -0.0029), -49: (0.0127, -0.003), -48: (0.0129, -0.0028), -47: (0.0129, -0.0024), -46: (0.0129, -0.0025), -45: (0.0129, -0.0026), -44: (0.0131, -0.0029), -43: (0.0128, -0.0032), -42: (0.0125, -0.0035), -41: (0.0125, -0.0036), -40: (0.0132, -0.0031), -39: (0.0132, -0.0032), -38: (0.0131, -0.0032)}, -14: {-77: (0.0142, 0.0155), -76: (0.0144, 0.0153), -75: (0.0145, 0.0151), -74: (0.0139, 0.0108), -73: (0.0137, 0.01), -72: (0.0139, 0.0085), -71: (0.0121, 0.004), -70: (0.0121, 0.0032), -69: (0.0122, 0.0014), -68: (0.0123, 0.0014), -67: (0.0124, 0.0013), -66: (0.012, 0.0011), -65: (0.0119, 0.0007), -64: (0.0117, -0.0012), -63: (0.0118, -0.0017), -62: (0.0119, -0.0018), -61: (0.0118, -0.0019), -60: (0.0118, -0.0019), -59: (0.0118, -0.0024), -58: (0.0116, -0.0023), -57: (0.012, -0.0026), -56: (0.0125, -0.0026), -55: (0.0128, -0.0028), -54: (0.0128, -0.0027), -53: (0.0132, -0.0027), -52: (0.0132, -0.0028), -51: (0.0133, -0.0028), -50: (0.0132, -0.0029), -49: (0.0127, -0.0027), -48: (0.0126, -0.0027), -47: (0.013, -0.0024), -46: (0.0131, -0.0028), -45: (0.0131, -0.0028), -44: (0.0131, -0.0029), -43: (0.0128, -0.0033), -42: (0.0128, -0.0033), -41: (0.0129, -0.0034), -40: (0.013, -0.003), -39: (0.0132, -0.0032)}, -15: {-76: (0.0144, 0.0153), -75: (0.0138, 0.0128), -74: (0.0141, 0.0112), -73: (0.0137, 0.0101), -72: (0.0136, 0.0082), -71: (0.0127, 0.0079), -70: (0.0127, 0.0064), -69: (0.0122, 0.0026), -68: (0.0123, 0.0026), -67: (0.0124, 0.0024), -66: (0.0125, 0.002), -65: (0.0122, 0.0011), -64: (0.0116, -0.0003), -63: (0.0112, -0.0017), -62: (0.0113, -0.0017), -61: (0.0113, -0.0018), -60: (0.0114, -0.0021), -59: (0.0116, -0.0022), -58: (0.0116, -0.0023), -57: (0.012, -0.0025), -56: (0.0122, -0.0025), -55: (0.0124, -0.0026), -54: (0.0127, -0.0026), -53: (0.0127, -0.0026), -52: (0.013, -0.0026), -51: (0.0131, -0.0026), -50: (0.0127, -0.0025), -49: (0.0129, -0.0026), -48: (0.0126, -0.0026), -47: (0.0129, -0.0024), -46: (0.0134, -0.0026), -45: (0.0133, -0.0023), -44: (0.0132, -0.0023), -43: (0.0134, -0.0032), -42: (0.0128, -0.0033), -41: (0.0131, -0.0029), -40: (0.013, -0.0033), -39: (0.013, -0.0032)}, -16: {-75: (0.0135, 0.0104), -74: (0.0136, 0.0103), -73: (0.0136, 0.0085), -72: (0.0125, 0.0116), -71: (0.0126, 0.0116), -70: (0.0122, 0.0073), -69: (0.0117, 0.0034), -68: (0.0123, 0.0027), -67: (0.0125, 0.0021), -66: (0.0125, 0.0021), -65: (0.0116, 0.0018), -64: (0.0117, 0.0016), -63: (0.0116, -0.0003), -62: (0.0113, -0.0016), -61: (0.0113, -0.0017), -60: (0.0114, -0.0019), -59: (0.0116, -0.0021), -58: (0.0116, -0.0022), -57: (0.012, -0.0024), -56: (0.0124, -0.0025), -55: (0.0127, -0.0026), -54: (0.0122, -0.0025), -53: (0.013, -0.0025), -52: (0.0129, -0.0026), -51: (0.0126, -0.0025), -50: (0.0127, -0.0025), -49: (0.0126, -0.0026), -48: (0.0126, -0.0027), -47: (0.013, -0.0027), -46: (0.0133, -0.0026), -45: (0.0134, -0.0024), -44: (0.0135, -0.0026), -43: (0.0136, -0.0026), -42: (0.0133, -0.0029), -41: (0.013, -0.003), -40: (0.013, -0.0031), -39: (0.013, -0.0032)}, -17: {-73: (0.0123, 0.0123), -72: (0.0125, 0.0118), -71: (0.012, 0.0098), -70: (0.0109, 0.0079), -69: (0.0105, 0.0038), -68: (0.0119, 0.0031), -67: (0.0122, 0.0028), -66: (0.0125, 0.003), -65: (0.0116, 0.002), -64: (0.0117, 0.0015), -63: (0.0116, -0.0002), -62: (0.0117, -0.0008), -61: (0.0113, -0.0016), -60: (0.0114, -0.0018), -59: (0.0115, -0.0018), -58: (0.0116, -0.0021), -57: (0.0123, -0.002), -56: (0.0125, -0.0021), -55: (0.0127, -0.0021), -54: (0.0122, -0.0025), -53: (0.0124, -0.0024), -52: (0.0125, -0.0024), -51: (0.0126, -0.0025), -50: (0.0126, -0.0025), -49: (0.0126, -0.0026), -48: (0.0126, -0.0027), -47: (0.0128, -0.0027), -46: (0.0133, -0.0026), -45: (0.0136, -0.0025), -44: (0.0138, -0.0027), -43: (0.0139, -0.0029), -42: (0.0137, -0.0031), -41: (0.0129, -0.0034), -40: (0.013, -0.0031), -39: (0.013, -0.0032)}, -18: {-72: (0.0117, 0.0108), -71: (0.0109, 0.0092), -70: (0.0084, 0.0049), -69: (0.0094, 0.003), -68: (0.0115, 0.0021), -67: (0.0118, 0.0027), -66: (0.0127, 0.0029), -65: (0.0125, 0.0024), -64: (0.0126, 0.0024), -63: (0.0127, 0.0023), -62: (0.0117, -0.0002), -61: (0.0118, -0.0007), -60: (0.0113, -0.0017), -59: (0.0114, -0.0018), -58: (0.0123, -0.0018), -57: (0.0125, -0.0019), -56: (0.0128, -0.002), -55: (0.0128, -0.002), -54: (0.0131, -0.002), -53: (0.013, -0.0021), -52: (0.0126, -0.0023), -51: (0.0126, -0.0023), -50: (0.0125, -0.0027), -49: (0.0125, -0.0028), -48: (0.0125, -0.0028), -47: (0.0128, -0.0029), -46: (0.0131, -0.0029), -45: (0.0135, -0.0028), -44: (0.0135, -0.0036), -43: (0.0136, -0.0031), -42: (0.0134, -0.0033), -41: (0.0132, -0.0035), -40: (0.0131, -0.0036), -39: (0.0132, -0.0037)}, -19: {-71: (0.0099, 0.008), -70: (0.0093, 0.0018), -69: (0.01, 0.0017), -68: (0.0125, 0.0014), -67: (0.014, 0.0024), -66: (0.0136, 0.0037), -65: (0.0125, 0.0025), -64: (0.0126, 0.0025), -63: (0.012, 0.0005), -62: (0.0122, 0.0006), -61: (0.0116, -0.0011), -60: (0.0117, -0.0011), -59: (0.0121, -0.0016), -58: (0.0122, -0.0017), -57: (0.0125, -0.0016), -56: (0.0126, -0.0017), -55: (0.0128, -0.0018), -54: (0.0132, -0.0018), -53: (0.0132, -0.0019), -52: (0.0123, -0.0021), -51: (0.0127, -0.0023), -50: (0.0127, -0.0024), -49: (0.0127, -0.0027), -48: (0.0127, -0.0029), -47: (0.0128, -0.0028), -46: (0.0131, -0.0031), -45: (0.0134, -0.0033), -44: (0.0129, -0.0033), -43: (0.0127, -0.0035), -42: (0.0129, -0.0034), -41: (0.0133, -0.0034), -40: (0.0132, -0.0035), -39: (0.0132, -0.0036)}, -20: {-71: (0.0116, 0.0128), -70: (0.0123, 0.0014), -69: (0.0147, 0.0019), -68: (0.017, 0.0049), -67: (0.0162, 0.0041), -66: (0.0159, 0.0044), -65: (0.0144, 0.0044), -64: (0.0135, 0.0027), -63: (0.0134, 0.0039), -62: (0.0131, 0.0021), -61: (0.0117, -0.0019), -60: (0.0118, -0.0019), -59: (0.0124, -0.0011), -58: (0.0124, -0.0015), -57: (0.012, -0.0016), -56: (0.0122, -0.0014), -55: (0.0122, -0.0015), -54: (0.0129, -0.0016), -53: (0.0131, -0.0015), -52: (0.0123, -0.0018), -51: (0.0126, -0.002), -50: (0.0128, -0.0023), -49: (0.0126, -0.0026), -48: (0.0126, -0.0027), -47: (0.0127, -0.0027), -46: (0.0133, -0.0035), -45: (0.0133, -0.0036), -44: (0.0129, -0.0034), -43: (0.0127, -0.0034), -42: (0.0129, -0.003), -41: (0.0133, -0.0033), -40: (0.0133, -0.0034)}, -21: {-71: (0.0142, 0.0201), -70: (0.015, 0.0213), -69: (0.0159, 0.0114), -68: (0.0179, 0.0105), -67: (0.0181, 0.0076), -66: (0.0164, 0.0086), -65: (0.014, 0.0058), -64: (0.0137, 0.0057), -63: (0.0121, 0.0032), -62: (0.0117, -0.0017), -61: (0.0117, -0.0018), -60: (0.0118, -0.0019), -59: (0.0125, -0.0022), -58: (0.0125, -0.0022), -57: (0.0121, -0.0013), -56: (0.0122, -0.0014), -55: (0.0122, -0.0015), -54: (0.0122, -0.0015), -53: (0.0124, -0.0015), -52: (0.0122, -0.002), -51: (0.0127, -0.0022), -50: (0.0126, -0.0023), -49: (0.0127, -0.0025), -48: (0.0127, -0.0025), -47: (0.013, -0.0027), -46: (0.0135, -0.0028), -45: (0.0132, -0.0036), -44: (0.0128, -0.0034), -43: (0.0126, -0.0034), -42: (0.0128, -0.003), -41: (0.0128, -0.0031), -40: (0.0129, -0.0033)}, -22: {-71: (0.0169, 0.0314), -70: (0.0151, 0.0245), -69: (0.017, 0.0204), -68: (0.0179, 0.0126), -67: (0.0173, 0.0129), -66: (0.0163, 0.0109), -65: (0.0142, 0.0068), -64: (0.013, 0.0045), -63: (0.0123, 0.0021), -62: (0.0124, 0.002), -61: (0.0124, 0.0019), -60: (0.0118, -0.0019), -59: (0.0125, -0.0017), -58: (0.0125, -0.0022), -57: (0.0121, -0.0012), -56: (0.0122, -0.0013), -55: (0.0122, -0.0014), -54: (0.0122, -0.0015), -53: (0.0124, -0.0018), -52: (0.0125, -0.0019), -51: (0.0129, -0.002), -50: (0.0125, -0.002), -49: (0.0126, -0.0022), -48: (0.0127, -0.0023), -47: (0.0131, -0.0027), -46: (0.0134, -0.0029), -45: (0.0136, -0.0029), -44: (0.0129, -0.0027), -43: (0.0128, -0.0027), -42: (0.0128, -0.0028), -41: (0.0128, -0.0031)}, -23: {-71: (0.0174, 0.0319), -70: (0.0172, 0.029), -69: (0.0172, 0.0252), -68: (0.0172, 0.0166), -67: (0.0166, 0.0147), -66: (0.0149, 0.0124), -65: (0.0127, 0.0049), -64: (0.0128, 0.0048), -63: (0.0123, 0.0022), -62: (0.0124, 0.0021), -61: (0.0124, 0.0007), -60: (0.0122, -0.0018), -59: (0.0121, -0.0017), -58: (0.0125, -0.0022), -57: (0.013, -0.0012), -56: (0.0122, -0.0012), -55: (0.013, -0.0014), -54: (0.0122, -0.0016), -53: (0.0127, -0.0019), -52: (0.0125, -0.0019), -51: (0.0129, -0.0019), -50: (0.0124, -0.0015), -49: (0.0126, -0.002), -48: (0.0127, -0.0021), -47: (0.0131, -0.0026), -46: (0.0135, -0.0029), -45: (0.0136, -0.0029), -44: (0.0134, -0.0029), -43: (0.013, -0.0028), -42: (0.0131, -0.0029)}, -24: {-71: (0.0181, 0.0324), -70: (0.0177, 0.0275), -69: (0.0177, 0.0242), -68: (0.0167, 0.0185), -67: (0.015, 0.0113), -66: (0.0141, 0.0104), -65: (0.0127, 0.005), -64: (0.0128, 0.0049), -63: (0.0124, 0.0), -62: (0.0125, -0.0009), -61: (0.0124, -0.0005), -60: (0.0122, -0.0017), -59: (0.012, -0.0021), -58: (0.012, -0.0022), -57: (0.0127, -0.0014), -56: (0.0127, -0.0014), -55: (0.0127, -0.0015), -54: (0.0136, -0.0016), -53: (0.0137, -0.0017), -52: (0.0136, -0.0019), -51: (0.0134, -0.0017), -50: (0.0132, -0.0017), -49: (0.0128, -0.0018), -48: (0.0131, -0.0024), -47: (0.0134, -0.0027), -46: (0.0136, -0.0029)}, -25: {-71: (0.0182, 0.0289), -70: (0.0184, 0.0288), -69: (0.0175, 0.0218), -68: (0.016, 0.0161), -67: (0.0155, 0.0133), -66: (0.0129, 0.0078), -65: (0.0127, 0.0063), -64: (0.0123, 0.0016), -63: (0.0124, 0.001), -62: (0.0116, -0.0002), -61: (0.0118, -0.0004), -60: (0.0123, -0.0016), -59: (0.0126, -0.0023), -58: (0.0126, -0.0022), -57: (0.0121, -0.0013), -56: (0.0132, -0.0015), -55: (0.0132, -0.0016), -54: (0.013, -0.0017), -53: (0.0146, -0.0018), -52: (0.0146, -0.0019), -51: (0.014, -0.0021), -50: (0.0134, -0.0023), -49: (0.0134, -0.0024), -48: (0.0133, -0.0025), -47: (0.0135, -0.0028)}, -26: {-71: (0.0187, 0.0262), -70: (0.0189, 0.0261), -69: (0.0149, 0.0144), -68: (0.0148, 0.0132), -67: (0.0127, 0.0075), -66: (0.0115, 0.0029), -65: (0.0123, 0.0037), -64: (0.0112, 0.0011), -63: (0.0107, -0.0015), -62: (0.0112, -0.0014), -61: (0.011, -0.0027), -60: (0.0123, -0.0021), -59: (0.0126, -0.002), -58: (0.013, -0.0011), -57: (0.0121, -0.0012), -56: (0.0133, -0.0013), -55: (0.0132, -0.0015), -54: (0.013, -0.0011), -53: (0.0131, -0.0014), -52: (0.014, -0.0013), -51: (0.0134, -0.0016), -50: (0.0134, -0.0021), -49: (0.0133, -0.0023), -48: (0.0133, -0.0024)}, -27: {-71: (0.018, 0.0225), -70: (0.0182, 0.0224), -69: (0.0149, 0.0144), -68: (0.0149, 0.0143), -67: (0.0109, 0.0025), -66: (0.0101, 0.0005), -65: (0.0106, 0.0011), -64: (0.0106, 0.0006), -63: (0.0108, 0.0008), -62: (0.0112, -0.0014), -61: (0.011, -0.0027), -60: (0.0124, -0.0017), -59: (0.0128, -0.0009), -58: (0.013, -0.001), -57: (0.0125, -0.0011), -56: (0.0124, -0.0012), -55: (0.0124, -0.0014), -54: (0.0125, -0.0012), -53: (0.0122, -0.0012), -52: (0.0131, -0.0013), -51: (0.0132, -0.0014), -50: (0.0136, -0.0021), -49: (0.0136, -0.0022), -48: (0.0136, -0.0024)}, -28: {-72: (0.0178, 0.0226), -71: (0.018, 0.0228), -70: (0.0171, 0.0199), -69: (0.016, 0.0167), -68: (0.012, 0.006), -67: (0.0101, 0.001), -66: (0.0101, 0.0006), -65: (0.0102, 0.0004), -64: (0.0099, -0.0008), -63: (0.0108, 0.0008), -62: (0.0111, -0.0005), -61: (0.0113, -0.0018), -60: (0.0122, -0.0017), -59: (0.0129, -0.0009), -58: (0.013, -0.001), -57: (0.0132, -0.0011), -56: (0.0124, -0.0012), -55: (0.0124, -0.0013), -54: (0.0127, -0.0012), -53: (0.0122, -0.0011), -52: (0.0132, -0.0011), -51: (0.0136, -0.0014), -50: (0.0137, -0.002), -49: (0.0135, -0.0021), -48: (0.0136, -0.0023)}, -29: {-72: (0.0185, 0.0157), -71: (0.0185, 0.0194), -70: (0.0179, 0.009), -69: (0.0177, 0.0137), -68: (0.0124, 0.0074), -67: (0.0101, 0.0011), -66: (0.0101, 0.001), -65: (0.0098, -0.0004), -64: (0.0099, -0.0005), -63: (0.0108, -0.0011), -62: (0.0113, -0.0018), -61: (0.0126, -0.0012), -60: (0.0127, -0.0013), -59: (0.0127, -0.001), -58: (0.0131, -0.0012), -57: (0.0136, -0.0015), -56: (0.0137, -0.0016), -55: (0.0136, -0.0018), -54: (0.0136, -0.0019), -53: (0.0134, -0.0011), -52: (0.0133, -0.0012), -51: (0.0136, -0.0013), -50: (0.0138, -0.0018), -49: (0.0137, -0.0021)}, -30: {-72: (0.0189, 0.0161), -71: (0.0175, 0.0023), -70: (0.0177, 0.0021), -69: (0.0178, 0.002), -68: (0.0158, 0.0012), -67: (0.0124, -0.002), -66: (0.0108, -0.0013), -65: (0.0109, -0.0015), -64: (0.011, -0.0016), -63: (0.0107, -0.0024), -62: (0.0122, -0.002), -61: (0.0126, -0.0013), -60: (0.0127, -0.0014), -59: (0.0128, -0.0015), -58: (0.0132, -0.0015), -57: (0.0138, -0.0021), -56: (0.0139, -0.0023), -55: (0.014, -0.0025), -54: (0.0137, -0.0021), -53: (0.0132, -0.0018), -52: (0.0132, -0.0019), -51: (0.0133, -0.0018), -50: (0.0138, -0.0017)}, -31: {-72: (0.0191, 0.0214), -71: (0.0181, 0.0098), -70: (0.0165, -0.0012), -69: (0.0165, -0.0076), -68: (0.0166, -0.0077), -67: (0.0148, -0.0063), -66: (0.0118, -0.0029), -65: (0.0113, -0.0025), -64: (0.0116, -0.0026), -63: (0.0121, -0.0018), -62: (0.0121, -0.0019), -61: (0.0123, -0.0017), -60: (0.0124, -0.0019), -59: (0.0126, -0.002), -58: (0.0127, -0.0014), -57: (0.0134, -0.0022), -56: (0.0139, -0.0023), -55: (0.0137, -0.0022), -54: (0.0133, -0.0023), -53: (0.0132, -0.0023), -52: (0.0132, -0.0018), -51: (0.0133, -0.0019), -50: (0.0136, -0.0022)}, -32: {-72: (0.0193, 0.0158), -71: (0.0189, 0.0101), -70: (0.0179, 0.0038), -69: (0.0151, -0.0037), -68: (0.0157, -0.0057), -67: (0.0139, -0.0061), -66: (0.0118, -0.0028), -65: (0.0119, -0.0029), -64: (0.012, -0.003), -63: (0.0121, -0.0017), -62: (0.0121, -0.0013), -61: (0.0123, -0.0016), -60: (0.0124, -0.0018), -59: (0.0126, -0.0019), -58: (0.0127, -0.0015), -57: (0.0129, -0.0017), -56: (0.0132, -0.0019), -55: (0.0133, -0.0018), -54: (0.0133, -0.0024), -53: (0.0132, -0.0024), -52: (0.0132, -0.0023), -51: (0.0133, -0.0023)}, -33: {-72: (0.022, 0.0117), -71: (0.0198, 0.0079), -70: (0.016, 0.0005), -69: (0.0153, -0.0024), -68: (0.0136, -0.007), -67: (0.0139, -0.0043), -66: (0.0123, -0.0037), -65: (0.0119, -0.0028), -64: (0.012, -0.003), -63: (0.0118, -0.0015), -62: (0.0121, -0.0017), -61: (0.0123, -0.0015), -60: (0.0125, -0.0017), -59: (0.0126, -0.0018), -58: (0.0127, -0.0018), -57: (0.0127, -0.0013), -56: (0.013, -0.0013), -55: (0.0131, -0.0013), -54: (0.0131, -0.0018), -53: (0.0132, -0.0023), -52: (0.0132, -0.0024)}, -34: {-72: (0.023, 0.0063), -71: (0.0196, 0.0011), -70: (0.0159, -0.0022), -69: (0.0133, -0.0055), -68: (0.0126, -0.0075), -67: (0.0122, -0.007), -66: (0.0122, -0.0059), -65: (0.0119, -0.006), -64: (0.0128, -0.0039), -63: (0.0127, -0.0036), -62: (0.0128, -0.0026), -61: (0.0127, -0.0023), -60: (0.0127, -0.0017), -59: (0.0128, -0.0019), -58: (0.013, -0.002), -57: (0.013, -0.0016), -56: (0.0131, -0.0012), -55: (0.0132, -0.0016), -54: (0.0133, -0.0017), -53: (0.0135, -0.002)}, -35: {-73: (0.0214, -0.0051), -72: (0.0216, -0.0047), -71: (0.0204, -0.0051), -70: (0.0179, -0.0101), -69: (0.0137, -0.0137), -68: (0.012, -0.0074), -67: (0.0116, -0.009), -66: (0.0117, -0.0086), -65: (0.0124, -0.007), -64: (0.0134, -0.0054), -63: (0.0132, -0.0043), -62: (0.0135, -0.0039), -61: (0.0133, -0.0027), -60: (0.0136, -0.0028), -59: (0.0134, -0.0021), -58: (0.0131, -0.0018), -57: (0.0133, -0.002), -56: (0.0133, -0.0017), -55: (0.0132, -0.0014), -54: (0.0135, -0.0018)}, -36: {-73: (0.02, -0.0036), -72: (0.0187, -0.0073), -71: (0.0187, -0.0136), -70: (0.019, -0.0191), -69: (0.0147, -0.0147), -68: (0.0135, -0.015), -67: (0.0124, -0.0121), -66: (0.013, -0.0071), -65: (0.0133, -0.0063), -64: (0.014, -0.0056), -63: (0.0138, -0.0043), -62: (0.014, -0.0042), -61: (0.0137, -0.0033), -60: (0.0138, -0.0033), -59: (0.0135, -0.0022), -58: (0.0137, -0.0023), -57: (0.0133, -0.002), -56: (0.0135, -0.0019)}, -37: {-74: (0.0179, -0.0004), -73: (0.0181, -0.0017), -72: (0.0176, -0.0102), -71: (0.0183, -0.0077), -70: (0.0184, -0.0199), -69: (0.0189, -0.0212), -68: (0.0178, -0.0139), -67: (0.0142, -0.0072), -66: (0.014, -0.0068), -65: (0.014, -0.0047), -64: (0.014, -0.0055), -63: (0.014, -0.0045), -62: (0.0142, -0.0034), -61: (0.0142, -0.0035), -60: (0.0142, -0.0029), -59: (0.0143, -0.0023), -58: (0.0143, -0.0023), -57: (0.0141, -0.0024), -56: (0.0141, -0.0022)}, -38: {-74: (0.0174, 0.0017), -73: (0.0175, -0.005), -72: (0.0178, -0.0057), -71: (0.0178, -0.0106), -70: (0.019, -0.0153), -69: (0.0194, -0.0144), -68: (0.0177, -0.0101), -67: (0.0163, -0.0085), -66: (0.0148, -0.0059), -65: (0.0144, -0.0051), -64: (0.0142, -0.005), -63: (0.0143, -0.0051), -62: (0.0141, -0.0039), -61: (0.0143, -0.0027), -60: (0.0143, -0.0025), -59: (0.0143, -0.0021), -58: (0.0142, -0.0022), -57: (0.0143, -0.0024)}, -39: {-74: (0.0171, 0.0072), -73: (0.0168, 0.0037), -72: (0.0176, -0.003), -71: (0.0186, -0.0069), -70: (0.0194, -0.0072), -69: (0.0188, -0.0108), -68: (0.0168, -0.0084), -67: (0.0154, -0.0053), -66: (0.0154, -0.0052), -65: (0.0147, -0.0042), -64: (0.0148, -0.0044), -63: (0.0149, -0.0044), -62: (0.0147, -0.0031), -61: (0.0143, -0.0027), -60: (0.0143, -0.0023), -59: (0.0143, -0.0021), -58: (0.0143, -0.0022)}, -40: {-74: (0.0163, 0.0145), -73: (0.0174, 0.0103), -72: (0.0169, 0.0077), -71: (0.0175, 0.0049), -70: (0.0185, -0.0036), -69: (0.0186, -0.0037), -68: (0.0153, -0.0051), -67: (0.0154, -0.0052), -66: (0.0154, -0.0052), -65: (0.0152, -0.0045), -64: (0.0148, -0.0043), -63: (0.0149, -0.0044), -62: (0.015, -0.0044)}, -41: {-74: (0.0155, 0.0157), -73: (0.0152, 0.0144), -72: (0.0167, 0.0125), -71: (0.0165, 0.0089), -70: (0.0161, 0.0037), -69: (0.0147, 0.0002), -68: (0.0136, -0.0027), -67: (0.0137, -0.0036), -66: (0.0137, -0.0037), -65: (0.0142, -0.004), -64: (0.0135, -0.0028), -63: (0.0134, -0.0029), -62: (0.0133, -0.003)}, -42: {-75: (0.015, 0.0156), -74: (0.0144, 0.0113), -73: (0.0136, 0.0082), -72: (0.0137, 0.008), -71: (0.0138, 0.0079), -70: (0.0132, 0.0031), -69: (0.0131, 0.0004), -68: (0.0133, 0.0001), -67: (0.0135, -0.0031), -66: (0.0133, -0.0031), -65: (0.0133, -0.0031), -64: (0.0128, -0.0026), -63: (0.013, -0.0027)}, -43: {-75: (0.013, 0.007), -74: (0.0127, 0.0037), -73: (0.0128, 0.0036), -72: (0.0129, 0.0035), -71: (0.013, 0.0033), -70: (0.0132, 0.0032), -69: (0.0123, 0.0022), -68: (0.0115, 0.0), -67: (0.0125, -0.0014), -66: (0.0122, -0.0009), -65: (0.0111, -0.001), -64: (0.012, -0.0023)}, -44: {-75: (0.0119, 0.0023), -74: (0.012, 0.0022), -73: (0.0121, 0.002), -72: (0.0122, 0.0019), -71: (0.0123, 0.0017), -70: (0.0125, 0.0016), -69: (0.0126, 0.0015), -68: (0.0116, 0.0001), -67: (0.0113, -0.0002), -66: (0.0124, -0.0008), -65: (0.0123, -0.0004)}, -45: {-75: (0.0119, 0.0024), -74: (0.012, 0.0023), -73: (0.0121, 0.0021), -72: (0.0122, 0.0021), -71: (0.0123, 0.0019), -70: (0.0125, 0.0017), -69: (0.0126, 0.0016), -68: (0.0113, 0.001), -67: (0.0112, 0.0007), -66: (0.0111, 0.0004), -65: (0.0128, 0.0002)}, -46: {-74: (0.0121, 0.0032), -73: (0.0121, 0.0031), -72: (0.0122, 0.0029), -71: (0.0123, 0.0028), -70: (0.0126, 0.0026), -69: (0.0127, 0.0025), -68: (0.0128, 0.0023), -67: (0.0116, 0.0014), -66: (0.0115, 0.0011)}, -47: {-75: (0.012, 0.0035), -74: (0.0121, 0.0033), -73: (0.0122, 0.0032), -72: (0.0127, 0.0032), -71: (0.0129, 0.0031), -70: (0.0133, 0.0033), -69: (0.0134, 0.0032), -68: (0.0135, 0.003), -67: (0.0136, 0.0029), -66: (0.0126, 0.0016), -65: (0.0126, 0.0014)}, -48: {-75: (0.0127, 0.0042), -74: (0.0128, 0.0041), -73: (0.0129, 0.0039), -72: (0.013, 0.0038), -71: (0.0131, 0.0036), -70: (0.0133, 0.0035), -69: (0.0134, 0.0033), -68: (0.0142, 0.0034), -67: (0.0143, 0.0032), -66: (0.015, 0.0032), -65: (0.0151, 0.0031)}, -49: {-75: (0.0127, 0.0043), -74: (0.0128, 0.0042), -73: (0.0136, 0.0042), -72: (0.0138, 0.0041), -71: (0.0145, 0.0041), -70: (0.0147, 0.004), -69: (0.0148, 0.0038), -68: (0.0149, 0.0037), -67: (0.015, 0.0035)}, -50: {-75: (0.014, 0.0052), -74: (0.0142, 0.0047), -73: (0.0143, 0.0045), -72: (0.0144, 0.0044), -71: (0.0145, 0.0042), -70: (0.0147, 0.0041), -69: (0.0148, 0.0039), -68: (0.0149, 0.0038)}, -51: {-75: (0.0145, 0.0056), -74: (0.0146, 0.0054), -73: (0.0147, 0.0053), -72: (0.0148, 0.0051), -71: (0.0149, 0.0049), -70: (0.0151, 0.0048), -69: (0.0152, 0.0046)}, -52: {-74: (0.0146, 0.0055), -73: (0.0147, 0.0054), -72: (0.0148, 0.0052), -71: (0.0149, 0.0051), -70: (0.0148, 0.0054), -69: (0.0149, 0.0052)}, -53: {-74: (0.0141, 0.0074), -73: (0.0142, 0.0074), -72: (0.0142, 0.0072), -71: (0.0146, 0.0057), -70: (0.0148, 0.0055), -69: (0.0149, 0.0053), -68: (0.015, 0.0052)}, -54: {-73: (0.0136, 0.0081), -72: (0.0138, 0.0079), -71: (0.0139, 0.0078), -70: (0.0141, 0.0076), -69: (0.0141, 0.0075), -68: (0.0142, 0.0073), -67: (0.0143, 0.0071)}, -55: {-71: (0.0138, 0.0079), -70: (0.014, 0.0077), -69: (0.014, 0.0076), -68: (0.0141, 0.0074), -67: (0.0143, 0.0072), -66: (0.0143, 0.007)}}

# calculo das velocidades
def vemos(lat, lon, modelo):
    modelo = modelo.lower().replace(' ', '')
    if modelo == 'vemos2009':
        dic = vemos2009
    elif modelo == 'vemos2017':
        dic = vemos2017

    try: # bilinear
        LAT = floor(lat)
        LON = floor(lon)
        dlat = lat - LAT # J
        dlon = lon - LON # I
        vlat = (1-dlat)*(1-dlon)*dic[LAT][LON][0] + (1-dlat)*dlon*dic[LAT][LON+1][0] + (1-dlon)*dlat*dic[LAT+1][LON][0] + dlon*dlat*dic[LAT+1][LON+1][0]
        vlon = (1-dlat)*(1-dlon)*dic[LAT][LON][1] + (1-dlat)*dlon*dic[LAT][LON+1][1] + (1-dlon)*dlat*dic[LAT+1][LON][1] + dlon*dlat*dic[LAT+1][LON+1][1]
        return (vlat, vlon)
    except:
        try:
            vlat = dic[round(lat)][round(lon)][0]
            vlon = dic[round(lat)][round(lon)][1]
            return (vlat, vlon)
        except:
            return None
