import os
import re
import json
import random

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtWidgets import QApplication, QWidget, QPushButton, QMessageBox, QInputDialog
from qgis.PyQt.QtCore import QSettings, QSize
from qgis.core import *
from qgis.gui import QgsMapCanvas, QgsMapToolPan
from datetime import date
from dateutil.relativedelta import relativedelta
# import requests
from .lerplus_config import API_URLBASE
from .lerplus_utils import *

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'lerplushints.ui'))


class LERplusHintsDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(LERplusHintsDialog, self).__init__(parent)

        self.setupUi(self)

        self.closeButton.clicked.connect(self.closeWindow)

        self.hintText.setPlainText(self.getHint())
        settings = QgsSettings()
        self.checkboxShowHints.setChecked(settings.value("lerplusdock/showhints", True, type=bool))

        # self.setWindowFlags(Qt.Window)
        # self.notsendButton.clicked.connect(self.notsendReport)
        
    def getHint(self):
        hints = [
            'Vidste du, at du kan bestille en opdatering med friske data fra LER? tryk på \u21BB "Opdatér data" ud for en forespørgsel!',
            'Vidste du, at du kan arkivere forespørgsler som du ved, du ikke skal genbesøge? Dette vil påvirke hastigheden af interfacet, så din oplevelse bliver bedre. Skulle du få brug for at genskabe disse data, kan det lade sig gøre ved henvendelse til qLER.',
            'LER+ opretter et lag du kan søge i, hvis du ikke selv har valgt et polygonlag. Bare tryk på SØG-knappen.',
            'Vidste du, at du kan gruppere ledningsdata efter Ledningsejer og Forsyningstype, når du importerer et LER-svar? Det kan være mere praktisk for dig end blot at sortere på Forsyningstype.',
            'Hvis du omdøber gruppenavnet for en importeret LER-søgning, kan du importere den samme søgning flere gange. Det kan være praktisk hvis du har tilpasset stylingen for en søgning, som ellers vil blive overskrevet næste gang du trykker på Importer.',
            'Det her er en ret stærk feature i LER+, du måske ikke har opdaget: "Tilføj LERID" kan du bruge til at importere LER-søgninger, du eller dine kolleger har udført andre steder end i LER+. Indtast bare LER-nummeret (eller flere adskilt af komma), så dukker de op i din velkendte liste, og opfører sig helt som alle de andre.',
            'Vidste du, at du kan fjerne de her irriterende LER+ tips ved opstart, ved at fjerne fluebenet herunder eller - hvis du foretrækker lige at overveje det lidt - i Indstillinger? &#128521;',
            'Knappen "Indstillinger" giver dig mulighed for at få en mere komprimeret visning af listen over søgninger. Du kan også slå til og fra, om du ønsker at se dine kollegers LER-søgninger på listen.',
            'Hvis du foretrækker, at listen over LER-søgninger opdateres automatisk, når du starter QGIS, kan du aktivere dette bag knappen "Indstillinger".',
            'Skabeloner sparer dig for at indtaste trivielle oplysninger hver gang du skal udføre en LER-søgning. Husk at udnytte denne stærke feature.',
            'Kravet fra LER, om at du oplyser "Forsyningsart" når du søger, dækker over hvilken forsyningsart du arbejder med - det har ingen indflydelse på hvilke forsyningsarter, du modtager fra ledningsejerne - de sender alt, hvad de har, uanset hvad din favorit-forsyningsart er :)'
        ]
        return random.choice(hints)
        

    def closeWindow(self):
        settings = QgsSettings()
        settings.setValue("lerplusdock/showhints", self.checkboxShowHints.isChecked())
        self.close()

    #def notsendReport(self):
#        self.close()

    def setIface(self, iface):
        self.iface = iface
        #self.errorText.setText(errortext)
