

import os
import re
import json

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtWidgets import QApplication, QWidget, QPushButton, QMessageBox, QInputDialog
from qgis.PyQt.QtCore import QSettings, QSize
from qgis.core import *
from qgis.gui import QgsMapCanvas, QgsMapToolPan
from datetime import date
from dateutil.relativedelta import relativedelta
# import requests
#from .lerplus_config import API_URLBASE
from .lerplus_utils import *


# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'lerpluserrorreport.ui'))


class LERplusErrorDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(LERplusErrorDialog, self).__init__(parent)

        self.setupUi(self)

        self.sendButton.clicked.connect(self.sendReport)
        #self.setWindowFlags(Qt.Window)
        self.notsendButton.clicked.connect(self.notsendReport)

    def sendReport(self):
        errortext = self.errorText.toPlainText()
        data = {
            'errortext': errortext,
            'url': self.errorurl,
            'jsondata': self.jsondata
        }
        if (make_api_call(self, "adderrorreport", data)) == False:
            QMessageBox.information(self, 'Fejlrapport ikke tilføjet',
                                    'Der skete en fejl ved indsendning af fejlrapporten.')
        else:
            QMessageBox.information(self, 'Fejlrapport tilføjet', 'Tak for at du indsendte fejlrapporten.')
            #QMessageBox.information(self, 'Invalid API-response', r.text)
        self.close()

    def notsendReport(self):
        self.close()

    def setIface(self, iface, errortext, url, jsondata):
        self.iface = iface
        self.errorText.setPlainText(errortext)
        self.errorurl=url
        self.jsondata=jsondata
        self.sendButton.setEnabled(True)
