# -*- coding: utf-8 -*-
"""
/***************************************************************************
 LERplusDialog
                                 A QGIS plugin
 Nem adgang til LER 2.0-forespørgsler
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-05-04
        git sha              : $Format:%H$
        copyright            : (C) 2023 by qLER ApS
        email                : morten@qler.dk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import re

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtWidgets import QApplication, QWidget, QPushButton, QMessageBox, QInputDialog
from qgis.core import *
from datetime import date
from dateutil.relativedelta import relativedelta
# import requests
from .lerplus_config import API_URLBASE
from .lerplus_utils import *

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'lerplusnewsession.ui'))


class LERplusNewSession(QtWidgets.QDialog, FORM_CLASS):
    areaprice = 0
    geometrywkt = ''
    geometrycrs = ''

    def __init__(self, parent=None):
        """Constructor."""
        super(LERplusNewSession, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        # self.tokenEdit.setText(settings.value("lerplus/token"))
        self.sendButton.clicked.connect(self.sendNewSession)
        self.cancelButton.clicked.connect(self.cancelNewSession)

        self.getTemplateButton.clicked.connect(self.getTemplate)
        self.saveTemplateButton.clicked.connect(self.saveTemplate)
        self.updateTemplateButton.clicked.connect(self.updateTemplate)
        self.deleteTemplateButton.clicked.connect(self.deleteTemplate)

        self.setDefaultButton.clicked.connect(self.setDefaultTemplate)

        self.updateTemplateList()
        self.geometry = ''
        self.projection = ''

    # def prepareDataObject(self):

    def validate_email(self, email):
        if re.match(r"[^@]+@[^@]+\.[^@]+", email):
            return True
        return False

    def validateForm(self):
        if not self.description.text():
            QMessageBox.information(self, 'Manglende information', 'Der skal angives en kort beskrivelse')
            return False
        """ 
        if not self.kontaktperson.text() and not self.kontaktadresse.text():
            QMessageBox.information(self, 'Manglende information', 'Der skal ENTEN angives en kontaktperson eller en kontaktadresse. Begge skal være en gyldig email')
            return False
    
        if self.kontaktperson.text() and self.kontaktadresse.text():
            QMessageBox.information(self, 'Manglende information', 'Der skal ENTEN angives en kontaktperson eller en kontaktadresse. Begge skal være en gyldig email')
            return False
        """
        if self.kontaktperson.text() and not self.validate_email(self.kontaktperson.text()):
            QMessageBox.information(self, 'Manglende information',
                                    'Der skal angives en gyldig emailadresse til en kontaktperson oprettet hos LER.')
            return False
        """
        if self.kontaktadresse.text() and not self.validate_email(self.kontaktadresse.text()):
            QMessageBox.information(self, 'Manglende information', 'Der skal ENTEN angives en kontaktperson eller en kontaktadresse. Begge skal være en gyldig email')
            return False
        """

        if self.formaal.currentText() == 'Andet':
            if not self.formaal_andet_tekst.text():
                QMessageBox.information(self, 'Manglende information',
                                    'Der skal angives andet formål')
                return False

        if self.forsyningsart_teledata.checkState() == 0:
            if self.forsyningsart_antenne.checkState() == 0:
                if self.forsyningsart_vand.checkState() == 0:
                    if self.forsyningsart_termisk.checkState() == 0:
                        if self.forsyningsart_el.checkState() == 0:
                            if self.forsyningsart_olie.checkState() == 0:
                                if self.forsyningsart_gas.checkState() == 0:
                                    if self.forsyningsart_aflob.checkState() == 0:
                                        if self.forsyningsart_vejafvanding.checkState() == 0:
                                            if self.forsyningsart_foringsror.checkState() == 0:
                                                if  self.forsyningsart_andet.checkState() == 0:
                                                    QMessageBox.information(self, 'Manglende information',
                                                                            'Der skal angives mindst 1 forsyningsart')
                                                    return False


        if self.forsyningsart_andet.checkState() > 0:
            if not self.forsyningsart_andet_tekst.text():
                QMessageBox.information(self, 'Manglende information',
                                    'Når anden forsyningsart er valgt skal der angives en tekst')
                return False







        if self.areaprice > 100:
            reply = QMessageBox.question(self, 'Afsendelse',
                                         'Denne forespørgsel anslår vi vil koster kr. ' + "{:.2f}".format(
                                             self.areaprice) + '! Er det i orden?',
                                         QMessageBox.Yes | QMessageBox.No, QMessageBox.No)
            if reply == QMessageBox.No:
                return False

        return True

    def updateTemplateList(self):

        apiresponse = make_api_call(self, "gettemplates")

        if apiresponse is False:
            return

        self.templateDropdown.clear()

        for template in apiresponse['data']['templates']:
            self.templateDropdown.addItem(template["name"])

    def getTemplate(self):
        # currentText() virker også
        data = {
            'templatename': self.templateDropdown.currentText()
        }
        apiresponse = make_api_call(self, "gettemplate", data)

        if apiresponse is False:
            return

        self.setFieldsFromArray(json.loads(apiresponse['data']['fieldvalues']))

    def setDefaultTemplate(self):
        currenttemplate = self.templateDropdown.currentText()
        settings = QgsSettings()
        settings.setValue("lerplusdock/defaulttemplate", currenttemplate);
        self.getTemplate()
        QMessageBox.information(self, 'Skabeloner', 'Skabelonen blev valgt som standard')


    def deleteTemplate(self):

        reply = QMessageBox.question(self, 'Slet skabelon',
                                     'Er du sikker på du vil slette denne skabelon?',
                                     QMessageBox.Yes | QMessageBox.No, QMessageBox.No)
        if reply == QMessageBox.No:
            return
        data = {
            'templatename': self.templateDropdown.currentText()
        }
        apiresponse = make_api_call(self, "deletetemplate", data)

        if apiresponse is False:
            return

        self.updateTemplateList()

        QMessageBox.information(self, 'Skabeloner', 'skabelonen blev slettet')

    def saveTemplate(self):
        newname, ok = QInputDialog.getText(self, 'Gem skabelon', 'Hvad skal den nye skabelon kaldes:')
        if ok:

            data = {
                'fieldvalues': json.dumps(self.getFieldsArray(False)),
                'newname': newname
            }
            apiresponse = make_api_call(self, "savetemplate", data)

            if apiresponse is False:
                return

            self.updateTemplateList()
            QMessageBox.information(self, 'Skabeloner', 'skabelonen blev gemt')

    def updateTemplate(self):
        data = {
            'fieldvalues': json.dumps(self.getFieldsArray(False)),
            'templatename': self.templateDropdown.currentText()
        }
        apiresponse = make_api_call(self, "updatetemplate", data)

        if apiresponse is False:
            return

        self.updateTemplateList()
        QMessageBox.information(self, 'Skabeloner', 'skabelonen blev opdateret')


    def getFieldsArray(self, include_polygons=True):
        data = {
            'description': self.description.text()
            , 'sagsnummer': self.sagsnummer.text()
            # , 'kontaktadresse': self.kontaktadresse.text()
            , 'eget_ordrenummer': self.egetordrenummer.text()
            , 'graveperiode_fra': self.graveperiode_fra.date().toString("yyyy-MM-dd")
            , 'graveperiode_til': self.graveperiode_til.date().toString("yyyy-MM-dd")
            , 'kontaktperson': self.kontaktperson.text()

            , 'bemaerkning': self.bemaerkning.toPlainText()

            , 'forsyningsart_teledata': self.forsyningsart_teledata.checkState()
            , 'forsyningsart_antenne': self.forsyningsart_antenne.checkState()
            , 'forsyningsart_vand': self.forsyningsart_vand.checkState()
            , 'forsyningsart_termisk': self.forsyningsart_termisk.checkState()
            , 'forsyningsart_el': self.forsyningsart_el.checkState()
            , 'forsyningsart_olie': self.forsyningsart_olie.checkState()
            , 'forsyningsart_gas': self.forsyningsart_gas.checkState()
            , 'forsyningsart_aflob': self.forsyningsart_aflob.checkState()
            , 'forsyningsart_vejafvanding': self.forsyningsart_vejafvanding.checkState()
            , 'forsyningsart_foringsror': self.forsyningsart_foringsror.checkState()
            , 'forsyningsart_andet': self.forsyningsart_andet.checkState()
            , 'forsyningsart_andet_tekst': self.forsyningsart_andet_tekst.text()

            , 'formaal': self.formaal.currentText()
            , 'formaal_andet_tekst': self.formaal_andet_tekst.text()

            , 'graveart_gravemaskine': self.graveart_gravemaskine.checkState()
            , 'graveart_styret_underboring': self.graveart_styret_underboring.checkState()
            , 'graveart_kaedegraver': self.graveart_kaedegraver.checkState()
            , 'graveart_gennempresning': self.graveart_gennempresning.checkState()
            , 'graveart_boring_m_paelebor': self.graveart_boring_m_paelebor.checkState()
            , 'graveart_relining': self.graveart_relining.checkState()
            , 'graveart_cracking': self.graveart_cracking.checkState()
            , 'graveart_plov': self.graveart_plov.checkState()
            , 'graveart_ramning': self.graveart_ramning.checkState()
            , 'graveart_spraengning': self.graveart_spraengning.checkState()
            , 'graveart_andet': self.graveart_andet.checkState()
            , 'graveart_andet_tekst': self.graveart_andet_tekst.text()

            # , 'papirformat': self.papirformat.currentText()
            # , 'digitalformat_shp': self.digitalformat_shp.checkState()
            # , 'digitalformat_tab': self.digitalformat_tab.checkState()
            # , 'digitalformat_dgn': self.digitalformat_dgn.checkState()
            # , 'digitalformat_dxf': self.digitalformat_dxf.checkState()
        }
        if include_polygons:
            #data["polygon"] = self.showgeometry.toPlainText()
            data["polygons"] = json.dumps(self.wktlist)
        """if self.geometry.area() > 250000:
            data["multisession"] = 1
        else:
            data["multisession"] = 0
        """

        return data


    def setFieldsFromArray(self, data):
        self.description.setText(data['description'])
        self.description.setText(data['eget_ordrenummer'])
        self.sagsnummer.setText(data['sagsnummer'])
        # self.graveperiode_fra.date().setDate(data['graveperiode_fra'])
        # self.graveperiode_til.date().setDate(data['graveperiode_til'])
        # self.kontaktadresse.setText(data['kontaktadresse'])
        self.kontaktperson.setText(data['kontaktperson'])

        self.bemaerkning.setPlainText(data['bemaerkning'])

        self.forsyningsart_teledata.setCheckState(data['forsyningsart_teledata'])
        self.forsyningsart_antenne.setCheckState(data['forsyningsart_antenne'])
        self.forsyningsart_vand.setCheckState(data['forsyningsart_vand'])
        self.forsyningsart_el.setCheckState(data['forsyningsart_el'])
        self.forsyningsart_olie.setCheckState(data['forsyningsart_olie'])
        self.forsyningsart_gas.setCheckState(data['forsyningsart_gas'])
        self.forsyningsart_aflob.setCheckState(data['forsyningsart_aflob'])
        self.forsyningsart_vejafvanding.setCheckState(data['forsyningsart_vejafvanding'])
        self.forsyningsart_foringsror.setCheckState(data['forsyningsart_foringsror'])
        self.forsyningsart_andet.setCheckState(data['forsyningsart_andet'])
        self.forsyningsart_andet_tekst.setText(data['forsyningsart_andet_tekst'])

        self.formaal.setCurrentText(data["formaal"])
        self.formaal_andet_tekst.setText(data['formaal_andet_tekst'])

        self.graveart_gravemaskine.setCheckState(data['graveart_gravemaskine'])
        self.graveart_styret_underboring.setCheckState(data['graveart_styret_underboring'])
        self.graveart_kaedegraver.setCheckState(data['graveart_kaedegraver'])
        self.graveart_gennempresning.setCheckState(data['graveart_gennempresning'])
        self.graveart_boring_m_paelebor.setCheckState(data['graveart_boring_m_paelebor'])
        self.graveart_relining.setCheckState(data['graveart_relining'])
        self.graveart_cracking.setCheckState(data['graveart_cracking'])
        self.graveart_plov.setCheckState(data['graveart_plov'])
        self.graveart_ramning.setCheckState(data['graveart_ramning'])
        self.graveart_spraengning.setCheckState(data['graveart_spraengning'])
        self.graveart_andet.setCheckState(data['graveart_andet'])
        self.graveart_andet_tekst.setText(data['graveart_andet_tekst'])


    def sendNewSession(self):
        #QMessageBox.information(self, 'current geometry', json.dumps(self.wktlist))
        if not self.validateForm():
            return
        reply = QMessageBox.question(self, 'Afsendelse', 'Er du sikker på du vil afsende forespørgslen?',
                                     QMessageBox.Yes | QMessageBox.No, QMessageBox.No)
        if reply == QMessageBox.No:
            return
        # QMessageBox.information(self, 'test af info', "Dette er test af en simpel infobox " + str(self.geometry.area()) + "m2")

        # token = self.tokenEdit.text()
        """settings = QgsSettings()
        token = settings.value("lerplus/token")
        #QMessageBox.information(self, 'Token', token)
        API_ENDPOINT = API_URLBASE+'/addsession?apitoken='+token
       
        r = requests.post(url=API_ENDPOINT, data=data)
        response_text = r.text
      
        if not is_valid_json(r.text):
            QMessageBox.information(self, 'Invalid API-response', r.text)
            return
      
        if "error" in response_text.lower():
            if settings.value("lerplus/debugmode") == 1:
                QMessageBox.information(self, 'ERROR! API-response', response_text)
            else:
                QMessageBox.information(self, 'Fejl', "Der skete en fejl ved oprettelse af sessionen")
            return
        """
        data = self.getFieldsArray()
        data['source'] = 'qgis'
        data['manytomulti'] = self.manyToMultiCheckBox.checkState()
        data['optimizeareas'] = self.optimizeAreasCheckBox.checkState()
        result = make_api_call(self, 'addsession', data)
        if result is False:
            return
        settings = QgsSettings()
        settings.setValue("lerplusdock/importmanytomulti", self.manyToMultiCheckBox.checkState())
        settings.setValue("lerplusdock/importoptimizeareas", self.optimizeAreasCheckBox.checkState())

        QMessageBox.information(self, "Succes!", 'Session blev tilføjet!\nFuld status og muligheden for at importere data\nkan du forvente efter 5-10 minutter ved små områder,\nog 10-15 min ved store, opdelte områder.')

        # self.iface.messageBar().pushMessage("Success", "settings saved", level=Qgis.Info, duration=5)

        #  QgsMessageLog.logMessage("Your settings was saved!", level=Qgis.Info)

        self.close()


    def cancelNewSession(self):
        reply = QMessageBox.question(self, 'Afbryd', 'Er du sikker på du vil afbryde denne ?',
                                     QMessageBox.Yes | QMessageBox.No, QMessageBox.No)
        if reply == QMessageBox.Yes:
            self.close()
        # else:
        # event.ignore()


    def setIface(self, iface):
        self.iface = iface


    def setProjection(self, projection):
        self.projection = projection

    def setIsDemo(self, isdemo):
        self.isdemo = isdemo

    def setGeometryList(self, geomlist, wktlist):
        self.geomlist = geomlist
        self.wktlist = wktlist
        totalarea = 0
        totalmulti = 0
        totalcount = 0
        for geom in geomlist:
            totalarea += geom.area()
            totalcount += 1
            if geom.area() > 250000:
                totalmulti += 1
        areaprice = totalarea * 0.015
        self.areaprice = areaprice
        #areaprice = price

        areal = "{0:,.1f}".format(totalarea) + ' m2 '
        if len(geomlist) == 1:
            areal = areal + 'i 1 område, '
        else:
            areal = areal + 'i ' + str (len(geomlist)) + ' områder, '
        areal = areal + "{0:,.1f}".format(areaprice) + ' kr. (vejledende)'
        self.arealLabel.setText(areal)
        if totalmulti > 0:
            self.multiLabel.setText(str(totalmulti) + " MULTI")
        else:
            self.multiLabel.setText(str(totalcount) +" SINGLE")

        if totalcount > 1:
            self.manyToMultiCheckBox.setEnabled(True)
        else:
            self.manyToMultiCheckBox.setEnabled(False)

        if totalmulti > 0:
            self.optimizeAreasCheckBox.setEnabled(True)
        else:
            self.optimizeAreasCheckBox.setEnabled(False)






    def setGeometry(self, geometry):
        self.geometry = geometry
        #self.showgeometry.setPlainText(str(self.geometry.asWkt()))
        #QMessageBox.information(self, 'current geometry', geometry.toString())


        self.geometrywkt = str(self.geometry.asWkt())
        areal = "{0:,.1f}".format(self.geometry.area()) + ' m2 '
        price = self.geometry.area() * 0.015
        self.areaprice = price
        areal = areal + "{0:,.1f}".format(price) + ' kr. (vejledende)'
        self.arealLabel.setText(areal)
        if self.geometry.area() > 250000:
            self.multiLabel.setText("MULTI")
        else:
            self.multiLabel.setText("SINGLE")


    def setupValues(self):
        today = date.today()
        self.graveperiode_fra.setMinimumDate(today)
        #maxdate = today + relativedelta(months=6)
        #self.graveperiode_fra.setMaximumDate(maxdate)

        settings = QgsSettings()
        manytomulti = settings.value("lerplusdock/importmanytomulti")
        if manytomulti is not None:
            self.manyToMultiCheckBox.setCheckState(int(manytomulti))

        optimizeareas = settings.value("lerplusdock/importoptimizeareas")
        if optimizeareas is not None:
            self.optimizeAreasCheckBox.setCheckState(int(optimizeareas))


        if self.isdemo == 1:
            self.kontaktperson.setText('qler@qler.dk')
            self.kontaktperson.setReadOnly(True)

            self.bemaerkning.setPlainText('Testforespørgsel')
            self.bemaerkning.setReadOnly(True)
            self.description.setText('Testforespørgsel')
            self.description.setReadOnly(True)

            self.egetordrenummer.setReadOnly(True)
            self.graveperiode_fra.setReadOnly(True)
            self.graveperiode_til.setReadOnly(True)
            self.sagsnummer.setReadOnly(True)

            self.formaal.setCurrentIndex(2)
            self.formaal.setEnabled(False)
        else:
            defaulttemplate = settings.value("lerplusdock/defaulttemplate")
            self.templateDropdown.setCurrentText(defaulttemplate)
            self.getTemplate()
