# -*- coding: utf-8 -*-
"""
/***************************************************************************
 LerPlusDockDockWidget
                                 A QGIS plugin
 Nem adgang til LER2 forespørgsler
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-10-09
        git sha              : $Format:%H$
        copyright            : (C) 2023 by qLER ApS
        email                : morten@qler.dk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.core import QgsGeometryValidator, QgsFeature
from qgis.core import QgsVectorLayer, QgsField, QgsFields, QgsWkbTypes
from qgis.PyQt.QtCore import QVariant

from qgis.PyQt import QtGui, QtWidgets, uic
from qgis.PyQt.QtCore import pyqtSignal
from qgis.PyQt.QtCore import QSettings, QSize
from qgis.PyQt.QtWidgets import QFrame, QMessageBox, QPushButton
from qgis.PyQt.QtWidgets import QApplication, QMainWindow, QTableWidget, QTableWidgetItem, QPushButton, QVBoxLayout, \
    QWidget, QComboBox, QProgressDialog
from qgis.PyQt.QtGui import QDesktopServices
from qgis.PyQt.QtGui import QColor, QFont
from qgis.PyQt.QtCore import Qt, QUrl
# from .lerplus_settings import LERplusSettings
# from .lerplus_config import *
from .lerplus_utils import *
from .qt_compat import (Qt_UserRole, Qt_AlignRight, Qt_AlignCenter, Qt_AlignVCenter,
                        QFrame_StyledPanel, QFrame_Raised)
from datetime import datetime
from qgis.PyQt.QtCore import QTimer
from functools import partial
from .lerplusnewsession import LERplusNewSession
from .lerplussessioninfo import LERplusSessionInfo
from .lerplusmultisessioninfo import LERplusMultiSessionInfo
from .lerplusimport import LERplusImportDialog
from .lerplusinject import LERplusInjectDialog
from .lerplushints import LERplusHintsDialog
import tempfile
#import processing
import requests
import sys
from qgis.core import QgsCoordinateReferenceSystem, QgsCoordinateTransform, QgsProject

# from .suggester import Suggester
# from .config import Settings


FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'lerpluswidget.ui'))


class DateTableWidgetItem(QTableWidgetItem):
    def __init__(self, date_str, timestamp):
        super().__init__(date_str)
        self.timestamp = timestamp

    def __lt__(self, other):
        if isinstance(other, DateTableWidgetItem):
            return self.timestamp < other.timestamp
        return super().__lt__(other)


class AreaTableWidgetItem(QTableWidgetItem):
    def __lt__(self, other):
        if isinstance(other, QTableWidgetItem):
            # Compare based on the numeric sorting value stored in UserRole
            return self.data(Qt_UserRole) < other.data(Qt_UserRole)
        return super().__lt__(other)


class LerPlusWidget(QFrame, FORM_CLASS):
    closingPlugin = pyqtSignal()

    def __init__(self, iface):
        """Constructor."""
        QFrame.__init__(self, iface.mainWindow())
        # super(LerPlusWidget, self).__init__(parent)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://doc.qt.io/qt-5/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        # self.readconfig()
        self.setupUi(self)
        self.iface = iface
        self.setFrameStyle(QFrame_StyledPanel | QFrame_Raised)

        # self.settings=settings
        # self.suggester = Suggester(
        #    settings=settings,
        #    searchbox_widget=self.searchEdit,
        #    notauthorized_func=self.handleNotAuthorized
        # )

        self.resize(50, self.height())
        # self.searchEdit.setFocus()
        self.settingsButton.clicked.connect(self.showSettings)
        self.newsessionButton.clicked.connect(self.newSession)
        self.updatenowButton.clicked.connect(lambda: self.updateSessions(True))
        self.injectButton.clicked.connect(self.doInject)

        settings = QgsSettings()
        compactlist = settings.value("lerplusdock/compactlist")

        self.timer = QTimer()
        self.timer.timeout.connect(self.updateSessions)
        self.timer.start(120000)  # 60 seconds in milliseconds
        # QMessageBox.about(self, "Fejl", str(compactlist))
        if compactlist == "1":
            columns = ['LER#', "Udf.", "Opd.", "\u21BB", "Lavet af", "Status", "Areal", "MT", "Ej", "LER2", "-LER2",
                       "Beskr.", "Sags#", "Info", "Import", "Kort", "DL", "Ark.", "CAD"]
        else:
            columns = ['LER#', "Udført", "Opdateret", "\u21BB", "Lavet af", "Status", "Areal", "Multi", "Ejere", "LER2", "-LER2",
                       "Beskrivelse", "Sags#", "Info", "Importér", "Kortviser", "Download", "Arkivering", "CAD"]
        self.resulttable.setColumnCount(len(columns))
        self.resulttable.setHorizontalHeaderLabels(columns)  # "ZIP", "GML", "DGN",
        self.resulttable.setSortingEnabled(True)

        self.resulttable.setSelectionBehavior(QtWidgets.QAbstractItemView.SelectionBehavior.SelectRows)
        self.resulttable.setEditTriggers(QtWidgets.QAbstractItemView.EditTrigger.NoEditTriggers)# make it readonly

        # self.readconfig()
        # self.updateSessions()
        self.checkToken()

        self.filterEdit.textChanged.connect(self.filterresulttable)

        startupcheck = settings.value("lerplusdock/startupcheck")
        if startupcheck == True:
            self.updateSessions(True)

        showhints = settings.value("lerplusdock/showhints",False,type=bool)
        if showhints == True:
            QTimer.singleShot(3000, self.showHint)

    def showHint(self):
        self.hints = LERplusHintsDialog()
        self.hints.setIface(self.iface)
        self.hints.show()


    def addScratchLayer(self):

        layer_name = "LER+ scratch layer"

        # Create the scratch layer
        polygon_layer = QgsVectorLayer("Polygon?crs=EPSG:25832", layer_name, "memory")

        # Add some example attributes (optional)
        #provider = polygon_layer.dataProvider()
        #provider.addAttributes([
        #        QgsField("id", QVariant.Int),
        #    QgsField("name", QVariant.String)
        #])
        #polygon_layer.updateFields()

        # Add the layer to the project
        QgsProject.instance().addMapLayer(polygon_layer)
        self.iface.setActiveLayer(polygon_layer)
        polygon_layer.startEditing()
        QMessageBox.about(self, "Næste skridt", "Nu skal du bare oprette en søgepolygon i det valgte lag.")

    def newSession(self):

        settings = QgsSettings()

        layer = self.iface.activeLayer()

        if layer is None:
            #QMessageBox.about(self, "Fejl", "Ikke noget aktivt layer")
            reply = QMessageBox.question(self, "Fejl",
                                         "Ikke noget aktivt layer. Skal jeg oprette et midlertidigt scratch lag?",
                                         QMessageBox.StandardButton.Yes | QMessageBox.StandardButton.No, QMessageBox.StandardButton.No)
            if reply == QMessageBox.StandardButton.No:
                return
            self.addScratchLayer()
            return

        if not hasattr(layer, 'selectedFeatures'):
            #QMessageBox.about(self, "Fejl", "Layer har ikke valgte features")

            reply = QMessageBox.question(self, "Fejl",
                                         "Layer har ikke valgte featuresr. Skal jeg oprette et midlertidigt scratch lag?",
                                         QMessageBox.StandardButton.Yes | QMessageBox.StandardButton.No, QMessageBox.StandardButton.No)
            if reply == QMessageBox.StandardButton.No:
                return
            self.addScratchLayer()
            return

            return

        dotransform = False
        transformer = False
        if layer.crs().authid() != 'EPSG:25832':
            transformcrs = settings.value("lerplusdock/transformcrs")
            # QMessageBox.about(self, "Fejl",
            #                              transformcrs)
            if transformcrs == "1":
                source_crs = layer.crs()
                target_crs = QgsCoordinateReferenceSystem(25832)
                transformer = QgsCoordinateTransform(source_crs, target_crs, QgsProject.instance())
                # transformed_geom = geom.transform(transform)
                dotransform = True
                # QMessageBox.about(self, "Fejl",
                #                "Tranformerer")
            else:
                QMessageBox.about(self, "Fejl",
                                  "Koordinatsystemet skal være EPSG:25832\nDet valgte lag er i " + layer.crs().authid())
                return

        geomlist = []
        wktlist = []
        hasmulti = False
        selected = layer.selectedFeatures()
        # QMessageBox.about(self, "antal", str(len(selected)))

        for feature in selected:
            geom = feature.geometry()

            if dotransform is True:
                geom.transform(transformer)
            wkt = geom.asWkt(2)
            # QMessageBox.about(self, "antal", wkt)
            # if dotransform is True:
            #    QMessageBox.about(self, "showtransformed", wkt)
            # QMessageBox.information(self, 'Sending to API', wkt)
            if wkt.startswith("Polygon") is False:
                QMessageBox.about(self, "Fejl", "Alle valgte geometrier skal være POLYGON. Vi fandt en: " + wkt[0:20])
                return
            if geom.area() < 1:
                areal = str(geom.area())
                QMessageBox.about(self, "Fejl",
                                  "En af de valgte geometrier har et areal på mindre end 1 m2\nAreal: " + areal)
                return

            validator = QgsGeometryValidator(geom)  # , layer.crs()
            issues = validator.validateGeometry(geom)

            if issues:
                for issue in issues:
                    print(f"  - {issue.what()}")
                QMessageBox.about(
                    self,
                    "Fejl",
                    "Vi fandt geometrifejl i en af de valgte polygoner. Se evt. konsollen."
                )
                return
            #QMessageBox.about(self, "antal", wkt)

            wktlist.append(str(wkt))
            # QMessageBox.about(self, "antal", str(len(wktlist)))
            geomlist.append(geom)
            if geom.area() > 250000:
                hasmulti = True

        if len(geomlist) > 1:
            if hasmulti is True:
                QMessageBox.about(self, "Fejl", "Det er ikke muligt spørge på flere polygoner samtidig,\nhvis en eller flere er større end 25ha.")
                return

        if len(geomlist) == 0:
            QMessageBox.about(self, "Fejl", "Ingen geometrier valgt")
            return

        if hasmulti is True:
            reply = QMessageBox.question(self, "Advarsel",
                                         "Du har mindst 1 valgt område som er større end 25ha.\nVil du fortsætte?",
                                         QMessageBox.StandardButton.Yes | QMessageBox.StandardButton.No, QMessageBox.StandardButton.No)
            if reply == QMessageBox.StandardButton.No:
                return

        self.newsession = LERplusNewSession()
        self.newsession.setIface(self.iface)

        # QMessageBox.information(self, 'Sending to API', str(len(geomlist)))
        self.newsession.setGeometryList(geomlist, wktlist)
        # self.newsession.setWKTList(wktlist)
        self.newsession.setIsDemo(self.isdemo)
        self.newsession.setupValues()
        self.newsession.exec()

        return

    def filterresulttable(self):
        filter_text = self.filterEdit.text().lower()
        columns_to_filter = [0, 1, 2, 4, 7]  # Indices of the columns to filter

        for row in range(self.resulttable.rowCount()):
            row_data = [self.resulttable.item(row, col).text().lower() if col in columns_to_filter else "" for col in
                        range(self.resulttable.columnCount())]
            if any(filter_text in cell_data for cell_data in row_data):
                self.resulttable.setRowHidden(row, False)
            else:
                self.resulttable.setRowHidden(row, True)

    def closeEvent(self, event):
        self.closingPlugin.emit()
        self.timer.timeout.disconnect(self.updateSessions)
        event.accept()

    def setIface(self, iface):
        self.iface = iface

    def showSettings(self):
        settings = QgsSettings()
        oldapikey = settings.value("lerplusdock/apitoken")

        self.iface.showOptionsDialog(currentPage="LER+")
        newapikey = settings.value("lerplusdock/apitoken")

        if oldapikey != newapikey:
            # QMessageBox.information(self, 'checking', "yup")

            self.checkToken()
            self.resulttable.clearContents()
            self.resulttable.setRowCount(0)
            startupcheck = settings.value("lerplusdock/startupcheck")
            if startupcheck == "1":
                self.updateSessions(True)

        compactlist = settings.value("lerplusdock/compactlist")

        if compactlist == "1":
            columns = ['LER#', "Udf.", "Opd.", "\u21BB", "Lavet af", "Status", "Areal", "MlT", "Ej", "LER2", "-LER2",
                       "Beskr.", "Sags#", "Info", "Import", "Kort", "DL", "Ark.", "CAD"]
        else:
            columns = ['LER#', "Udført", "Opdateret", "\u21BB", "Lavet af", "Status", "Areal", "Multi", "Ejere", "LER2", "-LER2",
                       "Beskrivelse", "Sags#", "Info", "Importér", "Kortviser", "Download", "Arkivering", "CAD"]
        # self.resulttable.setColumnCount(len(columns))
        self.resulttable.setHorizontalHeaderLabels(columns)  # "ZIP", "GML", "DGN",

        # self.settings = LERplusSettings()
        # self.settings.setIface(self.iface)
        # self.settings.exec()

    def checkToken(self, showtestinfo=True):
        settings = QgsSettings()
        token = settings.value("lerplusdock/apitoken")
        # QMessageBox.information(self, 'Token', token)
        # QgsMessageLog.logMessage(token)
        if (token != "") and (token is not None):
            # QgsMessageLog.logMessage(token)
            # r = requests.get(f'https://backend.lerplus.dk/api/checktoken?apitoken={token}')
            #    if token is
            reply = make_api_call(self, 'checktoken', '', 5)
            # r = requests.get(API_URLBASE + '/checktoken?apitoken=' + token)

            """if not is_valid_json(r.text):
                QMessageBox.information(self, 'Invalid API-response', r.text)
                return
            """
            # QMessageBox.information(self, 'API-response', r.text)
            # if r.status_code == 200:
            if reply is not False:
                self.isdemo = 0
                if reply['data']['testuser'] == 1:
                    QMessageBox.about(self, "Information",
                                      "Dette token er til test af lerPLUS, derfor gør følgende begræsninger sig gældende:\n"
                                      "- Der kan kun foretaget 5 gaveforespørgler\n"
                                      "- Graveforespørgsler kan maksimalt være på 125 m²")
                    self.isdemo = 1
                # self.apiStatusBox.setProperty("styleSheet", "background-color: rgb(0, 170, 0);")
                # self.apiStatusLabel.setProperty("text", "API forbundet")
                self.clientName.show()
                # if settings.value("lerplus/debugmode") == 1:
                #    QMessageBox.information(self, 'API-response', r.text)

                # reply = json.loads(r.text)
                # QgsMessageLog.logMessage(reply['data']['client name'])

                self.clientName.setProperty("text", reply['data']['user name'] + ", " + reply['data']['client name'])
                if reply['data']['ler2ok'] == 1:
                    self.LER2Status.setProperty("text", "LER-status: OK")
                    self.LER2Status.setStyleSheet("color:green")
                else:
                    self.LER2Status.setProperty("text", "LER-status: Fejl: " + reply['data']['ler2error'])
                    self.LER2Status.setStyleSheet("color:red")

                if reply['data']['islive'] == 1:
                    self.clientIsLive.setProperty("text", "LER-miljø: LIVE")
                else:
                    self.clientIsLive.setProperty("text", "LER-miljø: EXTEST")

            else:
                # QgsMessageLog.logMessage(str(r.status_code))
                # self.apiStatusBox.setProperty("styleSheet", "background-color: rgb(170, 0, 0);")
                #  self.apiStatusLabel.setProperty("text", "API ikke forbundet")
                # if settings.value("lerplus/debugmode") == 1:
                #    QMessageBox.information(self, 'API-response', r.text)
                self.LER2Status.setProperty("text", "LER2-status: N/A")
                self.LER2Status.setStyleSheet("color:red")
                self.clientIsLive.setProperty("text", "Miljø: N/A")
                self.clientName.setProperty("text", "N/A")
                # self.clientName.hide()

    def handleNotAuthorized(self):
        title = self.tr(u'Afvist af lerPLUS-backend')
        message = self.tr(u'Manglende eller ukorrekt token til LER+.')
        button_text = self.tr(u'Åbn indstillinger')
        widget = self.iface.messageBar().createMessage(title, message)
        button = QPushButton(widget)
        button.setText(button_text)
        button.pressed.connect(lambda: self.iface.showOptionsDialog(currentPage='LER+'))
        widget.layout().addWidget(button)
        self.iface.messageBar().pushWidget(widget, level=Qgis.Warning, duration=15)

    def getProgressBox(self, title, message):
        progress_dialog = QProgressDialog(message, None, 0, 0, self)
        progress_dialog.setWindowTitle(title)
        progress_dialog.setModal(True)
        progress_dialog.setCancelButton(None)
        progress_dialog.show()

        # Simulate a processing task
        QApplication.processEvents()
        return progress_dialog

    def updateSessions(self, force=False):
        # QMessageBox.information(self, 'HI')
        settings = QgsSettings()

        # self.settings.value('token'),

        if self.autopollCheckbox.isChecked() is False:
            if force is False:
                return

        apitoken = settings.value("lerplusdock/apitoken")
        if apitoken is None:
            return

        if force is True:
            self.updatenowButton.setText("Opdaterer...")

        pbox = self.getProgressBox("LER+", "Henter data...")

        showallsessions = settings.value("lerplusdock/showallsessions")
        data = {
            'showallsessions': showallsessions
        }

        response = make_api_call(self, 'getsessions', data, 80)
        if response is False:
            self.updatelabel.setText("Sidst opdateret: fejl ved api-kald")
            self.updatenowButton.setText("Tjek nu")
            pbox.close()
            return

        if response['status'] != 'ok':
            if response['status'] == 'empty':
                self.resulttable.setItem(0, 0, QTableWidgetItem('Sidst opdateret: ingen tilgængelige besvarelser'))
                # self.updatelabel.setText("Sidst opdateret: ingen tilgængelige besvarelser")
            else:
                # self.resulttable.setItem(0, 0, QTableWidgetItem('Sidst opdateret: fejl ved api-kald, status!=ok/empty'))
                self.updatelabel.setText("Sidst opdateret: fejl ved api-kald, status!=ok/empty")
            pbox.close()
            return

        # self.updatelabel.setText("Sidst opdateret: " + datetime.now().strftime("%Y-%m-%d %H:%M:%S"))
        self.updatenowButton.setText("Tjek nu")
        if len(response['data']['sessions']) == 0:
            # self.resulttable.setItem(0, 0, QTableWidgetItem('Sidst opdateret: ingen tilgængelige besvarelser'))
            self.updatelabel.setText("Sidst opdateret: ingen tilgængelige besvarelser")
            self.resulttable.clearContents()
            self.resulttable.setRowCount(0)
            pbox.close()
            return

        row = 0
        self.resulttable.clearContents()
        self.resulttable.setRowCount(0)

        pbox.setRange(0, len(response['data']['sessions']) + 1)

        count = 0

        buttons = {}
        for session in response['data']['sessions']:
            count += 1
            pbox.setValue(count)
            QApplication.processEvents()
            self.resulttable.insertRow(row)
            # print(session["ismulti"])
            ismulti = (session["ismulti"] == "1")
            bname = 'button' + str(session['id'])

            rowcount = 0
            # self.resulttable.setItem(row, rowcount, QTableWidgetItem(session['lerrespons']['Id']))

            item = QTableWidgetItem(str(session['lerid']))
            item.setToolTip(str(session['ssid']))

            self.resulttable.setItem(row, rowcount, item)

            rowcount += 1

            item = DateTableWidgetItem(session['dato'], session['datounix'])
            item.setToolTip(session['datofull'])
            self.resulttable.setItem(row, rowcount, item)

            rowcount += 1
            item = DateTableWidgetItem(session['updated'], session['updatedunix'])
            item.setToolTip(session['updatedfull'])
            self.resulttable.setItem(row, rowcount, item)

            rowcount += 1
            buttons[bname] = QPushButton("\u21BB")
            buttons[bname].setToolTip('Sæt til opdatering')
            update_font = QFont()
            update_font.setPointSize(14)
            update_font.setBold(True)
            buttons[bname].setFont(update_font)
            # buttons[bname].setFont(QFont('Wingdings', 16))
            buttons[bname].clicked.connect(partial(self.doOrderUpdate, session['ssid'], session['lerid']))
            self.resulttable.setCellWidget(row, rowcount, buttons[bname])

            rowcount += 1
            self.resulttable.setItem(row, rowcount, QTableWidgetItem(session['lavetaf']))

            rowcount += 1
            self.resulttable.setItem(row, rowcount, QTableWidgetItem(session['statustext']))

            rowcount += 1
            item = AreaTableWidgetItem(session['area'])
            item.setTextAlignment(Qt_AlignRight | Qt_AlignVCenter)
            value = session['area']
            sorting_value = session['arearaw']
            """if value != "N/A":
                #self.updatelabel.setText("HEY")
                sorting_value = session['area']int(value.replace('.', '').replace(' m²', ''))
            else:
                sorting_value = 0
            """
            item.setData(Qt_UserRole, sorting_value)
            self.resulttable.setItem(row, rowcount, item)

            rowcount += 1
            # print('multitext' + str(session['multitext']))
            multitext = QTableWidgetItem(str(session['multitext']))
            multitext.setTextAlignment(Qt_AlignCenter | Qt_AlignVCenter)
            self.resulttable.setItem(row, rowcount, multitext)  # session['multi']

            ejercount = QTableWidgetItem(str(session['ejercount']))
            ejercount.setToolTip(str(session['ejernavnestring']))
            rowcount += 1
            self.resulttable.setItem(row, rowcount, ejercount)

            ejerstatus = QTableWidgetItem(str(session['ejerleveret']) + "/" + str(session['ejerforventet']))
            ejerstatus.setToolTip(str(session['ejernavneleveretstring']))
            if session['ejerleveret'] == session['ejerforventet']:
                ejerstatus.setBackground(QColor(66, 245, 126))
            else:
                ejerstatus.setBackground(QColor(245, 66, 66))
            # resultitem.setToolTip(str(session['ejernavnestring']))

            rowcount += 1
            self.resulttable.setItem(row, rowcount, ejerstatus)

            rowcount += 1
            ejerudenomcount = QTableWidgetItem(str(session['ejerudenom']))

            if session['ejerudenom'] > 0:
                ejerudenomcount.setBackground(QColor(255, 234, 0))
            else:
                ejerudenomcount.setBackground(QColor(66, 245, 126))


            ejerudenomcount.setToolTip(str(session['ejernavneudenomstring']))
            self.resulttable.setItem(row, rowcount, ejerudenomcount)

            rowcount += 1
            self.resulttable.setItem(row, rowcount, QTableWidgetItem(session['description']))

            rowcount += 1
            self.resulttable.setItem(row, rowcount, QTableWidgetItem(session['sagsnummer']))

            # Info button

            buttons[bname] = QPushButton("INFO")
            buttons[bname].clicked.connect(
                partial(self.showInfo, session['id'], ismulti))  # session['lerrespons']['Id']
            rowcount += 1
            if ismulti is False:
                buttons[bname].setEnabled(False)
            self.resulttable.setCellWidget(row, rowcount, buttons[bname])

            # Importbutton
            bname = 'button' + str(session['id'])
            # QMessageBox.information(self, 'SUCCESS! API-response', bname)
            buttons[bname] = QPushButton("Importér")

            groupname = session['description'] + " (LER:" + str(session['lerid']) + ")"

            buttons[bname].clicked.connect(partial(self.showResultJSON, session['id'], groupname))  # session['lerrespons']['Id']
            rowcount += 1
            if session['allowimport'] != 1:
                buttons[bname].setEnabled(False)
            #if ismulti is False:
            #    buttons[bname].setEnabled(False)
            self.resulttable.setCellWidget(row, rowcount, buttons[bname])

            # kortviser button

            bname = 'kortbutton' + str(session['lerid'])  # session['lerrespons']['Id']
            buttons[bname] = QPushButton("Vis i LER kortviser")
            buttons[bname].clicked.connect(
                partial(self.showKortviser, session['lerid'], session['guid'])
            )  # session['lerrespons']['Id']
            rowcount += 1
            if ismulti is True:
                buttons[bname].setEnabled(False)
            if session['allowimport'] != 1:
                buttons[bname].setEnabled(False)

            self.resulttable.setCellWidget(row, rowcount, buttons[bname])

            combo_box = QComboBox()
            combo_box.addItem("Vælg format")  # Placeholder option

            if ismulti is False:
                combo_box.addItem("zip")
                combo_box.addItem("gml")
            # else:
            # combo_box.setEnabled(False)

            if session['allowimport'] != 1:
                combo_box.setEnabled(False)
            combo_box.addItem("gpkg")
            combo_box.addItem("kml")
            # combo_box.addItem("dgn")
            # combo_box.currentIndexChanged.connect(lambda index, row=row: self.on_option_selected(session['ssid'], row))
            combo_box.currentIndexChanged.connect(partial(self.downloadSession, session['ssid'], combo_box))

            # combo_box.currentIndexChanged.connect(
            #                lambda index, combo_box=combo_box, row=row: self.on_option_selected(combo_box, row))
            rowcount += 1
            self.resulttable.setCellWidget(row, rowcount, combo_box)

            # arkivering button
            bname = 'archive' + str(session['lerid'])
            # QMessageBox.information(self, 'SUCCESS! API-response', bname)
            buttons[bname] = QPushButton("Arkivér")
            # button =
            # buttons[bname].clicked.connect(lambda: self.showResult(session['lerrespons']['Id']))
            buttons[bname].clicked.connect(partial(self.doArchive, session['ssid'], session['lerid']))
            rowcount += 1

            if session['allowimport'] != 1:
                buttons[bname].setEnabled(False)

            self.resulttable.setCellWidget(row, rowcount, buttons[bname])

            rowcount += 1
            buttons[bname] = QPushButton("Transformér til CAD")
            buttons[bname].clicked.connect(partial(self.doCAD, session['ssid'], session['lerid']))
            self.resulttable.setCellWidget(row, rowcount, buttons[bname])



            row = row + 1
        self.resulttable.resizeColumnsToContents()
        pbox.close()
        self.updatelabel.setText("Sidst opdateret: " + datetime.now().strftime("%Y-%m-%d %H:%M:%S"))
        # self.resulttable.horizontalHeader().setStretchLastSection(True)
        return

    def downloadSession(self, ssid, combobox):
        type = combobox.currentText()
        if type not in ['zip', 'gml', 'gpkg', 'kml']:
            return
        token = get_download_token(self, ssid)
        if token is False:
            return

        url = 'https://backend2.lerplus.dk/download/' + type + '/' + token
        qturl = QUrl(url)  # Replace with your desired URL
        QDesktopServices.openUrl(qturl)

    def doArchive(self, ssid, lerid):
        reply = QMessageBox.question(self, 'Arkivering',
                                     'Er du sikker på du vil arkivere forespørgslen?',
                                     QMessageBox.StandardButton.Yes | QMessageBox.StandardButton.No, QMessageBox.StandardButton.No)
        if reply == QMessageBox.StandardButton.No:
            return
        data = {
            'ssid': ssid
        }
        apiresponse = make_api_call(self, "archivesession", data)
        niceresponse = json.dumps(apiresponse, sort_keys=True, indent=4)
        if (apiresponse["status"] == 'ok'):
            self.updateSessions(True)
        else:
            QMessageBox.information(self, 'API-response', apiresponse["errortext"])

    def doOrderUpdate(self, ssid, lerid):
        data = {
            'ssid': ssid
        }
        apiresponse = make_api_call(self, "orderupdate", data)
        niceresponse = json.dumps(apiresponse, sort_keys=True, indent=4)
        if (apiresponse["status"] == 'ok'):
            self.updateSessions(True)

    def doCAD(self, ssid, lerid):
        data = {
            'ssid': ssid
        }
        apiresponse = make_api_call(self, "requestcad", data)
        niceresponse = json.dumps(apiresponse, sort_keys=True, indent=4)
        if (apiresponse["status"] == 'ok'):
            QMessageBox.information(self, "Transformér til CAD",
                                    "Tak! \nVi har modtaget din bestilling af konvertering af din LER-søgning til CAD. \nDu modtager CAD-fil på mail jf. den opsætning og tidsfrist, vi har aftalt.")

    def showKortviser(self, lerid, guid):
        url = 'https://kortviser.ler.dk/?diggingRequestNr=' + str(lerid) + '&ledningspakkeGuid=' + guid
        qturl = QUrl(url)  # Replace with your desired URL
        QDesktopServices.openUrl(qturl)

    def showInfo(self, ssid, ismulti):
        if ismulti is True:
            self.multisessioninfo = LERplusMultiSessionInfo()
            self.multisessioninfo.setIface(self.iface)
            self.multisessioninfo.setMSID(ssid)

            self.multisessioninfo.exec()
        else:
            self.sessioninfo = LERplusSessionInfo()
            self.sessioninfo.setIface(self.iface)
            self.sessioninfo.setSSID(ssid)

            self.sessioninfo.exec()

    def doInject(self):
        # QMessageBox.information(self, 'showresult', lerid)

        self.injectdialog = LERplusInjectDialog(self)
        self.injectdialog.setIface(self.iface)
        self.injectdialog.exec()
        if not self.injectdialog.isConfirmed():
            return
        #pbox = self.getProgressBox('LER+', "Indlæser ledningsdata")
        lerid=self.injectdialog.getLerID()
        description=self.injectdialog.getDescription()
        casenumber=self.injectdialog.getCasenumber()
        multimethod=self.injectdialog.getMultiMethod()
        #huskd casenumber!
        data = {
            'lerid': lerid,
            'description': description,
            'casenumber': casenumber,
            'multimethod': multimethod,
            'source': 'qgis'
        }
        response = make_api_call(self, 'injectsession', data, 120)
        if (response == False or response["status"] != 'ok'):
            #QMessageBox.information(self, '', response['error'])
            pbox.close()
            return

        QMessageBox.information(self, 'Success', "Indsættelse af Ler-ID lykkedes!")
        self.updateSessions(False)


    def showResult(self, ssid):
        # QMessageBox.information(self, 'showresult', lerid)


        self.importdialog = LERplusImportDialog(self)
        self.importdialog.setIface(self.iface)
        self.importdialog.exec()
        if not self.importdialog.isConfirmed():
            return



        """
        reply = QMessageBox.question(self, 'Afsendelse',
                                     'Er du sikker på du vil importere ledningsdata fra ssid=' + str(ssid) + '?',
                                     QMessageBox.StandardButton.Yes | QMessageBox.StandardButton.No, QMessageBox.StandardButton.No)
        if not reply:
            return
        """

        settings = QgsSettings()

        pbox = self.getProgressBox('LER+', "Indlæser ledningsdata")
        data = {
            'ssid': ssid
        }
        response = make_api_call(self, 'getpgresults', data, 120)
        if (response == False or response["status"] != 'ok'):
            pbox.close()
            return

        # r = requests.get(API_URLBASE + '/getpgresults?apitoken=' + token + '&lernr=' + lerid)
        # QMessageBox.information(self, 'ERROR! API-response', str(r.status_code))

        """if not is_valid_json(r.text):
            QMessageBox.information(self, 'Invalid API-response', r.text)
            return
    
        if r.status_code != 200:
            QMessageBox.information(self, 'ERROR! API-response', str(r.status_codestr))
    
        if inDebugMode() is True:
            QMessageBox.information(self, 'SUCCESS! API-response', r.text)
    
        response = json.loads(r.text)
        """

        lerid = str(response['data']['session']['lerid'])

        # QMessageBox.information(self, '', json.dumps(response['data']['session']))
        groupname = response['data']['groupname']  # + ' (LERID ' + lerid + ')'
        schema = response['data']['pginfo']['schema']

        connection_info = {
            'connectionName': groupname + ' connection',
            'host': response['data']['pginfo']['exhost'],  # Replace with your PostGIS host
            'port': response['data']['pginfo']['port'],
            'database': response['data']['pginfo']['dbname'],  # Replace with your database name
            'username': response['data']['pginfo']['username'],  # Replace with your PostGIS username
            'password': response['data']['pginfo']['password'],  # Replace with your PostGIS password
            'schema': schema,  # Replace with your schema name if not 'public'
            'table': 'your_table_name',  # Replace with your table name
            'geom_column': 'geometri'  # Replace with your geometry column name
        }

        # layer_group = QgsLayerTreeGroup(groupname)
        root = QgsProject.instance().layerTreeRoot()

        # eksisterer det allerede?
        layer_group = root.findGroup(groupname)

        """   if not layer_group:
            # ellers opret gruppen
            # layer_group = root.addGroup(groupname)
            layer_group = root.insertGroup(0, groupname)
        else:
            # Slet alle lag, så der opdateres i stedet
            for child in layer_group.children():
                if isinstance(child, QgsLayerTreeLayer):
                    QgsProject.instance().removeMapLayer(child.layerId())
        """
        # bufferzoner = layer_group.addGroup("Bufferzoner")

        uri = QgsDataSourceUri()
        uri.setConnection(
            connection_info['host'],
            str(connection_info['port']),
            connection_info['database'],
            connection_info['username'],
            connection_info['password']
        )
        uri.setParam('connect_timeout', '1')
        # uri_str=uri.uri()
        # QgsProject.instance().writeEntry("PostgreSQL/connections", groupname+' PG connection', uri_str)

        # styles_directory = os.path.join(os.path.dirname(__file__), 'styles')

        # Construct the absolute path to the file
        # sld_file_path = os.path.join(styles_directory, 'styles.sld')

        # = "styles/"
        # vandtest =  os.path.join(styles_directory, 'vandtest_qml.qml')
        # redtest = os.path.join(styles_directory, 'redtest.qml')
        # elledning = os.path.join(styles_directory, 'Elledning.qml')
        # redtest = "styles/redtest.qml"
        QMessageBox.information(self, "test","here")
        pbox.setRange(0, len(response['data']['tables']) + 1)
        graveforesp_layer = ''
        count = 0
        for table in response['data']['tables']:
            count += 1
            pbox.setValue(count)
            QApplication.processEvents()

            if table['tablename'] == 'informationsressource':
                continue
            if table['tablename'] == 'kontaktprofil':
                continue
            if table['tablename'] == 'utilityowner':
                continue
            if table['tablename'] == 'utilitypackageinfo':
                continue

            uri.setDataSource(
                connection_info['schema'],
                table['tablename'],
                connection_info['geom_column'],
                ""
            )
            uri.setSrid('25832')

            # QMessageBox.information(self, 'Layer failed to load!', uri.uri())
            # Create a new PostGIS layer
            postgis_layer = QgsVectorLayer(uri.uri(), table['tablename'].capitalize(), 'postgres')
            postgis_layer.setReadOnly(True)

            # ler:" +

            if not postgis_layer.isValid():
                error_message = f"Layer '{table['tablename']}' failed to load!"
                QgsMessageLog.logMessage(error_message, 'PostGIS Layer Loader', Qgis.Critical)

                # Capture additional information about the error
                # error_message += f"\nURI: {uri.uri()}"
                # QgsMessageLog.logMessage(f"URI: {uri.uri()}", 'PostGIS Layer Loader', Qgis.Critical)

                # QMessageBox.information(self, 'Layer failed to load!', error_message)
                # QMessageBox.information(self, 'Layer failed to load!', 'dont know why' + table['tablename'])
                tis = 0
            else:
                # QMessageBox.information(self, 'Layer field names', ''.join(map(str, postgis_layer.fields().names())))

                if table['tablename'] == "graveforesp":
                    graveforesp_layer = postgis_layer
                    continue

                new_layer = QgsProject.instance().addMapLayer(postgis_layer, False)

                # with open(sld_file_path) as f:
                #                    lines = f.readlines()

                # new_layer.loadSldStyle(sld_file_path)

                if table['layerstyle'] != "":
                    temp = tempfile.NamedTemporaryFile('w')
                    tmpname = temp.name
                    temp.close()
                    tmpfile = open(tmpname, "w")
                    # kan skrive string fordi den ikke blev åbnet som binær (default open er 'w+b')
                    tmpfile.write(table['layerstyle'])
                    tmpfile.close()
                    # print(tmpname)
                    new_layer.loadNamedStyle(tmpname)

                    # clean up
                    os.remove(tmpname)
                    # QMessageBox.information(self, 'loadNamesStyle', type(table['layerstyle']))
                    # print(table['layerstyle'])
                """
                if table['tablename'] == "elledning":
                    buffer_distance = 10  # Use the appropriate distance units for your data
    
                    # Create a buffer around the PostGIS layer
                    buffer_layer = QgsProcessingFeatureSourceDefinition(new_layer.id())
                    params = {
                        'INPUT': buffer_layer,
                        'DISTANCE': buffer_distance,
                        'SEGMENTS': 5,  # Number of segments to approximate curves in the buffer
                        'OUTPUT': 'memory:'
                        # You can also specify a file path if you want to save the buffer as a new layer
                    }
    
                    # Run the buffer algorithm
                    # processing.core.Processing.initialize()
                    result = processing.run("native:buffer", params)
    
                    # Access the resulting buffer layer
                    # buffered_layer = QgsProcessingFeatureSourceDefinition("memory:").source()
                    buffered_layer = result['OUTPUT']
                  #  print(type(buffered_layer))
                   # if buffered_layer:
                        # Add the buffered layer to the QGIS project
                        # QgsProject.instance().addMapLayer(buffered_layer)
                        #bufferzoner.addLayer(buffered_layer)
                  #  else:
                      #  print("Buffered layer not found in memory.")
                """

                layer_group.addLayer(new_layer)
                # new_layer.loadNamedStyle(elledning)
                # style_manager.loadStyle(new_layer, sld_file_path)
                # style_manager = QgsMapLayerStyleManager(new_layer)
                # style_manager.loadFromString(lines)

                # Refresh the layer to see the changes
                # new_layer.triggerRepaint()
                self.iface.mapCanvas().refresh()
        pbox.close()

        if graveforesp_layer != '':
            # MessageBox.information(self, 'getting to graveforesp!', 'dont know why')
            new_layer = QgsProject.instance().addMapLayer(graveforesp_layer, False)
            layer_group.addLayer(new_layer)
            QgsProject.instance().layerTreeRoot().findLayer(graveforesp_layer.id()).setItemVisibilityChecked(False)

        return

    def showResultJSON(self, ssid, groupname):

        self.importdialog = LERplusImportDialog(self)
        self.importdialog.setIface(self.iface, groupname)

        self.importdialog.exec()
        if not self.importdialog.isConfirmed():
            return

        crs = self.importdialog.getCRS()
        groupname = self.importdialog.getGroupname()

        settings = QgsSettings()

        pbox = self.getProgressBox('LER+', "Indlæser ledningsdata")
        data = {
            'ssid': ssid,
            'grouping': settings.value("lerplusdock/importgroup"),
            'sendstyling': settings.value("lerplusdock/importsendstyling"),
        }
        response = make_api_call(self, 'getjsonresults', data, 120)
        if (response == False or response["status"] != 'ok'):
            pbox.close()
            return


        #lerid = str(response['data']['session']['lerid'])

        root = QgsProject.instance().layerTreeRoot()

        # eksisterer det allerede?
        layer_group = root.findGroup(groupname)

        if not layer_group:
            # ellers opret gruppen
            # layer_group = root.addGroup(groupname)
            layer_group = root.insertGroup(0, groupname)
        else:
            # Slet alle lag og eventuelle undergrupper, så der opdateres i stedet
            def clear_group(group):
                # Kopiér listen så vi kan ændre træet mens vi itererer
                for child in list(group.children()):
                    if isinstance(child, QgsLayerTreeLayer):
                        # Fjern laget fra projektet (fjerner også noden i træet)
                        QgsProject.instance().removeMapLayer(child.layerId())
                        try:
                            group.removeChildNode(child)
                        except Exception:
                            pass
                    else:
                        # Antag undergruppe
                        try:
                            clear_group(child)
                        finally:
                            try:
                                group.removeChildNode(child)
                            except Exception:
                                pass
            clear_group(layer_group)

        baseuri = response['data']['baseurl']
        #QMessageBox.information(self, "test", "here")
        # Prepare subgroup handling
        subgroup_cache = {}
        def get_or_create_subgroup(name):
            if not name:
                return layer_group
            if name in subgroup_cache:
                return subgroup_cache[name]
            grp = layer_group.findGroup(name)
            if not grp or grp.parent() != layer_group:
                grp = layer_group.addGroup(name)
            subgroup_cache[name] = grp
            return grp


        pbox.setRange(0, len(response['data']['tables']) + 1)
        graveforesp_layer = ''
        graveforesp_target_group = layer_group
        count = 0
        #QMessageBox.information(self, "test", str(len(response['data']['tables'])))
        for table in response['data']['tables']:
            count += 1
            pbox.setValue(count)
            QApplication.processEvents()

            if table['tablename'] == 'informationsressource':
                continue
            if table['tablename'] == 'kontaktprofil':
                continue
            if table['tablename'] == 'utilityowner':
                continue
            if table['tablename'] == 'utilitypackageinfo':
                continue


            uri = baseuri + str(table['tablename']) + "/" + str(crs) + "?sessiontoken=" + response['data']['sessiontoken']


            # Create a new PostGIS layer
            json_layer = QgsVectorLayer(uri, table['showtablename'].capitalize(), 'ogr')
            #authid = f"EPSG:{int(crs)}"
            #json_layer.setCrs(QgsCoordinateReferenceSystem(crs)) deprecated
            epsg = int(crs)  # your int
            crs_obj = QgsCoordinateReferenceSystem.fromEpsgId(epsg)

            if crs_obj.isValid():
                json_layer.setCrs(crs_obj)
            else:
                # log / fallback
                pass

            # ler:" +

            if not json_layer.isValid():
                error_message = f"Layer '{table['tablename']}' failed to load!"
                QgsMessageLog.logMessage(error_message, 'JSON Layer Loader', Qgis.Critical)
            else:
                # QMessageBox.information(self, 'Layer field names', ''.join(map(str, postgis_layer.fields().names())))

                subgroup_name = table.get('subgroup') if isinstance(table, dict) else None
                target_group = get_or_create_subgroup(subgroup_name) if subgroup_name else layer_group

                if table['tablename'] == "graveforesp":
                    graveforesp_layer = json_layer
                    graveforesp_target_group = target_group
                    continue

                new_layer = QgsProject.instance().addMapLayer(json_layer, False)
                if table['layerstyle'] != "":
                    temp = tempfile.NamedTemporaryFile('w')
                    tmpname = temp.name
                    temp.close()
                    tmpfile = open(tmpname, "w")
                    # kan skrive string fordi den ikke blev åbnet som binær (default open er 'w+b')
                    tmpfile.write(table['layerstyle'])
                    tmpfile.close()
                    # print(tmpname)
                    new_layer.loadNamedStyle(tmpname)

                    # clean up
                    os.remove(tmpname)
                    # QMessageBox.information(self, 'loadNamesStyle', type(table['layerstyle']))
                    # print(table['layerstyle'])


                target_group.addLayer(new_layer)

                self.iface.mapCanvas().refresh()
        pbox.close()

        if graveforesp_layer != '':
            # MessageBox.information(self, 'getting to graveforesp!', 'dont know why')
            new_layer = QgsProject.instance().addMapLayer(graveforesp_layer, False)
            graveforesp_target_group.addLayer(new_layer)
            QgsProject.instance().layerTreeRoot().findLayer(graveforesp_layer.id()).setItemVisibilityChecked(False)

        return


"""
    def readconfig(self):
        self.settings = Settings() # new config
        # Old way was storing settings in global scope. Leave advanced options there for now
        s = QSettings()
        k = __package__

        # prefix muncodes
        #muncodes = re.findall(r'\d+', settings.value('kommunefilter'))
        #areafilter = ','.join(['muncode0'+str(k) for k in muncodes])

        self.config = {
            'apitoken' : self.settings.value('apitoken'),
            'debugmode': self.settings.value('debugmode'),
        }

    """
