import os
import re
import json

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtWidgets import QApplication, QWidget, QPushButton, QMessageBox, QInputDialog
from qgis.PyQt.QtCore import QSettings, QSize
from qgis.core import *
from qgis.gui import QgsMapCanvas, QgsMapToolPan
from datetime import date
from dateutil.relativedelta import relativedelta
# import requests
from .lerplus_config import API_URLBASE
from .lerplus_utils import *

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'lerplusimport.ui'))


class LERplusImportDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(LERplusImportDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        self.crsComboBox.addItem("WGS84 EPSG:4326", 4326)
        self.crsComboBox.addItem("ETRS89 EPSG:25832", 25832)
        self.crsComboBox.addItem("ETRS89/Kp2000 Jutland EPSG:2196", 2196)
        self.crsComboBox.addItem("ETRS89/Kp2000 Zealand EPSG:2197", 2197)

        self.groupComboBox.addItem("Forsyningstype",1)
        #self.groupComboBox.addItem("Forsyningstype/ledningsjer",2)
        self.groupComboBox.addItem("Ledningsjer/forsyningstype", 3)

        self.importconfirmed = False

        # self.tokenEdit.setText(settings.value("lerplus/token"))

        settings = QgsSettings()
        importcrs = settings.value("lerplusdock/importcrs")
        importgroup = settings.value("lerplusdock/importgroup")
        # Example: preselect EPSG:4326
        self.setComboByValue(self.crsComboBox, importcrs)
        self.setComboByValue(self.groupComboBox, importgroup)

        settings.value("lerplusdock/startupcheck", False, type=bool)

        # Håndter opgradering fra gamle settings (0/1 eller 'true'/'false' strenge)
        sendstyling = settings.value("lerplusdock/importsendstyling", False)
        
        if isinstance(sendstyling, str):
            sendstyling_bool = sendstyling.lower() in ('true', '1', 'yes')
        else:
            sendstyling_bool = bool(sendstyling)
            
        self.sendStylingCheckBox.setChecked(sendstyling_bool)


        #manytomulti = settings.value("lerplusdock/importmanytomulti")
        #if manytomulti is not None:
            #self.manyToMultiCheckBox.setCheckState(manytomulti)

        self.okButton.clicked.connect(self.executeImport)
        self.cancelButton.clicked.connect(self.cancelImport)

    def setComboByValue(self, combo, value):
        index = combo.findData(value)
        if index != -1:
            combo.setCurrentIndex(index)

    def executeImport(self):
        self.importconfirmed = True
        settings = QgsSettings()
        settings.setValue("lerplusdock/importcrs", self.crsComboBox.currentData())
        settings.setValue("lerplusdock/importgroup", self.groupComboBox.currentData())
        settings.setValue("lerplusdock/importsendstyling", self.sendStylingCheckBox.isChecked())

        #settings.setValue("lerplusdock/importmanytomulti", self.manyToMultiCheckBox.checkState())
        self.close()

    def cancelImport(self):
        self.importconfirmed = False
        self.close()

    def isConfirmed(self):
        return self.importconfirmed

    def getCRS(self):
        return self.crsComboBox.currentData()

    def getGroupname(self):
        return self.groupnameEdit.text()

    def getSendStyling(self):
        return self.sendStylingCheckBox.checkState()

    def getManyToMulti(self):
        return self.manyToMultiCheckBox.checkState()

    def setIface(self, iface, groupname):
        self.iface = iface
        self.groupnameEdit.setText(groupname)
"""
    def updateInfo(self):
        self.rawInfo.setPlainText(json.dumps(self.sessioninfo))
        self.descriptionLabel.setText(self.sessioninfo["description"])

    def setMSID(self, msid):
        self.msid = msid
        #self.infoTextEdit.setPlainText(str(ssid))
        data = {
            'msid': msid
        }
        apiresponse = make_api_call(self, "getmultisession", data)

        if apiresponse is False:
            return
        #self.infoTextEdit.setPlainText(json.dumps(apiresponse['data']))
        self.sessioninfo = apiresponse['data']['msession']
        # print("session info: ",self.sessioninfo)
        self.updateMap()
        self.updateInfo()
        """


