import os
import re
import json
import random

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtWidgets import QApplication, QWidget, QPushButton, QMessageBox, QInputDialog
from qgis.PyQt.QtCore import QSettings, QSize
from qgis.core import *
from qgis.gui import QgsMapCanvas, QgsMapToolPan
from datetime import date
from dateutil.relativedelta import relativedelta
# import requests
from .lerplus_config import API_URLBASE
from .lerplus_utils import *

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'lerplushints.ui'))


class LERplusHintsDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(LERplusHintsDialog, self).__init__(parent)

        self.setupUi(self)

        self.closeButton.clicked.connect(self.closeWindow)

        self.hintText.setPlainText(self.getHint())
        settings = QgsSettings()
        self.checkboxShowHints.setChecked(settings.value("lerplusdock/showhints", True, type=bool))

        # self.setWindowFlags(Qt.Window)
        # self.notsendButton.clicked.connect(self.notsendReport)
        
    def getHint(self):
        hints = [
            'Vidste du at du kan bestille en opdatering med friske data fra LER? tryk på \u21BB "Opdatér data" ud for en forespørgsel!',
            'Vidst du, at du kan arkivere forespørgsler som du ved, du ikke skal genbesøge? Dette vil påvirke hastigheden af interfaces, så din oplevelse bliver bedre. Skulle du få brug for at genskabe disse data, kan det lade sig gøre ved henvendelse til qLER.'
        ]
        return random.choice(hints)
        

    def closeWindow(self):
        settings = QgsSettings()
        settings.setValue("lerplusdock/showhints", self.checkboxShowHints.isChecked())
        self.close()

    #def notsendReport(self):
#        self.close()

    def setIface(self, iface):
        self.iface = iface
        #self.errorText.setText(errortext)
