

import os
import re
import json

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtGui import QIntValidator
from qgis.PyQt.QtWidgets import QApplication, QWidget, QPushButton, QMessageBox, QInputDialog
from qgis.PyQt.QtCore import QSettings, QSize
from qgis.core import *
from qgis.gui import QgsMapCanvas, QgsMapToolPan
from datetime import date
from dateutil.relativedelta import relativedelta
# import requests
from .lerplus_config import API_URLBASE
from .lerplus_utils import *

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'lerplusinject.ui'))


class LERplusInjectDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(LERplusInjectDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)



        self.injectconfirmed = False

        # self.tokenEdit.setText(settings.value("lerplus/token"))


        self.okButton.clicked.connect(self.executeInject)
        self.cancelButton.clicked.connect(self.cancelInject)

        # Ensure leridEdit only accepts numbers (digits)
        if hasattr(self, 'leridEdit'):
            digit_validator = QIntValidator(0, 2147483647, self)
            self.leridEdit.setValidator(digit_validator)

    def executeInject(self):
        # Validate inputs before confirming
        lerid = self.leridEdit.text().strip() if hasattr(self, 'leridEdit') else ""
        description = self.descriptionEdit.text().strip() if hasattr(self, 'descriptionEdit') else ""

        errors = []
        # lerid: only numbers and longer than 4 characters
        if not lerid or not lerid.isdigit() or len(lerid) <= 4:
            errors.append("LER ID must be numeric and longer than 4 characters.")

        # description: filled out and longer than 4 characters
        if not description or len(description) <= 4:
            errors.append("Description must be filled out and longer than 4 characters.")

        if errors:
            QMessageBox.critical(self, "Invalid input", "\n".join(errors))
            self.injectconfirmed = False
            return

        self.injectconfirmed = True
        """
        settings = QgsSettings()
        settings.setValue("lerplusdock/importcrs", self.crsComboBox.currentData())
        settings.setValue("lerplusdock/importgroup", self.groupComboBox.currentData())
        settings.setValue("lerplusdock/importsendstyling", self.sendStylingCheckBox.checkState())
        #settings.setValue("lerplusdock/importmanytomulti", self.manyToMultiCheckBox.checkState())
        """
        self.close()

    def cancelInject(self):
        self.injectconfirmed = False
        self.close()

    def isConfirmed(self):
        return self.injectconfirmed

    def getLerID(self):
        return self.leridEdit.text()

    def getDescription(self):
        return self.descriptionEdit.text()

    def getCasenumber(self):
        return self.casenumberEdit.text()

    def setIface(self, iface):
        self.iface = iface
        #self.groupnameEdit.setText(groupname)
