# -*- coding: utf-8 -*-
"""
/***************************************************************************
 LERplusDialog
                                 A QGIS plugin
 Nem adgang til LER 2.0-forespørgsler
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-05-04
        git sha              : $Format:%H$
        copyright            : (C) 2023 by qLER ApS
        email                : morten@qler.dk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import re
import json

from functools import partial
from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtCore import Qt
from PyQt5.QtWidgets import QApplication, QWidget, QPushButton, QMessageBox, QInputDialog
from PyQt5.QtWidgets import QApplication, QMainWindow, QTableWidget, QTableWidgetItem, QPushButton, QVBoxLayout, \
    QWidget, QComboBox, QProgressDialog
from qgis.core import *
from qgis.gui import QgsMapCanvas, QgsMapToolPan
from datetime import date
from dateutil.relativedelta import relativedelta
# import requests
from .lerplus_config import API_URLBASE
from .lerplus_utils import *
from qgis.PyQt.QtCore import Qt, QUrl
from qgis.PyQt.QtGui import QDesktopServices

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'lerplusmultisessioninfo.ui'))

class AreaTableWidgetItem(QTableWidgetItem):
    def __lt__(self, other):
        if isinstance(other, QTableWidgetItem):
            # Compare based on the numeric sorting value stored in UserRole
            return self.data(Qt.UserRole) < other.data(Qt.UserRole)
        return super().__lt__(other)

class LERplusMultiSessionInfo(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(LERplusMultiSessionInfo, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        # self.tokenEdit.setText(settings.value("lerplus/token"))
        self.okButton.clicked.connect(self.closeMultiSessionInfo)

        self.canvas = QgsMapCanvas()
        #self.canvas.setCanvasColor(Qt.white)
        self.canvas.setRenderFlag(True)
        self.pan_tool = QgsMapToolPan(self.canvas)
        self.canvas.setMapTool(self.pan_tool)

        # Find the placeholder widget and replace it
        placeholder = self.findChild(QWidget, "mapCanvasWidget")
        layout = placeholder.parent().layout()
        layout.replaceWidget(placeholder, self.canvas)
        placeholder.deleteLater()
        self.canvas.setDestinationCrs(QgsCoordinateReferenceSystem("EPSG:25832"))
        url = "type=xyz&url=https://tile.openstreetmap.org/{z}/{x}/{y}.png&zmin=0&zmax=19"
        self.osmlayer = QgsRasterLayer(url, "OpenStreetMap", "wms")
        self.canvas.setLayers([self.osmlayer])
        self.canvas.zoomToFullExtent()
        self.canvas.refresh()

        columns = ['LER#', "Status", "Areal", "Ejere", "LER2", "-LER2", "Kortviser"]

        self.slicetable.setColumnCount(len(columns))
        self.slicetable.setHorizontalHeaderLabels(columns)  # "ZIP", "GML", "DGN",
        self.slicetable.setSortingEnabled(True)
        self.slicetable.setSelectionBehavior(QTableWidget.SelectRows)
        self.slicetable.setEditTriggers(QTableWidget.NoEditTriggers)  # make it readonly

        self.filterEdit.textChanged.connect(self.filterslicetable)

        #if not layer.isValid():
#            print("Failed to load OSM layer!")
        #else:
            #QgsProject.instance().addMapLayer(layer)
            #self.canvas.setLayers([layer])
            #self.canvas.zoomToFullExtent()


    def setIface(self, iface):
        self.iface = iface

    def closeMultiSessionInfo(self):
        self.close()

    def updateMap(self):
        self.wktlayer = QgsVectorLayer("Polygon?crs=EPSG:25832", "WKT Layer", "memory")
        if not self.wktlayer.isValid():
            print("Failed to create layer!")
            return

        # Create a Feature with the WKT Geometry
        feature = QgsFeature()
        geometry = QgsGeometry.fromWkt(self.sessioninfo['bigpolygon'])
        feature.setGeometry(geometry)

        # Add the Feature to the Layer
        self.wktlayer.dataProvider().addFeatures([feature])

        # Add the Layer to the Project and Canvas
        # QgsProject.instance().addMapLayer(layer)
        self.canvas.setLayers([self.wktlayer, self.osmlayer])

        # Zoom to the Polygon
        # self.canvas.setExtent()
        wktextent = self.wktlayer.extent()

        buffer_ratio = 0.1  # Adjust this value as needed
        buffered_extent = wktextent.buffered(
            max(wktextent.width(), wktextent.height()) * buffer_ratio
        )

        # Combine the buffered extent with the OSM layer extent
        # osm_extent = osm_layer.extent()
        # buffered_extent.combineExtentWith(osm_extent)
        self.canvas.setExtent(buffered_extent)

        self.canvas.refresh()

    def updateInfo(self):
        self.rawInfo.setPlainText(json.dumps(self.sessioninfo))
        self.descriptionLabel.setText(self.sessioninfo["description"])

    def updateSlices(self):
        self.slicetable.clearContents()
        self.slicetable.setRowCount(0)

        #pbox.setRange(0, len(self.sessioninfo['slices']) + 1)


        row = 0
        buttons = {}
        for slice in self.sessioninfo['slices']:
            self.slicetable.insertRow(row)
            colcount = 0

            #LerID
            item = QTableWidgetItem(str(slice['lerid']))
            item.setToolTip(str(slice['id']))
            self.slicetable.setItem(row, colcount, item)
            colcount += 1

            #lerstatus
            item = QTableWidgetItem(str(slice['lerstatus']))
            #item.setToolTip(str(slice['id']))
            self.slicetable.setItem(row, colcount, item)
            colcount += 1

            #Areal
            #item = AreaTableWidgetItem(session['area'])
            item = AreaTableWidgetItem(slice["area"])
            item.setTextAlignment(Qt.AlignRight | Qt.AlignVCenter)
            #value = session['area']
            #sorting_value = session['arearaw']
            #item.setData(Qt.UserRole, sorting_value)
            self.slicetable.setItem(row, colcount, item)
            colcount += 1

            # ejere ialt
            item = QTableWidgetItem(str(slice['ejercount']))
            self.slicetable.setItem(row, colcount, item)
            colcount += 1

            # LER2-ejere
            item = QTableWidgetItem(str(slice['ejerleveret']) + '/' + str(slice['ejerforventet']))
            item.setToolTip(slice['ejernavneleveretstring'])
            self.slicetable.setItem(row, colcount, item)
            colcount += 1

            # LER2-ejere udenom
            item = QTableWidgetItem(str(slice['ejerudenom']))
            item.setToolTip(",".join(slice['ejernavneudenomstring']))
            self.slicetable.setItem(row, colcount, item)
            colcount += 1

            #KORTVISER knap
            bname = 'kortbutton' + str(slice['lerid'])  # session['lerrespons']['Id']
            buttons[bname] = QPushButton("Vis i LER kortviser")
            buttons[bname].clicked.connect(
                partial(self.showKortviser, slice['kortviserurl'])
            )
            self.slicetable.setCellWidget(row, colcount, buttons[bname])
            colcount += 1




            row += 1

        self.slicetable.resizeColumnsToContents()




    def setMSID(self, msid):
        self.msid = msid
        #self.infoTextEdit.setPlainText(str(ssid))
        data = {
            'msid': msid
        }
        apiresponse = make_api_call(self, "getmultisession", data)

        if apiresponse is False:
            return
        self.rawInfo.setPlainText(json.dumps(apiresponse['data']))
        #self.tabWidget.removeTab(2)

        self.sessioninfo = apiresponse['data']['msession']
        # print("session info: ",self.sessioninfo)
        self.updateMap()
        self.updateInfo()
        self.updateSlices()



    def showKortviser(self, url):
        #url = 'https://kortviser.ler.dk/?diggingRequestNr=' + str(lerid) + '&ledningspakkeGuid=' + guid
        qturl = QUrl(url)  # Replace with your desired URL
        QDesktopServices.openUrl(qturl)

    def filterslicetable(self):
        filter_text = self.filterEdit.text().lower()
        columns_to_filter = [0]  # Indices of the columns to filter

        for row in range(self.slicetable.rowCount()):
            row_data = [self.slicetable.item(row, col).text().lower() if col in columns_to_filter else "" for col in
                        range(self.slicetable.columnCount())]
            if any(filter_text in cell_data for cell_data in row_data):
                self.slicetable.setRowHidden(row, False)
            else:
                self.slicetable.setRowHidden(row, True)
