# -*- coding: utf-8 -*-
"""
/***************************************************************************
 LERplusDialog
                                 A QGIS plugin
 Nem adgang til LER 2.0-forespørgsler
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-05-04
        git sha              : $Format:%H$
        copyright            : (C) 2023 by qLER ApS
        email                : morten@qler.dk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import re

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtCore import Qt
from PyQt5.QtWidgets import QApplication, QWidget, QPushButton, QMessageBox, QInputDialog
from qgis.core import *
from qgis.gui import QgsMapCanvas, QgsMapToolPan
from datetime import date
from dateutil.relativedelta import relativedelta
# import requests
from .lerplus_config import API_URLBASE
from .lerplus_utils import *

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'lerplusmultisessioninfo.ui'))


class LERplusMultiSessionInfo(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(LERplusMultiSessionInfo, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        # self.tokenEdit.setText(settings.value("lerplus/token"))
        self.okButton.clicked.connect(self.closeMultiSessionInfo)

        self.canvas = QgsMapCanvas()
        #self.canvas.setCanvasColor(Qt.white)
        self.canvas.setRenderFlag(True)
        self.pan_tool = QgsMapToolPan(self.canvas)
        self.canvas.setMapTool(self.pan_tool)

        # Find the placeholder widget and replace it
        placeholder = self.findChild(QWidget, "mapCanvasWidget")
        layout = placeholder.parent().layout()
        layout.replaceWidget(placeholder, self.canvas)
        placeholder.deleteLater()
        self.canvas.setDestinationCrs(QgsCoordinateReferenceSystem("EPSG:25832"))
        url = "type=xyz&url=https://tile.openstreetmap.org/{z}/{x}/{y}.png&zmin=0&zmax=19"
        self.osmlayer = QgsRasterLayer(url, "OpenStreetMap", "wms")
        self.canvas.setLayers([self.osmlayer])
        self.canvas.zoomToFullExtent()
        self.canvas.refresh()

        #if not layer.isValid():
#            print("Failed to load OSM layer!")
        #else:
            #QgsProject.instance().addMapLayer(layer)
            #self.canvas.setLayers([layer])
            #self.canvas.zoomToFullExtent()


    def setIface(self, iface):
        self.iface = iface

    def closeMultiSessionInfo(self):
        self.close()

    def updateMap(self):
        self.wktlayer = QgsVectorLayer("Polygon?crs=EPSG:25832", "WKT Layer", "memory")
        if not self.wktlayer.isValid():
            print("Failed to create layer!")
            return

        # Create a Feature with the WKT Geometry
        feature = QgsFeature()
        geometry = QgsGeometry.fromWkt(self.sessioninfo['bigpolygon'])
        feature.setGeometry(geometry)

        # Add the Feature to the Layer
        self.wktlayer.dataProvider().addFeatures([feature])

        # Add the Layer to the Project and Canvas
        # QgsProject.instance().addMapLayer(layer)
        self.canvas.setLayers([self.wktlayer, self.osmlayer])

        # Zoom to the Polygon
        # self.canvas.setExtent()
        wktextent = self.wktlayer.extent()

        buffer_ratio = 0.1  # Adjust this value as needed
        buffered_extent = wktextent.buffered(
            max(wktextent.width(), wktextent.height()) * buffer_ratio
        )

        # Combine the buffered extent with the OSM layer extent
        # osm_extent = osm_layer.extent()
        # buffered_extent.combineExtentWith(osm_extent)
        self.canvas.setExtent(buffered_extent)

        self.canvas.refresh()

    def updateInfo(self):
        # self.infoTextEdit.setPlainText(self.sessioninfo)
        self.descriptionLabel.setText(self.sessioninfo["description"])

    def setMSID(self, msid):
        self.msid = msid
        #self.infoTextEdit.setPlainText(str(ssid))
        data = {
            'msid': msid
        }
        apiresponse = make_api_call(self, "getmultisession", data)

        if apiresponse is False:
            return
        #self.infoTextEdit.setPlainText(json.dumps(apiresponse['data']))
        self.sessioninfo = apiresponse['data']['msession']
        # print("session info: ",self.sessioninfo)
        self.updateMap()
        self.updateInfo()


