# -*- coding: utf-8 -*-
"""
/***************************************************************************
 LERplusDialog
                                 A QGIS plugin
 Nem adgang til LER 2.0-forespørgsler
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-05-04
        git sha              : $Format:%H$
        copyright            : (C) 2023 by qLER ApS
        email                : morten@qler.dk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import re

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from PyQt5.QtWidgets import QApplication, QWidget, QPushButton, QMessageBox, QInputDialog
from qgis.core import *
from qgis.gui import QgsMapCanvas, QgsMapToolPan
from datetime import date
from dateutil.relativedelta import relativedelta
# import requests
from .lerplus_config import API_URLBASE
from .lerplus_utils import *

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'lerplussessioninfo.ui'))


class LERplusSessionInfo(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(LERplusSessionInfo, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        # self.tokenEdit.setText(settings.value("lerplus/token"))
        self.okButton.clicked.connect(self.closeSessionInfo)

        self.canvas = QgsMapCanvas()
        #self.canvas.setCanvasColor(Qt.white)
        self.canvas.setRenderFlag(True)
        self.pan_tool = QgsMapToolPan(self.canvas)
        self.canvas.setMapTool(self.pan_tool)

        placeholder = self.findChild(QWidget, "mapCanvasWidget")
        layout = placeholder.parent().layout()
        layout.replaceWidget(placeholder, self.canvas)
        placeholder.deleteLater()
        self.canvas.setDestinationCrs(QgsCoordinateReferenceSystem("EPSG:25832"))
        url = "type=xyz&url=https://tile.openstreetmap.org/{z}/{x}/{y}.png&zmin=0&zmax=19"
        self.osmlayer = QgsRasterLayer(url, "OpenStreetMap", "wms")

        if not self.osmlayer.isValid():
            print("Failed to load OSM layer!")
        else:
            #QgsProject.instance().addMapLayer(layer)
            self.canvas.setLayers([self.osmlayer])
            self.canvas.zoomToFullExtent()
            self.canvas.refresh()



    def setIface(self, iface):
        self.iface = iface

    def closeSessionInfo(self):
        self.close()

    def updateMap(self):
        self.wktlayer = QgsVectorLayer("Polygon?crs=EPSG:25832", "WKT Layer", "memory")
        if not self.wktlayer.isValid():
            print("Failed to create layer!")
            return

        # Create a Feature with the WKT Geometry
        feature = QgsFeature()
        geometry = QgsGeometry.fromWkt(self.sessioninfo['polygon'])
        feature.setGeometry(geometry)

        # Add the Feature to the Layer
        self.wktlayer.dataProvider().addFeatures([feature])

        # Add the Layer to the Project and Canvas
        #QgsProject.instance().addMapLayer(layer)
        self.canvas.setLayers([self.wktlayer,self.osmlayer])

        # Zoom to the Polygon
        #self.canvas.setExtent()
        wktextent = self.wktlayer.extent()


        buffer_ratio = 0.1  # Adjust this value as needed
        buffered_extent = wktextent.buffered(
            max(wktextent.width(), wktextent.height()) * buffer_ratio
        )

    # Combine the buffered extent with the OSM layer extent
    #osm_extent = osm_layer.extent()
        #buffered_extent.combineExtentWith(osm_extent)
        self.canvas.setExtent(buffered_extent)
        



        self.canvas.refresh()

    def updateInfo(self):
        #self.infoTextEdit.setPlainText(self.sessioninfo)
        self.descriptionLabel.setProperty('text',self.sessioninfo["description"])


    def setSSID(self, ssid):
        self.ssid = ssid
        #self.infoTextEdit.setPlainText(str(ssid))
        data = {
            'ssid': ssid
        }
        apiresponse = make_api_call(self, "getsession", data)

        if apiresponse is False:
            return
        self.sessioninfo = apiresponse['data']['session']
        #print("session info: ",self.sessioninfo)
        self.updateMap()
        self.updateInfo()


