#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
Test script to verify QDate and QDateTime conversion to ISO format strings
"""

from PyQt5.QtCore import QDate, QDateTime

# Test QDate conversion
test_date = QDate(2000, 1, 1)
print(f"QDate instance: {test_date}")
print(f"String representation (wrong): {str(test_date)}")
print(f"ISO format (correct): {test_date.toString('yyyy-MM-dd')}")
print()

# Test QDateTime conversion
test_datetime = QDateTime(QDate(2000, 1, 1), )
print(f"QDateTime instance: {test_datetime}")
print(f"String representation (wrong): {str(test_datetime)}")
print(f"ISO format (correct): {test_datetime.toString('yyyy-MM-dd HH:mm:ss')}")
print()

# Verify the format matches expected output
expected_date = "2000-01-01"
actual_date = test_date.toString('yyyy-MM-dd')
assert actual_date == expected_date, f"Expected {expected_date}, got {actual_date}"
print(f"✓ QDate conversion test passed: {actual_date}")

# Test with different date
test_date2 = QDate(2025, 10, 17)
expected_date2 = "2025-10-17"
actual_date2 = test_date2.toString('yyyy-MM-dd')
assert actual_date2 == expected_date2, f"Expected {expected_date2}, got {actual_date2}"
print(f"✓ QDate conversion test passed: {actual_date2}")

print("\nAll tests passed!")
