# -*- coding: utf-8 -*-
"""
/***************************************************************************
 LerPlusDockDockWidget
                                 A QGIS plugin
 Nem adgang til LER2 forespørgsler
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-10-09
        git sha              : $Format:%H$
        copyright            : (C) 2023 by qLER ApS
        email                : morten@qler.dk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import QtGui, QtWidgets, uic
from qgis.PyQt.QtCore import pyqtSignal
from qgis.PyQt.QtCore import QSettings, QSize
from qgis.PyQt.QtWidgets import QFrame, QMessageBox, QPushButton
from PyQt5.QtWidgets import QApplication, QMainWindow, QTableWidget, QTableWidgetItem, QPushButton, QVBoxLayout, QWidget
from qgis.PyQt.QtGui import QDesktopServices
from PyQt5.QtGui import QColor
from qgis.PyQt.QtCore import Qt, QUrl
from .ler2validering_utils import *
from .ler2validering_validate import *
from datetime import datetime
from PyQt5.QtCore import QTimer, QDate, QDateTime
from functools import partial
#from .lerplusnewsession import LERplusNewSession
import tempfile
import processing
import requests
import json
from qgis.core import QgsCoordinateReferenceSystem, QgsCoordinateTransform, QgsProject, QgsGeometry, QgsWkbTypes, QgsPointXY

#from .suggester import Suggester
#from .config import Settings


FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'ler2validering_widget.ui'))


class ler2valideringWidget(QFrame, FORM_CLASS):

    closingPlugin = pyqtSignal()

    def __init__(self, iface):
        """Constructor."""
        QFrame.__init__(self, iface.mainWindow())
        #super(LerPlusWidget, self).__init__(parent)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://doc.qt.io/qt-5/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        #self.readconfig()
        self.setupUi(self)
        self.iface = iface
        self.setFrameStyle(QFrame.StyledPanel + QFrame.Raised)

        #self.settings=settings
        #self.suggester = Suggester(
        #    settings=settings,
        #    searchbox_widget=self.searchEdit,
        #    notauthorized_func=self.handleNotAuthorized
        #)

        self.resize(50, self.height())
        #self.searchEdit.setFocus()
        self.settingsButton.clicked.connect(self.showSettings)
        self.checkButton.clicked.connect(self.doCheck)
        #self.updatenowButton.clicked.connect(lambda: self.updateSessions(True))

        ##self.timer = QTimer()
        ##self.timer.timeout.connect(self.updateSessions)
        #self.timer.start(120000)  # 60 seconds in milliseconds

        self.resultTable.setColumnCount(4)
        self.resultTable.setHorizontalHeaderLabels(
            ['FID', "Fejl", "objectType", "Beskrivelse"]
        )
        self.resultTable.setSortingEnabled(True)
        # Highlight feature when clicking any cell in a row
        try:
            self.resultTable.cellClicked.disconnect()
        except Exception:
            pass
        self.resultTable.cellClicked.connect(self.onResultRowClicked)

        #self.readconfig()
        #self.updateSessions()
        self.checkToken()


#        self.filterEdit.textChanged.connect(self.filterresulttable)

    def detectObjectType(self, selected_features, layer):
        # Find the objectType field (case-insensitively)
        object_type_field = None
        for field in layer.fields():
            if field.name().lower() == "objecttype":
                object_type_field = field.name()
                break
        
        # If field doesn't exist, return False
        if object_type_field is None:
            return False
        
        # Check if at least one feature has a non-empty value for this field
        for feature in selected_features:
            value = feature[object_type_field]
            # Check if value is not None and not empty string
            if value is not None and value != "":
                # Convert QVariant to Python native type if needed
                if hasattr(value, 'toPyObject'):
                    try:
                        value = value.toPyObject()
                    except Exception:
                        pass
                # Return the first non-empty value
                if value is not None and value != "":
                    return value
        
        # No non-empty value found
        return False
        



    def _single_if_possible(self, geom):
        """
        If geometry is multipart but contains only one part, convert it to the
        corresponding single-part geometry. Otherwise return original geometry.
        """
        try:
            if not geom or not isinstance(geom, QgsGeometry):
                return geom
            if not geom.isMultipart():
                return geom

            gtype = geom.type()
            # Point geometry
            if gtype == QgsWkbTypes.PointGeometry:
                pts = geom.asMultiPoint()
                if pts and len(pts) == 1:
                    return QgsGeometry.fromPointXY(pts[0])
                return geom
            # Line geometry
            if gtype == QgsWkbTypes.LineGeometry:
                lines = geom.asMultiPolyline()
                if lines and len(lines) == 1:
                    return QgsGeometry.fromPolylineXY(lines[0])
                return geom
            # Polygon geometry
            if gtype == QgsWkbTypes.PolygonGeometry:
                polys = geom.asMultiPolygon()
                if polys and len(polys) == 1:
                    return QgsGeometry.fromPolygonXY(polys[0])
                return geom
        except Exception:
            return geom
        return geom

    def prepareJSON(self, selected_features, layer):
        # Byg GeoJSON FeatureCollection af valgte features inkl. attributter og stabil id
        source_crs = layer.crs()
        target_crs = QgsCoordinateReferenceSystem(25832)
        need_transform = source_crs.authid() != 'EPSG:25832'
        if need_transform:
            transform = QgsCoordinateTransform(source_crs, target_crs, QgsProject.instance())

        field_names = [f.name() for f in layer.fields()]
        features_geo = []
        for f in selected_features:
            # Kopiér geometri og transformer hvis nødvendigt
            geom = QgsGeometry(f.geometry())
            if need_transform:
                try:
                    geom.transform(transform)
                except Exception as e:
                    QMessageBox.about(self, "Fejl", f"Kunne ikke transformere geometri for FID {f.id()}: {e}")
                    return
            # Simplify multipart geometry to singlepart if it has only one part
            geom = self._single_if_possible(geom)
            try:
                geom_json_obj = json.loads(geom.asJson())
            except Exception:
                geom_json_obj = None

            try:
                geom_wkt = geom.asWkt()
            except Exception:
                geom_wkt = None

            properties = {}
            for name in field_names:
                val = f[name]
                # Convert QVariant to Python native type
                if hasattr(val, 'toPyObject'):
                    try:
                        val = val.toPyObject()
                    except Exception:
                        pass
                # Handle None/NULL values
                if val is None:
                    properties[name] = None
                # Convert any remaining non-serializable types
                elif isinstance(val, (str, int, float, bool)):
                    properties[name] = val
                elif isinstance(val, (list, dict)):
                    properties[name] = val
                # Handle QDate and QDateTime instances
                elif isinstance(val, QDateTime):
                    properties[name] = val.toString("yyyy-MM-dd HH:mm:ss")
                elif isinstance(val, QDate):
                    properties[name] = val.toString("yyyy-MM-dd")
                else:
                    # Convert other types to string as fallback
                    properties[name] = str(val) if val is not None else None
            properties['geomwkt'] = geom_wkt
            properties.pop('geometri', None)

            features_geo.append({
                "type": "Feature",
                "id": int(f.id()),
                "layer_id": layer.id(),
                "layer_name": layer.name(),
                #"geometry": geom_json_obj,
                #"geomwkt": geom_wkt,
                "properties": properties
            })

        feature_collection = {
            "type": "FeatureCollection",
            "features": features_geo,
            "crs": {
                "type": "name",
                "properties": {"name": "EPSG:25832" if need_transform else source_crs.authid()}
            }
        }

        geojson_str = json.dumps(feature_collection, ensure_ascii=False)
        # For now, just provide the full GeoJSON code: copy to clipboard and inform user
        """try:
            QApplication.clipboard().setText(geojson_str)
            QMessageBox.information(self, "GeoJSON", "GeoJSON for valgte features er kopieret til udklipsholderen.")
        except Exception:
            QMessageBox.information(self, "GeoJSON", geojson_str)
        """

        return geojson_str


    def doCheck(self):

        layer = self.iface.activeLayer()

        if layer is None:
            QMessageBox.about(self, "Fejl", "Ikke noget aktivt layer")
            return
        #QMessageBox.about(self, "Fejl", "Sålangtsågodt")

        if not hasattr(layer, 'selectedFeatures'):
            QMessageBox.about(self, "Fejl", "Layer har ikke valgte features")
            return

        selected_features = list(layer.selectedFeatures())
        if len(selected_features) == 0:
            QMessageBox.about(self, "Fejl", "Ingen geometri valgt")
            return

        # Åbn valideringsdialog
        self.validatedialog = ler2valideringWidgetValidateDialog(self)
        self.validatedialog.setIface(self.iface)  # , groupname
        self.validatedialog.setInfo(len(selected_features), self.detectObjectType(selected_features, layer), layer)

        self.validatedialog.exec_()
        if not self.validatedialog.isConfirmed():
            return

        forcedobjtype=self.validatedialog.getForcedObjType()

        json_str = self.prepareJSON(selected_features, layer)



        data = {
            'jsonfeatures': json_str,
            'forcedobjecttype': forcedobjtype
        }

        reply = make_api_call(self, 'checkfeatures', data)
        if reply is False:
            QMessageBox.information(self, "validatejson", "Fejl i API-kald")
            return
            #self.clientName.show()
            #elf.clientName.setProperty("text", reply['data']['client name'])

        self.fillResultTable(reply['data']['errorlist'])


    def fillResultTable(self, errorlist):
        self.resultTable.setRowCount(len(errorlist))
        row = 0
        for errorline in errorlist:
            column = 0
            item = QTableWidgetItem(str(errorline['id']))
            #item.setToolTip(str(errorline['ssid']))
            self.resultTable.setItem(row, column, item)

            column += 1
            item = QTableWidgetItem(errorline['error'])
            self.resultTable.setItem(row, column, item)

            column += 1
            item = QTableWidgetItem(errorline['objecttype'])
            self.resultTable.setItem(row, column, item)

            column += 1
            item = QTableWidgetItem(errorline['description'])
            self.resultTable.setItem(row, column, item)
            row += 1
        self.resultTable.resizeColumnsToContents()

    def highlighFeature(self, fid, layer):
        canvas = self.iface.mapCanvas()
        canvas.zoomToFeatureIds(layer, [fid])
        canvas.flashFeatureIds(layer, [fid])

    def onResultRowClicked(self, row, column):
        # Extract fid from first column
        try:
            fid_item = self.resultTable.item(row, 0)
            fid_text = fid_item.text() if fid_item is not None else None
            if not fid_text:
                return
            fid = int(fid_text)
        except Exception:
            return

        # Try to get object type from column 2 to resolve layer name
        objtype = None
        obj_item = self.resultTable.item(row, 2)
        if obj_item is not None:
            objtype = obj_item.text()

        layer = None
        try:
            if objtype:
                for lyr in QgsProject.instance().mapLayers().values():
                    try:
                        if lyr.name().lower() == str(objtype).lower():
                            layer = lyr
                            break
                    except Exception:
                        continue
            # Fallback to active layer
            if layer is None and hasattr(self, 'iface') and self.iface is not None:
                layer = self.iface.activeLayer()
        except Exception:
            layer = None

        if layer is None:
            # No layer to highlight on; silently ignore
            return

        self.highlighFeature(fid, layer)


    def filterresulttable(self):
        return
        filter_text = self.filterEdit.text().lower()
        columns_to_filter = [0, 6]  # Indices of the columns to filter

        for row in range(self.resulttable.rowCount()):
            row_data = [self.resulttable.item(row, col).text().lower() if col in columns_to_filter else "" for col in
                        range(self.resulttable.columnCount())]
            if any(filter_text in cell_data for cell_data in row_data):
                self.resulttable.setRowHidden(row, False)
            else:
                self.resulttable.setRowHidden(row, True)

    def closeEvent(self, event):
        self.closingPlugin.emit()
        self.timer.timeout.disconnect(self.updateSessions)
        event.accept()

    def setIface(self,iface):
        self.iface = iface

    def showSettings(self):
        self.iface.showOptionsDialog(currentPage="LER2validering")
        self.checkToken()
        #self.settings = LERplusSettings()
        #self.settings.setIface(self.iface)
        #self.settings.exec_()


    def checkToken(self):
        settings = QgsSettings()
        token = settings.value("ler2validering/apitoken")
        # QMessageBox.information(self, 'Token', token)
        # QgsMessageLog.logMessage(token)
        if (token != "") and (token is not None):
            reply = make_api_call(self,'checktoken')
            if reply is not False:
                self.clientName.show()
                self.clientName.setProperty("text", reply['data']['client name'])
            else:
                self.clientName.setProperty("text", "N/A")
                #self.clientName.hide()


