# -*- coding: utf-8 -*-

"""
/***************************************************************************
 LeastCostPath
                                 A QGIS plugin
 Find the least cost path with given cost raster and points
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-12-12
        copyright            : (C) 2018 by FlowMap Group@SESS.PKU
        email                : xurigong@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'FlowMap Group@SESS.PKU'
__date__ = '2018-12-12'
__copyright__ = '(C) 2018 by FlowMap Group@SESS.PKU'

import unittest
from ..dijkstra_algorithm import dijkstra
from math import sqrt


class LeastCostPathAlgorithmTest(unittest.TestCase):
    """Test least cost path algorithm"""

    def test_least_cost_path(self):
        matrix1 = [[1, 1, 1],
                   [1, 1, 1],
                   [1, 1, 1]]
        matrix2 = [[1, 1, 1],
                   [1, 100, 1],
                   [1, 1, 1]]
        matrix3 = [[1, 1, 1],
                   [1, None, 1],
                   [1, 1, 1]]

        start = (0, 0)
        ends = [(2, 2)]
        path, cost = dijkstra(start, ends, matrix1)
        self.assertEqual(cost, sqrt(2) * 2)

        path, cost = dijkstra(start, ends, matrix2)
        self.assertEqual(cost, sqrt(2) + 2)

        path, cost = dijkstra(start, ends, matrix3)
        self.assertEqual(cost, sqrt(2) + 2)

        ends = [(1, 1), (2, 2)]
        path, cost = dijkstra(start, ends, matrix2)
        self.assertEqual(cost, sqrt(2) + 2)

        # end points overlap with start point
        ends = [(0, 0), (2, 2)]
        path, cost = dijkstra(start, ends, matrix2)
        self.assertEqual(cost, 0)
        self.assertEqual(len(path), 1)

    def test_not_exists_least_cost_path(self):

        # not reachable
        matrix1 = [[1, None, 1],
                   [1, None, 1],
                   [1, None, 1]]

        # start is Nodata
        matrix2 = [[None, 1, 1],
                   [1, 1, 1],
                   [1, 1, 1]]

        # end is Nodata
        matrix3 = [[1, 1, 1],
                   [1, 1, 1],
                   [1, 1, None]]

        start = (0, 0)
        ends = [(2, 2)]
        path, cost = dijkstra(start, ends, matrix1)
        self.assertIsNone(cost)

        path, cost = dijkstra(start, ends, matrix2)
        self.assertIsNone(cost)

        path, cost = dijkstra(start, ends, matrix3)
        self.assertIsNone(cost)
