# -*- coding: utf-8 -*-
"""
/***************************************************************************
 LayoutPanelDockWidget
                                 A QGIS plugin
 Add a panel to manage layouts without blocking the main interface
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2022-02-09
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Atelier JBP
        email                : jbpeter@outlook.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import  QtWidgets, uic
from qgis.PyQt.QtCore import pyqtSignal, Qt, QEvent
from PyQt5.QtWidgets import QAbstractItemView 
from qgis.core import QgsMessageLog


from .modules.project import Project
from .modules.layout_list import LayoutList
from .modules.layout_item import LayoutItem
from .modules.context_menu import ContextMenu
from .modules.template_menu import TemplateMenu

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'layout_panel_dockwidget_base.ui'))


class LayoutPanelDockWidget(QtWidgets.QDockWidget, FORM_CLASS):

    closingPlugin = pyqtSignal()

    def __init__(self, iface, parent=None):
        """Initialize the layout panel"""
        super(LayoutPanelDockWidget, self).__init__(parent)
        self.setupUi(self)

        self.iface = iface
                               
        # Initialize modules
        plugin_dir = os.path.dirname(os.path.realpath(__file__))
        self.project = Project(plugin_dir,parent=self)
        self.layout_list = LayoutList(parent=self)
        self.layout_item = LayoutItem(parent=self)
        self.context_menu = ContextMenu(parent=self)
        self.template_menu = TemplateMenu(parent=self)
        
        #Disable edit triggers - F2 shortcut to edit is managed by keyPressEvent
        self.listWidget.setEditTriggers(QAbstractItemView.NoEditTriggers)
        
        # Set connections        
        self.pbCreateLayout.clicked.connect(self.project.createNewLayout)
        self.pbDeleteLayout.clicked.connect(lambda: self.layout_list.removeSelectedLayouts(True))
        self.listWidget.itemDoubleClicked.connect(self.layout_item.openCurrentLayout)
        self.listWidget.setContextMenuPolicy(Qt.CustomContextMenu)
        self.listWidget.customContextMenuRequested.connect(self.context_menu.openContextMenu)
        self.listWidget.itemDelegate().closeEditor.connect(self.layout_item.renameLayoutClosedEditor)
        self.mLineEdit.valueChanged.connect(self.layout_list.updateLayoutList)

    
    # Manage keyboard shortcuts       
    def keyPressEvent(self, event):
         if (event.type() == QEvent.KeyPress):
            key = event.key()
            modifier = event.modifiers()

            if key == Qt.Key_F2:
                self.layout_item.renameLayout()
                event.accept()
                
            if (key == Qt.Key_Enter) or (key == Qt.Key_Return):
                self.layout_item.openCurrentLayout()
                event.accept()
                
            if ( modifier != Qt.ShiftModifier) and key == Qt.Key_Delete:
                self.layout_list.removeSelectedLayouts()
                event.accept()
                
            if ( modifier == Qt.ShiftModifier) and key == Qt.Key_Delete:
                self.layout_list.removeSelectedLayouts(False)
                event.accept()
                
            if ( modifier == Qt.ControlModifier) and key == Qt.Key_C:
                self.layout_item.duplicateLayout()
                event.accept()
    
    
    def closeEvent(self, event):
        """Close the plugin"""
        self.closingPlugin.emit()
        event.accept()
            
    
    def log(self, msg):
        """Helper to log msg in QGIS used for debug only"""
        QgsMessageLog.logMessage(str(msg), "Layout Panel")
    
        

#TODO: update extent of refence map automatically after creating layout from template              
#TODO: Show layout extent on canvas/to new layer/ zoom to map extent /mask 
#TODO: quick print layout?
#TODO: cleanup the code
#TODO: update statusbar
#TODO: standard paper format in tooltip (A4, A3, etc.)
#TODO: translation TR
#TODO: Filter tool button? filter by size, page count, expression, etc.
#TODO: Add support for reports
#TODO: Support for drag & drop
#TODO: edit default export settings
#TODO: icons for layout templates
#TODO: Export layout list as table