# -*- coding: utf-8 -*-
"""
/***************************************************************************
 LayerAtlasDockWidget
                                 A QGIS plugin
 Discover and share geospatial layers easily within QGIS
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-07-04
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Layer Atlas
        email                : contact@layeratlas.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.core import QgsMapLayerType
from qgis.gui import QgsDockWidget, QgisInterface
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtCore import QUrl, Qt, pyqtSignal


class LayerAtlasDockWidget(QgsDockWidget):
    closingPlugin = pyqtSignal()

    def __init__(self, _iface: QgisInterface = None):
        """Constructor."""
        super().__init__()
        self.iface = _iface
        self.setObjectName("LayerAtlasPlugin")
        self.setWindowTitle(self.tr("Layer Atlas"))
        self.setAllowedAreas(Qt.LeftDockWidgetArea | Qt.RightDockWidgetArea)

        self.contextMenuActions = []
        self.dev_mode = False

        self.set_web_view("https://www.layeratlas.com/?qgis=true")

    def set_web_view(self, url):
        try:
            from layeratlas.core.custom_web_engine_view import CustomWebEngineView

            self.view = CustomWebEngineView(self.iface)
            url = QUrl(url)
            self.view.setUrl(url)
            self.setWidget(self.view)
            self.add_actions_layer_tree()

        except ImportError:
            # if PyqtWebEngine not available, try to install it
            from layeratlas.core.manage_dependencies import confirm_install

            confirm_install(self.iface)

            # Show a message if user doesn't want to install
            from layeratlas.core.manage_dependencies import get_html_page

            self.container = QtWidgets.QWidget()
            self.setWidget(self.container)
            self.layout = QtWidgets.QVBoxLayout(self.container)

            self.view = get_html_page()
            self.layout.addWidget(self.view)

            # Create a button for installing dependencies
            self.install_deps_button = QtWidgets.QPushButton(
                "Install Dependencies", self
            )
            self.install_deps_button.clicked.connect(
                lambda: confirm_install(self.iface)
            )
            self.layout.addWidget(self.install_deps_button)

    def add_actions_layer_tree(self):
        """Add custom actions to the layer tree context menu for uploading layers to Layer Atlas."""
        for layer_type in QgsMapLayerType:
            uploadAction = QtWidgets.QAction("Add to Layer Atlas")
            uploadAction.setIcon(QIcon(":icons/upload_sign.svg"))
            uploadAction.triggered.connect(self.add_layer_to_layer_atlas)
            self.iface.addCustomActionForLayerType(uploadAction, None, layer_type, True)
            self.contextMenuActions.append(uploadAction)

    def remove_actions_layer_tree(self):
        """Removes custom actions from the layer tree context menu."""
        for uploadAction in self.contextMenuActions:
            self.iface.removeCustomActionForLayerType(uploadAction)
        self.contextMenuActions = []

    def add_layer_to_layer_atlas(self):
        if self.isVisible() == False:
            self.show()
        self.view.add_layer_to_layer_atlas()

    def keyPressEvent(self, event):
        """Handle key press events for debugging and reloading the plugin."""

        if event.key() == Qt.Key_F1 and event.modifiers() == Qt.ControlModifier:
            # toogle url dev / prod
            if self.dev_mode:
                self.set_web_view("https://www.layeratlas.com/?qgis=true")
                self.setWindowTitle(self.tr("Layer Atlas"))
            else:
                self.set_web_view("http://localhost:9000/?qgis=true")
                self.setWindowTitle(self.tr("Layer Atlas (Dev Mode)"))
            self.show()
            self.dev_mode = not self.dev_mode

        if event.key() == Qt.Key_F5 and event.modifiers() == Qt.ControlModifier:
            # Reload the page
            self.view.reload()

        if event.key() == Qt.Key_F10 and event.modifiers() == Qt.ControlModifier:
            # Open the dev tools
            from layeratlas.core.custom_web_engine_view import CustomWebEngineView

            self.debug_window = QtWidgets.QDialog()
            self.dev_view = CustomWebEngineView(self.iface)
            debug_layout = QtWidgets.QHBoxLayout()
            debug_layout.setContentsMargins(0, 0, 0, 0)
            debug_layout.addWidget(self.dev_view)
            self.debug_window.setLayout(debug_layout)
            self.view.page().setDevToolsPage(self.dev_view.page())
            self.debug_window.show()

    def cleanup_on_close(self):
        """Cleanup the plugin on close."""
        self.remove_actions_layer_tree()
