# -*- coding: utf-8 -*-
"""
/***************************************************************************
 layer_counter
                                 A QGIS plugin
 Plugin that count layer loaded in the layer panel.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-07-30
        copyright            : (C) 2025 by Eagleprojects S.p.A.
        email                : gis@eagleprojects.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.PyQt.QtCore import QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QWidget, QVBoxLayout, QLabel, QDockWidget
from qgis.core import QgsProject
import os.path


class LayerCounterWidget(QWidget):
    """Widget per il pannello del contatore layer."""
    
    def __init__(self, iface, parent=None):
        super(LayerCounterWidget, self).__init__(parent)
        self.iface = iface
        self.setupUi()
        self.connectSignals()
        self.updateCounts()
    
    def setupUi(self):
        """Configura l'interfaccia utente del widget."""
        layout = QVBoxLayout()
        
        # Etichette per i conteggi (senza titolo)
        self.total_label = QLabel("Total layers: 0")
        self.selected_label = QLabel("Selected layers: 0")
        
        # Stile per le etichette (ingrandite)
        label_style = "font-size: 12px; margin: 0px; padding: 1px; font-weight: bold; text-align: left;"
        self.total_label.setStyleSheet(label_style)
        self.selected_label.setStyleSheet(label_style)
        
        # Aggiungi i widget al layout (senza spazi extra)
        layout.setContentsMargins(5, 5, 5, 5)  # Margini ridotti del layout
        layout.setSpacing(2)  # Spazio ridotto tra gli elementi
        layout.addWidget(self.total_label)
        layout.addWidget(self.selected_label)
        layout.addStretch()  # Spazio flessibile in fondo
        
        self.setLayout(layout)
        self.setMinimumHeight(80)
    
    def connectSignals(self):
        """Connette i segnali per l'aggiornamento automatico."""
        # Aggiornamento quando vengono aggiunti/rimossi layer
        QgsProject.instance().layersAdded.connect(self.updateCounts)
        QgsProject.instance().layersRemoved.connect(self.updateCounts)
        QgsProject.instance().cleared.connect(self.updateCounts)
        
        # Aggiornamento quando cambiano le selezioni
        if hasattr(self.iface, 'layerTreeView'):
            selection_model = self.iface.layerTreeView().selectionModel()
            if selection_model:
                selection_model.selectionChanged.connect(self.updateCounts)
    
    def updateCounts(self, *args, **kwargs):
        """Aggiorna i conteggi dei layer."""
        try:
            # Conta tutti i layer nel progetto
            total_layers = len(QgsProject.instance().mapLayers())
            
            # Conta i layer selezionati
            selected_layers = 0
            if hasattr(self.iface, 'layerTreeView'):
                selected_layers_list = self.iface.layerTreeView().selectedLayers()
                selected_layers = len(selected_layers_list)
            
            # Aggiorna le etichette
            self.total_label.setText(f"Total layers: {total_layers}")
            self.selected_label.setText(f"Selected layers: {selected_layers}")
            
        except Exception as e:
            print(f"Errore nell'aggiornamento conteggi: {e}")
            self.total_label.setText("Total layers: Errore")
            self.selected_label.setText("Selected layers: Errore")


class layer_counter:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor."""
        # Save reference to the QGIS interface
        self.iface = iface
        # Initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        
        # Declare instance attributes
        self.actions = []
        self.menu = 'Layer Counter'
        self.first_start = None
        self.dock_widget = None
        self.widget = None

    def tr(self, message):
        """Get the translation for a string using Qt translation API."""
        return QCoreApplication.translate('layer_counter', message)

    def add_action(self, icon_path, text, callback, enabled_flag=True, 
                  add_to_menu=True, add_to_toolbar=True, status_tip=None, 
                  whats_this=None, parent=None):
        """Add a toolbar icon to the toolbar."""
        
        # Use default icon if file doesn't exist
        if not os.path.exists(icon_path):
            icon = QIcon()
        else:
            icon = QIcon(icon_path)
            
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(self.menu, action)

        self.actions.append(action)
        return action

    @staticmethod
    def _dock_area(area_name: str):
        # Qt6: Qt.DockWidgetArea.LeftDockWidgetArea
        # Qt5: Qt.LeftDockWidgetArea
        if hasattr(Qt, "DockWidgetArea"):
            return getattr(Qt.DockWidgetArea, area_name)
        return getattr(Qt, area_name)

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        # print("DEBUG: Layer Counter plugin initGui() called")

        # Se QGIS richiama initGui più volte, evita di ricreare tutto
        if self.dock_widget is not None:
            # Assicura che sia visibile/agganciato
            try:
                if not self.dock_widget.isVisible():
                    self.dock_widget.show()
            except Exception:
                pass
            return

        # Crea il widget per il pannello
        self.widget = LayerCounterWidget(self.iface)

        # Crea il dock widget
        dock = QDockWidget("Layer Counter", self.iface.mainWindow())
        dock.setObjectName("layer_counter.LayerCounterDockWidget")
        dock.setWidget(self.widget)

        # Allowed areas (Qt5/Qt6 compat)
        dock.setAllowedAreas(
            self._dock_area("LeftDockWidgetArea") |
            self._dock_area("RightDockWidgetArea") |
            self._dock_area("BottomDockWidgetArea")
        )

        self.iface.addDockWidget(self._dock_area("LeftDockWidgetArea"), dock)

        # Salva SOLO dopo che è tutto ok
        self.dock_widget = dock

        # Azione menu/toolbar
        icon_path = os.path.join(self.plugin_dir, 'icon.png')
        self.add_action(
            icon_path,
            text='Layer Counter',
            callback=self.toggle_panel,
            parent=self.iface.mainWindow()
        )

        self.first_start = True

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        print("DEBUG: Layer Counter plugin unload() called")
        
        # Rimuovi il dock widget
        if self.dock_widget:
            self.iface.removeDockWidget(self.dock_widget)
            self.dock_widget = None
            self.widget = None
        
        # Remove actions
        for action in self.actions:
            self.iface.removePluginMenu(self.menu, action)
            self.iface.removeToolBarIcon(action)

    def toggle_panel(self):
        """Mostra o nasconde il pannello."""
        if self.dock_widget:
            if self.dock_widget.isVisible():
                self.dock_widget.hide()
            else:
                self.dock_widget.show()

    def run(self):
        """Run method - ora mostra/nasconde il pannello invece del popup."""
        self.toggle_panel()