# -*- coding: utf-8 -*-
"""
/***************************************************************************
 LayerCombinationsDialog
                                 A QGIS plugin
 Store and restore layer visibilities
                             -------------------
        begin                : 2012-12-26
        copyright            : (C) 2012 by Olivier Dalang
        email                : olivier.dalang@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from LcCanvasBase import LcCanvasBase

# create the dialog for zoom to point

class LcCanvasDockWidget(QDockWidget, LcCanvasBase):
    """
    This palette is an interface for saving and restoring layers visibilities.
    """


    def __init__(self, manager):
        QDockWidget.__init__(self, "Layer combinations")
        LcCanvasBase.__init__(self, manager)

        #Setup the DockWidget
        mainWidget = QWidget()
        self.layout = QGridLayout()
        self.layout.setColumnStretch( 0, 1 )
        self.layout.setRowStretch( 3, 1 )
        mainWidget.setLayout(self.layout)
        self.setWidget(mainWidget)
        
        self.deleBtn.setFixedWidth(50)
        self.saveBtn.setFixedWidth(50)

        #Layout the main UI elements
        self.layout.addWidget(self.combBox,0,0)
        self.layout.addWidget(self.deleBtn,0,1)
        self.layout.addWidget(self.nameEdt,1,0)
        self.layout.addWidget(self.saveBtn,1,1)
        self.layout.addWidget(self.foldChk,2,0,1,2)

    def addToiFace(self, iface):
        iface.addDockWidget(Qt.LeftDockWidgetArea, self)
    def removeFromiFace(self, iface):
        iface.mainWindow().removeDockWidget(self)