# -*- coding: utf-8 -*-
"""
/***************************************************************************
  Clasificador
                                 A QGIS plugin
 clasifica un raster en categories
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
 clasificaDialog
        begin                : 2020-07-08
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Víctor Hernandez
        email                : victorhdzgeo@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import sys, os
import qgis
from qgis.core import *
from qgis.PyQt import QtWidgets, QtCore, QtGui, uic
from qgis.PyQt.QtCore import *
from qgis.PyQt.QtGui import *
from qgis.PyQt.QtWidgets import QFileDialog

from .clasificador_raster import clasifica_raster
from .clasificador_shape import clasificar_shape

Qt = QtCore.Qt


# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'clasifica_capa_dialog_base.ui'))


class clasificaDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(clasificaDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.type_v.toggled.connect(self.select_type)
        self.type_r.toggled.connect(self.select_type)
        self.layer.setFilters(QgsMapLayerProxyModel.VectorLayer) # filter layers vectors in mapcombox
        self.layer.layerChanged.connect(self.l_fields.setLayer) # signal changed layer in mapcombobox
        self.l_fields.setFilters(QgsFieldProxyModel.Numeric) # filtered fields for type numeric
        self.l_fields.setLayer(self.layer.currentLayer())   # agrega al elemento l_fields la lista de campos numericos de la capa en layer

        self.c_wf.toggled.connect(self.select_clasifica)   #señal de activación de los diferentes modos 
        self.quartil.toggled.connect(self.select_clasifica)
        self.quintil.toggled.connect(self.select_clasifica)
        self.decil.toggled.connect(self.select_clasifica)
        self.equidistant.toggled.connect(self.select_clasifica)
        
        self.but_run.clicked.connect(self.run_clasificador)  # ejecuta la acción para clasificar la capa 
        self.but_close.clicked.connect(self.close_plugin)  # señal de cerrar el plugin al presionar el boton close 

        
    def select_type(self):
        '''
        Función para filtrar el tipo de datos, raster o vector en el elemento layer 
        '''
        status = False
        self.layer.setFilters(QgsMapLayerProxyModel.RasterLayer)
        if self.type_v.isChecked():
            status = True
            self.layer.setFilters(QgsMapLayerProxyModel.VectorLayer)
            self.layer.layerChanged.connect(self.l_fields.setLayer)
            self.l_fields.setFilters(QgsFieldProxyModel.Numeric)
            self.l_fields.setLayer(self.layer.currentLayer())
            
        self.l_fields.setVisible(status)
        self.labelf.setVisible(status)
        
    def select_clasifica(self):
        '''
        Esta función verifica que modo esta checked para ocultar 
        o mostrar los elementos progression factor, categories 
        
        '''

        status = True

        if self.c_wf.isChecked() or self.progressive.isChecked():
            self.label_i.setVisible(False)
            self.intervals.setVisible(False)
        
        if self.quartil.isChecked() or self.quintil.isChecked() or self.decil.isChecked():
            status = False
               
            self.label_i.setVisible(status)
            self.intervals.setVisible(status)
        
        self.labelcat.setVisible(status)
        self.labelfp.setVisible(status)
        self.fp.setVisible(status)
        self.categories.setVisible(status)
        
        if self.equidistant.isChecked():
            status= True
        
            self.label_i.setVisible(status)
            self.intervals.setVisible(status)

            self.labelcat.setVisible(False)
            self.categories.setVisible(False)
            self.labelfp.setVisible(False)
            self.fp.setVisible(False)


    def close_plugin(self):
        self.close()

    def run_clasificador(self):
        '''
        Esta funcion verifica en primer lugar verifica
        el tipo de entrada en raster o vector 

        posteriormente verifica el modo de clasificación 
        y obtiene los parametros según el modo seleccionado

        una vez concluido el proceso de clasificacion, en caso de que
        el tipo de entrada sea raster, carga en automatico la capa al proyecto
        y se cierra la vetana.


        en caso de que el tipo de entrada sea vector, la capa vectorial
        entra en fase de edición, guarda los cambios, actualiza la tabla de atributos
        y se sierra la ventana. 
        

        '''

        if self.type_r.isChecked():
            raster = self.layer.currentLayer()
            v_fp = self.fp.value()
            n_cats = self.categories.value()
            path_r = raster.source()
            if self.c_wf.isChecked():
                clasifica_raster(path_r,"wf",fp=v_fp,categories=n_cats)
            elif self.progressive.isChecked():
                clasifica_raster(path_r,"progresiva",fp=v_fp,categories=n_cats)
            elif self.quartil.isChecked():
                clasifica_raster(path_r,"cuartiles")
            elif self.quintil.isChecked():
                clasifica_raster(path_r,"quintiles")
            elif self.decil.isChecked():
                clasifica_raster(path_r,"deciles")
            elif self.equidistant.isChecked():
                n_cats = self.intervals.value()
                clasifica_raster(path_r,"equidistante",categories=n_cats)
            self.close_plugin()
            
        if self.type_v.isChecked():
            vector = self.layer.currentLayer()
            path_v = vector.source()
            v_fp = self.fp.value()
            n_cats = self.categories.value()
            campo = self.l_fields.currentText()
            if self.c_wf.isChecked():
                clasificar_shape(path_v,"wf", campo, fp=v_fp, categories=n_cats)
            if self.progressive.isChecked():
                clasificar_shape(path_v,"progressive", campo, fp=v_fp, categories=n_cats)
                self.layer.currentLayer().updateFields()
                self.layer.currentLayer().commitChanges()
            elif self.quartil.isChecked():
                clasificar_shape(path_v,"cuartiles", campo,categories=4)
                self.layer.currentLayer().updateFields()
                self.layer.currentLayer().commitChanges()
            elif self.quintil.isChecked():
                clasificar_shape(path_v,"quintiles", campo,categories=5)
                self.layer.currentLayer().updateFields()
                self.layer.currentLayer().commitChanges()
            elif self.decil.isChecked():
                clasificar_shape(path_v,"deciles", campo,categories=10)
                self.layer.currentLayer().updateFields()
                self.layer.currentLayer().commitChanges()
            elif self.equidistant.isChecked():
                n_cats2 = self.intervals.value()
                clasificar_shape(path_v,"equidistante", campo, categories=n_cats2)
                self.layer.currentLayer().updateFields()
                self.layer.currentLayer().commitChanges()
            
            self.layer.currentLayer().startEditing()
            self.layer.currentLayer().commitChanges()
            self.close_plugin()