# ags_presets.py
# Predefined A‑gs (physiological) parameters for various tree species

from typing import Dict, Any

AGS_PRESETS: Dict[str, Dict[str, float]] = {
    "Abstract Conifer Tree": {
        "comp_point25": 45.0,
        "comp_point_q10": 1.5,
        "gm25": 2.5,
        "gm_q10": 2.0,
        "gm_t1": 5.0,
        "gm_t2": 36.0,
        "ammax25": 1.0,
        "ammax_q10": 2.0,
        "ammax_t1": 8.0,
        "ammax_t2": 36.0,
        "e0": 0.016,
        "f0": 0.5,
        "gc": 0.35,
        "dmax": 25.0,
        "albedo": 0.18,
        "transmittance": 0.30
    },
    "Abstract Deciduous Tree": {
        "comp_point25": 45.0,
        "comp_point_q10": 1.5,
        "gm25": 5.0,
        "gm_q10": 2.0,
        "gm_t1": 5.0,
        "gm_t2": 36.0,
        "ammax25": 2.2,
        "ammax_q10": 2.0,
        "ammax_t1": 8.0,
        "ammax_t2": 36.0,
        "e0": 0.017,
        "f0": 0.85,
        "gc": 0.25,
        "dmax": 20.0,
        "albedo": 0.18,
        "transmittance": 0.30
    },
    "Abstract Palm Tree": {
        "comp_point25": 45.0,
        "comp_point_q10": 1.5,
        "gm25": 5.0,
        "gm_q10": 2.0,
        "gm_t1": 5.0,
        "gm_t2": 36.0,
        "ammax25": 2.2,
        "ammax_q10": 2.0,
        "ammax_t1": 8.0,
        "ammax_t2": 36.0,
        "e0": 0.017,
        "f0": 0.85,
        "gc": 0.25,
        "dmax": 20.0,
        "albedo": 0.18,
        "transmittance": 0.30
    },
    "Ash Tree": {
        "comp_point25": 45.0,
        "comp_point_q10": 1.5,
        "gm25": 4.5,
        "gm_q10": 2.0,
        "gm_t1": 5.0,
        "gm_t2": 36.0,
        "ammax25": 2.0,
        "ammax_q10": 2.0,
        "ammax_t1": 8.0,
        "ammax_t2": 36.0,
        "e0": 0.017,
        "f0": 0.9,
        "gc": 0.2,
        "dmax": 15.0,
        "albedo": 0.18,
        "transmittance": 0.30
    },
    "Beech Tree": {
        "comp_point25": 45.0,
        "comp_point_q10": 1.5,
        "gm25": 4.5,
        "gm_q10": 2.0,
        "gm_t1": 5.0,
        "gm_t2": 36.0,
        "ammax25": 2.0,
        "ammax_q10": 2.0,
        "ammax_t1": 8.0,
        "ammax_t2": 36.0,
        "e0": 0.017,
        "f0": 0.9,
        "gc": 0.2,
        "dmax": 15.0,
        "albedo": 0.18,
        "transmittance": 0.30
    },
    "Horse Chestnut Tree": {
        "comp_point25": 45.0,
        "comp_point_q10": 1.5,
        "gm25": 5.0,
        "gm_q10": 2.0,
        "gm_t1": 5.0,
        "gm_t2": 36.0,
        "ammax25": 2.2,
        "ammax_q10": 2.0,
        "ammax_t1": 8.0,
        "ammax_t2": 36.0,
        "e0": 0.017,
        "f0": 0.85,
        "gc": 0.25,
        "dmax": 20.0,
        "albedo": 0.18,
        "transmittance": 0.30
    },
    "Linden/Lime Tree": {
        "comp_point25": 45.0,
        "comp_point_q10": 1.5,
        "gm25": 1.5,
        "gm_q10": 2.0,
        "gm_t1": 5.0,
        "gm_t2": 38.0,
        "ammax25": 0.6,
        "ammax_q10": 2.0,
        "ammax_t1": 8.0,
        "ammax_t2": 38.0,
        "e0": 0.01,
        "f0": 0.5,
        "gc": 0.02,
        "dmax": 28.0,
        "albedo": 0.18,
        "transmittance": 0.30
    },
    "Maple Tree": {
        "comp_point25": 45.0,
        "comp_point_q10": 1.5,
        "gm25": 5.0,
        "gm_q10": 2.0,
        "gm_t1": 5.0,
        "gm_t2": 36.0,
        "ammax25": 2.2,
        "ammax_q10": 2.0,
        "ammax_t1": 8.0,
        "ammax_t2": 36.0,
        "e0": 0.017,
        "f0": 0.85,
        "gc": 0.25,
        "dmax": 20.0,
        "albedo": 0.18,
        "transmittance": 0.30
    },
    "Oak Tree": {
        "comp_point25": 45.0,
        "comp_point_q10": 1.5,
        "gm25": 3.0,
        "gm_q10": 2.0,
        "gm_t1": 5.0,
        "gm_t2": 36.0,
        "ammax25": 1.5,
        "ammax_q10": 2.0,
        "ammax_t1": 8.0,
        "ammax_t2": 36.0,
        "e0": 0.017,
        "f0": 0.6,
        "gc": 0.3,
        "dmax": 25.0,
        "albedo": 0.18,
        "transmittance": 0.30
    },
    "Pine Tree": {
        "comp_point25": 45.0,
        "comp_point_q10": 1.5,
        "gm25": 3.0,
        "gm_q10": 2.0,
        "gm_t1": 5.0,
        "gm_t2": 36.0,
        "ammax25": 1.5,
        "ammax_q10": 2.0,
        "ammax_t1": 8.0,
        "ammax_t2": 36.0,
        "e0": 0.017,
        "f0": 0.6,
        "gc": 0.3,
        "dmax": 25.0,
        "albedo": 0.18,
        "transmittance": 0.30
    },
    "Plane Tree": {
        "comp_point25": 45.0,
        "comp_point_q10": 1.5,
        "gm25": 6.0,
        "gm_q10": 2.0,
        "gm_t1": 5.0,
        "gm_t2": 36.0,
        "ammax25": 2.5,
        "ammax_q10": 2.0,
        "ammax_t1": 8.0,
        "ammax_t2": 36.0,
        "e0": 0.017,
        "f0": 0.9,
        "gc": 0.2,
        "dmax": 15.0,
        "albedo": 0.18,
        "transmittance": 0.30
    },
    "Robinia Tree": {
        "comp_point25": 45.0,
        "comp_point_q10": 1.5,
        "gm25": 5.0,
        "gm_q10": 2.0,
        "gm_t1": 5.0,
        "gm_t2": 36.0,
        "ammax25": 2.2,
        "ammax_q10": 2.0,
        "ammax_t1": 8.0,
        "ammax_t2": 36.0,
        "e0": 0.017,
        "f0": 0.85,
        "gc": 0.25,
        "dmax": 20.0,
        "albedo": 0.18,
        "transmittance": 0.30
    },
    "Thuja Tree": {
        "comp_point25": 45.0,
        "comp_point_q10": 1.5,
        "gm25": 2.5,
        "gm_q10": 2.0,
        "gm_t1": 5.0,
        "gm_t2": 36.0,
        "ammax25": 1.0,
        "ammax_q10": 2.0,
        "ammax_t1": 8.0,
        "ammax_t2": 36.0,
        "e0": 0.016,
        "f0": 0.5,
        "gc": 0.35,
        "dmax": 25.0,
        "albedo": 0.18,
        "transmittance": 0.30
    }
}