from classes.landxml_reader import LandXMLReader
from classes.landxml_writer import LandXMLWriter
from classes.mesh2dm_writer import Mesh2DMWriter
from qgis.core import QgsApplication, QgsCoordinateReferenceSystem, QgsMeshLayer

qgs = QgsApplication([], False)
qgs.initQgis()

land_xml_filename = "/home/cahik/Lutra/Example_Clean.xml"


land_xlm = LandXMLWriter()

crs = QgsCoordinateReferenceSystem("EPSG:5514")

lyr_a = QgsMeshLayer("/home/cahik/Lutra/A.2dm", "A", "mdal")
lyr_a.setCrs(crs)
lyr_b = QgsMeshLayer("/home/cahik/Lutra/B.2dm", "B", "mdal")
lyr_b.setCrs(crs)

land_xlm.add_surface(lyr_a)
land_xlm.add_surface(lyr_b)

land_xlm.write("/home/cahik/Lutra/MultiSurface.xml")
