from utilities.dcmgeometrysdk.dcmgeometry.polygons import PolygonGeom
import shapely.wkb as swkb
import shapely.geometry as sg
import shapely.validation as sv
import shapely.ops as so
# polygon is ORM object from sqlalchemy


def create_polygons(polygon, points=None):
    polygons = []
    geometry = swkb.loads(polygon.geom.desc, hex=True)
    # geometry = sv.make_valid(geometry)
    if isinstance(geometry, sg.Polygon):
        geometry = sg.MultiPolygon([geometry])
    if isinstance(geometry, sg.MultiPolygon):
        p = PolygonGeom()

        crs = polygon.geom.srid
        if crs in [7844, 4283]:
            p.coord_decimals = 9
        else:
            p.coord_decimals = 3
        name = polygon.spi
        if len(geometry.geoms) == 1:
            geom = geometry.geoms[0]
            p.create_polygon(geom, points, name, crs)
        else:
            p.geom = None
            p.multipart = True
            geoms = [g for g in geometry.geoms]
            for g in geoms:
                c = PolygonGeom()
                nn = name + '_' + str(geoms.index(g))
                c.create_polygon(g, points, nn, p.crs)
                c.parent = name
                p.part = True
                p.children[c.name] = g
                polygons.append(c)
        polygons.append(p)

    return polygons
