import shapely.validation as sv

def build_json_files(geoms, invalid_poly=False):
    json_dict = {}
    json_dict['points'] = {}
    json_dict['lines'] = {}
    json_dict['polygons'] = {}
    json_dict['line_order'] = {}
    json_dict['stds'] = {}
    for k, v in geoms.points.items():
        json_dict['points'][k] = v.geometry.wkt
    for k, v in geoms.lines.items():
        json_dict['lines'][v.name] = v.geometry.wkt
        json_dict['stds'][v.name] = {'direction_std': v.bearing_std,
                                     'distance_std': v.distance_std}
    for k, v in geoms.polygons.items():
        valid = True
        if len(v.line_order) > 0:
            for lo in v.line_order.values():
                if lo[0].setup_point.name != lo[-1].target_point.name:
                    valid = False
            if v.geometry.is_valid is False and valid is True:
                v.geometry = sv.make_valid(v.geometry)
            if v.geometry.is_valid is True and v.geometry.is_empty is False:
                json_dict['polygons'][k] = v.geometry.wkt

                lineorder = []
                for ring, lo in v.line_order.items():
                    ring_no = int(ring.split('-')[-1])
                    for line in lo:
                        data = {}
                        data['ring'] = ring_no
                        data['bearing'] = line.dd_bearing
                        data['distance'] = line.distance
                        data['@purpose'] = line.line_type
                        data['@name'] = line.name
                        data['reversed'] = line.reversed
                        data['arc'] = line.is_arc
                        data['bearing_type'] = line.azimuth_type
                        data['distance_type'] = line.distance_type
                        lineorder.append(data)
                json_dict['line_order'][k] = lineorder
    return json_dict