import os
import fiona
import geopandas as gpd
from lxml import etree
import pandas as pd
import boto3
from copy import deepcopy
from utilities.dcmgeometrysdk.dcmgeometry.geometry import Geometries
from utilities.dcmgeometrysdk.dcmgeometry.polygons import PolygonGeom
from utilities.dcmgeometrysdk.dcmgeometry.points import PointGeom
from utilities.dcmgeometrysdk.dcmgeometry.lines import LineGeom
from utilities.dcmgeometrysdk.dcmgeometry.arcs import ArcGeom
from utilities.dcmgeometrysdk.dna.dnawriters import DNAWriters
from utilities.dcmgeometrysdk.dna.dnarunner import DNARunner
from utilities.dcmgeometrysdk.dna.dnareaders import DNAReaders
from utilities.dcmgeometrysdk.iuf.iuf_full import parseString
from utilities.dcmgeometrysdk.geometryfunctions.bearingdistancefunctions import remove_stroked_curves
from pathlib import Path
import shapely.geometry as sg
from shapely.ops import nearest_points
from shapely import force_2d
import shapely.ops as so

def build_polygons(data):
    insert_polygons = {}
    for insert in data.INSERT + data.REPLACE:

        for poly in insert.POLYGON:
            for pn in poly.POLYGON_NAME:
                for pi in pn.POLYGON_ITEM:
                    polygon = {}

                    for ph in pi.HEADER:
                        polygon['PFI'] = ph.PFI
                        polygon['table'] = ph.TABLE

                    exist_poly = insert_polygons.get(polygon.get('PFI'))
                    for pa in pi.ATT:
                        att, val = pa.split('=')
                        polygon[att] = val.strip('"')

                    if not exist_poly:
                        exist_poly = polygon
                    connects = exist_poly.get('connects', [])
                    for connect in pi.CONNECT:
                        att, val = connect.split('=')

                        connects.append((att, val.strip('"')))
                    exist_poly['connects'] = connects
                    outers = []
                    for out in pi.OUTER:
                        outer = []
                        for coord in out.XY:
                            x, y = coord.split(',')
                            x = float(x)
                            y = float(y)
                            outer.append((x,y))
                        outers.append(outer)
                    inners = []
                    for inners in pi.INNER:
                        inner = []
                        for coord in inners.XY:
                            print(coord)
                            x, y = coord.split(',')
                            x = float(x)
                            y = float(y)
                            inner.append((x,y))
                        if len(inner) == 0:
                            inners.append(inner)
                    pss = []
                    inner_pols = [sg.Polygon(inner) for inner in inners]
                    for outer in outers:
                        outer_pol = sg.Polygon(shell=outer)
                        holes = []
                        for inner_pol in inner_pols:
                            if inner_pol.within(outer_pol):
                                inner = inner_pol.coords[:]
                                holes.append(inner)
                        if len(holes) > 0:
                            ps = sg.Polygon(shell=outer, holes=holes)
                        else:
                            ps = outer_pol
                        ps = remove_stroked_curves(ps)
                        pss.append(ps)

                    epss = exist_poly.get('geometry')
                    if epss is not None:
                        pss.extend([g for g in epss.geoms])
                    exist_poly['geometry'] = sg.MultiPolygon(pss)
                    exist_poly['type_'] = insert.original_tagname_
                    insert_polygons[exist_poly['PFI']] = exist_poly
    return insert_polygons

def build_a_spatial(data):
    aspatial = {}
    for insert in data.INSERT + data.REPLACE:
        for poly in insert.ASPATIAL:
            for pn in poly.ASPATIAL_NAME:
                for pi in pn.ASPATIAL_ITEM:
                    polygon = {}
                    for ph in pi.HEADER:
                        polygon['PFI'] = ph.PFI
                        polygon['table'] = ph.TABLE

                    exist_poly = aspatial.get(polygon.get('PFI'))
                    for pa in pi.ATT:
                        att, val = pa.split('=')
                        polygon[att] = val.strip('"')
                    if not exist_poly:
                        exist_poly = polygon
                    connects = exist_poly.get('connects', [])
                    for connect in pi.CONNECT:
                        att, val = connect.split('=')
                        connects.append((att, val.strip('"')))
                    exist_poly['connects'] = connects
                    aspatial[exist_poly['PFI']] = exist_poly

    return aspatial

def create_dcm_point(x):
    p = PointGeom()
    #if x.coords_right is None or pd.isna(x.coords_right):
    p.geometry = sg.Point(x.coords_)

    p.original_geom = sg.Point(x.original_coords)
    p.original_crs = 7844
    p.name = str(x.id_)
    p.point_oid = x.id_
    p.point_type = 'boundary'
    if x.distance > 0 and x.dup is False:
        p.ccc = True
    p.crs = 7844
    return p

def create_dcm_polygon(x, points):
    test = PolygonGeom()
    test.create_polygon(x.geometry, name=x.poly_name, crs=7844, points=points, coord_decimals=9)
    test.crs = 7844
    return test

infile_str = '/Users/jamesleversha/Downloads/IUF/inputs/bayside_iuf_data_gda2020_15-jan-2023.xml'
infile = Path(infile_str)
root = etree.parse(infile)
outpath = '/Users/jamesleversha/Downloads/IUF/outputs'




f = [{'coords':tuple(round(float(a),9) for a in i.text.split(','))} for i in root.findall('.//XY')]
df = pd.DataFrame(f)
df = gpd.GeoDataFrame(df, geometry=df.coords.apply(lambda x: sg.Point(x)), crs=7844)
df['original_coords'] = df['coords']

df.to_crs(7855, inplace=True)
df = df.reset_index()[['index','coords', 'original_coords', 'geometry']]
df.rename(columns={'index':'id'}, inplace=True)
df
df['distance'] = -1


in_shape = '/Users/jamesleversha/Downloads/IUF/inputs/parcel_view.gpkg'
gdf = gpd.read_file(in_shape)[['geometry']]
gdf['a'] = 1
gdf2 = gdf.dissolve(by='a')
in_shape = '/Users/jamesleversha/Downloads/IUF/inputs/property_view.gpkg'
gdf3 = gpd.read_file(in_shape)[['geometry']]
gdf3['a'] = 1
gdf4 = gdf3.dissolve(by='a')

gdf = pd.concat([gdf,gdf3])
gdf.drop(columns=['a'], inplace=True)
gdf2 = pd.concat([gdf2,gdf4])
del gdf3
del gdf4

data_values = [(1, 3600, .5, True)]#, (.2, 60, .5, False)]
for dv in data_values:
    if dv[3] is True:
        base_gdf = gdf2
    else:
        base_gdf = gdf
    base_gdf = base_gdf.explode(index_parts=True)
    base_gdf['coords'] = base_gdf.geometry.apply(lambda x: sg.mapping(force_2d(x))['coordinates'])
    base_gdf = base_gdf.explode('coords').explode('coords').reset_index()
    base_gdf['coords'] = base_gdf.coords.apply(lambda li: type(li)(round(x, 9) for x in li))
    base_gdf = gpd.GeoDataFrame(base_gdf, geometry=base_gdf.coords.apply(lambda x: sg.Point(x)), crs=7844)
    base_gdf.to_crs(7855, inplace=True)
    base_gdf['wkt'] = base_gdf.geometry.apply(lambda x: x.wkt)
    base_gdf = base_gdf.reset_index()[['index', 'coords', 'geometry', 'wkt']]
    base_gdf.drop_duplicates(['coords'], keep='first', inplace=True)
    base_gdf.rename(columns={'index': 'id'}, inplace=True)

    cdf = df.drop_duplicates(['original_coords'], keep='first')

    joined_df = gpd.sjoin_nearest(cdf, base_gdf, how='left', max_distance=dv[0], lsuffix='', distance_col='distances')
    joined_df.loc[joined_df.distances.notnull(), 'distance'] = joined_df.distances
    joined_df['dup'] = joined_df.wkt.duplicated(keep=False)
    joined_df['dcm_geom'] = joined_df.apply(create_dcm_point, axis=1)
    joined_df['id_'] = joined_df.id_.astype(str)

    data = parseString(etree.tostring(root), silence=True, print_warnings=False)
    a = build_a_spatial(data)
    i = build_polygons(data)
    explode_df = pd.DataFrame([item for item in i.values()])
    explode_df = gpd.GeoDataFrame(explode_df, geometry=explode_df['geometry'], crs=7844).explode(index_parts=True)
    explode_df['part'] = explode_df.groupby('PFI').cumcount() + 1
    explode_df['poly_name'] = explode_df.PFI.astype(str) + '_' + explode_df.part.astype(str)
    explode_df = explode_df[['PFI', 'poly_name', 'geometry']].reset_index(drop=True)

    all_geoms = Geometries()
    all_geoms.crs = 7844
    all_geoms.points = {i.name: i for i in joined_df.dcm_geom.to_list()}
    explode_df['dcm_polygon'] = explode_df.apply(lambda x: create_dcm_polygon(x, all_geoms.points), axis=1)
    all_geoms.polygons = {i.name: i for i in explode_df.dcm_polygon.to_list()}
    all_geoms.add_lines_from_polygons()

    if dv == data_values[-1]:
       all_geoms.gen_graph_from_points_lines(add_unconnected=True, add_gen_lines=True, join_branches=True)

    for k, v in all_geoms.points.items():
        v: PointGeom
        x = joined_df.loc[joined_df['id_'] == k]
        x = x.iloc[0]
        if pd.isna(x.coords_right) is False and v.ccc is True:
            v.set_new_geometry(sg.Point(x.coords_right))
            v.set_associated_id(x.id_right, x.distance)
        all_geoms.points[k] = v

    all_geoms.crs = 7844
    all_geoms.survey_year = 2022

    #
    for k, v in all_geoms.lines.items():
        v: LineGeom
        points = all_geoms.points
        sp = v.setup_point.name
        tp = v.target_point.name
        if points.get(sp).ccc is True and points.get(tp).ccc is True:
            v.line_type = 'Ignored'
            v.distance_type = 'Ignored'
            v.azimuth_type = 'Ignored'
        v: LineGeom
        v.bearing_std = dv[1]
        v.distance_std = dv[2]

    f = DNAWriters(all_geoms, outpath, out_datum=7844, ignore_types=('Ignored', 'BranchConnection'),
                   profile_location='/Users/jamesleversha/PycharmProjects/DigitalCadastre/utilities/dcmgeometrysdk/resources/aprioris.json')
    msrs, stns = f.write_stn_msr_file('test', outpath)

    print('running dna')
    runner = DNARunner('/opt/dynadjust', filename='tester', output_dir=outpath, docker=True, host_directory=outpath,
                       mount_dir='/mnt/', max_iter=50, iter_thresh=.02, multi_thread=True)
    runner.build_execution_cmd(msrs, stns)
    runner.write_execution_cmd_to_file()
    result = runner.run_dna_via_subprocesses(msrs, stns)
    print('finished dna')
    #
    z = DNAReaders(result, stn_corrections=True)
    all_geoms.update_coords_from_dna_reader(z, use_xml=False, loops=False)

    nd = [{'coords': (float(point.original_geom.x),float(point.original_geom.y)),
           'new_coords': (float(point.geometry.x),float(point.geometry.y)),
           'id': point.name} for point in all_geoms.points.values()]
    ndf = pd.DataFrame(nd)
    # ndf = gpd.GeoDataFrame(ndf, geometry=ndf['coords'].apply(lambda x: sg.Point(x)), crs=7844)
    # ndf.to_crs(7855, inplace=True)
    # ndf = gpd.sjoin_nearest(ndf, base_gdf, how='left', max_distance=.2,distance_col='distance')
    # ndf = pd.DataFrame(ndf)
    # ndf.sort_values(by='distance', inplace=True)
    # ndf['dup'] = ndf['coords_right'].duplicated(keep='first')
    # ndf.loc[ndf.dup.isin([True]), ['coords_right']] = None
    #
    # if dv == data_values[-1]:
    #     for item in ndf.loc[ndf.coords_right.notnull()].itertuples():
    #         point = all_geoms.points[item.id_left]
    #         point.geometry = sg.Point((round(x, 9) for x in item.coords_right))
    #         all_geoms.points[item.id_left] = point
    #
    #     all_geoms.update_geometries(loops=False)
    #
    # ndf.loc[ndf.coords_right.notnull(), 'new_coords'] = ndf.coords_right

    df = pd.merge(df, ndf, left_on='original_coords', right_on='coords', how='left', suffixes=('', '_right'))
    df['coords'] = df['new_coords']
    df = df[['id', 'coords', 'original_coords', 'distance']]
    df['coords'] = df.coords.apply(lambda li: type(li)(round(x, 9) for x in li))
    df = gpd.GeoDataFrame(df, geometry=df['coords'].apply(lambda x: sg.Point(x)), crs=7844)
    df.to_crs(7855, inplace=True)
    df['distance'] = -1

    for i in root.findall('.//XY'):
        xy = i.text.split(',')
        xy = tuple(float(x) for x in xy)
        new_xy = df.loc[df.original_coords == xy]['coords']
        if new_xy.size > 0:
            new_xy = new_xy.to_list()[0]
            new_xy = ','.join([f'{n:.9f}' for n in new_xy])
            i.text = new_xy
    df['original_coords'] = df['coords']

all_geoms.crs = 7844
all_geoms.survey_number = 'tester'
all_geoms.write_geom_to_file(location=outpath)

outfile = infile_str.replace('.xml', '-output.xml').replace('inputs', 'outputs')
root.write(outfile, pretty_print=True)