#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Tue Jan 17 16:27:23 2023 by generateDS.py version 2.41.1.
# Python 3.9.15 | packaged by conda-forge | (main, Nov 22 2022, 08:48:25)  [Clang 14.0.6 ]
#
# Command line options:
#   ('-o', 'iuf_full.py')
#   ('-s', 'iuf-full-app1.py')
#   ('--member-specs', 'dict')
#
# Command line arguments:
#   iuf_full.xsd
#
# Command line:
#   /opt/homebrew/anaconda3/envs/geo-39/bin/generateds -o "iuf_full.py" -s "iuf-full-app1.py" --member-specs="dict" iuf_full.xsd
#
# Current working directory (os.getcwd()):
#   iuf
#

import sys
try:
    ModulenotfoundExp_ = ModuleNotFoundError
except NameError:
    ModulenotfoundExp_ = ImportError
from six.moves import zip_longest
import os
import re as re_
import base64
import datetime as datetime_
import decimal as decimal_
from lxml import etree as etree_


Validate_simpletypes_ = True
SaveElementTreeNode = True
TagNamePrefix = ""
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    try:
        if isinstance(infile, os.PathLike):
            infile = os.path.join(infile)
    except AttributeError:
        pass
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    element = etree_.fromstring(instring, parser=parser, **kwargs)
    return element

#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for an example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#
# Additionally, the generatedsnamespaces module can contain a python
# dictionary named GenerateDSNamespaceTypePrefixes that associates element
# types with the namespace prefixes that are to be added to the
# "xsi:type" attribute value.  See the _exportAttributes method of
# any generated element type and the generation of "xsi:type" for an
# example of the use of this table.
# An example table:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceTypePrefixes = {
#         "ElementtypeC": "aaa:",
#         "ElementtypeD": "bbb:",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ModulenotfoundExp_ :
    GenerateDSNamespaceDefs_ = {}
try:
    from generatedsnamespaces import GenerateDSNamespaceTypePrefixes as GenerateDSNamespaceTypePrefixes_
except ModulenotfoundExp_ :
    GenerateDSNamespaceTypePrefixes_ = {}

#
# You can replace the following class definition by defining an
# importable module named "generatedscollector" containing a class
# named "GdsCollector".  See the default class definition below for
# clues about the possible content of that class.
#
try:
    from generatedscollector import GdsCollector as GdsCollector_
except ModulenotfoundExp_ :

    class GdsCollector_(object):

        def __init__(self, messages=None):
            if messages is None:
                self.messages = []
            else:
                self.messages = messages

        def add_message(self, msg):
            self.messages.append(msg)

        def get_messages(self):
            return self.messages

        def clear_messages(self):
            self.messages = []

        def print_messages(self):
            for msg in self.messages:
                print("Warning: {}".format(msg))

        def write_messages(self, outstream):
            for msg in self.messages:
                outstream.write("Warning: {}\n".format(msg))


#
# The super-class for enum types
#

try:
    from enum import Enum
except ModulenotfoundExp_ :
    Enum = object

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ModulenotfoundExp_ as exp:
    try:
        from generatedssupersuper import GeneratedsSuperSuper
    except ModulenotfoundExp_ as exp:
        class GeneratedsSuperSuper(object):
            pass
    
    class GeneratedsSuper(GeneratedsSuperSuper):
        __hash__ = object.__hash__
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def __str__(self):
            settings = {
                'str_pretty_print': True,
                'str_indent_level': 0,
                'str_namespaceprefix': '',
                'str_name': self.__class__.__name__,
                'str_namespacedefs': '',
            }
            for n in settings:
                if hasattr(self, n):
                    settings[n] = getattr(self, n)
            if sys.version_info.major == 2:
                from StringIO import StringIO
            else:
                from io import StringIO
            output = StringIO()
            self.export(
                output,
                settings['str_indent_level'],
                pretty_print=settings['str_pretty_print'],
                namespaceprefix_=settings['str_namespaceprefix'],
                name_=settings['str_name'],
                namespacedef_=settings['str_namespacedefs']
            )
            strval = output.getvalue()
            output.close()
            return strval
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_parse_string(self, input_data, node=None, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data).decode('ascii')
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % int(input_data)
        def gds_parse_integer(self, input_data, node=None, input_name=''):
            try:
                ival = int(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires integer value: %s' % exp)
            return ival
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            try:
                value = int(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires integer value')
            return value
        def gds_format_integer_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integer values')
            return values
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % float(input_data)).rstrip('0')
        def gds_parse_float(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires float or double value: %s' % exp)
            return fval_
        def gds_validate_float(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires float value')
            return value
        def gds_format_float_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of float values')
            return values
        def gds_format_decimal(self, input_data, input_name=''):
            return_value = '%s' % input_data
            if '.' in return_value:
                return_value = return_value.rstrip('0')
                if return_value.endswith('.'):
                    return_value = return_value.rstrip('.')
            return return_value
        def gds_parse_decimal(self, input_data, node=None, input_name=''):
            try:
                decimal_value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return decimal_value
        def gds_validate_decimal(self, input_data, node=None, input_name=''):
            try:
                value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return value
        def gds_format_decimal_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return ' '.join([self.gds_format_decimal(item) for item in input_data])
        def gds_validate_decimal_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    decimal_.Decimal(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of decimal values')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_parse_double(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires double or float value: %s' % exp)
            return fval_
        def gds_validate_double(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires double or float value')
            return value
        def gds_format_double_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(
                        node, 'Requires sequence of double or float values')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_parse_boolean(self, input_data, node=None, input_name=''):
            input_data = input_data.strip()
            if input_data in ('true', '1'):
                bval = True
            elif input_data in ('false', '0'):
                bval = False
            else:
                raise_parse_error(node, 'Requires boolean value')
            return bval
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            if input_data not in (True, 1, False, 0, ):
                raise_parse_error(
                    node,
                    'Requires boolean value '
                    '(one of True, 1, False, 0)')
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                value = self.gds_parse_boolean(value, node, input_name)
                if value not in (True, 1, False, 0, ):
                    raise_parse_error(
                        node,
                        'Requires sequence of boolean values '
                        '(one of True, 1, False, 0)')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (
                    time_parts[0], "{}".format(micro_seconds).rjust(6, "0"), )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.
            # The target value must match at least one of the patterns
            # in order for the test to succeed.
            found1 = True
            target = str(target)
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    mo = re_.search(patterns2, target)
                    if mo is not None and len(mo.group(0)) == len(target):
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_check_cardinality_(
                self, value, input_name,
                min_occurs=0, max_occurs=1, required=None):
            if value is None:
                length = 0
            elif isinstance(value, list):
                length = len(value)
            else:
                length = 1
            if required is not None :
                if required and length < 1:
                    self.gds_collector_.add_message(
                        "Required value {}{} is missing".format(
                            input_name, self.gds_get_node_lineno_()))
            if length < min_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is below "
                    "the minimum allowed, "
                    "expected at least {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        min_occurs, length))
            elif length > max_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is above "
                    "the maximum allowed, "
                    "expected at most {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        max_occurs, length))
        def gds_validate_builtin_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value, input_name=input_name)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_validate_defined_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            # provide default value in case option --disable-xml is used.
            content = ""
            content = etree_.tostring(node, encoding="unicode")
            return content
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.items()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                if ExternalEncoding:
                    encoding = ExternalEncoding
                else:
                    encoding = 'utf-8'
                return instring.encode(encoding)
            else:
                return instring
        @staticmethod
        def convert_unicode(instring):
            if isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode('utf8')
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result
        def __eq__(self, other):
            def excl_select_objs_(obj):
                return (obj[0] != 'parent_object_' and
                        obj[0] != 'gds_collector_')
            if type(self) != type(other):
                return False
            return all(x == y for x, y in zip_longest(
                filter(excl_select_objs_, self.__dict__.items()),
                filter(excl_select_objs_, other.__dict__.items())))
        def __ne__(self, other):
            return not self.__eq__(other)
        # Django ETL transform hooks.
        def gds_djo_etl_transform(self):
            pass
        def gds_djo_etl_transform_db_obj(self, dbobj):
            pass
        # SQLAlchemy ETL transform hooks.
        def gds_sqa_etl_transform(self):
            return 0, None
        def gds_sqa_etl_transform_db_obj(self, dbobj):
            pass
        def gds_get_node_lineno_(self):
            if (hasattr(self, "gds_elementtree_node_") and
                    self.gds_elementtree_node_ is not None):
                return ' near line {}'.format(
                    self.gds_elementtree_node_.sourceline)
            else:
                return ""
    
    
    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = ''
# Set this to false in order to deactivate during export, the use of
# name space prefixes captured from the input document.
UseCapturedNS_ = True
CapturedNsmap_ = {}
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    s1 = s1.replace('\n', '&#10;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        if prefix == 'xml':
            namespace = 'http://www.w3.org/XML/1998/namespace'
        else:
            namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


def encode_str_2_3(instr):
    return instr


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if node is not None:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace,
               pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name_=name,
                pretty_print=pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name,
                base64.b64encode(self.value),
                self.name))
    def to_etree(self, element, mapping_=None, reverse_mapping_=None, nsmap_=None):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(
                element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self, mapping_=None, reverse_mapping_=None, nsmap_=None):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0,
            optional=0, child_attrs=None, choice=None):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container
    def set_child_attrs(self, child_attrs): self.child_attrs = child_attrs
    def get_child_attrs(self): return self.child_attrs
    def set_choice(self, choice): self.choice = choice
    def get_choice(self): return self.choice
    def set_optional(self, optional): self.optional = optional
    def get_optional(self): return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class IUF(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = {
        'DESCRIPTION': MemberSpec_('DESCRIPTION', 'DESCRIPTION', 1, 0, {'maxOccurs': 'unbounded', 'name': 'DESCRIPTION', 'ref': 'DESCRIPTION', 'type': 'DESCRIPTION'}, None),
        'INSERT': MemberSpec_('INSERT', 'INSERT', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'INSERT', 'ref': 'INSERT', 'type': 'INSERT'}, None),
        'REPLACE': MemberSpec_('REPLACE', 'REPLACE', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'REPLACE', 'ref': 'REPLACE', 'type': 'REPLACE'}, None),
        'DELETE': MemberSpec_('DELETE', 'DELETE', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'DELETE', 'ref': 'DELETE', 'type': 'DELETE'}, None),
    }
    subclass = None
    superclass = None
    def __init__(self, DESCRIPTION=None, INSERT=None, REPLACE=None, DELETE=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if DESCRIPTION is None:
            self.DESCRIPTION = []
        else:
            self.DESCRIPTION = DESCRIPTION
        self.DESCRIPTION_nsprefix_ = None
        if INSERT is None:
            self.INSERT = []
        else:
            self.INSERT = INSERT
        self.INSERT_nsprefix_ = None
        if REPLACE is None:
            self.REPLACE = []
        else:
            self.REPLACE = REPLACE
        self.REPLACE_nsprefix_ = None
        if DELETE is None:
            self.DELETE = []
        else:
            self.DELETE = DELETE
        self.DELETE_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, IUF)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IUF.subclass:
            return IUF.subclass(*args_, **kwargs_)
        else:
            return IUF(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_DESCRIPTION(self):
        return self.DESCRIPTION
    def set_DESCRIPTION(self, DESCRIPTION):
        self.DESCRIPTION = DESCRIPTION
    def add_DESCRIPTION(self, value):
        self.DESCRIPTION.append(value)
    def insert_DESCRIPTION_at(self, index, value):
        self.DESCRIPTION.insert(index, value)
    def replace_DESCRIPTION_at(self, index, value):
        self.DESCRIPTION[index] = value
    def get_INSERT(self):
        return self.INSERT
    def set_INSERT(self, INSERT):
        self.INSERT = INSERT
    def add_INSERT(self, value):
        self.INSERT.append(value)
    def insert_INSERT_at(self, index, value):
        self.INSERT.insert(index, value)
    def replace_INSERT_at(self, index, value):
        self.INSERT[index] = value
    def get_REPLACE(self):
        return self.REPLACE
    def set_REPLACE(self, REPLACE):
        self.REPLACE = REPLACE
    def add_REPLACE(self, value):
        self.REPLACE.append(value)
    def insert_REPLACE_at(self, index, value):
        self.REPLACE.insert(index, value)
    def replace_REPLACE_at(self, index, value):
        self.REPLACE[index] = value
    def get_DELETE(self):
        return self.DELETE
    def set_DELETE(self, DELETE):
        self.DELETE = DELETE
    def add_DELETE(self, value):
        self.DELETE.append(value)
    def insert_DELETE_at(self, index, value):
        self.DELETE.insert(index, value)
    def replace_DELETE_at(self, index, value):
        self.DELETE[index] = value
    def _hasContent(self):
        if (
            self.DESCRIPTION or
            self.INSERT or
            self.REPLACE or
            self.DELETE
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='IUF', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('IUF')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'IUF':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='IUF')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='IUF', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='IUF'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='IUF', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for DESCRIPTION_ in self.DESCRIPTION:
            namespaceprefix_ = self.DESCRIPTION_nsprefix_ + ':' if (UseCapturedNS_ and self.DESCRIPTION_nsprefix_) else ''
            DESCRIPTION_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DESCRIPTION', pretty_print=pretty_print)
        for INSERT_ in self.INSERT:
            namespaceprefix_ = self.INSERT_nsprefix_ + ':' if (UseCapturedNS_ and self.INSERT_nsprefix_) else ''
            INSERT_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='INSERT', pretty_print=pretty_print)
        for REPLACE_ in self.REPLACE:
            namespaceprefix_ = self.REPLACE_nsprefix_ + ':' if (UseCapturedNS_ and self.REPLACE_nsprefix_) else ''
            REPLACE_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='REPLACE', pretty_print=pretty_print)
        for DELETE_ in self.DELETE:
            namespaceprefix_ = self.DELETE_nsprefix_ + ':' if (UseCapturedNS_ and self.DELETE_nsprefix_) else ''
            DELETE_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DELETE', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'DESCRIPTION':
            obj_ = DESCRIPTION.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DESCRIPTION.append(obj_)
            obj_.original_tagname_ = 'DESCRIPTION'
        elif nodeName_ == 'INSERT':
            obj_ = INSERT.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.INSERT.append(obj_)
            obj_.original_tagname_ = 'INSERT'
        elif nodeName_ == 'REPLACE':
            obj_ = REPLACE.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.REPLACE.append(obj_)
            obj_.original_tagname_ = 'REPLACE'
        elif nodeName_ == 'DELETE':
            obj_ = DELETE.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DELETE.append(obj_)
            obj_.original_tagname_ = 'DELETE'
# end class IUF


class DESCRIPTION(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = {
        'AUTHORITY': MemberSpec_('AUTHORITY', 'xs:string', 1, 0, {'maxOccurs': 'unbounded', 'name': 'AUTHORITY', 'ref': 'AUTHORITY', 'type': 'xs:string'}, None),
        'DATASET': MemberSpec_('DATASET', 'xs:string', 1, 0, {'maxOccurs': 'unbounded', 'name': 'DATASET', 'ref': 'DATASET', 'type': 'xs:string'}, None),
        'EXPORT': MemberSpec_('EXPORT', 'EXPORT', 1, 0, {'maxOccurs': 'unbounded', 'name': 'EXPORT', 'ref': 'EXPORT', 'type': 'EXPORT'}, None),
    }
    subclass = None
    superclass = None
    def __init__(self, AUTHORITY=None, DATASET=None, EXPORT=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if AUTHORITY is None:
            self.AUTHORITY = []
        else:
            self.AUTHORITY = AUTHORITY
        self.AUTHORITY_nsprefix_ = None
        if DATASET is None:
            self.DATASET = []
        else:
            self.DATASET = DATASET
        self.DATASET_nsprefix_ = None
        if EXPORT is None:
            self.EXPORT = []
        else:
            self.EXPORT = EXPORT
        self.EXPORT_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DESCRIPTION)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DESCRIPTION.subclass:
            return DESCRIPTION.subclass(*args_, **kwargs_)
        else:
            return DESCRIPTION(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_AUTHORITY(self):
        return self.AUTHORITY
    def set_AUTHORITY(self, AUTHORITY):
        self.AUTHORITY = AUTHORITY
    def add_AUTHORITY(self, value):
        self.AUTHORITY.append(value)
    def insert_AUTHORITY_at(self, index, value):
        self.AUTHORITY.insert(index, value)
    def replace_AUTHORITY_at(self, index, value):
        self.AUTHORITY[index] = value
    def get_DATASET(self):
        return self.DATASET
    def set_DATASET(self, DATASET):
        self.DATASET = DATASET
    def add_DATASET(self, value):
        self.DATASET.append(value)
    def insert_DATASET_at(self, index, value):
        self.DATASET.insert(index, value)
    def replace_DATASET_at(self, index, value):
        self.DATASET[index] = value
    def get_EXPORT(self):
        return self.EXPORT
    def set_EXPORT(self, EXPORT):
        self.EXPORT = EXPORT
    def add_EXPORT(self, value):
        self.EXPORT.append(value)
    def insert_EXPORT_at(self, index, value):
        self.EXPORT.insert(index, value)
    def replace_EXPORT_at(self, index, value):
        self.EXPORT[index] = value
    def _hasContent(self):
        if (
            self.AUTHORITY or
            self.DATASET or
            self.EXPORT
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DESCRIPTION', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DESCRIPTION')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DESCRIPTION':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DESCRIPTION')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DESCRIPTION', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DESCRIPTION'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DESCRIPTION', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for AUTHORITY_ in self.AUTHORITY:
            namespaceprefix_ = self.AUTHORITY_nsprefix_ + ':' if (UseCapturedNS_ and self.AUTHORITY_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAUTHORITY>%s</%sAUTHORITY>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(AUTHORITY_), input_name='AUTHORITY')), namespaceprefix_ , eol_))
        for DATASET_ in self.DATASET:
            namespaceprefix_ = self.DATASET_nsprefix_ + ':' if (UseCapturedNS_ and self.DATASET_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDATASET>%s</%sDATASET>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(DATASET_), input_name='DATASET')), namespaceprefix_ , eol_))
        for EXPORT_ in self.EXPORT:
            namespaceprefix_ = self.EXPORT_nsprefix_ + ':' if (UseCapturedNS_ and self.EXPORT_nsprefix_) else ''
            EXPORT_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='EXPORT', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'AUTHORITY':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AUTHORITY')
            value_ = self.gds_validate_string(value_, node, 'AUTHORITY')
            self.AUTHORITY.append(value_)
            self.AUTHORITY_nsprefix_ = child_.prefix
        elif nodeName_ == 'DATASET':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'DATASET')
            value_ = self.gds_validate_string(value_, node, 'DATASET')
            self.DATASET.append(value_)
            self.DATASET_nsprefix_ = child_.prefix
        elif nodeName_ == 'EXPORT':
            obj_ = EXPORT.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.EXPORT.append(obj_)
            obj_.original_tagname_ = 'EXPORT'
# end class DESCRIPTION


class EXPORT(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = {
        'SCHEMA': MemberSpec_('SCHEMA', 'xs:string', 0, 0, {'use': 'required', 'name': 'SCHEMA'}),
        'LGA': MemberSpec_('LGA', 'xs:string', 0, 0, {'use': 'required', 'name': 'LGA'}),
        'FROM_DATE': MemberSpec_('FROM_DATE', 'xs:string', 0, 0, {'use': 'required', 'name': 'FROM_DATE'}),
        'TO_DATE': MemberSpec_('TO_DATE', 'xs:string', 0, 0, {'use': 'required', 'name': 'TO_DATE'}),
        'FORMAT': MemberSpec_('FORMAT', 'xs:string', 0, 0, {'use': 'required', 'name': 'FORMAT'}),
        'DATE': MemberSpec_('DATE', 'xs:string', 0, 0, {'use': 'required', 'name': 'DATE'}),
        'BY': MemberSpec_('BY', 'xs:string', 0, 0, {'use': 'required', 'name': 'BY'}),
        'valueOf_': MemberSpec_('valueOf_', [], 0),
    }
    subclass = None
    superclass = None
    def __init__(self, SCHEMA=None, LGA=None, FROM_DATE=None, TO_DATE=None, FORMAT=None, DATE=None, BY=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.SCHEMA = _cast(None, SCHEMA)
        self.SCHEMA_nsprefix_ = None
        self.LGA = _cast(None, LGA)
        self.LGA_nsprefix_ = None
        self.FROM_DATE = _cast(None, FROM_DATE)
        self.FROM_DATE_nsprefix_ = None
        self.TO_DATE = _cast(None, TO_DATE)
        self.TO_DATE_nsprefix_ = None
        self.FORMAT = _cast(None, FORMAT)
        self.FORMAT_nsprefix_ = None
        self.DATE = _cast(None, DATE)
        self.DATE_nsprefix_ = None
        self.BY = _cast(None, BY)
        self.BY_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, EXPORT)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if EXPORT.subclass:
            return EXPORT.subclass(*args_, **kwargs_)
        else:
            return EXPORT(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_SCHEMA(self):
        return self.SCHEMA
    def set_SCHEMA(self, SCHEMA):
        self.SCHEMA = SCHEMA
    def get_LGA(self):
        return self.LGA
    def set_LGA(self, LGA):
        self.LGA = LGA
    def get_FROM_DATE(self):
        return self.FROM_DATE
    def set_FROM_DATE(self, FROM_DATE):
        self.FROM_DATE = FROM_DATE
    def get_TO_DATE(self):
        return self.TO_DATE
    def set_TO_DATE(self, TO_DATE):
        self.TO_DATE = TO_DATE
    def get_FORMAT(self):
        return self.FORMAT
    def set_FORMAT(self, FORMAT):
        self.FORMAT = FORMAT
    def get_DATE(self):
        return self.DATE
    def set_DATE(self, DATE):
        self.DATE = DATE
    def get_BY(self):
        return self.BY
    def set_BY(self, BY):
        self.BY = BY
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def _hasContent(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='EXPORT', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('EXPORT')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'EXPORT':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='EXPORT')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='EXPORT'):
        if self.SCHEMA is not None and 'SCHEMA' not in already_processed:
            already_processed.add('SCHEMA')
            outfile.write(' SCHEMA=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.SCHEMA), input_name='SCHEMA')), ))
        if self.LGA is not None and 'LGA' not in already_processed:
            already_processed.add('LGA')
            outfile.write(' LGA=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.LGA), input_name='LGA')), ))
        if self.FROM_DATE is not None and 'FROM_DATE' not in already_processed:
            already_processed.add('FROM_DATE')
            outfile.write(' FROM_DATE=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.FROM_DATE), input_name='FROM_DATE')), ))
        if self.TO_DATE is not None and 'TO_DATE' not in already_processed:
            already_processed.add('TO_DATE')
            outfile.write(' TO_DATE=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.TO_DATE), input_name='TO_DATE')), ))
        if self.FORMAT is not None and 'FORMAT' not in already_processed:
            already_processed.add('FORMAT')
            outfile.write(' FORMAT=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.FORMAT), input_name='FORMAT')), ))
        if self.DATE is not None and 'DATE' not in already_processed:
            already_processed.add('DATE')
            outfile.write(' DATE=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.DATE), input_name='DATE')), ))
        if self.BY is not None and 'BY' not in already_processed:
            already_processed.add('BY')
            outfile.write(' BY=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.BY), input_name='BY')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='EXPORT', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('SCHEMA', node)
        if value is not None and 'SCHEMA' not in already_processed:
            already_processed.add('SCHEMA')
            self.SCHEMA = value
        value = find_attr_value_('LGA', node)
        if value is not None and 'LGA' not in already_processed:
            already_processed.add('LGA')
            self.LGA = value
        value = find_attr_value_('FROM_DATE', node)
        if value is not None and 'FROM_DATE' not in already_processed:
            already_processed.add('FROM_DATE')
            self.FROM_DATE = value
        value = find_attr_value_('TO_DATE', node)
        if value is not None and 'TO_DATE' not in already_processed:
            already_processed.add('TO_DATE')
            self.TO_DATE = value
        value = find_attr_value_('FORMAT', node)
        if value is not None and 'FORMAT' not in already_processed:
            already_processed.add('FORMAT')
            self.FORMAT = value
        value = find_attr_value_('DATE', node)
        if value is not None and 'DATE' not in already_processed:
            already_processed.add('DATE')
            self.DATE = value
        value = find_attr_value_('BY', node)
        if value is not None and 'BY' not in already_processed:
            already_processed.add('BY')
            self.BY = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class EXPORT


class INSERT(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = {
        'POLYGON': MemberSpec_('POLYGON', 'POLYGON', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'POLYGON', 'ref': 'POLYGON', 'type': 'POLYGON'}, None),
        'LINE': MemberSpec_('LINE', 'LINE', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'LINE', 'ref': 'LINE', 'type': 'LINE'}, None),
        'POINT': MemberSpec_('POINT', 'POINT', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'POINT', 'ref': 'POINT', 'type': 'POINT'}, None),
        'ASPATIAL': MemberSpec_('ASPATIAL', 'ASPATIAL', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'ASPATIAL', 'ref': 'ASPATIAL', 'type': 'ASPATIAL'}, None),
    }
    subclass = None
    superclass = None
    def __init__(self, POLYGON=None, LINE=None, POINT=None, ASPATIAL=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if POLYGON is None:
            self.POLYGON = []
        else:
            self.POLYGON = POLYGON
        self.POLYGON_nsprefix_ = None
        if LINE is None:
            self.LINE = []
        else:
            self.LINE = LINE
        self.LINE_nsprefix_ = None
        if POINT is None:
            self.POINT = []
        else:
            self.POINT = POINT
        self.POINT_nsprefix_ = None
        if ASPATIAL is None:
            self.ASPATIAL = []
        else:
            self.ASPATIAL = ASPATIAL
        self.ASPATIAL_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, INSERT)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if INSERT.subclass:
            return INSERT.subclass(*args_, **kwargs_)
        else:
            return INSERT(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_POLYGON(self):
        return self.POLYGON
    def set_POLYGON(self, POLYGON):
        self.POLYGON = POLYGON
    def add_POLYGON(self, value):
        self.POLYGON.append(value)
    def insert_POLYGON_at(self, index, value):
        self.POLYGON.insert(index, value)
    def replace_POLYGON_at(self, index, value):
        self.POLYGON[index] = value
    def get_LINE(self):
        return self.LINE
    def set_LINE(self, LINE):
        self.LINE = LINE
    def add_LINE(self, value):
        self.LINE.append(value)
    def insert_LINE_at(self, index, value):
        self.LINE.insert(index, value)
    def replace_LINE_at(self, index, value):
        self.LINE[index] = value
    def get_POINT(self):
        return self.POINT
    def set_POINT(self, POINT):
        self.POINT = POINT
    def add_POINT(self, value):
        self.POINT.append(value)
    def insert_POINT_at(self, index, value):
        self.POINT.insert(index, value)
    def replace_POINT_at(self, index, value):
        self.POINT[index] = value
    def get_ASPATIAL(self):
        return self.ASPATIAL
    def set_ASPATIAL(self, ASPATIAL):
        self.ASPATIAL = ASPATIAL
    def add_ASPATIAL(self, value):
        self.ASPATIAL.append(value)
    def insert_ASPATIAL_at(self, index, value):
        self.ASPATIAL.insert(index, value)
    def replace_ASPATIAL_at(self, index, value):
        self.ASPATIAL[index] = value
    def _hasContent(self):
        if (
            self.POLYGON or
            self.LINE or
            self.POINT or
            self.ASPATIAL
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='INSERT', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('INSERT')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'INSERT':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='INSERT')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='INSERT', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='INSERT'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='INSERT', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for POLYGON_ in self.POLYGON:
            namespaceprefix_ = self.POLYGON_nsprefix_ + ':' if (UseCapturedNS_ and self.POLYGON_nsprefix_) else ''
            POLYGON_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='POLYGON', pretty_print=pretty_print)
        for LINE_ in self.LINE:
            namespaceprefix_ = self.LINE_nsprefix_ + ':' if (UseCapturedNS_ and self.LINE_nsprefix_) else ''
            LINE_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='LINE', pretty_print=pretty_print)
        for POINT_ in self.POINT:
            namespaceprefix_ = self.POINT_nsprefix_ + ':' if (UseCapturedNS_ and self.POINT_nsprefix_) else ''
            POINT_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='POINT', pretty_print=pretty_print)
        for ASPATIAL_ in self.ASPATIAL:
            namespaceprefix_ = self.ASPATIAL_nsprefix_ + ':' if (UseCapturedNS_ and self.ASPATIAL_nsprefix_) else ''
            ASPATIAL_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ASPATIAL', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'POLYGON':
            obj_ = POLYGON.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.POLYGON.append(obj_)
            obj_.original_tagname_ = 'POLYGON'
        elif nodeName_ == 'LINE':
            obj_ = LINE.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.LINE.append(obj_)
            obj_.original_tagname_ = 'LINE'
        elif nodeName_ == 'POINT':
            obj_ = POINT.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.POINT.append(obj_)
            obj_.original_tagname_ = 'POINT'
        elif nodeName_ == 'ASPATIAL':
            obj_ = ASPATIAL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ASPATIAL.append(obj_)
            obj_.original_tagname_ = 'ASPATIAL'
# end class INSERT


class POLYGON(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = {
        'POLYGON_NAME': MemberSpec_('POLYGON_NAME', 'POLYGON_NAME', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'POLYGON_NAME', 'ref': 'POLYGON_NAME', 'type': 'POLYGON_NAME'}, None),
    }
    subclass = None
    superclass = None
    def __init__(self, POLYGON_NAME=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if POLYGON_NAME is None:
            self.POLYGON_NAME = []
        else:
            self.POLYGON_NAME = POLYGON_NAME
        self.POLYGON_NAME_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POLYGON)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POLYGON.subclass:
            return POLYGON.subclass(*args_, **kwargs_)
        else:
            return POLYGON(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_POLYGON_NAME(self):
        return self.POLYGON_NAME
    def set_POLYGON_NAME(self, POLYGON_NAME):
        self.POLYGON_NAME = POLYGON_NAME
    def add_POLYGON_NAME(self, value):
        self.POLYGON_NAME.append(value)
    def insert_POLYGON_NAME_at(self, index, value):
        self.POLYGON_NAME.insert(index, value)
    def replace_POLYGON_NAME_at(self, index, value):
        self.POLYGON_NAME[index] = value
    def _hasContent(self):
        if (
            self.POLYGON_NAME
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='POLYGON', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POLYGON')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POLYGON':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POLYGON')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POLYGON', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POLYGON'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='POLYGON', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for POLYGON_NAME_ in self.POLYGON_NAME:
            namespaceprefix_ = self.POLYGON_NAME_nsprefix_ + ':' if (UseCapturedNS_ and self.POLYGON_NAME_nsprefix_) else ''
            POLYGON_NAME_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='POLYGON_NAME', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'POLYGON_NAME':
            obj_ = POLYGON_NAME.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.POLYGON_NAME.append(obj_)
            obj_.original_tagname_ = 'POLYGON_NAME'
# end class POLYGON


class POLYGON_NAME(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = {
        'POLYGON_ITEM': MemberSpec_('POLYGON_ITEM', 'POLYGON_ITEM', 1, 0, {'maxOccurs': 'unbounded', 'name': 'POLYGON_ITEM', 'ref': 'POLYGON_ITEM', 'type': 'POLYGON_ITEM'}, None),
    }
    subclass = None
    superclass = None
    def __init__(self, POLYGON_ITEM=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if POLYGON_ITEM is None:
            self.POLYGON_ITEM = []
        else:
            self.POLYGON_ITEM = POLYGON_ITEM
        self.POLYGON_ITEM_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POLYGON_NAME)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POLYGON_NAME.subclass:
            return POLYGON_NAME.subclass(*args_, **kwargs_)
        else:
            return POLYGON_NAME(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_POLYGON_ITEM(self):
        return self.POLYGON_ITEM
    def set_POLYGON_ITEM(self, POLYGON_ITEM):
        self.POLYGON_ITEM = POLYGON_ITEM
    def add_POLYGON_ITEM(self, value):
        self.POLYGON_ITEM.append(value)
    def insert_POLYGON_ITEM_at(self, index, value):
        self.POLYGON_ITEM.insert(index, value)
    def replace_POLYGON_ITEM_at(self, index, value):
        self.POLYGON_ITEM[index] = value
    def _hasContent(self):
        if (
            self.POLYGON_ITEM
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='POLYGON_NAME', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POLYGON_NAME')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POLYGON_NAME':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POLYGON_NAME')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POLYGON_NAME', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POLYGON_NAME'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='POLYGON_NAME', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for POLYGON_ITEM_ in self.POLYGON_ITEM:
            namespaceprefix_ = self.POLYGON_ITEM_nsprefix_ + ':' if (UseCapturedNS_ and self.POLYGON_ITEM_nsprefix_) else ''
            POLYGON_ITEM_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='POLYGON_ITEM', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'POLYGON_ITEM':
            obj_ = POLYGON_ITEM.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.POLYGON_ITEM.append(obj_)
            obj_.original_tagname_ = 'POLYGON_ITEM'
# end class POLYGON_NAME


class POLYGON_ITEM(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = {
        'HEADER': MemberSpec_('HEADER', 'HEADER', 1, 0, {'maxOccurs': 'unbounded', 'name': 'HEADER', 'ref': 'HEADER', 'type': 'HEADER'}, None),
        'OUTER': MemberSpec_('OUTER', 'OUTER', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'OUTER', 'ref': 'OUTER', 'type': 'OUTER'}, None),
        'INNER': MemberSpec_('INNER', 'INNER', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'INNER', 'ref': 'INNER', 'type': 'INNER'}, None),
        'CONNECT': MemberSpec_('CONNECT', 'xs:string', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'CONNECT', 'ref': 'CONNECT', 'type': 'xs:string'}, None),
        'ATT': MemberSpec_('ATT', 'xs:string', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'ATT', 'ref': 'ATT', 'type': 'xs:string'}, None),
    }
    subclass = None
    superclass = None
    def __init__(self, HEADER=None, OUTER=None, INNER=None, CONNECT=None, ATT=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if HEADER is None:
            self.HEADER = []
        else:
            self.HEADER = HEADER
        self.HEADER_nsprefix_ = None
        if OUTER is None:
            self.OUTER = []
        else:
            self.OUTER = OUTER
        self.OUTER_nsprefix_ = None
        if INNER is None:
            self.INNER = []
        else:
            self.INNER = INNER
        self.INNER_nsprefix_ = None
        if CONNECT is None:
            self.CONNECT = []
        else:
            self.CONNECT = CONNECT
        self.CONNECT_nsprefix_ = None
        if ATT is None:
            self.ATT = []
        else:
            self.ATT = ATT
        self.ATT_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POLYGON_ITEM)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POLYGON_ITEM.subclass:
            return POLYGON_ITEM.subclass(*args_, **kwargs_)
        else:
            return POLYGON_ITEM(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_HEADER(self):
        return self.HEADER
    def set_HEADER(self, HEADER):
        self.HEADER = HEADER
    def add_HEADER(self, value):
        self.HEADER.append(value)
    def insert_HEADER_at(self, index, value):
        self.HEADER.insert(index, value)
    def replace_HEADER_at(self, index, value):
        self.HEADER[index] = value
    def get_OUTER(self):
        return self.OUTER
    def set_OUTER(self, OUTER):
        self.OUTER = OUTER
    def add_OUTER(self, value):
        self.OUTER.append(value)
    def insert_OUTER_at(self, index, value):
        self.OUTER.insert(index, value)
    def replace_OUTER_at(self, index, value):
        self.OUTER[index] = value
    def get_INNER(self):
        return self.INNER
    def set_INNER(self, INNER):
        self.INNER = INNER
    def add_INNER(self, value):
        self.INNER.append(value)
    def insert_INNER_at(self, index, value):
        self.INNER.insert(index, value)
    def replace_INNER_at(self, index, value):
        self.INNER[index] = value
    def get_CONNECT(self):
        return self.CONNECT
    def set_CONNECT(self, CONNECT):
        self.CONNECT = CONNECT
    def add_CONNECT(self, value):
        self.CONNECT.append(value)
    def insert_CONNECT_at(self, index, value):
        self.CONNECT.insert(index, value)
    def replace_CONNECT_at(self, index, value):
        self.CONNECT[index] = value
    def get_ATT(self):
        return self.ATT
    def set_ATT(self, ATT):
        self.ATT = ATT
    def add_ATT(self, value):
        self.ATT.append(value)
    def insert_ATT_at(self, index, value):
        self.ATT.insert(index, value)
    def replace_ATT_at(self, index, value):
        self.ATT[index] = value
    def _hasContent(self):
        if (
            self.HEADER or
            self.OUTER or
            self.INNER or
            self.CONNECT or
            self.ATT
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='POLYGON_ITEM', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POLYGON_ITEM')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POLYGON_ITEM':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POLYGON_ITEM')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POLYGON_ITEM', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POLYGON_ITEM'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='POLYGON_ITEM', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for HEADER_ in self.HEADER:
            namespaceprefix_ = self.HEADER_nsprefix_ + ':' if (UseCapturedNS_ and self.HEADER_nsprefix_) else ''
            HEADER_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='HEADER', pretty_print=pretty_print)
        for OUTER_ in self.OUTER:
            namespaceprefix_ = self.OUTER_nsprefix_ + ':' if (UseCapturedNS_ and self.OUTER_nsprefix_) else ''
            OUTER_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='OUTER', pretty_print=pretty_print)
        for INNER_ in self.INNER:
            namespaceprefix_ = self.INNER_nsprefix_ + ':' if (UseCapturedNS_ and self.INNER_nsprefix_) else ''
            INNER_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='INNER', pretty_print=pretty_print)
        for CONNECT_ in self.CONNECT:
            namespaceprefix_ = self.CONNECT_nsprefix_ + ':' if (UseCapturedNS_ and self.CONNECT_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCONNECT>%s</%sCONNECT>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(CONNECT_), input_name='CONNECT')), namespaceprefix_ , eol_))
        for ATT_ in self.ATT:
            namespaceprefix_ = self.ATT_nsprefix_ + ':' if (UseCapturedNS_ and self.ATT_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sATT>%s</%sATT>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(ATT_), input_name='ATT')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'HEADER':
            obj_ = HEADER.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.HEADER.append(obj_)
            obj_.original_tagname_ = 'HEADER'
        elif nodeName_ == 'OUTER':
            obj_ = OUTER.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.OUTER.append(obj_)
            obj_.original_tagname_ = 'OUTER'
        elif nodeName_ == 'INNER':
            obj_ = INNER.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.INNER.append(obj_)
            obj_.original_tagname_ = 'INNER'
        elif nodeName_ == 'CONNECT':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CONNECT')
            value_ = self.gds_validate_string(value_, node, 'CONNECT')
            self.CONNECT.append(value_)
            self.CONNECT_nsprefix_ = child_.prefix
        elif nodeName_ == 'ATT':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ATT')
            value_ = self.gds_validate_string(value_, node, 'ATT')
            self.ATT.append(value_)
            self.ATT_nsprefix_ = child_.prefix
# end class POLYGON_ITEM


class HEADER(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = {
        'TABLE': MemberSpec_('TABLE', 'xs:string', 0, 0, {'use': 'required', 'name': 'TABLE'}),
        'PFI': MemberSpec_('PFI', 'xs:string', 0, 0, {'use': 'required', 'name': 'PFI'}),
        'CREATED': MemberSpec_('CREATED', 'xs:string', 0, 0, {'use': 'required', 'name': 'CREATED'}),
        'UFI_OLD': MemberSpec_('UFI_OLD', 'xs:string', 0, 1, {'use': 'optional', 'name': 'UFI_OLD'}),
        'UFI': MemberSpec_('UFI', 'xs:string', 0, 0, {'use': 'required', 'name': 'UFI'}),
        'valueOf_': MemberSpec_('valueOf_', [], 0),
    }
    subclass = None
    superclass = None
    def __init__(self, TABLE=None, PFI=None, CREATED=None, UFI_OLD=None, UFI=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.TABLE = _cast(None, TABLE)
        self.TABLE_nsprefix_ = None
        self.PFI = _cast(None, PFI)
        self.PFI_nsprefix_ = None
        self.CREATED = _cast(None, CREATED)
        self.CREATED_nsprefix_ = None
        self.UFI_OLD = _cast(None, UFI_OLD)
        self.UFI_OLD_nsprefix_ = None
        self.UFI = _cast(None, UFI)
        self.UFI_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, HEADER)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if HEADER.subclass:
            return HEADER.subclass(*args_, **kwargs_)
        else:
            return HEADER(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_TABLE(self):
        return self.TABLE
    def set_TABLE(self, TABLE):
        self.TABLE = TABLE
    def get_PFI(self):
        return self.PFI
    def set_PFI(self, PFI):
        self.PFI = PFI
    def get_CREATED(self):
        return self.CREATED
    def set_CREATED(self, CREATED):
        self.CREATED = CREATED
    def get_UFI_OLD(self):
        return self.UFI_OLD
    def set_UFI_OLD(self, UFI_OLD):
        self.UFI_OLD = UFI_OLD
    def get_UFI(self):
        return self.UFI
    def set_UFI(self, UFI):
        self.UFI = UFI
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def _hasContent(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='HEADER', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('HEADER')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'HEADER':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='HEADER')
        outfile.write('>')
        self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='HEADER'):
        if self.TABLE is not None and 'TABLE' not in already_processed:
            already_processed.add('TABLE')
            outfile.write(' TABLE=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.TABLE), input_name='TABLE')), ))
        if self.PFI is not None and 'PFI' not in already_processed:
            already_processed.add('PFI')
            outfile.write(' PFI=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.PFI), input_name='PFI')), ))
        if self.CREATED is not None and 'CREATED' not in already_processed:
            already_processed.add('CREATED')
            outfile.write(' CREATED=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.CREATED), input_name='CREATED')), ))
        if self.UFI_OLD is not None and 'UFI_OLD' not in already_processed:
            already_processed.add('UFI_OLD')
            outfile.write(' UFI_OLD=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.UFI_OLD), input_name='UFI_OLD')), ))
        if self.UFI is not None and 'UFI' not in already_processed:
            already_processed.add('UFI')
            outfile.write(' UFI=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.UFI), input_name='UFI')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='HEADER', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('TABLE', node)
        if value is not None and 'TABLE' not in already_processed:
            already_processed.add('TABLE')
            self.TABLE = value
        value = find_attr_value_('PFI', node)
        if value is not None and 'PFI' not in already_processed:
            already_processed.add('PFI')
            self.PFI = value
        value = find_attr_value_('CREATED', node)
        if value is not None and 'CREATED' not in already_processed:
            already_processed.add('CREATED')
            self.CREATED = value
        value = find_attr_value_('UFI_OLD', node)
        if value is not None and 'UFI_OLD' not in already_processed:
            already_processed.add('UFI_OLD')
            self.UFI_OLD = value
        value = find_attr_value_('UFI', node)
        if value is not None and 'UFI' not in already_processed:
            already_processed.add('UFI')
            self.UFI = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class HEADER


class OUTER(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = {
        'XY': MemberSpec_('XY', 'xs:string', 1, 0, {'maxOccurs': 'unbounded', 'name': 'XY', 'ref': 'XY', 'type': 'xs:string'}, None),
    }
    subclass = None
    superclass = None
    def __init__(self, XY=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if XY is None:
            self.XY = []
        else:
            self.XY = XY
        self.XY_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OUTER)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OUTER.subclass:
            return OUTER.subclass(*args_, **kwargs_)
        else:
            return OUTER(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_XY(self):
        return self.XY
    def set_XY(self, XY):
        self.XY = XY
    def add_XY(self, value):
        self.XY.append(value)
    def insert_XY_at(self, index, value):
        self.XY.insert(index, value)
    def replace_XY_at(self, index, value):
        self.XY[index] = value
    def _hasContent(self):
        if (
            self.XY
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='OUTER', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('OUTER')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'OUTER':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='OUTER')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='OUTER', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='OUTER'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='OUTER', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for XY_ in self.XY:
            namespaceprefix_ = self.XY_nsprefix_ + ':' if (UseCapturedNS_ and self.XY_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sXY>%s</%sXY>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(XY_), input_name='XY')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'XY':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'XY')
            value_ = self.gds_validate_string(value_, node, 'XY')
            self.XY.append(value_)
            self.XY_nsprefix_ = child_.prefix
# end class OUTER


class INNER(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = {
        'XY': MemberSpec_('XY', 'xs:string', 1, 0, {'maxOccurs': 'unbounded', 'name': 'XY', 'ref': 'XY', 'type': 'xs:string'}, None),
    }
    subclass = None
    superclass = None
    def __init__(self, XY=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if XY is None:
            self.XY = []
        else:
            self.XY = XY
        self.XY_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, INNER)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if INNER.subclass:
            return INNER.subclass(*args_, **kwargs_)
        else:
            return INNER(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_XY(self):
        return self.XY
    def set_XY(self, XY):
        self.XY = XY
    def add_XY(self, value):
        self.XY.append(value)
    def insert_XY_at(self, index, value):
        self.XY.insert(index, value)
    def replace_XY_at(self, index, value):
        self.XY[index] = value
    def _hasContent(self):
        if (
            self.XY
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='INNER', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('INNER')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'INNER':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='INNER')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='INNER', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='INNER'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='INNER', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for XY_ in self.XY:
            namespaceprefix_ = self.XY_nsprefix_ + ':' if (UseCapturedNS_ and self.XY_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sXY>%s</%sXY>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(XY_), input_name='XY')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'XY':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'XY')
            value_ = self.gds_validate_string(value_, node, 'XY')
            self.XY.append(value_)
            self.XY_nsprefix_ = child_.prefix
# end class INNER


class LINE(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = {
        'LINE_NAME': MemberSpec_('LINE_NAME', 'LINE_NAME', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'LINE_NAME', 'ref': 'LINE_NAME', 'type': 'LINE_NAME'}, None),
    }
    subclass = None
    superclass = None
    def __init__(self, LINE_NAME=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if LINE_NAME is None:
            self.LINE_NAME = []
        else:
            self.LINE_NAME = LINE_NAME
        self.LINE_NAME_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LINE)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LINE.subclass:
            return LINE.subclass(*args_, **kwargs_)
        else:
            return LINE(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_LINE_NAME(self):
        return self.LINE_NAME
    def set_LINE_NAME(self, LINE_NAME):
        self.LINE_NAME = LINE_NAME
    def add_LINE_NAME(self, value):
        self.LINE_NAME.append(value)
    def insert_LINE_NAME_at(self, index, value):
        self.LINE_NAME.insert(index, value)
    def replace_LINE_NAME_at(self, index, value):
        self.LINE_NAME[index] = value
    def _hasContent(self):
        if (
            self.LINE_NAME
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='LINE', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('LINE')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'LINE':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='LINE')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='LINE', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='LINE'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='LINE', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for LINE_NAME_ in self.LINE_NAME:
            namespaceprefix_ = self.LINE_NAME_nsprefix_ + ':' if (UseCapturedNS_ and self.LINE_NAME_nsprefix_) else ''
            LINE_NAME_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='LINE_NAME', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'LINE_NAME':
            obj_ = LINE_NAME.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.LINE_NAME.append(obj_)
            obj_.original_tagname_ = 'LINE_NAME'
# end class LINE


class LINE_NAME(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = {
        'LINE_ITEM': MemberSpec_('LINE_ITEM', 'LINE_ITEM', 1, 0, {'maxOccurs': 'unbounded', 'name': 'LINE_ITEM', 'ref': 'LINE_ITEM', 'type': 'LINE_ITEM'}, None),
    }
    subclass = None
    superclass = None
    def __init__(self, LINE_ITEM=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if LINE_ITEM is None:
            self.LINE_ITEM = []
        else:
            self.LINE_ITEM = LINE_ITEM
        self.LINE_ITEM_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LINE_NAME)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LINE_NAME.subclass:
            return LINE_NAME.subclass(*args_, **kwargs_)
        else:
            return LINE_NAME(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_LINE_ITEM(self):
        return self.LINE_ITEM
    def set_LINE_ITEM(self, LINE_ITEM):
        self.LINE_ITEM = LINE_ITEM
    def add_LINE_ITEM(self, value):
        self.LINE_ITEM.append(value)
    def insert_LINE_ITEM_at(self, index, value):
        self.LINE_ITEM.insert(index, value)
    def replace_LINE_ITEM_at(self, index, value):
        self.LINE_ITEM[index] = value
    def _hasContent(self):
        if (
            self.LINE_ITEM
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='LINE_NAME', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('LINE_NAME')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'LINE_NAME':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='LINE_NAME')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='LINE_NAME', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='LINE_NAME'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='LINE_NAME', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for LINE_ITEM_ in self.LINE_ITEM:
            namespaceprefix_ = self.LINE_ITEM_nsprefix_ + ':' if (UseCapturedNS_ and self.LINE_ITEM_nsprefix_) else ''
            LINE_ITEM_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='LINE_ITEM', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'LINE_ITEM':
            obj_ = LINE_ITEM.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.LINE_ITEM.append(obj_)
            obj_.original_tagname_ = 'LINE_ITEM'
# end class LINE_NAME


class LINE_ITEM(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = {
        'HEADER': MemberSpec_('HEADER', 'HEADER', 1, 0, {'maxOccurs': 'unbounded', 'name': 'HEADER', 'ref': 'HEADER', 'type': 'HEADER'}, None),
        'XY': MemberSpec_('XY', 'xs:string', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'XY', 'ref': 'XY', 'type': 'xs:string'}, None),
        'CONNECT': MemberSpec_('CONNECT', 'xs:string', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'CONNECT', 'ref': 'CONNECT', 'type': 'xs:string'}, None),
        'ATT': MemberSpec_('ATT', 'xs:string', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'ATT', 'ref': 'ATT', 'type': 'xs:string'}, None),
    }
    subclass = None
    superclass = None
    def __init__(self, HEADER=None, XY=None, CONNECT=None, ATT=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if HEADER is None:
            self.HEADER = []
        else:
            self.HEADER = HEADER
        self.HEADER_nsprefix_ = None
        if XY is None:
            self.XY = []
        else:
            self.XY = XY
        self.XY_nsprefix_ = None
        if CONNECT is None:
            self.CONNECT = []
        else:
            self.CONNECT = CONNECT
        self.CONNECT_nsprefix_ = None
        if ATT is None:
            self.ATT = []
        else:
            self.ATT = ATT
        self.ATT_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LINE_ITEM)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LINE_ITEM.subclass:
            return LINE_ITEM.subclass(*args_, **kwargs_)
        else:
            return LINE_ITEM(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_HEADER(self):
        return self.HEADER
    def set_HEADER(self, HEADER):
        self.HEADER = HEADER
    def add_HEADER(self, value):
        self.HEADER.append(value)
    def insert_HEADER_at(self, index, value):
        self.HEADER.insert(index, value)
    def replace_HEADER_at(self, index, value):
        self.HEADER[index] = value
    def get_XY(self):
        return self.XY
    def set_XY(self, XY):
        self.XY = XY
    def add_XY(self, value):
        self.XY.append(value)
    def insert_XY_at(self, index, value):
        self.XY.insert(index, value)
    def replace_XY_at(self, index, value):
        self.XY[index] = value
    def get_CONNECT(self):
        return self.CONNECT
    def set_CONNECT(self, CONNECT):
        self.CONNECT = CONNECT
    def add_CONNECT(self, value):
        self.CONNECT.append(value)
    def insert_CONNECT_at(self, index, value):
        self.CONNECT.insert(index, value)
    def replace_CONNECT_at(self, index, value):
        self.CONNECT[index] = value
    def get_ATT(self):
        return self.ATT
    def set_ATT(self, ATT):
        self.ATT = ATT
    def add_ATT(self, value):
        self.ATT.append(value)
    def insert_ATT_at(self, index, value):
        self.ATT.insert(index, value)
    def replace_ATT_at(self, index, value):
        self.ATT[index] = value
    def _hasContent(self):
        if (
            self.HEADER or
            self.XY or
            self.CONNECT or
            self.ATT
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='LINE_ITEM', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('LINE_ITEM')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'LINE_ITEM':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='LINE_ITEM')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='LINE_ITEM', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='LINE_ITEM'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='LINE_ITEM', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for HEADER_ in self.HEADER:
            namespaceprefix_ = self.HEADER_nsprefix_ + ':' if (UseCapturedNS_ and self.HEADER_nsprefix_) else ''
            HEADER_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='HEADER', pretty_print=pretty_print)
        for XY_ in self.XY:
            namespaceprefix_ = self.XY_nsprefix_ + ':' if (UseCapturedNS_ and self.XY_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sXY>%s</%sXY>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(XY_), input_name='XY')), namespaceprefix_ , eol_))
        for CONNECT_ in self.CONNECT:
            namespaceprefix_ = self.CONNECT_nsprefix_ + ':' if (UseCapturedNS_ and self.CONNECT_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCONNECT>%s</%sCONNECT>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(CONNECT_), input_name='CONNECT')), namespaceprefix_ , eol_))
        for ATT_ in self.ATT:
            namespaceprefix_ = self.ATT_nsprefix_ + ':' if (UseCapturedNS_ and self.ATT_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sATT>%s</%sATT>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(ATT_), input_name='ATT')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'HEADER':
            obj_ = HEADER.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.HEADER.append(obj_)
            obj_.original_tagname_ = 'HEADER'
        elif nodeName_ == 'XY':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'XY')
            value_ = self.gds_validate_string(value_, node, 'XY')
            self.XY.append(value_)
            self.XY_nsprefix_ = child_.prefix
        elif nodeName_ == 'CONNECT':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CONNECT')
            value_ = self.gds_validate_string(value_, node, 'CONNECT')
            self.CONNECT.append(value_)
            self.CONNECT_nsprefix_ = child_.prefix
        elif nodeName_ == 'ATT':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ATT')
            value_ = self.gds_validate_string(value_, node, 'ATT')
            self.ATT.append(value_)
            self.ATT_nsprefix_ = child_.prefix
# end class LINE_ITEM


class POINT(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = {
        'POINT_NAME': MemberSpec_('POINT_NAME', 'POINT_NAME', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'POINT_NAME', 'ref': 'POINT_NAME', 'type': 'POINT_NAME'}, None),
    }
    subclass = None
    superclass = None
    def __init__(self, POINT_NAME=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if POINT_NAME is None:
            self.POINT_NAME = []
        else:
            self.POINT_NAME = POINT_NAME
        self.POINT_NAME_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POINT)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POINT.subclass:
            return POINT.subclass(*args_, **kwargs_)
        else:
            return POINT(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_POINT_NAME(self):
        return self.POINT_NAME
    def set_POINT_NAME(self, POINT_NAME):
        self.POINT_NAME = POINT_NAME
    def add_POINT_NAME(self, value):
        self.POINT_NAME.append(value)
    def insert_POINT_NAME_at(self, index, value):
        self.POINT_NAME.insert(index, value)
    def replace_POINT_NAME_at(self, index, value):
        self.POINT_NAME[index] = value
    def _hasContent(self):
        if (
            self.POINT_NAME
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='POINT', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POINT')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POINT':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POINT')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POINT', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POINT'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='POINT', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for POINT_NAME_ in self.POINT_NAME:
            namespaceprefix_ = self.POINT_NAME_nsprefix_ + ':' if (UseCapturedNS_ and self.POINT_NAME_nsprefix_) else ''
            POINT_NAME_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='POINT_NAME', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'POINT_NAME':
            obj_ = POINT_NAME.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.POINT_NAME.append(obj_)
            obj_.original_tagname_ = 'POINT_NAME'
# end class POINT


class POINT_NAME(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = {
        'POINT_ITEM': MemberSpec_('POINT_ITEM', 'POINT_ITEM', 1, 0, {'maxOccurs': 'unbounded', 'name': 'POINT_ITEM', 'ref': 'POINT_ITEM', 'type': 'POINT_ITEM'}, None),
    }
    subclass = None
    superclass = None
    def __init__(self, POINT_ITEM=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if POINT_ITEM is None:
            self.POINT_ITEM = []
        else:
            self.POINT_ITEM = POINT_ITEM
        self.POINT_ITEM_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POINT_NAME)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POINT_NAME.subclass:
            return POINT_NAME.subclass(*args_, **kwargs_)
        else:
            return POINT_NAME(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_POINT_ITEM(self):
        return self.POINT_ITEM
    def set_POINT_ITEM(self, POINT_ITEM):
        self.POINT_ITEM = POINT_ITEM
    def add_POINT_ITEM(self, value):
        self.POINT_ITEM.append(value)
    def insert_POINT_ITEM_at(self, index, value):
        self.POINT_ITEM.insert(index, value)
    def replace_POINT_ITEM_at(self, index, value):
        self.POINT_ITEM[index] = value
    def _hasContent(self):
        if (
            self.POINT_ITEM
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='POINT_NAME', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POINT_NAME')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POINT_NAME':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POINT_NAME')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POINT_NAME', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POINT_NAME'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='POINT_NAME', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for POINT_ITEM_ in self.POINT_ITEM:
            namespaceprefix_ = self.POINT_ITEM_nsprefix_ + ':' if (UseCapturedNS_ and self.POINT_ITEM_nsprefix_) else ''
            POINT_ITEM_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='POINT_ITEM', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'POINT_ITEM':
            obj_ = POINT_ITEM.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.POINT_ITEM.append(obj_)
            obj_.original_tagname_ = 'POINT_ITEM'
# end class POINT_NAME


class POINT_ITEM(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = {
        'HEADER': MemberSpec_('HEADER', 'HEADER', 1, 0, {'maxOccurs': 'unbounded', 'name': 'HEADER', 'ref': 'HEADER', 'type': 'HEADER'}, None),
        'XY': MemberSpec_('XY', 'xs:string', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'XY', 'ref': 'XY', 'type': 'xs:string'}, None),
        'CONNECT': MemberSpec_('CONNECT', 'xs:string', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'CONNECT', 'ref': 'CONNECT', 'type': 'xs:string'}, None),
        'ATT': MemberSpec_('ATT', 'xs:string', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'ATT', 'ref': 'ATT', 'type': 'xs:string'}, None),
    }
    subclass = None
    superclass = None
    def __init__(self, HEADER=None, XY=None, CONNECT=None, ATT=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if HEADER is None:
            self.HEADER = []
        else:
            self.HEADER = HEADER
        self.HEADER_nsprefix_ = None
        if XY is None:
            self.XY = []
        else:
            self.XY = XY
        self.XY_nsprefix_ = None
        if CONNECT is None:
            self.CONNECT = []
        else:
            self.CONNECT = CONNECT
        self.CONNECT_nsprefix_ = None
        if ATT is None:
            self.ATT = []
        else:
            self.ATT = ATT
        self.ATT_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, POINT_ITEM)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if POINT_ITEM.subclass:
            return POINT_ITEM.subclass(*args_, **kwargs_)
        else:
            return POINT_ITEM(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_HEADER(self):
        return self.HEADER
    def set_HEADER(self, HEADER):
        self.HEADER = HEADER
    def add_HEADER(self, value):
        self.HEADER.append(value)
    def insert_HEADER_at(self, index, value):
        self.HEADER.insert(index, value)
    def replace_HEADER_at(self, index, value):
        self.HEADER[index] = value
    def get_XY(self):
        return self.XY
    def set_XY(self, XY):
        self.XY = XY
    def add_XY(self, value):
        self.XY.append(value)
    def insert_XY_at(self, index, value):
        self.XY.insert(index, value)
    def replace_XY_at(self, index, value):
        self.XY[index] = value
    def get_CONNECT(self):
        return self.CONNECT
    def set_CONNECT(self, CONNECT):
        self.CONNECT = CONNECT
    def add_CONNECT(self, value):
        self.CONNECT.append(value)
    def insert_CONNECT_at(self, index, value):
        self.CONNECT.insert(index, value)
    def replace_CONNECT_at(self, index, value):
        self.CONNECT[index] = value
    def get_ATT(self):
        return self.ATT
    def set_ATT(self, ATT):
        self.ATT = ATT
    def add_ATT(self, value):
        self.ATT.append(value)
    def insert_ATT_at(self, index, value):
        self.ATT.insert(index, value)
    def replace_ATT_at(self, index, value):
        self.ATT[index] = value
    def _hasContent(self):
        if (
            self.HEADER or
            self.XY or
            self.CONNECT or
            self.ATT
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='POINT_ITEM', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('POINT_ITEM')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'POINT_ITEM':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='POINT_ITEM')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='POINT_ITEM', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='POINT_ITEM'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='POINT_ITEM', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for HEADER_ in self.HEADER:
            namespaceprefix_ = self.HEADER_nsprefix_ + ':' if (UseCapturedNS_ and self.HEADER_nsprefix_) else ''
            HEADER_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='HEADER', pretty_print=pretty_print)
        for XY_ in self.XY:
            namespaceprefix_ = self.XY_nsprefix_ + ':' if (UseCapturedNS_ and self.XY_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sXY>%s</%sXY>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(XY_), input_name='XY')), namespaceprefix_ , eol_))
        for CONNECT_ in self.CONNECT:
            namespaceprefix_ = self.CONNECT_nsprefix_ + ':' if (UseCapturedNS_ and self.CONNECT_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCONNECT>%s</%sCONNECT>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(CONNECT_), input_name='CONNECT')), namespaceprefix_ , eol_))
        for ATT_ in self.ATT:
            namespaceprefix_ = self.ATT_nsprefix_ + ':' if (UseCapturedNS_ and self.ATT_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sATT>%s</%sATT>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(ATT_), input_name='ATT')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'HEADER':
            obj_ = HEADER.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.HEADER.append(obj_)
            obj_.original_tagname_ = 'HEADER'
        elif nodeName_ == 'XY':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'XY')
            value_ = self.gds_validate_string(value_, node, 'XY')
            self.XY.append(value_)
            self.XY_nsprefix_ = child_.prefix
        elif nodeName_ == 'CONNECT':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CONNECT')
            value_ = self.gds_validate_string(value_, node, 'CONNECT')
            self.CONNECT.append(value_)
            self.CONNECT_nsprefix_ = child_.prefix
        elif nodeName_ == 'ATT':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ATT')
            value_ = self.gds_validate_string(value_, node, 'ATT')
            self.ATT.append(value_)
            self.ATT_nsprefix_ = child_.prefix
# end class POINT_ITEM


class ASPATIAL(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = {
        'ASPATIAL_NAME': MemberSpec_('ASPATIAL_NAME', 'ASPATIAL_NAME', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'ASPATIAL_NAME', 'ref': 'ASPATIAL_NAME', 'type': 'ASPATIAL_NAME'}, None),
    }
    subclass = None
    superclass = None
    def __init__(self, ASPATIAL_NAME=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if ASPATIAL_NAME is None:
            self.ASPATIAL_NAME = []
        else:
            self.ASPATIAL_NAME = ASPATIAL_NAME
        self.ASPATIAL_NAME_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ASPATIAL)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ASPATIAL.subclass:
            return ASPATIAL.subclass(*args_, **kwargs_)
        else:
            return ASPATIAL(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ASPATIAL_NAME(self):
        return self.ASPATIAL_NAME
    def set_ASPATIAL_NAME(self, ASPATIAL_NAME):
        self.ASPATIAL_NAME = ASPATIAL_NAME
    def add_ASPATIAL_NAME(self, value):
        self.ASPATIAL_NAME.append(value)
    def insert_ASPATIAL_NAME_at(self, index, value):
        self.ASPATIAL_NAME.insert(index, value)
    def replace_ASPATIAL_NAME_at(self, index, value):
        self.ASPATIAL_NAME[index] = value
    def _hasContent(self):
        if (
            self.ASPATIAL_NAME
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ASPATIAL', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ASPATIAL')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ASPATIAL':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ASPATIAL')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ASPATIAL', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ASPATIAL'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ASPATIAL', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ASPATIAL_NAME_ in self.ASPATIAL_NAME:
            namespaceprefix_ = self.ASPATIAL_NAME_nsprefix_ + ':' if (UseCapturedNS_ and self.ASPATIAL_NAME_nsprefix_) else ''
            ASPATIAL_NAME_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ASPATIAL_NAME', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ASPATIAL_NAME':
            obj_ = ASPATIAL_NAME.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ASPATIAL_NAME.append(obj_)
            obj_.original_tagname_ = 'ASPATIAL_NAME'
# end class ASPATIAL


class ASPATIAL_NAME(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = {
        'ASPATIAL_ITEM': MemberSpec_('ASPATIAL_ITEM', 'ASPATIAL_ITEM', 1, 0, {'maxOccurs': 'unbounded', 'name': 'ASPATIAL_ITEM', 'ref': 'ASPATIAL_ITEM', 'type': 'ASPATIAL_ITEM'}, None),
    }
    subclass = None
    superclass = None
    def __init__(self, ASPATIAL_ITEM=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if ASPATIAL_ITEM is None:
            self.ASPATIAL_ITEM = []
        else:
            self.ASPATIAL_ITEM = ASPATIAL_ITEM
        self.ASPATIAL_ITEM_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ASPATIAL_NAME)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ASPATIAL_NAME.subclass:
            return ASPATIAL_NAME.subclass(*args_, **kwargs_)
        else:
            return ASPATIAL_NAME(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ASPATIAL_ITEM(self):
        return self.ASPATIAL_ITEM
    def set_ASPATIAL_ITEM(self, ASPATIAL_ITEM):
        self.ASPATIAL_ITEM = ASPATIAL_ITEM
    def add_ASPATIAL_ITEM(self, value):
        self.ASPATIAL_ITEM.append(value)
    def insert_ASPATIAL_ITEM_at(self, index, value):
        self.ASPATIAL_ITEM.insert(index, value)
    def replace_ASPATIAL_ITEM_at(self, index, value):
        self.ASPATIAL_ITEM[index] = value
    def _hasContent(self):
        if (
            self.ASPATIAL_ITEM
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ASPATIAL_NAME', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ASPATIAL_NAME')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ASPATIAL_NAME':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ASPATIAL_NAME')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ASPATIAL_NAME', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ASPATIAL_NAME'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ASPATIAL_NAME', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ASPATIAL_ITEM_ in self.ASPATIAL_ITEM:
            namespaceprefix_ = self.ASPATIAL_ITEM_nsprefix_ + ':' if (UseCapturedNS_ and self.ASPATIAL_ITEM_nsprefix_) else ''
            ASPATIAL_ITEM_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ASPATIAL_ITEM', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ASPATIAL_ITEM':
            obj_ = ASPATIAL_ITEM.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ASPATIAL_ITEM.append(obj_)
            obj_.original_tagname_ = 'ASPATIAL_ITEM'
# end class ASPATIAL_NAME


class ASPATIAL_ITEM(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = {
        'HEADER': MemberSpec_('HEADER', 'HEADER', 1, 0, {'maxOccurs': 'unbounded', 'name': 'HEADER', 'ref': 'HEADER', 'type': 'HEADER'}, None),
        'CONNECT': MemberSpec_('CONNECT', 'xs:string', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'CONNECT', 'ref': 'CONNECT', 'type': 'xs:string'}, None),
        'ATT': MemberSpec_('ATT', 'xs:string', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'ATT', 'ref': 'ATT', 'type': 'xs:string'}, None),
    }
    subclass = None
    superclass = None
    def __init__(self, HEADER=None, CONNECT=None, ATT=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if HEADER is None:
            self.HEADER = []
        else:
            self.HEADER = HEADER
        self.HEADER_nsprefix_ = None
        if CONNECT is None:
            self.CONNECT = []
        else:
            self.CONNECT = CONNECT
        self.CONNECT_nsprefix_ = None
        if ATT is None:
            self.ATT = []
        else:
            self.ATT = ATT
        self.ATT_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ASPATIAL_ITEM)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ASPATIAL_ITEM.subclass:
            return ASPATIAL_ITEM.subclass(*args_, **kwargs_)
        else:
            return ASPATIAL_ITEM(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_HEADER(self):
        return self.HEADER
    def set_HEADER(self, HEADER):
        self.HEADER = HEADER
    def add_HEADER(self, value):
        self.HEADER.append(value)
    def insert_HEADER_at(self, index, value):
        self.HEADER.insert(index, value)
    def replace_HEADER_at(self, index, value):
        self.HEADER[index] = value
    def get_CONNECT(self):
        return self.CONNECT
    def set_CONNECT(self, CONNECT):
        self.CONNECT = CONNECT
    def add_CONNECT(self, value):
        self.CONNECT.append(value)
    def insert_CONNECT_at(self, index, value):
        self.CONNECT.insert(index, value)
    def replace_CONNECT_at(self, index, value):
        self.CONNECT[index] = value
    def get_ATT(self):
        return self.ATT
    def set_ATT(self, ATT):
        self.ATT = ATT
    def add_ATT(self, value):
        self.ATT.append(value)
    def insert_ATT_at(self, index, value):
        self.ATT.insert(index, value)
    def replace_ATT_at(self, index, value):
        self.ATT[index] = value
    def _hasContent(self):
        if (
            self.HEADER or
            self.CONNECT or
            self.ATT
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ASPATIAL_ITEM', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ASPATIAL_ITEM')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ASPATIAL_ITEM':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ASPATIAL_ITEM')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ASPATIAL_ITEM', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ASPATIAL_ITEM'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ASPATIAL_ITEM', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for HEADER_ in self.HEADER:
            namespaceprefix_ = self.HEADER_nsprefix_ + ':' if (UseCapturedNS_ and self.HEADER_nsprefix_) else ''
            HEADER_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='HEADER', pretty_print=pretty_print)
        for CONNECT_ in self.CONNECT:
            namespaceprefix_ = self.CONNECT_nsprefix_ + ':' if (UseCapturedNS_ and self.CONNECT_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCONNECT>%s</%sCONNECT>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(CONNECT_), input_name='CONNECT')), namespaceprefix_ , eol_))
        for ATT_ in self.ATT:
            namespaceprefix_ = self.ATT_nsprefix_ + ':' if (UseCapturedNS_ and self.ATT_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sATT>%s</%sATT>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(ATT_), input_name='ATT')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'HEADER':
            obj_ = HEADER.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.HEADER.append(obj_)
            obj_.original_tagname_ = 'HEADER'
        elif nodeName_ == 'CONNECT':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CONNECT')
            value_ = self.gds_validate_string(value_, node, 'CONNECT')
            self.CONNECT.append(value_)
            self.CONNECT_nsprefix_ = child_.prefix
        elif nodeName_ == 'ATT':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ATT')
            value_ = self.gds_validate_string(value_, node, 'ATT')
            self.ATT.append(value_)
            self.ATT_nsprefix_ = child_.prefix
# end class ASPATIAL_ITEM


class REPLACE(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = {
        'POLYGON': MemberSpec_('POLYGON', 'POLYGON', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'POLYGON', 'ref': 'POLYGON', 'type': 'POLYGON'}, None),
        'LINE': MemberSpec_('LINE', 'LINE', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'LINE', 'ref': 'LINE', 'type': 'LINE'}, None),
        'POINT': MemberSpec_('POINT', 'POINT', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'POINT', 'ref': 'POINT', 'type': 'POINT'}, None),
        'ASPATIAL': MemberSpec_('ASPATIAL', 'ASPATIAL', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'ASPATIAL', 'ref': 'ASPATIAL', 'type': 'ASPATIAL'}, None),
    }
    subclass = None
    superclass = None
    def __init__(self, POLYGON=None, LINE=None, POINT=None, ASPATIAL=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if POLYGON is None:
            self.POLYGON = []
        else:
            self.POLYGON = POLYGON
        self.POLYGON_nsprefix_ = None
        if LINE is None:
            self.LINE = []
        else:
            self.LINE = LINE
        self.LINE_nsprefix_ = None
        if POINT is None:
            self.POINT = []
        else:
            self.POINT = POINT
        self.POINT_nsprefix_ = None
        if ASPATIAL is None:
            self.ASPATIAL = []
        else:
            self.ASPATIAL = ASPATIAL
        self.ASPATIAL_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, REPLACE)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if REPLACE.subclass:
            return REPLACE.subclass(*args_, **kwargs_)
        else:
            return REPLACE(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_POLYGON(self):
        return self.POLYGON
    def set_POLYGON(self, POLYGON):
        self.POLYGON = POLYGON
    def add_POLYGON(self, value):
        self.POLYGON.append(value)
    def insert_POLYGON_at(self, index, value):
        self.POLYGON.insert(index, value)
    def replace_POLYGON_at(self, index, value):
        self.POLYGON[index] = value
    def get_LINE(self):
        return self.LINE
    def set_LINE(self, LINE):
        self.LINE = LINE
    def add_LINE(self, value):
        self.LINE.append(value)
    def insert_LINE_at(self, index, value):
        self.LINE.insert(index, value)
    def replace_LINE_at(self, index, value):
        self.LINE[index] = value
    def get_POINT(self):
        return self.POINT
    def set_POINT(self, POINT):
        self.POINT = POINT
    def add_POINT(self, value):
        self.POINT.append(value)
    def insert_POINT_at(self, index, value):
        self.POINT.insert(index, value)
    def replace_POINT_at(self, index, value):
        self.POINT[index] = value
    def get_ASPATIAL(self):
        return self.ASPATIAL
    def set_ASPATIAL(self, ASPATIAL):
        self.ASPATIAL = ASPATIAL
    def add_ASPATIAL(self, value):
        self.ASPATIAL.append(value)
    def insert_ASPATIAL_at(self, index, value):
        self.ASPATIAL.insert(index, value)
    def replace_ASPATIAL_at(self, index, value):
        self.ASPATIAL[index] = value
    def _hasContent(self):
        if (
            self.POLYGON or
            self.LINE or
            self.POINT or
            self.ASPATIAL
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='REPLACE', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('REPLACE')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'REPLACE':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='REPLACE')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='REPLACE', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='REPLACE'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='REPLACE', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for POLYGON_ in self.POLYGON:
            namespaceprefix_ = self.POLYGON_nsprefix_ + ':' if (UseCapturedNS_ and self.POLYGON_nsprefix_) else ''
            POLYGON_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='POLYGON', pretty_print=pretty_print)
        for LINE_ in self.LINE:
            namespaceprefix_ = self.LINE_nsprefix_ + ':' if (UseCapturedNS_ and self.LINE_nsprefix_) else ''
            LINE_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='LINE', pretty_print=pretty_print)
        for POINT_ in self.POINT:
            namespaceprefix_ = self.POINT_nsprefix_ + ':' if (UseCapturedNS_ and self.POINT_nsprefix_) else ''
            POINT_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='POINT', pretty_print=pretty_print)
        for ASPATIAL_ in self.ASPATIAL:
            namespaceprefix_ = self.ASPATIAL_nsprefix_ + ':' if (UseCapturedNS_ and self.ASPATIAL_nsprefix_) else ''
            ASPATIAL_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ASPATIAL', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'POLYGON':
            obj_ = POLYGON.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.POLYGON.append(obj_)
            obj_.original_tagname_ = 'POLYGON'
        elif nodeName_ == 'LINE':
            obj_ = LINE.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.LINE.append(obj_)
            obj_.original_tagname_ = 'LINE'
        elif nodeName_ == 'POINT':
            obj_ = POINT.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.POINT.append(obj_)
            obj_.original_tagname_ = 'POINT'
        elif nodeName_ == 'ASPATIAL':
            obj_ = ASPATIAL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ASPATIAL.append(obj_)
            obj_.original_tagname_ = 'ASPATIAL'
# end class REPLACE


class DELETE(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = {
        'POLYGON': MemberSpec_('POLYGON', 'POLYGON', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'POLYGON', 'ref': 'POLYGON', 'type': 'POLYGON'}, None),
        'LINE': MemberSpec_('LINE', 'LINE', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'LINE', 'ref': 'LINE', 'type': 'LINE'}, None),
        'POINT': MemberSpec_('POINT', 'POINT', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'POINT', 'ref': 'POINT', 'type': 'POINT'}, None),
        'ASPATIAL': MemberSpec_('ASPATIAL', 'ASPATIAL', 1, 1, {'maxOccurs': 'unbounded', 'minOccurs': '0', 'name': 'ASPATIAL', 'ref': 'ASPATIAL', 'type': 'ASPATIAL'}, None),
    }
    subclass = None
    superclass = None
    def __init__(self, POLYGON=None, LINE=None, POINT=None, ASPATIAL=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if POLYGON is None:
            self.POLYGON = []
        else:
            self.POLYGON = POLYGON
        self.POLYGON_nsprefix_ = None
        if LINE is None:
            self.LINE = []
        else:
            self.LINE = LINE
        self.LINE_nsprefix_ = None
        if POINT is None:
            self.POINT = []
        else:
            self.POINT = POINT
        self.POINT_nsprefix_ = None
        if ASPATIAL is None:
            self.ASPATIAL = []
        else:
            self.ASPATIAL = ASPATIAL
        self.ASPATIAL_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DELETE)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DELETE.subclass:
            return DELETE.subclass(*args_, **kwargs_)
        else:
            return DELETE(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_POLYGON(self):
        return self.POLYGON
    def set_POLYGON(self, POLYGON):
        self.POLYGON = POLYGON
    def add_POLYGON(self, value):
        self.POLYGON.append(value)
    def insert_POLYGON_at(self, index, value):
        self.POLYGON.insert(index, value)
    def replace_POLYGON_at(self, index, value):
        self.POLYGON[index] = value
    def get_LINE(self):
        return self.LINE
    def set_LINE(self, LINE):
        self.LINE = LINE
    def add_LINE(self, value):
        self.LINE.append(value)
    def insert_LINE_at(self, index, value):
        self.LINE.insert(index, value)
    def replace_LINE_at(self, index, value):
        self.LINE[index] = value
    def get_POINT(self):
        return self.POINT
    def set_POINT(self, POINT):
        self.POINT = POINT
    def add_POINT(self, value):
        self.POINT.append(value)
    def insert_POINT_at(self, index, value):
        self.POINT.insert(index, value)
    def replace_POINT_at(self, index, value):
        self.POINT[index] = value
    def get_ASPATIAL(self):
        return self.ASPATIAL
    def set_ASPATIAL(self, ASPATIAL):
        self.ASPATIAL = ASPATIAL
    def add_ASPATIAL(self, value):
        self.ASPATIAL.append(value)
    def insert_ASPATIAL_at(self, index, value):
        self.ASPATIAL.insert(index, value)
    def replace_ASPATIAL_at(self, index, value):
        self.ASPATIAL[index] = value
    def _hasContent(self):
        if (
            self.POLYGON or
            self.LINE or
            self.POINT or
            self.ASPATIAL
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DELETE', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DELETE')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DELETE':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DELETE')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DELETE', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DELETE'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DELETE', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for POLYGON_ in self.POLYGON:
            namespaceprefix_ = self.POLYGON_nsprefix_ + ':' if (UseCapturedNS_ and self.POLYGON_nsprefix_) else ''
            POLYGON_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='POLYGON', pretty_print=pretty_print)
        for LINE_ in self.LINE:
            namespaceprefix_ = self.LINE_nsprefix_ + ':' if (UseCapturedNS_ and self.LINE_nsprefix_) else ''
            LINE_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='LINE', pretty_print=pretty_print)
        for POINT_ in self.POINT:
            namespaceprefix_ = self.POINT_nsprefix_ + ':' if (UseCapturedNS_ and self.POINT_nsprefix_) else ''
            POINT_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='POINT', pretty_print=pretty_print)
        for ASPATIAL_ in self.ASPATIAL:
            namespaceprefix_ = self.ASPATIAL_nsprefix_ + ':' if (UseCapturedNS_ and self.ASPATIAL_nsprefix_) else ''
            ASPATIAL_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ASPATIAL', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'POLYGON':
            obj_ = POLYGON.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.POLYGON.append(obj_)
            obj_.original_tagname_ = 'POLYGON'
        elif nodeName_ == 'LINE':
            obj_ = LINE.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.LINE.append(obj_)
            obj_.original_tagname_ = 'LINE'
        elif nodeName_ == 'POINT':
            obj_ = POINT.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.POINT.append(obj_)
            obj_.original_tagname_ = 'POINT'
        elif nodeName_ == 'ASPATIAL':
            obj_ = ASPATIAL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ASPATIAL.append(obj_)
            obj_.original_tagname_ = 'ASPATIAL'
# end class DELETE


GDSClassesMapping = {
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print(USAGE_TEXT)
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    prefix_tag = TagNamePrefix + tag
    rootClass = GDSClassesMapping.get(prefix_tag)
    if rootClass is None:
        rootClass = globals().get(prefix_tag)
    return tag, rootClass


def get_required_ns_prefix_defs(rootNode):
    '''Get all name space prefix definitions required in this XML doc.
    Return a dictionary of definitions and a char string of definitions.
    '''
    nsmap = {
        prefix: uri
        for node in rootNode.iter()
        for (prefix, uri) in node.nsmap.items()
        if prefix is not None
    }
    namespacedefs = ' '.join([
        'xmlns:{}="{}"'.format(prefix, uri)
        for prefix, uri in nsmap.items()
    ])
    return nsmap, namespacedefs


def parse(inFileName, silence=False, print_warnings=True):
    global CapturedNsmap_
    gds_collector = GdsCollector_()
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'IUF'
        rootClass = IUF
    rootObj = rootClass.factory()
    rootObj.build(rootNode, gds_collector_=gds_collector)
    CapturedNsmap_, namespacedefs = get_required_ns_prefix_defs(rootNode)
    if not SaveElementTreeNode:
        doc = None
        rootNode = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_=namespacedefs,
            pretty_print=True)
    if print_warnings and len(gds_collector.get_messages()) > 0:
        separator = ('-' * 50) + '\n'
        sys.stderr.write(separator)
        sys.stderr.write('----- Warnings -- count: {} -----\n'.format(
            len(gds_collector.get_messages()), ))
        gds_collector.write_messages(sys.stderr)
        sys.stderr.write(separator)
    return rootObj


def parseEtree(inFileName, silence=False, print_warnings=True,
               mapping=None, reverse_mapping=None, nsmap=None):
    parser = None
    doc = parsexml_(inFileName, parser)
    gds_collector = GdsCollector_()
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'IUF'
        rootClass = IUF
    rootObj = rootClass.factory()
    rootObj.build(rootNode, gds_collector_=gds_collector)
    if mapping is None:
        mapping = {}
    if reverse_mapping is None:
        reverse_mapping = {}
    rootElement = rootObj.to_etree(
        None, name_=rootTag, mapping_=mapping,
        reverse_mapping_=reverse_mapping, nsmap_=nsmap)
    reverse_node_mapping = rootObj.gds_reverse_node_mapping(mapping)
    # Enable Python to collect the space used by the DOM.
    if not SaveElementTreeNode:
        doc = None
        rootNode = None
    if not silence:
        content = etree_.tostring(
            rootElement, pretty_print=True,
            xml_declaration=True, encoding="utf-8")
        sys.stdout.write(str(content))
        sys.stdout.write('\n')
    if print_warnings and len(gds_collector.get_messages()) > 0:
        separator = ('-' * 50) + '\n'
        sys.stderr.write(separator)
        sys.stderr.write('----- Warnings -- count: {} -----\n'.format(
            len(gds_collector.get_messages()), ))
        gds_collector.write_messages(sys.stderr)
        sys.stderr.write(separator)
    return rootObj, rootElement, mapping, reverse_node_mapping


def parseString(inString, silence=False, print_warnings=True):
    '''Parse a string, create the object tree, and export it.

    Arguments:
    - inString -- A string.  This XML fragment should not start
      with an XML declaration containing an encoding.
    - silence -- A boolean.  If False, export the object.
    Returns -- The root object in the tree.
    '''
    parser = None
    rootNode= parsexmlstring_(inString, parser)
    gds_collector = GdsCollector_()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'IUF'
        rootClass = IUF
    rootObj = rootClass.factory()
    rootObj.build(rootNode, gds_collector_=gds_collector)
    if not SaveElementTreeNode:
        rootNode = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='')
    if print_warnings and len(gds_collector.get_messages()) > 0:
        separator = ('-' * 50) + '\n'
        sys.stderr.write(separator)
        sys.stderr.write('----- Warnings -- count: {} -----\n'.format(
            len(gds_collector.get_messages()), ))
        gds_collector.write_messages(sys.stderr)
        sys.stderr.write(separator)
    return rootObj


def parseLiteral(inFileName, silence=False, print_warnings=True):
    parser = None
    doc = parsexml_(inFileName, parser)
    gds_collector = GdsCollector_()
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'IUF'
        rootClass = IUF
    rootObj = rootClass.factory()
    rootObj.build(rootNode, gds_collector_=gds_collector)
    # Enable Python to collect the space used by the DOM.
    if not SaveElementTreeNode:
        doc = None
        rootNode = None
    if not silence:
        sys.stdout.write('#from iuf_full import *\n\n')
        sys.stdout.write('import iuf_full as model_\n\n')
        sys.stdout.write('rootObj = model_.rootClass(\n')
        rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
        sys.stdout.write(')\n')
    if print_warnings and len(gds_collector.get_messages()) > 0:
        separator = ('-' * 50) + '\n'
        sys.stderr.write(separator)
        sys.stderr.write('----- Warnings -- count: {} -----\n'.format(
            len(gds_collector.get_messages()), ))
        gds_collector.write_messages(sys.stderr)
        sys.stderr.write(separator)
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

RenameMappings_ = {
}

#
# Mapping of namespaces to types defined in them
# and the file in which each is defined.
# simpleTypes are marked "ST" and complexTypes "CT".
NamespaceToDefMappings_ = {}

__all__ = [
    "ASPATIAL",
    "ASPATIAL_ITEM",
    "ASPATIAL_NAME",
    "DELETE",
    "DESCRIPTION",
    "EXPORT",
    "HEADER",
    "INNER",
    "INSERT",
    "IUF",
    "LINE",
    "LINE_ITEM",
    "LINE_NAME",
    "OUTER",
    "POINT",
    "POINT_ITEM",
    "POINT_NAME",
    "POLYGON",
    "POLYGON_ITEM",
    "POLYGON_NAME",
    "REPLACE"
]
