import pickle
from itertools import tee, islice, chain
import numpy as np
import pickle as pkl

def chunker(a_list, n, tuple_=False):
    """Yield successive n-sized chunks from l."""
    for i in range(0, len(a_list), n):
        if tuple_ is True:
            yield tuple(a_list[i:i + n])
        else:

            yield a_list[i:i + n]


# module gets previous and next item in a iterable
def previous_and_next(some_iterable):
    prevs, items, nexts = tee(some_iterable, 3)
    prevs = chain([None], prevs)
    nexts = chain(islice(nexts, 1, None), [None])
    return zip(prevs, items, nexts)


# sort a list in tuples
def sort_by_tuple(tup, index=1):
    # key is set to sort using second element of
    # sublist lambda has been used
    tup.sort(key=lambda x: x[index])
    return tup


# converts a matrix into a specified format so can be used with shapley affinity
def convert_r(x):
    if x is not None:
        return x[0][:2].tolist() + x[1][:2].tolist() + x[0][-1:].tolist() + x[1][-1:].tolist()
    else:
        return None


# cycle through a list
def cycle_list(some_list):
    return some_list[1:] + some_list[:1]


# convert polygon to array of points
def convert_polygon_to_array(polygon):
    listarray = []
    if hasattr(polygon, 'exterior'):
        polypoints = polygon.exterior.coords[:]

        for pp in polypoints:
            listarray.append([pp[0], pp[1]])
        return np.array(listarray)


def remove_duplicates(seq):
    seen = set()
    seen_add = seen.add
    return [x for x in seq if not (x in seen or seen_add(x))]


def actually_crosses(A, B, precis=0.05):
    """A hybrid spatial predicate that determines if two geometries cross on both sides"""
    return (B.crosses(A) and
            B.crosses(A.parallel_offset(precis, 'left')) and
            B.crosses(A.parallel_offset(precis, 'right')))


def degrees_minute_seconds_string(hp):
    if '.' in str(hp):
        d, ms = str(hp).split('.')
    else:
        d, ms = str(hp), '0000'
    d = d + u'\u00B0'
    m = ms[:2] + u'\u2019'
    s = ms[2:] + u'\u201D'
    return d + m + s


def write_pickle_to_file(obj, filepath):
    try:
        import dill
        with open(filepath, 'wb') as open_pickle:
            dill.dump(obj, open_pickle, protocol=dill.HIGHEST_PROTOCOL)
    except ImportError:
        with open(filepath, 'wb') as open_pickle:
            pickle.dump(obj, open_pickle, protocol=pickle.HIGHEST_PROTOCOL)

def read_pickle_from_file(filepath):
    try:
        with open(filepath, 'rb') as open_pickle:
            obj = pickle.load(open_pickle)
            return obj
    except:
        import dill
        with open(filepath, 'rb') as open_pickle:
            dill.load(obj, open_pickle)


