import pandas as pd
from utilities.dcmgeometrysdk.dna.dnawriters import DNADistances, DNAPQMeasure, DNADirectionSets
from utilities.dcmgeometrysdk.utilities.pandas_postgis_helpers import psql_insert_copy

class MapDNA2DynadjustMeasureBulk:
    def __init__(self, msr_object, zone_id=None, block_id=None, event_id=None, db_lookup=None):
        self.cadastral_zone_id = zone_id
        self.cadastral_block_id = block_id
        self.distances = msr_object.distances
        self.directions = msr_object.direction_sets
        self.pqs = msr_object.pqs
        self.angles = msr_object.angles
        self.db_lookup = db_lookup
        self.event_id = event_id
        self.df = self.process_all()

    def process_all(self):
        all_dfs = []
        all_dfs.append(self.process_directions())
        all_dfs.append(self.process_distances())
        all_dfs.append(self.process_pqs())
        df = pd.concat(all_dfs)
        df['cadastralzoneid'] = self.cadastral_zone_id
        df['cadastralblockid'] = self.cadastral_block_id
        df['cadastralblockid'] = df['cadastralblockid'].astype('Int64')
        df['cadastralzoneid'] = df['cadastralzoneid'].astype('Int64')
        df['update_event_id'] = None
        df['retire_event_id'] = None
        df.loc[df['ignore'] == '*', ['ignore']] = True
        df.loc[df['ignore'] != True, ['ignore']] = False
        df['first'] = df['first'].astype('Int64')
        df['second'] = df['second'].astype('Int64')
        df['third'] = df['third'].astype('Int64')
        df['value1'] = df['value1'].astype(float)
        df['value2'] = df['value2'].astype(float)
        df['stddev1'] = df['stddev1'].astype(float)
        df['stddev2'] = df['stddev2'].astype(float)
        df['source_id'] = df['source_id'].astype('Int64')
        df['instrumentheight'] = df['instrumentheight'].astype(float)
        df['stationheight'] = df['stationheight'].astype(float)
        df['planid'] = df['planid'].astype('Int64')
        return df

    def process_pqs(self):
        rows = []
        pqs: DNAPQMeasure
        for pqs in self.pqs:
            first = pqs.station_name
            value1 = pqs.coordinate
            second = None
            stddev1 = pqs.std
            source_id = int(pqs.db_id)
            plannumber = self.db_lookup.get(source_id, {}).get('plannumber')
            planid = self.db_lookup.get(source_id, {}).get('planid')
            third = None
            stddev2 = None
            value2 = None
            ignore = pqs.ignore
            type = pqs.measure
            source = 'SV'
            active = True
            instrumentheight = None
            stationheight = None
            create_event_id = self.event_id
            d = {'first': first, 'value1': value1, 'stddev1': stddev1, 'second': second, 'ignore': ignore,
                 'third': third, 'value2': value2, 'stddev2': stddev2, 'plannumber': plannumber, 'type': type,
                 'source': source, 'active': active, 'instrumentheight': instrumentheight, 'planid': planid,
                 'stationheight': stationheight, 'create_event_id': create_event_id, 'source_id': source_id}
            rows.append(d)
        return pd.DataFrame(rows)

    def process_distances(self):
        rows = []
        distance: DNADistances
        for distance in self.distances:
            first = distance.setup
            value1 = distance.distance
            second = distance.target
            stddev1 = distance.dist_std
            source_id = int(distance.db_id)
            plannumber = self.db_lookup.get(source_id, {}).get('plannumber')
            planid = self.db_lookup.get(source_id, {}).get('planid')
            third = None
            stddev2 = None
            value2 = None
            ignore = distance.ignore
            type = 'S'
            source = 'SV'
            active = True
            instrumentheight = distance.ins_height
            stationheight = distance.targ_height
            create_event_id = self.event_id
            d = {'first': first, 'value1': value1, 'stddev1': stddev1, 'second': second, 'ignore': ignore,
                 'third': third, 'value2': value2, 'stddev2': stddev2, 'plannumber': plannumber, 'type': type,
                 'source': source, 'active': active, 'instrumentheight': instrumentheight, 'planid': planid,
                 'stationheight': stationheight, 'create_event_id': create_event_id, 'source_id': source_id}
            rows.append(d)
        return pd.DataFrame(rows)
        
    def process_directions(self):
        rows = []

        for direction_set in self.directions:
            direction_set: DNADirectionSets
            directions = direction_set.direction_set
            if len(directions) > 1:
                first = directions[0].ip
                value1 = directions[0].hp_bearing
                second = directions[0].to_station
                stddev1 = directions[0].std
                source_id = int(directions[0].db_id)
                plannumber = self.db_lookup.get(source_id, {}).get('plannumber')
                planid = self.db_lookup.get(source_id, {}).get('planid')

                if len(directions[0].ignore) > 0:
                    ignore = True
                else:
                    ignore = False
                for direction in directions[1:]:
                    third = direction.to_station
                    stddev2 = direction.std
                    value2 = direction.hp_bearing
                    type = 'D'
                    source = 'SV'
                    active = True
                    instrumentheight = 0
                    stationheight = 0
                    create_event_id = self.event_id
                    d = {'first': first, 'value1': value1, 'stddev1': stddev1, 'second': second, 'ignore': ignore,
                         'third': third, 'value2': value2, 'stddev2': stddev2, 'plannumber': plannumber, 'type': type,
                         'source': source, 'active': active, 'instrumentheight': instrumentheight, 'planid': planid,
                         'stationheight': stationheight, 'create_event_id': create_event_id, 'source_id': source_id}

                    rows.append(d)
        return pd.DataFrame(rows)

    def load_df_to_db(self, engine, table_name='dynadjustmeasure', df=None):
        if df is None:
            df = self.df
        df.to_sql(table_name, engine, schema='adjustment', if_exists='append', method=psql_insert_copy,
                  index=False)
    
