from utilities.dcmgeometrysdk.dcmgeometry.points import PointGeom
import shapely.wkb as swkb
# point is ORM object from sqlalchemy


def create_point(point):
    p = PointGeom()
    p.geometry = swkb.loads(point.geom.desc, hex=True)
    p.original_geom = p.geometry
    p.name = str(point.point_id)
    p.point_oid = point.point_id
    p.point_type = point.dataset_type_id
    p.crs = point.geom.srid
    return p
