#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Wed Oct 28 10:35:04 2020 by generateDS.py version 2.36.2.
# Python 3.8.3 (default, Jul  2 2020, 16:21:59)  [GCC 7.3.0]
#
# Command line options:
#   ('-o', 'landxml.py')
#   ('-s', 'landxmlsubs.py')
#
# Command line arguments:
#   xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd
#
# Command line:
#   /home/anto/Downloads/generateDS-2.36.2/generateDS.py -o "landxml.py" -s "landxmlsubs.py" xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd
#
# Current working directory (os.getcwd()):
#   LandXMLSDK
#

from six.moves import zip_longest
import os
import sys
import re as re_
import base64
import datetime as datetime_
import decimal as decimal_

try:
    from lxml import etree as etree_
except ImportError:
    from xml.etree import ElementTree as etree_

Validate_simpletypes_ = True
SaveElementTreeNode = True
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    try:
        if isinstance(infile, os.PathLike):
            infile = os.path.join(infile)
    except AttributeError:
        pass

    doc = etree_.parse(infile, parser=parser, **kwargs)

    return doc


def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()

    element = etree_.fromstring(instring, parser=parser, **kwargs)

    return element


#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for an example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#
# Additionally, the generatedsnamespaces module can contain a python
# dictionary named GenerateDSNamespaceTypePrefixes that associates element
# types with the namespace prefixes that are to be added to the
# "xsi:type" attribute value.  See the exportAttributes method of
# any generated element type and the generation of "xsi:type" for an
# example of the use of this table.
# An example table:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceTypePrefixes = {
#         "ElementtypeC": "aaa:",
#         "ElementtypeD": "bbb:",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ImportError:
    GenerateDSNamespaceDefs_ = {}
try:
    from generatedsnamespaces import GenerateDSNamespaceTypePrefixes as GenerateDSNamespaceTypePrefixes_
except ImportError:
    GenerateDSNamespaceTypePrefixes_ = {}

#
# You can replace the following class definition by defining an
# importable module named "generatedscollector" containing a class
# named "GdsCollector".  See the default class definition below for
# clues about the possible content of that class.
#
try:
    from generatedscollector import GdsCollector as GdsCollector_
except ImportError:

    class GdsCollector_(object):

        def __init__(self, messages=None):
            if messages is None:
                self.messages = []
            else:
                self.messages = messages

        def add_message(self, msg):
            self.messages.append(msg)

        def get_messages(self):
            return self.messages

        def clear_messages(self):
            self.messages = []

        def print_messages(self):
            for msg in self.messages:
                print("Warning: {}".format(msg))

        def write_messages(self, outstream):
            for msg in self.messages:
                outstream.write("Warning: {}\n".format(msg))

#
# The super-class for enum types
#

try:
    from enum import Enum
except ImportError:
    Enum = object

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:

    class GeneratedsSuper(object):
        __hash__ = object.__hash__
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        eplan_value = False
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name

            def utcoffset(self, dt):
                return self.__offset

            def tzname(self, dt):
                return self.__name

            def dst(self, dt):
                return None

        def gds_format_string(self, input_data, input_name=''):
            return input_data

        def gds_parse_string(self, input_data, node=None, input_name=''):
            return input_data

        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data

        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)

        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data

        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data

        def gds_parse_integer(self, input_data, node=None, input_name=''):
            try:
                ival = int(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires integer value: %s' % exp)
            return ival

        def gds_validate_integer(self, input_data, node=None, input_name=''):
            try:
                value = int(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires integer value')
            return value

        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)

        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integer valuess')
            return values

        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')

        def gds_parse_float(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires float or double value: %s' % exp)
            return fval_

        def gds_validate_float(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires float value')
            return value

        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)

        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of float values')
            return values

        def gds_format_decimal(self, input_data, input_name=''):
            return_value = '%s' % input_data
            if '.' in return_value:
                return_value = return_value.rstrip('0')
                if return_value.endswith('.'):
                    return_value = return_value.rstrip('.')
            return return_value

        def gds_parse_decimal(self, input_data, node=None, input_name=''):
            try:
                decimal_value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return decimal_value

        def gds_validate_decimal(self, input_data, node=None, input_name=''):
            try:
                value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return value

        def gds_format_decimal_list(self, input_data, input_name=''):
            return ' '.join([self.gds_format_decimal(item) for item in input_data])

        def gds_validate_decimal_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    decimal_.Decimal(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of decimal values')
            return values

        def gds_format_double(self, input_data, input_name=''):
            return '%f' % input_data

        def gds_format_double_round(self, input_data, rounder=3, input_name=''):
            return f"%.{rounder}f" % round(input_data, rounder)

        def gds_parse_double(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires double or float value: %s' % exp)
            return fval_

        def gds_validate_double(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires double or float value')
            return value

        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)

        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(
                        node, 'Requires sequence of double or float values')
            return values

        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()

        def gds_parse_boolean(self, input_data, node=None, input_name=''):
            if input_data in ('true', '1'):
                bval = True
            elif input_data in ('false', '0'):
                bval = False
            else:
                raise_parse_error(node, 'Requires boolean value')
            return bval

        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            if input_data not in (True, 1, False, 0,):
                raise_parse_error(
                    node,
                    'Requires boolean value '
                    '(one of True, 1, False, 0)')
            return input_data

        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)

        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in (True, 1, False, 0,):
                    raise_parse_error(
                        node,
                        'Requires sequence of boolean values '
                        '(one of True, 1, False, 0)')
            return values

        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data

        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue

        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (
                    time_parts[0], "{}".format(micro_seconds).rjust(6, "0"),)
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt

        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data

        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue

        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data != '':
                if input_data[-1] == 'Z':
                    tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                    input_data = input_data[:-1]
                else:
                    results = GeneratedsSuper.tzoff_pattern.search(input_data)
                    if results is not None:
                        tzoff_parts = results.group(2).split(':')
                        tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                        if results.group(1) == '-':
                            tzoff *= -1
                        tz = GeneratedsSuper._FixedOffsetTZ(
                            tzoff, results.group(0))
                        input_data = input_data[:-6]
                dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
                dt = dt.replace(tzinfo=tz)
                return dt.date()
            return None

        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data

        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue

        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.
            # The target value must match at least one of the patterns
            # in order for the test to succeed.
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    mo = re_.search(patterns2, str(target))
                    if mo is not None and len(mo.group(0)) == len(str(target)):
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1

        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()

        def gds_check_cardinality_(
                self, value, input_name,
                min_occurs=0, max_occurs=1, required=None):
            if value is None:
                length = 0
            elif isinstance(value, list):
                length = len(value)
            else:
                length = 1
            if required is not None:
                if required and length < 1:
                    self.gds_collector_.add_message(
                        "Required value {}{} is missing".format(
                            input_name, self.gds_get_node_lineno_()))
            if length < min_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is below "
                    "the minimum allowed, "
                    "expected at least {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        min_occurs, length))
            elif length > max_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is above "
                    "the maximum allowed, "
                    "expected at most {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        max_occurs, length))

        def gds_validate_builtin_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value, input_name=input_name)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))

        def gds_validate_defined_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))

        def gds_str_lower(self, instring):
            return instring.lower()

        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path

        Tag_strip_pattern_ = re_.compile(r'\{.*\}')

        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)

        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'nsmap' in node.attrib:
                if 'xsi' in node.nsmap:
                    classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1

        def gds_build_any(self, node, type_name=None):
            # provide default value in case option --disable-xml is used.
            content = ""
            content = etree_.tostring(node, encoding="unicode")
            return content

        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.items()))

        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                if ExternalEncoding:
                    encoding = ExternalEncoding
                else:
                    encoding = 'utf-8'
                return instring.encode(encoding)
            else:
                return instring

        @staticmethod
        def convert_unicode(instring):
            if isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode('utf8')
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result

        def __eq__(self, other):
            def excl_select_objs_(obj):
                return (obj[0] != 'parent_object_' and
                        obj[0] != 'gds_collector_')

            if type(self) != type(other):
                return False
            return all(x == y for x, y in zip_longest(
                filter(excl_select_objs_, self.__dict__.items()),
                filter(excl_select_objs_, other.__dict__.items())))

        def __ne__(self, other):
            return not self.__eq__(other)

        # Django ETL transform hooks.
        def gds_djo_etl_transform(self):
            pass

        def gds_djo_etl_transform_db_obj(self, dbobj):
            pass

        # SQLAlchemy ETL transform hooks.
        def gds_sqa_etl_transform(self):
            return 0, None

        def gds_sqa_etl_transform_db_obj(self, dbobj):
            pass

        def gds_get_node_lineno_(self):
            if (hasattr(self, "gds_elementtree_node_") and
                    self.gds_elementtree_node_ is not None):
                if hasattr(self.gds_elementtree_node_, 'sourceline'):
                    return ' near line {}'.format(
                        self.gds_elementtree_node_.sourceline)
                else:
                    return ""
            else:
                return ""

    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None

#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = ''
# Set this to false in order to deactivate during export, the use of
# name space prefixes captured from the input document.
UseCapturedNS_ = True
CapturedNsmap_ = {}
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None


#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        if 'nsmap' in node.attrib:
            namespace = node.nsmap.get(prefix)
            if namespace is not None:
                value = attrs.get('{%s}%s' % (namespace, name,))
    return value


def encode_str_2_3(instr):
    return instr


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if node is not None:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline,)
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8

    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value

    def getCategory(self):
        return self.category

    def getContenttype(self, content_type):
        return self.content_type

    def getValue(self):
        return self.value

    def getName(self):
        return self.name

    def export(self, outfile, level, name, namespace,
               pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:  # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name_=name,
                pretty_print=pretty_print)

    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name,
                base64.b64encode(self.value),
                self.name))

    def to_etree(self, element, mapping_=None, nsmap_=None):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(
                element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:  # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)

    def to_etree_simple(self, mapping_=None, nsmap_=None):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
              self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
              self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text

    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        else:  # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0,
                 optional=0, child_attrs=None, choice=None):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional

    def set_name(self, name):
        self.name = name

    def get_name(self):
        return self.name

    def set_data_type(self, data_type):
        self.data_type = data_type

    def get_data_type_chain(self):
        return self.data_type

    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type

    def set_container(self, container):
        self.container = container

    def get_container(self):
        return self.container

    def set_child_attrs(self, child_attrs):
        self.child_attrs = child_attrs

    def get_child_attrs(self):
        return self.child_attrs

    def set_choice(self, choice):
        self.choice = choice

    def get_choice(self):
        return self.choice

    def set_optional(self, optional):
        self.optional = optional

    def get_optional(self):
        return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)


#
# Data representation classes.
#


class addressPointTypeType(str, Enum):
    """Corresponds to GEOCODE_FEATURE in Vicmap Address"""
    ENTRANCE = 'Entrance'
    VIRTUAL = 'Virtual'


class addressTypeType(str, Enum):
    """Corresponds to IS_PRIMARY field in Vicmap Address"""
    PRIMARY = 'Primary'
    SECONDARY = 'Secondary'


class adminAreaTypeType(str, Enum):
    """Allowable Admin Area types in VIC"""
    LGA = 'LGA'
    LOCALITY = 'Locality'
    COUNTY = 'County'
    PARISH = 'Parish'
    TOWNSHIP = 'Township'


class adminDateTypeType(str, Enum):
    """Allowable Admin Date types in VIC"""
    DATEOF_SURVEY = 'Date of Survey'
    DATEOF_REGISTRATION = 'Date of Registration'


class angularType(str, Enum):
    """Angular values expressed in "decimal dd.mm.ss" units have the numeric
    format "45.3025" representing 45 degrees 30 minutes and 25 seconds. Both
    the minutes and seconds must be
    two characters with a numeric range from 00 to 60."""
    DECIMALDDMMSS = 'decimal dd.mm.ss'


class annotationType(str, Enum):
    """TODO"""
    SECTION_35_SEE_RECORDINGOF_VESTING_TABLE_ATTACHED = 'Section 35 - See Recording of Vesting Table Attached'
    SECTION_35_COMPULSORY = 'Section 35 Compulsory'
    SECTION_35_AGREEMENT = 'Section 35 Agreement'
    PLANNING_PERMIT = 'Planning Permit'
    REPORTON_DATUM = 'Report on Datum'
    INSTRUMENTAND_CALIBRATION_DETAILS = 'Instrument and Calibration Details'
    CROWN_SECTION = 'Crown Section'
    CROWN_ALLOTMENT = 'Crown Allotment'
    CROWN_PORTION = 'Crown Portion'
    OTHER_CROWN_DESCRIPTION = 'Other Crown Description'
    PARCELWITH_AREABY_DEDUCTION = 'Parcel with Area by Deduction'
    RESTRICTION_EXPIRY_DATE = 'Restriction Expiry Date'
    GENERAL_PLAN_NOTATION = 'General Plan Notation'
    ABSTRACTOF_FIELD_RECORDS_NOTATION = 'Abstract of Field Records Notation'
    SURVEYORS_REPORT_NOTATION = 'Surveyor\'s Report Notation'
    TITLE_CLOSURE_JUSTIFICATION = 'Title Closure Justification'
    GENERAL_EASEMENT_NOTATION = 'General Easement Notation'
    EASEMENT_QUALIFICATION = 'Easement Qualification'
    IMPLIED_EASEMENT_NOTATION = 'Implied Easement Notation'
    EASEMENT_PURPOSE = 'Easement Purpose'
    EASEMENT_ORIGIN = 'Easement Origin'
    EASEMENT_BENEFICIARY = 'Easement Beneficiary'
    EASEMENT_WIDTH = 'Easement Width'
    SUPPLYOF_SUPPLEMENTARY_FIELD_RECORD_NOTATION = 'Supply of Supplementary Field Record Notation'
    BUILDING_BOUNDARY_NOTATION = 'Building Boundary Notation'
    OWNERS_CORPORATION_NOTATION = 'Owners Corporation Notation'
    ADDITIONAL_PURPOSEOF_PLAN = 'Additional Purpose of Plan'
    SECTION_12_2OFTHE_SUBDIVISION_ACT_1988APPLIESVIDETHISPLAN = 'Section 12(2) of the Subdivision Act 1988 applies vide this plan'
    SECTION_12_2OFTHE_SUBDIVISION_ACT_1988DOESNOTAPPLYVIDETHISPLAN = 'Section 12(2) of the Subdivision Act 1988 does not apply vide this plan'
    PURPOSE_OF_THE_OWNERS_CORPORATION = 'Purpose Of The Owners Corporation'
    THE_BASIS_FOR_ALLOCATION_OF_LOT_ENTITLEMENT_AND_LIABILITY = 'The Basis For Allocation Of Lot Entitlement And Liability'
    DETAILS_OF_THE_LIMITATIONS_OF_THE_OWNERS_CORPORATION = 'Details Of The Limitations Of The Owners Corporation'
    FUNCTIONS_OR_OBLIGATIONS_REFERRED_BY_THE_LIMITED_OWNERS_CORPORATION = 'Functions Or Obligations Referred By The Limited Owners Corporation'
    FUNCTIONS_OR_OBLIGATIONS_REFERRED_TO_THE_UNLIMITED_OWNERS_CORPORATION = 'Functions Or Obligations Referred To The Unlimited Owners Corporation'
    PURPOSEOF_PLAN = 'Purpose of Plan'
    GROUNDSFOR_REMOVAL = 'Grounds for Removal'
    GROUNDSFOR_VARIATION = 'Grounds for Variation'
    GROUNDSFOR_VESTING = 'Grounds for Vesting'
    FUTURE_PLAN_NUMBER = 'Future Plan Number'
    PRIOR_SURVEY = 'Prior Survey'
    BALANCE_OF_EXISTINGOC_ENTITLEMENT = 'Balance Of Existing OC Entitlement'
    BALANCE_OF_EXISTINGOC_LIABILITY = 'Balance Of Existing OC Liability'
    ADDITIONAL_PLAN_REFERENCE = 'Additional Plan Reference'
    ADJUSTMENT_EXCLUSION = 'Adjustment Exclusion'


class clockwise(str, Enum):
    CW = 'cw'
    CCW = 'ccw'


class distObservationType(str, Enum):
    """Values ascertained from OSGV"""
    ADOPT_DIMENSION = 'Adopt Dimension'
    COMPUTED = 'Computed'
    DERIVED = 'Derived'
    MEASURED = 'Measured'
    ABOUT = 'About'
    PROVIDEDBY_DELWP = 'ProvidedbyDELWP'
    ESTIMATED = 'Estimated'
    IGNORED = 'Ignored'


class equipmentType(str, Enum):
    """See reference list"""
    GNSSINCGPS = 'GNSS (inc. GPS)'
    LEVEL = 'Level'
    TAPE = 'Tape'
    THEODOLITEANDEDM = 'Theodolite and EDM'
    THEODOLITEAND_STEEL_BAND = 'Theodolite and Steel Band'
    TOTAL_STATION = 'Total Station'


class flatTypeType(str, Enum):
    """See reference list"""
    ANTENNA = 'Antenna'
    APARTMENT = 'Apartment'
    AUTO_TELLER_MACHINE = 'Auto Teller Machine'
    BARBEQUE = 'Barbeque'
    BATHING_BOX = 'Bathing Box'
    BERTH = 'Berth'
    BOATSHED = 'Boatshed'
    BUILDING = 'Building'
    BUNGALOW = 'Bungalow'
    CAGE = 'Cage'
    CARPARK = 'Carpark'
    CARSPACE = 'Carspace'
    CARWASH = 'Carwash'
    CLUB = 'Club'
    COOLROOM = 'Coolroom'
    COTTAGE = 'Cottage'
    COURTYARD = 'Courtyard'
    DUPLEX = 'Duplex'
    FACTORY = 'Factory'
    FLAT = 'Flat'
    GARAGE = 'Garage'
    GATE = 'Gate'
    HALL = 'Hall'
    HANGAR = 'Hangar'
    HELIPORT = 'Heliport'
    HOSTEL = 'Hostel'
    HOUSE = 'House'
    JETTY = 'Jetty'
    KIOSK = 'Kiosk'
    LEASE = 'Lease'
    LOBBY = 'Lobby'
    LOFT = 'Loft'
    LOT = 'Lot'
    MAISONETTE = 'Maisonette'
    MARINE_BERTH = 'Marine Berth'
    OFFICE = 'Office'
    PASSAGEWAY = 'Passageway'
    PENTHOUSE = 'Penthouse'
    RECEPTION = 'Reception'
    RESERVE = 'Reserve'
    RESTAURANT = 'Restaurant'
    ROOM = 'Room'
    SHED = 'Shed'
    SHOP = 'Shop'
    SHOWCASE = 'Showcase'
    SHOWROOM = 'Showroom'
    SIGN = 'Sign'
    SITE = 'Site'
    STALL = 'Stall'
    STORE = 'Store'
    STRATA_UNIT = 'Strata Unit'
    STUDIO = 'Studio'
    STUDIO_APARTMENT = 'Studio Apartment'
    SUBSTATION = 'Substation'
    SUITE = 'Suite'
    TENANCY = 'Tenancy'
    TOILET = 'Toilet'
    TOWER = 'Tower'
    TOWNHOUSE = 'Townhouse'
    UNIT = 'Unit'
    VAULT = 'Vault'
    VILLA = 'Villa'
    WARD = 'Ward'
    WAREHOUSE = 'Warehouse'
    WORKSHOP = 'Workshop'


class floorLevelTypeType(str, Enum):
    """See reference list"""
    BASEMENT = 'Basement'
    FLOOR = 'Floor'
    GROUND = 'Ground'
    LEVEL = 'Level'
    LOBBY = 'Lobby'
    LOWER_GROUND_FLOOR = 'Lower Ground Floor'
    LOWER_LEVEL = 'Lower Level'
    MEZZANINE = 'Mezzanine'
    OBSERVATION_DECK = 'Observation Deck'
    PARKING = 'Parking'
    PLATFORM = 'Platform'
    PODIUM = 'Podium'
    ROOFTOP = 'Rooftop'
    SUBBASEMENT = 'Sub-basement'
    UPPER_GROUND_FLOOR = 'Upper Ground Floor'


class gsMethodType(str, Enum):
    """See reference list"""
    INTERPOLATED = 'Interpolated'
    MODIFIED = 'Modified'
    RIGOROUS = 'Rigorous'


class gsModelType(str, Enum):
    """See reference list"""
    AUSGEOID_93 = 'AUSGEOID93'
    AUSGEOID_96 = 'AUSGEOID96'
    AUSGEOID_98 = 'AUSGEOID98'
    GEM_8 = 'GEM8'
    OSU_89 = 'OSU89'
    OSU_89_A = 'OSU89A'


class headOfPowerType(str, Enum):
    SUBDIVISION_ACT_1988 = 'Subdivision Act 1988'
    OWNERS_CORPORATION_ACT_2006 = 'Owners Corporation Act 2006'
    TRANSFEROF_LAND_ACT_1958 = 'Transfer of Land Act 1958'


class horzDatumType(str, Enum):
    LOCAL = 'Local'
    MGA_94__ZONE_54 = 'MGA94_Zone54'
    MGA_94__ZONE_55 = 'MGA94_Zone55'
    MGA_2020__ZONE_54 = 'MGA2020_Zone54'
    MGA_2020__ZONE_55 = 'MGA2020_Zone55'
    AMG_66__ZONE_54 = 'AMG66_Zone54'
    AMG_66__ZONE_55 = 'AMG66_Zone55'
    GDA_2020 = 'GDA2020'


class horzDatumTypeOrEmpty(str, Enum):
    MGA_2020__ZONE_54 = 'MGA2020_Zone54'
    MGA_2020__ZONE_55 = 'MGA2020_Zone55'
    GDA_2020 = 'GDA2020'
    _ = ''


class horzFixType(str, Enum):
    """See reference list"""
    ADJUSTMENT = 'Adjustment'
    CADASTRAL = 'Cadastral'
    DIGITISED = 'Digitised'
    GPS_DIFFERENTIAL = 'GPS(Differential)'
    GPS_KINEMATICS = 'GPS(Kinematics)'
    GPS_SINGLE_POINT = 'GPS(Single Point)'
    INTERSECTION = 'Intersection'
    PLOT = 'Plot'
    RADIATION = 'Radiation'
    RESECTION = 'Resection'
    TRANSFORMED = 'Transformed'
    TRAVERSE = 'Traverse'
    TRIANGULATION = 'Triangulation'
    UNCHECKED_RADIATION = 'Unchecked Radiation'
    UNKNOWN = 'Unknown'
    _ = ''


class horzOrderType(str, Enum):
    """See reference list"""
    _0 = '0'
    _1 = '1'
    _2 = '2'
    _3 = '3'
    _4 = '4'
    _5 = '5'
    _9_9 = '99'


class instrumentHeightType(str, Enum):
    """Force a default value of 0"""
    _0 = '0'


class jurisdictionType(str, Enum):
    VICTORIA = 'Victoria'


class latLongAngularType(str, Enum):
    """Latitude and Longitude coordinate angular values. Latitude (range -90 to
    +90) positive values for the northern hemisphere, negative for
    southern. Longitude (range -180 to +180) positive values are east of
    the prime meridian, negative values are west. Values expressed in
    "decimal dd.mm.ss" units have the format "45.3025" representing 45
    degrees 30 minutes and 25 seconds. Both the minutes and seconds must be
    two digits with a range of 00 to 60."""
    DECIMALDDMMSS = 'decimal dd.mm.ss'


class lineDescType(str, Enum):
    """The physical description of building boundaries."""
    EXTERIOR_FACE = 'Exterior Face'
    INTERIOR_FACE = 'Interior Face'
    MEDIAN = 'Median'
    OTHER = 'Other'


class metArea(str, Enum):
    SQUARE_METER = 'squareMeter'


class metLinear(str, Enum):
    METER = 'meter'


class metPressure(str, Enum):
    MILLI_BARS = 'milliBars'


class metTemperature(str, Enum):
    CELSIUS = 'celsius'


class metVolume(str, Enum):
    CUBIC_METER = 'cubicMeter'


class monumentCondition(str, Enum):
    """See reference list"""
    ABANDONED = 'Abandoned'
    DAMAGED = 'Damaged'
    DESTROYED = 'Destroyed'
    DISTURBED = 'Disturbed'
    FOUND = 'Found'
    LEANING = 'Leaning'
    LOOSE = 'Loose'
    NIPPLE_DAMAGED = 'Nipple Damaged'
    NOT_FOUND = 'Not Found'
    NOT_USED = 'Not Used'
    OK = 'OK'
    ORIGIN = 'Origin'
    PLACED = 'Placed'
    PLAQUE_MISSING = 'Plaque Missing'
    REMOVED = 'Removed'
    REPLACED = 'Replaced'
    SUSPECT = 'Suspect'
    UNKNOWN = 'Unknown'
    UNSTABLE = 'Unstable'


class monumentState(str, Enum):
    """States for monuments"""
    EXISTING = 'Existing'
    NEW = 'New'


class monumentType(str, Enum):
    """See reference list"""
    BOLT = 'Bolt'
    CHISEL_CUT = 'Chisel Cut'
    CROSS_HEAD_NAIL = 'Cross Head Nail'
    DEEP_DRIVEN_ROD = 'Deep Driven Rod'
    DRILL_HOLE = 'Drill Hole'
    DRILL_HOLEWITH_WINGS = 'Drill Hole with Wings'
    DUMPY = 'Dumpy'
    GI_NAIL = 'G.I. Nail'
    GI_PIPE = 'G.I. Pipe'
    NAILIN_JOIN = 'Nail in Join'
    NAILIN_PEG = 'Nail in Peg'
    NAILIN_POST = 'Nail in Post'
    NAILIN_RAIL = 'Nail in Rail'
    NOT_MARKED = 'Not Marked'
    OTHER = 'Other'
    PEG = 'Peg'
    PEGAND_TRENCH = 'Peg and Trench'
    PIN = 'Pin'
    PLAQUE = 'Plaque'
    REFERENCE_TREE = 'Reference Tree'
    RIVET = 'Rivet'
    ROD = 'Rod'
    ROUND_POST = 'Round Post'
    SSM_STANDARD_SURVEY_MARK = 'SSM (Standard Survey Mark)'
    SCREW = 'Screw'
    SPIKE = 'Spike'
    SPLIT_POST = 'Split Post'
    SQUARE_POST = 'Square Post'
    STAR_PICKET = 'Star Picket'
    SURVEY_NAIL = 'Survey Nail'
    TREE = 'Tree'
    UNKNOWN = 'Unknown'
    BRICK_BASE = 'Brick Base'
    BRICK_CORNER = 'Brick Corner'
    CEMENTFACED_BRICK = 'Cement faced Brick'
    CORNER = 'Corner'
    ETCH = 'Etch'
    INSTRUMENT_POINT = 'Instrument Point'
    NAIL = 'Nail'
    PIPE = 'Pipe'
    PIT_COVER = 'Pit Cover'
    POST = 'Post'
    SSM = 'SSM'
    STONE_BASE = 'Stone Base'
    HOLE = 'Hole'
    PM = 'PM'
    TRENCHES = 'Trenches'


class observationType(str, Enum):
    """Values ascertained from OSGV"""
    ADOPT_DIMENSION = 'Adopt Dimension'
    COMPUTED = 'Computed'
    DERIVED = 'Derived'
    MEASURED = 'Measured'
    ABOUT = 'About'
    ASSUMED = 'Assumed'
    PROVIDEDBY_DELWP = 'ProvidedbyDELWP'
    ESTIMATED = 'Estimated'
    IGNORED = 'Ignored'


class parcelClass(str, Enum):
    COMMON_PROPERTY = 'Common Property'
    LOT = 'Lot'
    ROAD = 'Road'
    RESERVE = 'Reserve'
    STAGE_LOT = 'Stage Lot'
    CROWN_ALLOTMENT = 'Crown Allotment'
    CROWN_PORTION = 'Crown Portion'
    CROWN_SECTION = 'Crown Section'
    EASEMENT = 'Easement'
    RESTRICTION = 'Restriction'
    DEPTH_LIMITATION = 'Depth Limitation'
    OWNERS_CORPORATION = 'Owners Corporation'
    ADMINISTRATIVE_AREA = 'Administrative Area'
    BALANCE = 'Balance'
    NIS = 'NIS'
    NIT = 'NIT'
    WIP = 'WIP'


class parcelFormat(str, Enum):
    """The type of boundaries the parcel is described by."""
    STANDARD = 'Standard'
    _2_D_BUILDING = '2D Building'
    GEOMETRY = 'Geometry'


class parcelStateType(str, Enum):
    """This is an extension of the LandXML state type, but is specific to
    parcels"""
    AFFECTED = 'affected'
    CREATED = 'created'
    EXTINGUISHED = 'extinguished'
    REFERENCED = 'referenced'
    PROPOSED = 'proposed'
    EXISTING = 'existing'


class parcelTypeType(str, Enum):
    """From national template"""
    ADMINISTRATIVE = 'Administrative'
    SINGLE = 'Single'
    MULTIPART = 'Multipart'
    PART = 'Part'


class planFeatureType(str, Enum):
    """A jurisdictionally specific list of Plan Feature Types which are used in
    conjunction with a sequence number to define the PlanFeature@name
    attribute. Each enumeration is used to define a linestyle during
    visualisation of the plan feature."""
    BRT = 'BRT'
    CHAIN = 'CHAIN'
    CNTL = 'CNTL'
    FEN = 'FEN'
    GATE = 'GATE'
    HDG = 'HDG'
    KERB = 'KERB'
    NSMB = 'NSMB'
    OFF = 'OFF'
    OTH = 'OTH'
    RAIL = 'RAIL'
    RWALL = 'RWALL'
    TWALL = 'TWALL'
    WALL = 'WALL'


class purpSurvType(str, Enum):
    """Application Types"""
    SECTION_6_1K = 'Section 6(1)(K)'
    SECTION_22_PLANOF_SUBDIVISION = 'Section 22-Plan of Subdivision'
    SECTION_22_PLANOF_CONSOLIDATION = 'Section 22-Plan of Consolidation'
    SECTION_23_CREATIONOF_EASEMENT = 'Section 23-Creation of Easement'
    SECTION_23_REMOVALOF_EASEMENT = 'Section 23-Removal of Easement'
    SECTION_23_VARIATIONOF_EASEMENT = 'Section 23-Variation of Easement'
    SECTION_23_CREATIONAND_REMOVALOF_EASEMENT = 'Section 23-Creation and Removal of Easement'
    SECTION_23_CREATIONAND_VARIATIONOF_EASEMENT = 'Section 23-Creation and Variation of Easement'
    SECTION_23_REMOVALAND_VARIATIONOF_EASEMENT = 'Section 23-Removal and Variation of Easement'
    SECTION_23_CREATIONAND_REMOVALAND_VARIATIONOF_EASEMENT = 'Section 23-Creation and Removal and Variation of Easement'
    SECTION_23_VARIATIONOF_CONDITIONIN_CROWN_GRANT = 'Section 23-Variation of Condition in Crown Grant'
    SECTION_23_REMOVALOF_CONDITIONIN_CROWN_GRANT = 'Section 23-Removal of Condition in Crown Grant'
    SECTION_23_CREATIONOF_RESTRICTION = 'Section 23-Creation of Restriction'
    SECTION_23_REMOVALOF_RESTRICTION = 'Section 23-Removal of Restriction'
    SECTION_23_VARIATIONOF_RESTRICTION = 'Section 23-Variation of Restriction'
    SECTION_24_A_VESTINGOFA_RESERVE = 'Section 24a-Vesting of a Reserve'
    SECTION_24_A_REMOVALOFA_RESERVE_PLANOF_SUBDIVISION = 'Section 24a-Removal of a Reserve (Plan of Subdivision)'
    SECTION_24_A_REMOVALOFA_RESERVE_PLANOF_CONSOLIDATION = 'Section 24a-Removal of a Reserve (Plan of Consolidation)'
    SECTION_24_A_REMOVALAND_VESTINGOFA_RESERVE_PLANOF_SUBDIVISION = 'Section 24a-Removal and Vesting of a Reserve (Plan of Subdivision)'
    SECTION_24_A_REMOVALAND_VESTINGOFA_RESERVE_PLANOF_CONSOLIDATION = 'Section 24a-Removal and Vesting of a Reserve (Plan of Consolidation)'
    SECTION_26 = 'Section 26'
    SECTION_32_PLANTOALTERLANDAFFECTEDBYANOWNERSCORPORATION_PLANOF_SUBDIVISION = 'Section 32-Plan to alter land affected by an owners corporation (Plan of Subdivision)'
    SECTION_32_PLANTOALTERLANDAFFECTEDBYANOWNERSCORPORATION_REGISTERED_PLAN = 'Section 32-Plan to alter land affected by an owners corporation (Registered Plan)'
    SECTION_32_PLANTOALTERLANDAFFECTEDBYANOWNERSCORPORATION_STRATA_PLAN = 'Section 32-Plan to alter land affected by an owners corporation (Strata Plan)'
    SECTION_32_PLANTOALTERLANDAFFECTEDBYANOWNERSCORPORATION_CLUSTER_SUBDIVISION = 'Section 32-Plan to alter land affected by an owners corporation (Cluster Subdivision)'
    SECTION_32_A_PLANOF_SUBDIVISIONOFLANDIFANOWNERSCORPORATIONISAFFECTED = 'Section 32a-Plan of Subdivision of land if an owners corporation is affected'
    SECTION_32_A_PLANOF_CONSOLIDATIONOFLANDIFANOWNERSCORPORATIONISAFFECTED = 'Section 32a-Plan of Consolidation of land if an owners corporation is affected'
    SECTION_32_B_PLANTOCREATEANOWNERSCORPORATION_EXISTING_PLAN = 'Section 32b-Plan to create an owners corporation (Existing Plan)'
    SECTION_32_B_PLANTOCREATEANOWNERSCORPORATION_NEW_PLAN = 'Section 32b-Plan to create an owners corporation (New Plan)'
    SECTION_35_ACQUISITIONOFLANDBYACQUIRINGAUTHORITY = 'Section 35-Acquisition of land by acquiring authority'
    SECTION_35_ACQUISITIONOFLANDIFANOWNERSCORPORATIONISAFFECTED_PLANOF_SUBDIVISION = 'Section 35-Acquisition of land if an owners corporation is affected (Plan of Subdivision)'
    SECTION_35_ACQUISITIONOFLANDIFANOWNERSCORPORATIONISAFFECTED_REGISTERED_PLAN = 'Section 35-Acquisition of land if an owners corporation is affected (Registered Plan)'
    SECTION_35_ACQUISITIONOFLANDIFANOWNERSCORPORATIONISAFFECTED_STRATA_PLAN = 'Section 35-Acquisition of land if an owners corporation is affected (Strata Plan)'
    SECTION_35_ACQUISITIONOFLANDIFANOWNERSCORPORATIONISAFFECTED_CLUSTER_SUBDIVISION = 'Section 35-Acquisition of land if an owners corporation is affected (Cluster Subdivision)'
    SECTION_35_8_SUBDIVISIONOFLANDVESTEDORREGISTEREDINAUTHORITY = 'Section 35(8)-Subdivision of land vested or registered in authority'
    SECTION_35_8_CONSOLIDATIONOFLANDVESTEDORREGISTEREDINAUTHORITY = 'Section 35(8)-Consolidation of land vested or registered in authority'
    SECTION_37_PLANOF_SUBDIVISION_STAGED_PLAN = 'Section 37-Plan of Subdivision (Staged Plan)'
    SECTION_37_ACQUISITIONOFLAND_PLANOF_SUBDIVISION_STAGED = 'Section 37-Acquisition of land (Plan of Subdivision (Staged))'
    SECTION_37_8 = 'Section 37(8)'


class purposeType(str, Enum):
    """Used by many of the Survey elements"""
    NORMAL = 'normal'
    TRAVERSE = 'traverse'
    SIDESHOT = 'sideshot'
    TOPO = 'topo'


class registrationType(str, Enum):
    LICENSED_CADASTRAL_SURVEYOR = 'Licensed Cadastral Surveyor'


class roadNameSuffixType(str, Enum):
    """See reference list"""
    A = 'A'
    B = 'B'
    BRANCH = 'Branch'
    C = 'C'
    CENTRAL = 'Central'
    DEVIATION = 'Deviation'
    EAST = 'East'
    EXTENSION = 'Extension'
    INNER = 'Inner'
    LOWER = 'Lower'
    MALL = 'Mall'
    NORTH = 'North'
    NORTH_EAST = 'North East'
    NORTH_WEST = 'North West'
    OFF = 'Off'
    ON = 'On'
    OUTER = 'Outer'
    SOUTH = 'South'
    SOUTH_EAST = 'South East'
    SOUTH_WEST = 'South West'
    UPPER = 'Upper'
    WEST = 'West'


class roadNameTypeType(str, Enum):
    """See reference list"""
    ACCESS = 'Access'
    ALLEY = 'Alley'
    ALLEYWAY = 'Alleyway'
    AMBLE = 'Amble'
    ANCHORAGE = 'Anchorage'
    APARTMENTS = 'Apartments'
    APPROACH = 'Approach'
    ARCADE = 'Arcade'
    ARCH = 'Arch'
    ARTERIAL = 'Arterial'
    ARTERY = 'Artery'
    AVENUE = 'Avenue'
    BANAN = 'Banan'
    BANK = 'Bank'
    BASIN = 'Basin'
    BAY = 'Bay'
    BEACH = 'Beach'
    BELT = 'Belt'
    BEND = 'Bend'
    BLOCK = 'Block'
    BLUFF = 'Bluff'
    BOARDWALK = 'Boardwalk'
    BOULEVARD = 'Boulevard'
    BOULEVARDE = 'Boulevarde'
    BOWL = 'Bowl'
    BRACE = 'Brace'
    BRAE = 'Brae'
    BRANCHLINE = 'Branchline'
    BREAK = 'Break'
    BRIDGE = 'Bridge'
    BROADWAY = 'Broadway'
    BROW = 'Brow'
    BYPASS = 'Bypass'
    BYWAY = 'Byway'
    CAUSEWAY = 'Causeway'
    CENTRE = 'Centre'
    CENTREWAY = 'Centreway'
    CHASE = 'Chase'
    CIRCLE = 'Circle'
    CIRCLET = 'Circlet'
    CIRCUIT = 'Circuit'
    CIRCUS = 'Circus'
    CLAIM = 'Claim'
    CLOSE = 'Close'
    CLUSTER = 'Cluster'
    COLONNADE = 'Colonnade'
    COMMON = 'Common'
    CONCOURSE = 'Concourse'
    CONNECTION = 'Connection'
    CONNECTOR = 'Connector'
    COPSE = 'Copse'
    CORNER = 'Corner'
    CORSEO = 'Corseo'
    CORSO = 'Corso'
    COURSE = 'Course'
    COURT = 'Court'
    COURTS = 'Courts'
    COURTYARD = 'Courtyard'
    COVE = 'Cove'
    CRESCENT = 'Crescent'
    CREST = 'Crest'
    CRIEF = 'Crief'
    CROOK = 'Crook'
    CROSS = 'Cross'
    CROSSING = 'Crossing'
    CROSSROAD = 'Crossroad'
    CROSSWAY = 'Crossway'
    CRUISEWAY = 'Cruiseway'
    CUL = 'Cul'
    CUL_DE_SAC = 'Cul-De-Sac'
    CUTTING = 'Cutting'
    DALE = 'Dale'
    DASH = 'Dash'
    DELL = 'Dell'
    DENE = 'Dene'
    DEVIATION = 'Deviation'
    DIP = 'Dip'
    DISTRIBUTOR = 'Distributor'
    DIVIDE = 'Divide'
    DOCK = 'Dock'
    DOMAIN = 'Domain'
    DOWN = 'Down'
    DOWNS = 'Downs'
    DRIFT = 'Drift'
    DRIVE = 'Drive'
    DRIVEWAY = 'Driveway'
    EDGE = 'Edge'
    ELBOW = 'Elbow'
    ELM = 'Elm'
    END = 'End'
    ENTRANCE = 'Entrance'
    ESPLANADE = 'Esplanade'
    ESTATE = 'Estate'
    EXPRESSWAY = 'Expressway'
    EXTENSION = 'Extension'
    FAIRWAY = 'Fairway'
    FALL = 'Fall'
    FARE = 'Fare'
    FARMS = 'Farms'
    FEN = 'Fen'
    FERN = 'Fern'
    FIREBREAK = 'Firebreak'
    FIRELINE = 'Fireline'
    FIRETRACK = 'Firetrack'
    FIRETRAIL = 'Firetrail'
    FLAT = 'Flat'
    FLATS = 'Flats'
    FOLLOW = 'Follow'
    FOOTWAY = 'Footway'
    FORD = 'Ford'
    FORESHORE = 'Foreshore'
    FORK = 'Fork'
    FORMATION = 'Formation'
    FREEWAY = 'Freeway'
    FRONT = 'Front'
    FRONTAGE = 'Frontage'
    GAP = 'Gap'
    GARDEN = 'Garden'
    GARDENS = 'Gardens'
    GATE = 'Gate'
    GATES = 'Gates'
    GATEWAY = 'Gateway'
    GLADE = 'Glade'
    GLADES = 'Glades'
    GLEN = 'Glen'
    GRANGE = 'Grange'
    GREEN = 'Green'
    GROUND = 'Ground'
    GROVE = 'Grove'
    GULLY = 'Gully'
    HAVEN = 'Haven'
    HEAD = 'Head'
    HEATH = 'Heath'
    HEIGHTS = 'Heights'
    HIGHROAD = 'Highroad'
    HIGHWAY = 'Highway'
    HILL = 'Hill'
    HOLLOW = 'Hollow'
    HUB = 'Hub'
    INTERCHANGE = 'Interchange'
    INTERSECTION = 'Intersection'
    ISLAND = 'Island'
    JUNCTION = 'Junction'
    KEY = 'Key'
    KEYS = 'Keys'
    KNOB = 'Knob'
    LADDER = 'Ladder'
    LAGOON = 'Lagoon'
    LANDING = 'Landing'
    LANE = 'Lane'
    LANEWAY = 'Laneway'
    LEA = 'Lea'
    LEADER = 'Leader'
    LEES = 'Lees'
    LEIGH = 'Leigh'
    LINE = 'Line'
    LINK = 'Link'
    LOOKOUT = 'Lookout'
    LOOP = 'Loop'
    LOOPS = 'Loops'
    MALL = 'Mall'
    MANOR = 'Manor'
    MEAD = 'Mead'
    MEANDER = 'Meander'
    MEW = 'Mew'
    MEWS = 'Mews'
    MILE = 'Mile'
    MOTORWAY = 'Motorway'
    MOTU = 'Motu'
    MOUNT = 'Mount'
    NEAVES = 'Neaves'
    NOOK = 'Nook'
    OAKS = 'Oaks'
    OUTLET = 'Outlet'
    OUTLOOK = 'Outlook'
    OVERBRIDGE = 'Overbridge'
    PADDOCK = 'Paddock'
    PAKU = 'Paku'
    PARADE = 'Parade'
    PARK = 'Park'
    PARKLANDS = 'Parklands'
    PARKWAY = 'Parkway'
    PART = 'Part'
    PASS = 'Pass'
    PASSAGE = 'Passage'
    PATH = 'Path'
    PATHWAY = 'Pathway'
    PIAZZA = 'Piazza'
    PLACE = 'Place'
    PLATEAU = 'Plateau'
    PLAZA = 'Plaza'
    POCKET = 'Pocket'
    POINT = 'Point'
    PORT = 'Port'
    PRIORS = 'Priors'
    PROMENADE = 'Promenade'
    PURSUIT = 'Pursuit'
    QUAD = 'Quad'
    QUADRANGLE = 'Quadrangle'
    QUADRANT = 'Quadrant'
    QUAY = 'Quay'
    QUAYS = 'Quays'
    RAMBLE = 'Ramble'
    RAMP = 'Ramp'
    RANAE = 'Ranae'
    RANGE = 'Range'
    REACH = 'Reach'
    REEF = 'Reef'
    RESERVE = 'Reserve'
    REST = 'Rest'
    RETREAT = 'Retreat'
    RETURN = 'Return'
    RIDE = 'Ride'
    RIDGE = 'Ridge'
    RIDGEWAY = 'Ridgeway'
    RIGHT_OF_WAY = 'Right Of Way'
    RING = 'Ring'
    RISE = 'Rise'
    RISING = 'Rising'
    RIVER = 'River'
    RIVERWAY = 'Riverway'
    RIVIERA = 'Riviera'
    ROAD = 'Road'
    ROADS = 'Roads'
    ROADSIDE = 'Roadside'
    ROADWAY = 'Roadway'
    RONDE = 'Ronde'
    ROSEBOWL = 'Rosebowl'
    ROTARY = 'Rotary'
    ROUND = 'Round'
    ROUTE = 'Route'
    ROW = 'Row'
    RUA = 'Rua'
    RUE = 'Rue'
    RUN = 'Run'
    SERVICEWAY = 'Serviceway'
    SHORE = 'Shore'
    SHUNT = 'Shunt'
    SIDING = 'Siding'
    SLOPE = 'Slope'
    SOUND = 'Sound'
    SPA = 'Spa'
    SPUR = 'Spur'
    SQUARE = 'Square'
    STAIRS = 'Stairs'
    STATE_HIGH = 'State High'
    STEEP = 'Steep'
    STEPS = 'Steps'
    STRAAT = 'Straat'
    STRAIGHT = 'Straight'
    STRAND = 'Strand'
    STREET = 'Street'
    STRIP = 'Strip'
    SUBWAY = 'Subway'
    TARN = 'Tarn'
    TEE = 'Tee'
    TERRACE = 'Terrace'
    THOROUGHFAIR = 'Thoroughfair'
    THOROUGHWA = 'Thoroughwa'
    THROUGHWAY = 'Throughway'
    TOLLWAY = 'Tollway'
    TOP = 'Top'
    TOR = 'Tor'
    TOWER = 'Tower'
    TOWERS = 'Towers'
    TRACK = 'Track'
    TRAIL = 'Trail'
    TRAILER = 'Trailer'
    TRAM = 'Tram'
    TRAMWAY = 'Tramway'
    TRAVERSE = 'Traverse'
    TREES = 'Trees'
    TRIANGLE = 'Triangle'
    TRUNKWAY = 'Trunkway'
    TUNNEL = 'Tunnel'
    TURN = 'Turn'
    TWIST = 'Twist'
    UNDERPASS = 'Underpass'
    VALE = 'Vale'
    VALLEY = 'Valley'
    VENUS = 'Venus'
    VIADUCT = 'Viaduct'
    VIEW = 'View'
    VIEWS = 'Views'
    VILLAGE = 'Village'
    VILLAS = 'Villas'
    VISTA = 'Vista'
    VUE = 'Vue'
    WADE = 'Wade'
    WALK = 'Walk'
    WALKWAY = 'Walkway'
    WATERS = 'Waters'
    WATERWAY = 'Waterway'
    WAY = 'Way'
    WHARF = 'Wharf'
    WHENUA = 'Whenua'
    WOOD = 'Wood'
    WOODS = 'Woods'
    WYND = 'Wynd'
    YARD = 'Yard'


class roadTypeType(str, Enum):
    """Not used in VIC, this is to comply to the national addressing
    standard"""
    PRIVATE = 'Private'
    PUBLIC = 'Public'


class stateType(str, Enum):
    EXISTING = 'existing'


class survPntType(str, Enum):
    MONUMENT = 'monument'
    CONTROL = 'control'
    SIDESHOT = 'sideshot'
    BOUNDARY = 'boundary'
    NATURALBOUNDARY = 'natural boundary'
    TRAVERSE = 'traverse'
    REFERENCE = 'reference'
    ADMINISTRATIVE = 'administrative'


class surveyBgDatumType(str, Enum):
    """Datum for survey bearing"""
    APPROX_TRUE_NORTH = 'Approx True North'
    MGA_94__ZONE_54 = 'MGA94_Zone54'
    MGA_94__ZONE_55 = 'MGA94_Zone55'
    MGA_2020__ZONE_54 = 'MGA2020_Zone54'
    MGA_2020__ZONE_55 = 'MGA2020_Zone55'
    AMG_66__ZONE_54 = 'AMG66_Zone54'
    AMG_66__ZONE_55 = 'AMG66_Zone55'
    GDA_2020 = 'GDA2020'
    LOCAL = 'Local'


class surveyFormatType(str, Enum):
    """Survey classifications, obtained from Surveying (Cadastral Surveys)
    Regulations 2005"""
    LEVEL_LAND = 'Level Land'
    UNDULATING_LAND = 'Undulating Land'
    STEEP_LAND = 'Steep Land'
    MOUNTAINOUS_LAND = 'Mountainous Land'


class surveyType(str, Enum):
    COMPILED = 'compiled'
    COMPUTED = 'computed'
    SURVEYED = 'surveyed'


class surveyorRoleType(str, Enum):
    SURVEYED_BY = 'Surveyed By'


class titleTypeType(str, Enum):
    """Values from VOTS and three eplan types for managing easements and
    restrictions"""
    ALPINE_LEASE = 'Alpine Lease'
    CROWN_GRANT = 'Crown Grant'
    CROWN_GRANT_PART = 'Crown Grant(Part)'
    CROWN_LAND = 'Crown Land'
    CROWN_LEASE = 'Crown Lease'
    FREEHOLD = 'Freehold'
    FREEHOLD_PART = 'Freehold(Part)'
    IDENTIFIED = 'Identified'
    MINERAL_INCLUDES = 'Mineral \'Includes\''
    MINERAL_EXCLUDES = 'Mineral \'Excludes\''
    TREASURERS_RECEIPT = 'Treasurer\'s Receipt'
    EASEMENT_BENEFIT = 'Easement Benefit'
    RESTRICTION_BENEFIT = 'Restriction Benefit'
    RESTRICTION_BURDEN = 'Restriction Burden'
    DEPTH_LIMITATION = 'Depth Limitation'
    DEPTH_LIMITATION_PART = 'Depth Limitation(Part)'


class useOfParcelType(str, Enum):
    """See reference list"""
    AIR_EXHAUSTAND_VENTILATION = 'Air Exhaust and Ventilation'
    AIR_EXHAUST_VENTILATIONAND_ACCESS = 'Air Exhaust, Ventilation and Access'
    AIR_SUPPLY = 'Air Supply'
    ANY_EASEMENTS = 'Any Easements'
    BORE_WINDMILLAND_TANK = 'Bore, Windmill and Tank'
    CARRIAGEWAY = 'Carriageway'
    CARRIAGEWAYWITH_LIMITATIONAND_OBLIGATION = 'Carriageway (with Limitation and Obligation)'
    CHANNEL = 'Channel'
    CHIMNEY = 'Chimney'
    COUNTY = 'County'
    DATA_TRANSMISSION = 'Data Transmission'
    DRAINAGE = 'Drainage'
    DRAINAGEAND_FLOODWAY = 'Drainage and Floodway'
    DRAINAGEAND_SEWERAGE = 'Drainage and Sewerage'
    DRAINAGEAND_WATERWAY = 'Drainage and Waterway'
    EROSION = 'Erosion'
    FIRE_ACCESS = 'Fire Access'
    FIRE_EGRESS = 'Fire Egress'
    FIRE_ESCAPE = 'Fire Escape'
    FLOODING = 'Flooding'
    FLOODWAY = 'Floodway'
    FLOWOF_AIR = 'Flow of Air'
    FLOWOF_LIGHT = 'Flow of Light'
    FLOWOF_LIGHTAND_AIR = 'Flow of Light and Air'
    FOOTWAY = 'Footway'
    GARBAGE_COLLECTION_GARBAGE = 'Garbage Collection/Garbage'
    GAS_DISTRIBUTION_PIPELINE = 'Gas Distribution Pipeline'
    GAS_TRANSMISSION_PIPELINE = 'Gas Transmission Pipeline'
    GROUND_WATER_MONITORING = 'Ground Water Monitoring'
    IRRIGATION = 'Irrigation'
    LGA = 'LGA'
    LAYING_WATER_PIPES = 'Laying Water Pipes'
    LIMITED = 'Limited'
    LIMITEDTOCP = 'Limited to CP'
    LOADINGAND_UNLOADING_HEAVY_EQUIPMENT = 'Loading and Unloading Heavy Equipment'
    LOCALITY = 'Locality'
    MAIL_COLLECTION = 'Mail Collection'
    NUISANCEOR_ANNOYANCE = 'Nuisance or Annoyance'
    OTHER = 'Other'
    OVERHANGING_BALCONY = 'Overhanging Balcony'
    OVERHANGING_EAVES = 'Overhanging Eaves'
    OVERHANGING_PROJECTIONS = 'Overhanging Projections'
    OVERHANGING_SPOUTING = 'Overhanging Spouting'
    PARISH = 'Parish'
    PARTY_WALL = 'Party Wall'
    PASSAGEOF_AIR = 'Passage of Air'
    PASSAGEOF_LIGHT = 'Passage of Light'
    PASSAGEOF_LIGHTAND_AIR = 'Passage of Light and Air'
    PIPELINEOR_ANCILLARY_PURPOSES = 'Pipeline or Ancillary Purposes'
    POWERLINE = 'Powerline'
    PUBLIC_CONVENIENCES = 'Public Conveniences'
    PUBLIC_HIGHWAY = 'Public Highway'
    QUARRYINGAND_BLASTING = 'Quarrying and Blasting'
    RECREATIONAND_GARDEN = 'Recreation and Garden'
    RIGHTOF_ACCESS = 'Right of Access'
    RIGHTOF_ENTRY = 'Right of Entry'
    SANITARY_CONVENIENCE = 'Sanitary Convenience'
    SEWERAGE = 'Sewerage'
    SIGNBOARD_SIGNAGE = 'Signboard, Signage'
    SOAKAGEBY_WATER = 'Soakage by Water'
    SUBMERGENCE = 'Submergence'
    SUPPLYOF_ELECTRICITY = 'Supply of Electricity'
    SUPPLYOF_GAS = 'Supply of Gas'
    SUPPLYOF_RECYCLED_WATER = 'Supply of Recycled Water'
    SUPPLYOF_WATER = 'Supply of Water'
    SUPPORT = 'Support'
    TELECOMMUNICATIONS = 'Telecommunications'
    TOWNSHIP = 'Township'
    TRANSMISSIONOF_ELECTRICITY = 'Transmission of Electricity'
    TREE_PLANTING = 'Tree Planting'
    UNDERGROUND_EFFLUENT_DISPOSAL = 'Underground Effluent Disposal'
    UNLIMITED = 'Unlimited'
    USEOF_STAIRWAY = 'Use of Stairway'
    VEHICLE_PARKING = 'Vehicle Parking'
    WALKWAY = 'Walkway'
    WALKWAYINTHEEVENTOFACTIVITYINSPECIFICLOCATION = 'Walkway in the event of \'activity\' in \'specific location\''
    WASTE_DISPOSAL = 'Waste Disposal'
    WATERWAY = 'Waterway'
    WATERWAY_MANAGEMENT = 'Waterway Management'
    WAY = 'Way'
    WETLAND = 'Wetland'


class vertDatumType(str, Enum):
    AHD = 'AHD'


class vertFixType(str, Enum):
    """See reference list"""
    _2_ND_ORDER = '2nd Order'
    _3_RD_ORDER = '3rd Order'
    _4_TH_ORDER = '4th Order'
    GPS = 'GPS'
    TRIG_HEIGHTING = 'Trig Heighting'
    UNKNOWN = 'Unknown'
    VERTICAL_ANGLES = 'Vertical Angles'
    ZEROTH_ORDER = 'Zeroth Order'


class vertOrderType(str, Enum):
    """See reference list"""
    _0 = '0'
    _1 = '1'
    _2 = '2'
    _3 = '3'
    _4 = '4'
    _5 = '5'
    _9_9 = '99'


class LandXML(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, date=None, time=None, version=None, Units=None, CoordinateSystem=None, Application=None,
                 CgPoints=None, Monuments=None, Parcels=None, PlanFeatures=None, Survey=None, FeatureDictionary=None,
                 gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if isinstance(date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(date, '%Y-%m-%d').date()
        else:
            initvalue_ = date
        self.date = initvalue_
        if isinstance(time, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(time, '%H:%M:%S').time()
        else:
            initvalue_ = time
        self.time = initvalue_
        self.version = _cast(None, version)
        self.version_nsprefix_ = None
        if Units is None:
            self.Units = []
        else:
            self.Units = Units
        self.Units_nsprefix_ = None
        if CoordinateSystem is None:
            self.CoordinateSystem = []
        else:
            self.CoordinateSystem = CoordinateSystem
        self.CoordinateSystem_nsprefix_ = None
        if Application is None:
            self.Application = []
        else:
            self.Application = Application
        self.Application_nsprefix_ = None
        if CgPoints is None:
            self.CgPoints = []
        else:
            self.CgPoints = CgPoints
        self.CgPoints_nsprefix_ = None
        if Monuments is None:
            self.Monuments = []
        else:
            self.Monuments = Monuments
        self.Monuments_nsprefix_ = None
        if Parcels is None:
            self.Parcels = []
        else:
            self.Parcels = Parcels
        self.Parcels_nsprefix_ = None
        if PlanFeatures is None:
            self.PlanFeatures = []
        else:
            self.PlanFeatures = PlanFeatures
        self.PlanFeatures_nsprefix_ = None
        if Survey is None:
            self.Survey = []
        else:
            self.Survey = Survey
        self.Survey_nsprefix_ = None
        if FeatureDictionary is None:
            self.FeatureDictionary = []
        else:
            self.FeatureDictionary = FeatureDictionary
        self.FeatureDictionary_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LandXML)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LandXML.subclass:
            return LandXML.subclass(*args_, **kwargs_)
        else:
            return LandXML(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Units(self):
        return self.Units

    def set_Units(self, Units):
        self.Units = Units

    def add_Units(self, value):
        self.Units.append(value)

    def insert_Units_at(self, index, value):
        self.Units.insert(index, value)

    def replace_Units_at(self, index, value):
        self.Units[index] = value

    def get_CoordinateSystem(self):
        return self.CoordinateSystem

    def set_CoordinateSystem(self, CoordinateSystem):
        self.CoordinateSystem = CoordinateSystem

    def add_CoordinateSystem(self, value):
        self.CoordinateSystem.append(value)

    def insert_CoordinateSystem_at(self, index, value):
        self.CoordinateSystem.insert(index, value)

    def replace_CoordinateSystem_at(self, index, value):
        self.CoordinateSystem[index] = value

    def get_Application(self):
        return self.Application

    def set_Application(self, Application):
        self.Application = Application

    def add_Application(self, value):
        self.Application.append(value)

    def insert_Application_at(self, index, value):
        self.Application.insert(index, value)

    def replace_Application_at(self, index, value):
        self.Application[index] = value

    def get_points(self):
        points = self.CgPoints
        if len(points) > 0:
            points = points[0]
        else:
            points = None
        return points

    def get_CgPoints(self):
        return self.CgPoints

    def set_CgPoints(self, CgPoints):
        self.CgPoints = CgPoints

    def add_CgPoints(self, value):
        self.CgPoints.append(value)

    def insert_CgPoints_at(self, index, value):
        self.CgPoints.insert(index, value)

    def replace_CgPoints_at(self, index, value):
        self.CgPoints[index] = value

    def get_Monuments(self):
        return self.Monuments

    def set_Monuments(self, Monuments):
        self.Monuments = Monuments

    def add_Monuments(self, value):
        self.Monuments.append(value)

    def insert_Monuments_at(self, index, value):
        self.Monuments.insert(index, value)

    def replace_Monuments_at(self, index, value):
        self.Monuments[index] = value

    def get_Parcels(self):
        return self.Parcels

    def set_Parcels(self, Parcels):
        self.Parcels = Parcels

    def add_Parcels(self, value):
        self.Parcels.append(value)

    def insert_Parcels_at(self, index, value):
        self.Parcels.insert(index, value)

    def replace_Parcels_at(self, index, value):
        self.Parcels[index] = value

    def get_PlanFeatures(self):
        return self.PlanFeatures

    def set_PlanFeatures(self, PlanFeatures):
        self.PlanFeatures = PlanFeatures

    def add_PlanFeatures(self, value):
        self.PlanFeatures.append(value)

    def insert_PlanFeatures_at(self, index, value):
        self.PlanFeatures.insert(index, value)

    def replace_PlanFeatures_at(self, index, value):
        self.PlanFeatures[index] = value

    def get_Survey(self):
        return self.Survey

    def set_Survey(self, Survey):
        self.Survey = Survey

    def add_Survey(self, value):
        self.Survey.append(value)

    def insert_Survey_at(self, index, value):
        self.Survey.insert(index, value)

    def replace_Survey_at(self, index, value):
        self.Survey[index] = value

    def get_FeatureDictionary(self):
        return self.FeatureDictionary

    def set_FeatureDictionary(self, FeatureDictionary):
        self.FeatureDictionary = FeatureDictionary

    def add_FeatureDictionary(self, value):
        self.FeatureDictionary.append(value)

    def insert_FeatureDictionary_at(self, index, value):
        self.FeatureDictionary.insert(index, value)

    def replace_FeatureDictionary_at(self, index, value):
        self.FeatureDictionary[index] = value

    def get_date(self):
        return self.date

    def set_date(self, date):
        self.date = date

    def get_time(self):
        return self.time

    def set_time(self, time):
        self.time = time

    def get_version(self):
        return self.version

    def set_version(self, version):
        self.version = version

    def hasContent_(self):
        if (
                self.Units or
                self.CoordinateSystem or
                self.Application or
                self.CgPoints or
                self.Monuments or
                self.Parcels or
                self.PlanFeatures or
                self.Survey or
                self.FeatureDictionary
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns="http://www.landxml.org/schema/LandXML-1.2" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" ' +
                             'xsi:schemaLocation="http://www.landxml.org/schema/LandXML-1.2 http://www.landxml.org/schema/LandXML-1.2/LandXML-1.2.xsd" ',
               name_='LandXML', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('LandXML')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'LandXML':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='LandXML')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='LandXML',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='LandXML'):
        if self.date is not None and 'date' not in already_processed:
            already_processed.add('date')
            outfile.write(' date="%s"' % self.gds_format_date(self.date, input_name='date'))
        if self.time is not None and 'time' not in already_processed:
            already_processed.add('time')
            outfile.write(' time="%s"' % self.gds_format_time(self.time, input_name='time'))
        if self.version is not None and 'version' not in already_processed:
            already_processed.add('version')
            outfile.write(' version=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.version), input_name='version')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
                       name_='LandXML', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Units_ in self.Units:
            namespaceprefix_ = self.Units_nsprefix_ + ':' if (UseCapturedNS_ and self.Units_nsprefix_) else ''
            Units_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Units', pretty_print=pretty_print)
        for CoordinateSystem_ in self.CoordinateSystem:
            namespaceprefix_ = self.CoordinateSystem_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.CoordinateSystem_nsprefix_) else ''
            CoordinateSystem_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CoordinateSystem',
                                     pretty_print=pretty_print)
        for Application_ in self.Application:
            namespaceprefix_ = self.Application_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.Application_nsprefix_) else ''
            Application_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Application',
                                pretty_print=pretty_print)
        for CgPoints_ in self.CgPoints:
            namespaceprefix_ = self.CgPoints_nsprefix_ + ':' if (UseCapturedNS_ and self.CgPoints_nsprefix_) else ''
            CgPoints_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CgPoints',
                             pretty_print=pretty_print)
        for Monuments_ in self.Monuments:
            namespaceprefix_ = self.Monuments_nsprefix_ + ':' if (UseCapturedNS_ and self.Monuments_nsprefix_) else ''
            Monuments_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Monuments',
                              pretty_print=pretty_print)
        for Parcels_ in self.Parcels:
            namespaceprefix_ = self.Parcels_nsprefix_ + ':' if (UseCapturedNS_ and self.Parcels_nsprefix_) else ''
            Parcels_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Parcels',
                            pretty_print=pretty_print)
        for PlanFeatures_ in self.PlanFeatures:
            namespaceprefix_ = self.PlanFeatures_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.PlanFeatures_nsprefix_) else ''
            PlanFeatures_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PlanFeatures',
                                 pretty_print=pretty_print)
        for Survey_ in self.Survey:
            namespaceprefix_ = self.Survey_nsprefix_ + ':' if (UseCapturedNS_ and self.Survey_nsprefix_) else ''
            Survey_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Survey',
                           pretty_print=pretty_print)
        for FeatureDictionary_ in self.FeatureDictionary:
            namespaceprefix_ = self.FeatureDictionary_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.FeatureDictionary_nsprefix_) else ''
            FeatureDictionary_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='FeatureDictionary',
                                      pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('date', node)
        if value is not None and 'date' not in already_processed:
            already_processed.add('date')
            try:
                self.date = self.gds_parse_date(value)
            except ValueError as exp:
                raise ValueError('Bad date attribute (date): %s' % exp)
        value = find_attr_value_('time', node)
        if value is not None and 'time' not in already_processed:
            already_processed.add('time')
            try:
                self.time = self.gds_parse_time(value)
            except ValueError as exp:
                raise ValueError('Bad time attribute (time): %s' % exp)
        value = find_attr_value_('version', node)
        if value is not None and 'version' not in already_processed:
            already_processed.add('version')
            self.version = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Units':
            obj_ = Units.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Units.append(obj_)
            obj_.original_tagname_ = 'Units'
        elif nodeName_ == 'CoordinateSystem':
            obj_ = CoordinateSystem.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CoordinateSystem.append(obj_)
            obj_.original_tagname_ = 'CoordinateSystem'
        elif nodeName_ == 'Application':
            obj_ = Application.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Application.append(obj_)
            obj_.original_tagname_ = 'Application'
        elif nodeName_ == 'CgPoints':
            obj_ = CgPoints.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CgPoints.append(obj_)
            obj_.original_tagname_ = 'CgPoints'
        elif nodeName_ == 'Monuments':
            obj_ = Monuments.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Monuments.append(obj_)
            obj_.original_tagname_ = 'Monuments'
        elif nodeName_ == 'Parcels':
            obj_ = Parcels.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Parcels.append(obj_)
            obj_.original_tagname_ = 'Parcels'
        elif nodeName_ == 'PlanFeatures':
            obj_ = PlanFeatures.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PlanFeatures.append(obj_)
            obj_.original_tagname_ = 'PlanFeatures'
        elif nodeName_ == 'Survey':
            obj_ = Survey.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Survey.append(obj_)
            obj_.original_tagname_ = 'Survey'
        elif nodeName_ == 'FeatureDictionary':
            obj_ = FeatureDictionary.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.FeatureDictionary.append(obj_)
            obj_.original_tagname_ = 'FeatureDictionary'


# end class LandXML


class ParcelType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, name=None, oID=None, area=None, desc=None, owner=None, parcelType=None, state=None, class_=None,
                 useOfParcel=None, parcelFormat=None, Center=None, CoordGeom=None, Parcels=None, Title=None,
                 LocationAddress=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.oID = _cast(None, oID)
        self.oID_nsprefix_ = None
        self.area = _cast(float, area)
        self.area_nsprefix_ = None
        self.desc = _cast(None, desc)
        self.desc_nsprefix_ = None
        self.owner = _cast(None, owner)
        self.owner_nsprefix_ = None
        self.parcelType = _cast(None, parcelType)
        self.parcelType_nsprefix_ = None
        self.state = _cast(None, state)
        self.state_nsprefix_ = None
        self.class_ = _cast(None, class_)
        self.class__nsprefix_ = None
        self.useOfParcel = _cast(None, useOfParcel)
        self.useOfParcel_nsprefix_ = None
        self.parcelFormat = _cast(None, parcelFormat)
        self.parcelFormat_nsprefix_ = None
        if Center is None:
            self.Center = []
        else:
            self.Center = Center
        self.Center_nsprefix_ = None
        if CoordGeom is None:
            self.CoordGeom = []
        else:
            self.CoordGeom = CoordGeom
        self.CoordGeom_nsprefix_ = None
        if Parcels is None:
            self.Parcels = []
        else:
            self.Parcels = Parcels
        self.Parcels_nsprefix_ = None
        if Title is None:
            self.Title = []
        else:
            self.Title = Title
        self.Title_nsprefix_ = None
        if LocationAddress is None:
            self.LocationAddress = []
        else:
            self.LocationAddress = LocationAddress
        self.LocationAddress_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ParcelType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ParcelType.subclass:
            return ParcelType.subclass(*args_, **kwargs_)
        else:
            return ParcelType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Center(self):
        return self.Center

    def set_Center(self, Center):
        self.Center = Center

    def add_Center(self, value):
        self.Center.append(value)

    def insert_Center_at(self, index, value):
        self.Center.insert(index, value)

    def replace_Center_at(self, index, value):
        self.Center[index] = value

    def get_CoordGeom(self):
        return self.CoordGeom

    def set_CoordGeom(self, CoordGeom):
        self.CoordGeom = CoordGeom

    def add_CoordGeom(self, value):
        self.CoordGeom.append(value)

    def insert_CoordGeom_at(self, index, value):
        self.CoordGeom.insert(index, value)

    def replace_CoordGeom_at(self, index, value):
        self.CoordGeom[index] = value

    def get_Parcels(self):
        return self.Parcels

    def set_Parcels(self, Parcels):
        self.Parcels = Parcels

    def add_Parcels(self, value):
        self.Parcels.append(value)

    def insert_Parcels_at(self, index, value):
        self.Parcels.insert(index, value)

    def replace_Parcels_at(self, index, value):
        self.Parcels[index] = value

    def get_Title(self):
        return self.Title

    def set_Title(self, Title):
        self.Title = Title

    def add_Title(self, value):
        self.Title.append(value)

    def insert_Title_at(self, index, value):
        self.Title.insert(index, value)

    def replace_Title_at(self, index, value):
        self.Title[index] = value

    def get_LocationAddress(self):
        return self.LocationAddress

    def set_LocationAddress(self, LocationAddress):
        self.LocationAddress = LocationAddress

    def add_LocationAddress(self, value):
        self.LocationAddress.append(value)

    def insert_LocationAddress_at(self, index, value):
        self.LocationAddress.insert(index, value)

    def replace_LocationAddress_at(self, index, value):
        self.LocationAddress[index] = value

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_oID(self):
        return self.oID

    def set_oID(self, oID):
        self.oID = oID

    def get_area(self):
        return self.area

    def set_area(self, area):
        self.area = area

    def get_desc(self):
        return self.desc

    def set_desc(self, desc):
        self.desc = desc

    def get_owner(self):
        return self.owner

    def set_owner(self, owner):
        self.owner = owner

    def get_parcelType(self):
        return self.parcelType

    def set_parcelType(self, parcelType):
        self.parcelType = parcelType

    def get_state(self):
        return self.state

    def set_state(self, state):
        self.state = state

    def get_class(self):
        return self.class_

    def set_class(self, class_):
        self.class_ = class_

    def get_useOfParcel(self):
        return self.useOfParcel

    def set_useOfParcel(self, useOfParcel):
        self.useOfParcel = useOfParcel

    def get_parcelFormat(self):
        return self.parcelFormat

    def set_parcelFormat(self, parcelFormat):
        self.parcelFormat = parcelFormat

    def validate_nonBlankString(self, value):
        # Validate type nonBlankString, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nonBlankString' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_blankOrDouble(self, value):
        # Validate type blankOrDouble, a restriction on xs:double.
        pass

    def validate_parcelTypeType(self, value):
        # Validate type enum:parcelTypeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Administrative', 'Single', 'Multipart', 'Part']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on parcelTypeType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_parcelStateType(self, value):
        # Validate type parcelStateType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['affected', 'created', 'extinguished', 'referenced', 'proposed', 'existing']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on parcelStateType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_parcelClass(self, value):
        # Validate type enum:parcelClass, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Common Property', 'Lot', 'Road', 'Reserve', 'Stage Lot', 'Crown Allotment',
                            'Crown Portion', 'Crown Section', 'Easement', 'Restriction', 'Depth Limitation',
                            'Owners Corporation', 'Administrative Area', 'Balance', 'NIS', 'NIT', 'WIP']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on parcelClass' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_useOfParcelType(self, value):
        # Validate type enum:useOfParcelType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Air Exhaust and Ventilation', 'Air Exhaust, Ventilation and Access', 'Air Supply',
                            'Any Easements', 'Bore, Windmill and Tank', 'Carriageway',
                            'Carriageway (with Limitation and Obligation)', 'Channel', 'Chimney', 'County',
                            'Data Transmission', 'Drainage', 'Drainage and Floodway', 'Drainage and Sewerage',
                            'Drainage and Waterway', 'Erosion', 'Fire Access', 'Fire Egress', 'Fire Escape', 'Flooding',
                            'Floodway', 'Flow of Air', 'Flow of Light', 'Flow of Light and Air', 'Footway',
                            'Garbage Collection/Garbage', 'Gas Distribution Pipeline', 'Gas Transmission Pipeline',
                            'Ground Water Monitoring', 'Irrigation', 'LGA', 'Laying Water Pipes', 'Limited',
                            'Limited to CP', 'Loading and Unloading Heavy Equipment', 'Locality', 'Mail Collection',
                            'Nuisance or Annoyance', 'Other', 'Overhanging Balcony', 'Overhanging Eaves',
                            'Overhanging Projections', 'Overhanging Spouting', 'Parish', 'Party Wall', 'Passage of Air',
                            'Passage of Light', 'Passage of Light and Air', 'Pipeline or Ancillary Purposes',
                            'Powerline', 'Public Conveniences', 'Public Highway', 'Quarrying and Blasting',
                            'Recreation and Garden', 'Right of Access', 'Right of Entry', 'Sanitary Convenience',
                            'Sewerage', 'Signboard, Signage', 'Soakage by Water', 'Submergence',
                            'Supply of Electricity', 'Supply of Gas', 'Supply of Recycled Water', 'Supply of Water',
                            'Support', 'Telecommunications', 'Township', 'Transmission of Electricity', 'Tree Planting',
                            'Underground Effluent Disposal', 'Unlimited', 'Use of Stairway', 'Vehicle Parking',
                            'Walkway', "Walkway in the event of 'activity' in 'specific location'", 'Waste Disposal',
                            'Waterway', 'Waterway Management', 'Way', 'Wetland']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on useOfParcelType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_parcelFormat(self, value):
        # Validate type enum:parcelFormat, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Standard', '2D Building', 'Geometry']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on parcelFormat' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.Center or
                self.CoordGeom or
                self.Parcels or
                self.Title or
                self.LocationAddress
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
               name_='ParcelType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ParcelType')
        if self.eplan_value is True:
            if self.state == 'referenced':
                self.state = 'existing'
            elif self.state == 'proposed':
                self.state = 'created'

        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ParcelType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        if self.eplan_value is True:
            if self.useOfParcel == 'Limited to CP':
                self.useOfParcel = 'Limited to Common Property'
            if len(str(self.area)) == 0:
                already_processed.add('area')
            if self.class_ in ['NIS', 'NIT', 'Balance', 'WIP']:
                self.class_ = 'Lot'
            if self.name is not None:
                if self.name.startswith('WIP') is True and self.name.startswith('WIP-') is False:
                    self.name = self.name.replace('WIP', 'WIP-')
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ParcelType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ParcelType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ParcelType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))
        if self.oID is not None and 'oID' not in already_processed:
            already_processed.add('oID')
            outfile.write(
                ' oID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.oID), input_name='oID')),))
        if self.area is not None and 'area' not in already_processed:
            already_processed.add('area')
            outfile.write(' area="%s"' % self.gds_format_double(self.area, input_name='area'))
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            outfile.write(
                ' desc=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.desc), input_name='desc')),))
        if self.owner is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            outfile.write(
                ' owner=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.owner), input_name='owner')),))
        if self.parcelType is not None and 'parcelType' not in already_processed:
            already_processed.add('parcelType')
            outfile.write(' parcelType=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.parcelType), input_name='parcelType')),))
        if self.state is not None and 'state' not in already_processed:
            already_processed.add('state')
            outfile.write(
                ' state=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.state), input_name='state')),))
        if self.class_ is not None and 'class_' not in already_processed:
            already_processed.add('class_')
            outfile.write(
                ' class=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.class_), input_name='class')),))
        if self.useOfParcel is not None and 'useOfParcel' not in already_processed:
            already_processed.add('useOfParcel')
            outfile.write(' useOfParcel=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.useOfParcel), input_name='useOfParcel')),))
        if self.parcelFormat is not None and 'parcelFormat' not in already_processed:
            already_processed.add('parcelFormat')
            outfile.write(' parcelFormat=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.parcelFormat), input_name='parcelFormat')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
                       name_='ParcelType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Center_ in self.Center:
            namespaceprefix_ = self.Center_nsprefix_ + ':' if (UseCapturedNS_ and self.Center_nsprefix_) else ''
            Center_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Center',
                           pretty_print=pretty_print)
        for CoordGeom_ in self.CoordGeom:
            namespaceprefix_ = self.CoordGeom_nsprefix_ + ':' if (UseCapturedNS_ and self.CoordGeom_nsprefix_) else ''
            CoordGeom_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CoordGeom',
                              pretty_print=pretty_print)
        for Parcels_ in self.Parcels:
            namespaceprefix_ = self.Parcels_nsprefix_ + ':' if (UseCapturedNS_ and self.Parcels_nsprefix_) else ''
            Parcels_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Parcels',
                            pretty_print=pretty_print)
        for Title_ in self.Title:
            namespaceprefix_ = self.Title_nsprefix_ + ':' if (UseCapturedNS_ and self.Title_nsprefix_) else ''
            Title_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Title', pretty_print=pretty_print)
        for LocationAddress_ in self.LocationAddress:
            namespaceprefix_ = self.LocationAddress_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.LocationAddress_nsprefix_) else ''
            LocationAddress_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='LocationAddress',
                                    pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
            self.validate_nonBlankString(self.name)  # validate type nonBlankString
        value = find_attr_value_('oID', node)
        if value is not None and 'oID' not in already_processed:
            already_processed.add('oID')
            self.oID = value
        value = find_attr_value_('area', node)
        if value is not None and 'area' not in already_processed and value != '':
            already_processed.add('area')
            value = self.gds_parse_double(value, node, 'area')
            self.area = value
            self.validate_blankOrDouble(self.area)  # validate type blankOrDouble
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            self.desc = value
            self.validate_nonBlankString(self.desc)  # validate type nonBlankString
        value = find_attr_value_('owner', node)
        if value is not None and 'owner' not in already_processed:
            already_processed.add('owner')
            self.owner = value
        value = find_attr_value_('parcelType', node)
        if value is not None and 'parcelType' not in already_processed:
            already_processed.add('parcelType')
            self.parcelType = value
            self.validate_parcelTypeType(self.parcelType)  # validate type parcelTypeType
        value = find_attr_value_('state', node)
        if value is not None and 'state' not in already_processed:
            already_processed.add('state')
            self.state = value
            self.validate_parcelStateType(self.state)  # validate type parcelStateType
        value = find_attr_value_('class', node)
        if value is not None and 'class' not in already_processed:
            already_processed.add('class')
            self.class_ = value
            self.validate_parcelClass(self.class_)  # validate type parcelClass
        value = find_attr_value_('useOfParcel', node)
        if value is not None and 'useOfParcel' not in already_processed:
            already_processed.add('useOfParcel')
            self.useOfParcel = value
            self.validate_useOfParcelType(self.useOfParcel)  # validate type useOfParcelType
        value = find_attr_value_('parcelFormat', node)
        if value is not None and 'parcelFormat' not in already_processed:
            already_processed.add('parcelFormat')
            self.parcelFormat = value
            self.validate_parcelFormat(self.parcelFormat)  # validate type parcelFormat

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Center':
            class_obj_ = self.get_class_obj_(child_, PntRefPointType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Center.append(obj_)
            obj_.original_tagname_ = 'Center'
        elif nodeName_ == 'CoordGeom':
            obj_ = CoordGeom.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CoordGeom.append(obj_)
            obj_.original_tagname_ = 'CoordGeom'
        elif nodeName_ == 'Parcels':
            obj_ = AllocationsParcelsType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Parcels.append(obj_)
            obj_.original_tagname_ = 'Parcels'
        elif nodeName_ == 'Title':
            obj_ = Title.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Title.append(obj_)
            obj_.original_tagname_ = 'Title'
        elif nodeName_ == 'LocationAddress':
            obj_ = LocationAddress.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.LocationAddress.append(obj_)
            obj_.original_tagname_ = 'LocationAddress'


# end class ParcelType


class AllocationsParcelsType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, desc=None, name=None, state=None, Parcel=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.desc = _cast(None, desc)
        self.desc_nsprefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.state = _cast(None, state)
        self.state_nsprefix_ = None
        if Parcel is None:
            self.Parcel = []
        else:
            self.Parcel = Parcel
        self.Parcel_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AllocationsParcelsType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AllocationsParcelsType.subclass:
            return AllocationsParcelsType.subclass(*args_, **kwargs_)
        else:
            return AllocationsParcelsType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Parcel(self):
        return self.Parcel

    def set_Parcel(self, Parcel):
        self.Parcel = Parcel

    def add_Parcel(self, value):
        self.Parcel.append(value)

    def insert_Parcel_at(self, index, value):
        self.Parcel.insert(index, value)

    def replace_Parcel_at(self, index, value):
        self.Parcel[index] = value

    def get_desc(self):
        return self.desc

    def set_desc(self, desc):
        self.desc = desc

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_state(self):
        return self.state

    def set_state(self, state):
        self.state = state

    def validate_stateType(self, value):
        # Validate type stateType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['existing']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on stateType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.Parcel
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
               name_='AllocationsParcelsType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AllocationsParcelsType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AllocationsParcelsType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AllocationsParcelsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AllocationsParcelsType',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AllocationsParcelsType'):
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            outfile.write(
                ' desc=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.desc), input_name='desc')),))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))
        if self.state is not None and 'state' not in already_processed:
            already_processed.add('state')
            outfile.write(
                ' state=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.state), input_name='state')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
                       name_='AllocationsParcelsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Parcel_ in self.Parcel:
            namespaceprefix_ = self.Parcel_nsprefix_ + ':' if (UseCapturedNS_ and self.Parcel_nsprefix_) else ''
            Parcel_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Parcel',
                           pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            self.desc = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('state', node)
        if value is not None and 'state' not in already_processed:
            already_processed.add('state')
            self.state = value
            self.validate_stateType(self.state)  # validate type stateType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Parcel':
            obj_ = AllocationsParcelType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Parcel.append(obj_)
            obj_.original_tagname_ = 'Parcel'


# end class AllocationsParcelsType


class AllocationsParcelType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, name=None, pclRef=None, lotEntitlements=None, liabilityApportionment=None, gds_collector_=None,
                 **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.pclRef = _cast(None, pclRef)
        self.pclRef_nsprefix_ = None
        self.lotEntitlements = _cast(None, lotEntitlements)
        self.lotEntitlements_nsprefix_ = None
        self.liabilityApportionment = _cast(None, liabilityApportionment)
        self.liabilityApportionment_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AllocationsParcelType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AllocationsParcelType.subclass:
            return AllocationsParcelType.subclass(*args_, **kwargs_)
        else:
            return AllocationsParcelType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_pclRef(self):
        return self.pclRef

    def set_pclRef(self, pclRef):
        self.pclRef = pclRef

    def get_lotEntitlements(self):
        return self.lotEntitlements

    def set_lotEntitlements(self, lotEntitlements):
        self.lotEntitlements = lotEntitlements

    def get_liabilityApportionment(self):
        return self.liabilityApportionment

    def set_liabilityApportionment(self, liabilityApportionment):
        self.liabilityApportionment = liabilityApportionment

    def validate_nonBlankString(self, value):
        # Validate type nonBlankString, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nonBlankString' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_parcelNameRef(self, value):
        # Validate type parcelNameRef, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            pass

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='AllocationsParcelType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AllocationsParcelType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AllocationsParcelType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AllocationsParcelType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AllocationsParcelType',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AllocationsParcelType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))
        if self.pclRef is not None and 'pclRef' not in already_processed:
            already_processed.add('pclRef')
            outfile.write(' pclRef=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.pclRef), input_name='pclRef')),))
        if self.lotEntitlements is not None and 'lotEntitlements' not in already_processed:
            already_processed.add('lotEntitlements')
            outfile.write(' lotEntitlements=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.lotEntitlements), input_name='lotEntitlements')),))
        if self.liabilityApportionment is not None and 'liabilityApportionment' not in already_processed:
            already_processed.add('liabilityApportionment')
            outfile.write(' liabilityApportionment=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.liabilityApportionment),
                                       input_name='liabilityApportionment')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"',
                       name_='AllocationsParcelType', fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
            self.validate_nonBlankString(self.name)  # validate type nonBlankString
        value = find_attr_value_('pclRef', node)
        if value is not None and 'pclRef' not in already_processed:
            already_processed.add('pclRef')
            self.pclRef = value
            self.validate_parcelNameRef(self.pclRef)  # validate type parcelNameRef
        value = find_attr_value_('lotEntitlements', node)
        if value is not None and 'lotEntitlements' not in already_processed:
            already_processed.add('lotEntitlements')
            self.lotEntitlements = value
            self.validate_nonBlankString(self.lotEntitlements)  # validate type nonBlankString
        value = find_attr_value_('liabilityApportionment', node)
        if value is not None and 'liabilityApportionment' not in already_processed:
            already_processed.add('liabilityApportionment')
            self.liabilityApportionment = value
            self.validate_nonBlankString(self.liabilityApportionment)  # validate type nonBlankString

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class AllocationsParcelType


class PntRefPointType(GeneratedsSuper):
    """All elements derived from PointType will either contain a coordinate
    text value ( "north east" or "north east elev"), a "pntRef" attribute
    value, or both. The "pntRef" attribute contains the value of a
    PointType derived element "name" attribute that exists elsewhere the
    instance data. If this element has a "pntRef" value, then it's
    coordinates will be retrieved from the referenced element. If an
    element contains both a coordinate value and a pntRef, the coordinate
    value should be used as the point location and the referenced point is
    either ignored or is used for point attributes such as number or
    desc.The featureRef attribute points to a specific named Feature
    element that contains feature data related to the point.
    The suggested form is to refer to a feature element within the same
    CgPoints group or parent element of
    the point element."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, pntRef=None, valueOf_=None, mixedclass_=None, content_=None, extensiontype_=None,
                 gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.pntRef = _cast(None, pntRef)
        self.pntRef_nsprefix_ = None
        self.valueOf_ = valueOf_
        self.extensiontype_ = extensiontype_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PntRefPointType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PntRefPointType.subclass:
            return PntRefPointType.subclass(*args_, **kwargs_)
        else:
            return PntRefPointType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_pntRef(self):
        return self.pntRef

    def set_pntRef(self, pntRef):
        self.pntRef = pntRef

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def hasContent_(self):
        if (
                (1 if type(self.valueOf_) in [int, float] else self.valueOf_) or
                self.content_
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='PntRefPointType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PntRefPointType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PntRefPointType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PntRefPointType')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PntRefPointType'):
        if self.pntRef is not None and 'pntRef' not in already_processed:
            already_processed.add('pntRef')
            outfile.write(' pntRef=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.pntRef), input_name='pntRef')),))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='PntRefPointType',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('pntRef', node)
        if value is not None and 'pntRef' not in already_processed:
            already_processed.add('pntRef')
            self.pntRef = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass


# end class PntRefPointType


class PointType(GeneratedsSuper):
    """All elements derived from PointType may represent 2D or 3D points. They
    may contain a coordinate text value ( "north east" or "north east
    elevation"), a "pntRef" attribute value, or both. The pntRef attribute
    contains the value of a PointType derived element's name attribute that
    exists elsewhere the document. If a PointType element has a pntRef
    attribute, then its coordinates will be retrieved from the referenced
    element. If an element contains both a coordinate value and a pntRef
    attribute, the coordinate value should be used as the point location
    and the referenced point is either ignored or used for point
    attributes.The featureRef attribute points to a specific named Feature
    element that contains feature data related to the point.
    The suggested form is to refer to a feature element within the same
    CgPoints group or parent element of
    the point element."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, name=None, desc=None, code=None, state=None, pntRef=None, latitude=None, longitude=None,
                 valueOf_=None, mixedclass_=None, content_=None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.desc = _cast(None, desc)
        self.desc_nsprefix_ = None
        self.code = _cast(None, code)
        self.code_nsprefix_ = None
        self.state = _cast(None, state)
        self.state_nsprefix_ = None
        self.pntRef = _cast(None, pntRef)
        self.pntRef_nsprefix_ = None
        self.latitude = _cast(float, latitude)
        self.latitude_nsprefix_ = None
        self.longitude = _cast(float, longitude)
        self.longitude_nsprefix_ = None
        self.valueOf_ = valueOf_
        self.extensiontype_ = extensiontype_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PointType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PointType.subclass:
            return PointType.subclass(*args_, **kwargs_)
        else:
            return PointType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_desc(self):
        return self.desc

    def set_desc(self, desc):
        self.desc = desc

    def get_code(self):
        return self.code

    def set_code(self, code):
        self.code = code

    def get_state(self):
        return self.state

    def set_state(self, state):
        self.state = state

    def get_pntRef(self):
        return self.pntRef

    def set_pntRef(self, pntRef):
        self.pntRef = pntRef

    def get_latitude(self):
        return self.latitude

    def set_latitude(self, latitude):
        self.latitude = latitude

    def get_longitude(self):
        return self.longitude

    def set_longitude(self, longitude):
        self.longitude = longitude

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def validate_stateType(self, value):
        # Validate type stateType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['existing']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on stateType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_latLongAngle(self, value):
        # Validate type latLongAngle, a restriction on xs:double.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value,
                                                                                                    "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_latLongAngle_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (
                encode_str_2_3(value), self.validate_latLongAngle_patterns_,))

    validate_latLongAngle_patterns_ = [['^(([-+]?[0-1]?[0-7]?[0-9]).([0-9]+))$']]

    def hasContent_(self):
        if (
                (1 if type(self.valueOf_) in [int, float] else self.valueOf_) or
                self.content_
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='PointType',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PointType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PointType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PointType')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PointType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            outfile.write(
                ' desc=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.desc), input_name='desc')),))
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(
                ' code=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.code), input_name='code')),))
        if self.state is not None and 'state' not in already_processed:
            already_processed.add('state')
            outfile.write(
                ' state=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.state), input_name='state')),))
        if self.pntRef is not None and 'pntRef' not in already_processed:
            already_processed.add('pntRef')
            outfile.write(' pntRef=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.pntRef), input_name='pntRef')),))
        if self.latitude is not None and 'latitude' not in already_processed:
            already_processed.add('latitude')
            outfile.write(' latitude="%s"' % self.gds_format_double(self.latitude, input_name='latitude'))
        if self.longitude is not None and 'longitude' not in already_processed:
            already_processed.add('longitude')
            outfile.write(' longitude="%s"' % self.gds_format_double(self.longitude, input_name='longitude'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='PointType',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            self.desc = value
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
        value = find_attr_value_('state', node)
        if value is not None and 'state' not in already_processed:
            already_processed.add('state')
            self.state = value
            self.validate_stateType(self.state)  # validate type stateType
        value = find_attr_value_('pntRef', node)
        if value is not None and 'pntRef' not in already_processed:
            already_processed.add('pntRef')
            self.pntRef = value
        value = find_attr_value_('latitude', node)
        if value is not None and 'latitude' not in already_processed:
            already_processed.add('latitude')
            value = self.gds_parse_double(value, node, 'latitude')
            self.latitude = value
            self.validate_latLongAngle(self.latitude)  # validate type latLongAngle
        value = find_attr_value_('longitude', node)
        if value is not None and 'longitude' not in already_processed:
            already_processed.add('longitude')
            value = self.gds_parse_double(value, node, 'longitude')
            self.longitude = value
            self.validate_latLongAngle(self.longitude)  # validate type latLongAngle
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass


# end class PointType


class PointType3dReq(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, name=None, desc=None, code=None, state=None, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.desc = _cast(None, desc)
        self.desc_nsprefix_ = None
        self.code = _cast(None, code)
        self.code_nsprefix_ = None
        self.state = _cast(None, state)
        self.state_nsprefix_ = None
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PointType3dReq)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PointType3dReq.subclass:
            return PointType3dReq.subclass(*args_, **kwargs_)
        else:
            return PointType3dReq(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_desc(self):
        return self.desc

    def set_desc(self, desc):
        self.desc = desc

    def get_code(self):
        return self.code

    def set_code(self, code):
        self.code = code

    def get_state(self):
        return self.state

    def set_state(self, state):
        self.state = state

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def validate_stateType(self, value):
        # Validate type stateType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['existing']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on stateType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                (1 if type(self.valueOf_) in [int, float] else self.valueOf_)
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='PointType3dReq',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PointType3dReq')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PointType3dReq':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PointType3dReq')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PointType3dReq',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PointType3dReq'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            outfile.write(
                ' desc=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.desc), input_name='desc')),))
        if self.code is not None and 'code' not in already_processed:
            already_processed.add('code')
            outfile.write(
                ' code=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.code), input_name='code')),))
        if self.state is not None and 'state' not in already_processed:
            already_processed.add('state')
            outfile.write(
                ' state=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.state), input_name='state')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='PointType3dReq',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            self.desc = value
        value = find_attr_value_('code', node)
        if value is not None and 'code' not in already_processed:
            already_processed.add('code')
            self.code = value
        value = find_attr_value_('state', node)
        if value is not None and 'state' not in already_processed:
            already_processed.add('state')
            self.state = value
            self.validate_stateType(self.state)  # validate type stateType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class PointType3dReq


class CgPoints(GeneratedsSuper):
    """A collection of coordinate geometry points"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, desc=None, name=None, CgPoint=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.desc = _cast(None, desc)
        self.desc_nsprefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        if CgPoint is None:
            self.CgPoint = []
        else:
            self.CgPoint = CgPoint
        self.CgPoint_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CgPoints)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CgPoints.subclass:
            return CgPoints.subclass(*args_, **kwargs_)
        else:
            return CgPoints(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_CgPoint(self):
        return self.CgPoint

    def set_CgPoint(self, CgPoint):
        self.CgPoint = CgPoint

    def add_CgPoint(self, value):
        self.CgPoint.append(value)

    def get_desc(self):
        return self.desc

    def set_desc(self, desc):
        self.desc = desc

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def hasContent_(self):
        if (
                self.CgPoint
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
               name_='CgPoints', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CgPoints')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CgPoints':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CgPoints')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CgPoints',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CgPoints'):
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            outfile.write(
                ' desc=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.desc), input_name='desc')),))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
                       name_='CgPoints', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for CgPoint_ in self.CgPoint:
            namespaceprefix_ = self.CgPoint_nsprefix_ + ':' if (UseCapturedNS_ and self.CgPoint_nsprefix_) else ''
            CgPoint_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CgPoint',
                            pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            self.desc = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CgPoint':
            obj_ = CgPoint.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CgPoint.append(obj_)
            obj_.original_tagname_ = 'CgPoint'


# end class CgPoints


class CgPoint(PointType):
    """A coordinate geometry point. The point is identified by the "name"
    attribute, the data value is a sequence of space delimited numeric
    values as (Northing Easting) or (Northing Easting Elevation)."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = PointType

    def __init__(self, name=None, desc=None, code=None, state=None, pntRef=None, latitude=None, longitude=None,
                 oID=None, pntSurv=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None,
                 **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(CgPoint, self).__init__(name, desc, code, state, pntRef, latitude, longitude, valueOf_, mixedclass_,
                                      content_, **kwargs_)
        self.oID = _cast(int, oID)
        self.oID_nsprefix_ = None
        self.pntSurv = _cast(None, pntSurv)
        self.pntSurv_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CgPoint)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CgPoint.subclass:
            return CgPoint.subclass(*args_, **kwargs_)
        else:
            return CgPoint(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_oID(self):
        return self.oID

    def set_oID(self, oID):
        self.oID = oID

    def get_pntSurv(self):
        return self.pntSurv

    def set_pntSurv(self, pntSurv):
        self.pntSurv = pntSurv

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def validate_survPntType(self, value):
        # Validate type survPntType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['monument', 'control', 'sideshot', 'boundary', 'natural boundary', 'traverse', 'reference',
                            'administrative']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on survPntType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                (1 if type(self.valueOf_) in [int, float] else self.valueOf_) or
                self.content_ or
                super(CgPoint, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='CgPoint',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CgPoint')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CgPoint':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CgPoint')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CgPoint'):
        super(CgPoint, self).exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CgPoint')
        if self.oID is not None and 'oID' not in already_processed:
            already_processed.add('oID')
            outfile.write(' oID="%s"' % self.gds_format_integer(self.oID, input_name='oID'))
        if self.pntSurv is not None and 'pntSurv' not in already_processed:
            already_processed.add('pntSurv')
            outfile.write(' pntSurv=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.pntSurv), input_name='pntSurv')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='CgPoint',
                       fromsubclass_=False, pretty_print=True):
        super(CgPoint, self).exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True,
                                            pretty_print=pretty_print)
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('oID', node)
        if value is not None and 'oID' not in already_processed:
            already_processed.add('oID')
            self.oID = self.gds_parse_integer(value, node, 'oID')
            if self.oID <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        value = find_attr_value_('pntSurv', node)
        if value is not None and 'pntSurv' not in already_processed:
            already_processed.add('pntSurv')
            self.pntSurv = value
            self.validate_survPntType(self.pntSurv)  # validate type survPntType
        super(CgPoint, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass


# end class CgPoint


class FeatureDictionary(GeneratedsSuper):
    """Used to describe specific Feature code and property type values."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, name=None, version=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.version = _cast(None, version)
        self.version_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, FeatureDictionary)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if FeatureDictionary.subclass:
            return FeatureDictionary.subclass(*args_, **kwargs_)
        else:
            return FeatureDictionary(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_version(self):
        return self.version

    def set_version(self, version):
        self.version = version

    def validate_nonBlankString(self, value):
        # Validate type nonBlankString, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nonBlankString' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='FeatureDictionary',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('FeatureDictionary')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'FeatureDictionary':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='FeatureDictionary')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='FeatureDictionary',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='FeatureDictionary'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))
        if self.version is not None and 'version' not in already_processed:
            already_processed.add('version')
            outfile.write(' version=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.version), input_name='version')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='FeatureDictionary',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('version', node)
        if value is not None and 'version' not in already_processed:
            already_processed.add('version')
            self.version = value
            self.validate_nonBlankString(self.version)  # validate type nonBlankString

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class FeatureDictionary


class PntList2D(GeneratedsSuper):
    """A sequential, space delimited list of 2D coordinates that must include
    the Start and End points (i.e. a minimum of 2 points, 4 values). It is
    primarily used for ProfileSurf to hold the list of station/elevations
    and CrossSectSurf for offset/elevation. Example: "0.000 86.52 6.267
    86.89 12.413 87.01 26.020 87.83" """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PntList2D)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PntList2D.subclass:
            return PntList2D.subclass(*args_, **kwargs_)
        else:
            return PntList2D(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='PntList2D',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PntList2D')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PntList2D':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PntList2D')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PntList2D',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PntList2D'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='PntList2D',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class PntList2D


class PntList3D(GeneratedsSuper):
    """A sequential, space delimited list of 3D coordinates that must include
    the Start and End points (i.e. a minimum of 2 points, 6 values).
    Primarily used to store lists of northing, easting and elevation for
    Terrain Surface data. Example: "0.000 86.52 50.0 6.267 86.89 50.0
    12.413 87.01 50.0 26.020 87.83 50.0" """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PntList3D)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PntList3D.subclass:
            return PntList3D.subclass(*args_, **kwargs_)
        else:
            return PntList3D(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='PntList3D',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PntList3D')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PntList3D':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PntList3D')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PntList3D',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PntList3D'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='PntList3D',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class PntList3D


class IrregularLine(GeneratedsSuper):
    """An irregular section of a line, such as a river boudary."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, desc=None, source=None, Start=None, End=None, PntList2D=None, PntList3D=None,
                 gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.desc = _cast(None, desc)
        self.desc_nsprefix_ = None
        self.source = _cast(None, source)
        self.source_nsprefix_ = None
        self.Start = Start
        self.Start_nsprefix_ = None
        self.End = End
        self.End_nsprefix_ = None
        self.PntList2D = PntList2D
        self.validate_PntList2D(self.PntList2D)
        self.PntList2D_nsprefix_ = None
        self.PntList3D = PntList3D
        self.validate_PntList3D(self.PntList3D)
        self.PntList3D_nsprefix_ = None
        self.polygon_index = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, IrregularLine)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IrregularLine.subclass:
            return IrregularLine.subclass(*args_, **kwargs_)
        else:
            return IrregularLine(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Start(self):
        return self.Start

    def set_Start(self, Start):
        self.Start = Start

    def get_End(self):
        return self.End

    def set_End(self, End):
        self.End = End

    def get_PntList2D(self):
        return self.PntList2D

    def set_PntList2D(self, PntList2D):
        self.PntList2D = PntList2D

    def get_PntList3D(self):
        return self.PntList3D

    def set_PntList3D(self, PntList3D):
        self.PntList3D = PntList3D

    def get_desc(self):
        return self.desc

    def set_desc(self, desc):
        self.desc = desc

    def get_source(self):
        return self.source

    def set_source(self, source):
        self.source = source

    def validate_PntList2D(self, value):
        result = True
        # Validate type PntList2D, a restriction on Point.
        pass
        return result

    def validate_PntList3D(self, value):
        result = True
        # Validate type PntList3D, a restriction on Point.
        pass
        return result

    def hasContent_(self):
        if (
                self.Start is not None or
                self.End is not None or
                self.PntList2D is not None or
                self.PntList3D is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
               name_='IrregularLine', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('IrregularLine')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'IrregularLine':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='IrregularLine')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='IrregularLine',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='IrregularLine'):
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            outfile.write(
                ' desc=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.desc), input_name='desc')),))
        if self.source is not None and 'source' not in already_processed:
            already_processed.add('source')
            outfile.write(' source=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.source), input_name='source')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
                       name_='IrregularLine', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Start is not None:
            namespaceprefix_ = self.Start_nsprefix_ + ':' if (UseCapturedNS_ and self.Start_nsprefix_) else ''
            self.Start.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Start',
                              pretty_print=pretty_print)
        if self.End is not None:
            namespaceprefix_ = self.End_nsprefix_ + ':' if (UseCapturedNS_ and self.End_nsprefix_) else ''
            self.End.export(outfile, level, namespaceprefix_, namespacedef_='', name_='End', pretty_print=pretty_print)
        if self.PntList2D is not None:
            namespaceprefix_ = self.PntList2D_nsprefix_ + ':' if (UseCapturedNS_ and self.PntList2D_nsprefix_) else ''
            self.PntList2D.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PntList2D',
                                  pretty_print=pretty_print)
        if self.PntList3D is not None:
            namespaceprefix_ = self.PntList3D_nsprefix_ + ':' if (UseCapturedNS_ and self.PntList3D_nsprefix_) else ''
            self.PntList3D.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PntList3D',
                                  pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            self.desc = value
        value = find_attr_value_('source', node)
        if value is not None and 'source' not in already_processed:
            already_processed.add('source')
            self.source = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Start':
            class_obj_ = self.get_class_obj_(child_, PntRefPointType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Start = obj_
            obj_.original_tagname_ = 'Start'
        elif nodeName_ == 'End':
            class_obj_ = self.get_class_obj_(child_, PntRefPointType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.End = obj_
            obj_.original_tagname_ = 'End'
        elif nodeName_ == 'PntList2D':
            value_ = child_.text
            self.PntList2D = value_
            #self.PntList2D_nsprefix_ = child_.prefix
            # validate type PntList2D
            self.validate_PntList2D(self.PntList2D)
        elif nodeName_ == 'PntList3D':
            value_ = child_.text
            self.PntList3D = value_
            self.PntList3D_nsprefix_ = child_.prefix
            # validate type PntList3D
            self.validate_PntList3D(self.PntList3D)


# end class IrregularLine


class Curve(GeneratedsSuper):
    """A circular curved section of a line. The radius is the distance from the
    Start or End to the Center.The rotation attribute "rot" defines whether
    the arc travels clockwise or counter-clockwise from the Start to End
    point."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, desc=None, rot=None, radius=None, Start=None, Center=None, End=None, gds_collector_=None,
                 **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.desc = _cast(None, desc)
        self.desc_nsprefix_ = None
        self.rot = _cast(None, rot)
        self.rot_nsprefix_ = None
        self.radius = _cast(float, radius)
        self.radius_nsprefix_ = None
        self.Start = Start
        self.Start_nsprefix_ = None
        self.Center = Center
        self.Center_nsprefix_ = None
        self.End = End
        self.End_nsprefix_ = None
        self.polygon_index = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Curve)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Curve.subclass:
            return Curve.subclass(*args_, **kwargs_)
        else:
            return Curve(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Start(self):
        return self.Start

    def set_Start(self, Start):
        self.Start = Start

    def get_Center(self):
        return self.Center

    def set_Center(self, Center):
        self.Center = Center

    def get_End(self):
        return self.End

    def set_End(self, End):
        self.End = End

    def get_desc(self):
        return self.desc

    def set_desc(self, desc):
        self.desc = desc

    def get_rot(self):
        return self.rot

    def set_rot(self, rot):
        self.rot = rot

    def get_radius(self):
        return self.radius

    def set_radius(self, radius):
        self.radius = radius

    def validate_clockwise(self, value):
        # Validate type clockwise, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['cw', 'ccw']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on clockwise' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.Start is not None or
                self.Center is not None or
                self.End is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
               name_='Curve', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Curve')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Curve':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Curve')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Curve',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Curve'):
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            outfile.write(
                ' desc=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.desc), input_name='desc')),))
        if self.rot is not None and 'rot' not in already_processed:
            already_processed.add('rot')
            outfile.write(
                ' rot=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.rot), input_name='rot')),))
        if self.radius is not None and 'radius' not in already_processed:
            already_processed.add('radius')
            outfile.write(' radius="%s"' % self.gds_format_double(self.radius, input_name='radius'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
                       name_='Curve', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Start is not None:
            namespaceprefix_ = self.Start_nsprefix_ + ':' if (UseCapturedNS_ and self.Start_nsprefix_) else ''
            self.Start.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Start',
                              pretty_print=pretty_print)
        if self.Center is not None:
            namespaceprefix_ = self.Center_nsprefix_ + ':' if (UseCapturedNS_ and self.Center_nsprefix_) else ''
            self.Center.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Center',
                               pretty_print=pretty_print)
        if self.End is not None:
            namespaceprefix_ = self.End_nsprefix_ + ':' if (UseCapturedNS_ and self.End_nsprefix_) else ''
            self.End.export(outfile, level, namespaceprefix_, namespacedef_='', name_='End', pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            self.desc = value
        value = find_attr_value_('rot', node)
        if value is not None and 'rot' not in already_processed:
            already_processed.add('rot')
            self.rot = value
            self.validate_clockwise(self.rot)  # validate type clockwise
        value = find_attr_value_('radius', node)
        if value is not None and 'radius' not in already_processed:
            already_processed.add('radius')
            value = self.gds_parse_double(value, node, 'radius')
            self.radius = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Start':
            class_obj_ = self.get_class_obj_(child_, PntRefPointType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Start = obj_
            obj_.original_tagname_ = 'Start'
        elif nodeName_ == 'Center':
            class_obj_ = self.get_class_obj_(child_, PntRefPointType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Center = obj_
            obj_.original_tagname_ = 'Center'
        elif nodeName_ == 'End':
            class_obj_ = self.get_class_obj_(child_, PntRefPointType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.End = obj_
            obj_.original_tagname_ = 'End'


# end class Curve


class CoordGeom(GeneratedsSuper):
    """A sequential list of linear elements.After the sequential list of
    elements an optional vertical geometry
    may be defined as a profile, which may be as simple as a list of PVIs
    (point to point 3D line string)."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, name=None, Line=None, IrregularLine=None, Curve=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        if Line is None:
            self.Line = []
        else:
            self.Line = Line
        self.Line_nsprefix_ = None
        if IrregularLine is None:
            self.IrregularLine = []
        else:
            self.IrregularLine = IrregularLine
        self.IrregularLine_nsprefix_ = None
        if Curve is None:
            self.Curve = []
        else:
            self.Curve = Curve
        self.Curve_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CoordGeom)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CoordGeom.subclass:
            return CoordGeom.subclass(*args_, **kwargs_)
        else:
            return CoordGeom(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Line(self):
        return self.Line

    def set_Line(self, Line):
        self.Line = Line

    def add_Line(self, value):
        self.Line.append(value)

    def insert_Line_at(self, index, value):
        self.Line.insert(index, value)

    def replace_Line_at(self, index, value):
        self.Line[index] = value

    def get_IrregularLine(self):
        return self.IrregularLine

    def set_IrregularLine(self, IrregularLine):
        self.IrregularLine = IrregularLine

    def add_IrregularLine(self, value):
        self.IrregularLine.append(value)

    def insert_IrregularLine_at(self, index, value):
        self.IrregularLine.insert(index, value)

    def replace_IrregularLine_at(self, index, value):
        self.IrregularLine[index] = value

    def get_Curve(self):
        return self.Curve

    def set_Curve(self, Curve):
        self.Curve = Curve

    def add_Curve(self, value):
        self.Curve.append(value)

    def insert_Curve_at(self, index, value):
        self.Curve.insert(index, value)

    def replace_Curve_at(self, index, value):
        self.Curve[index] = value

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def hasContent_(self):
        if (
                self.Line or
                self.IrregularLine or
                self.Curve
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
               name_='CoordGeom', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CoordGeom')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CoordGeom':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CoordGeom')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CoordGeom',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CoordGeom'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
                       name_='CoordGeom', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        lines = self.Line + self.IrregularLine + self.Curve
        lines = sorted(lines, key=lambda x: x.polygon_index)
        for item in lines:
            if item in self.Line:
                namespaceprefix_ = self.Line_nsprefix_ + ':' if (UseCapturedNS_ and self.Line_nsprefix_) else ''
                item.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Line', pretty_print=pretty_print)
            elif item in self.IrregularLine:
                namespaceprefix_ = self.IrregularLine_nsprefix_ + ':' if (
                            UseCapturedNS_ and self.IrregularLine_nsprefix_) else ''
                item.export(outfile, level, namespaceprefix_, namespacedef_='', name_='IrregularLine',
                                      pretty_print=pretty_print)
            elif item in self.Curve:
                namespaceprefix_ = self.Curve_nsprefix_ + ':' if (UseCapturedNS_ and self.Curve_nsprefix_) else ''
                item.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Curve', pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        if not isinstance(node, list):
            node = [n for n in node]
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Line':
            obj_ = Line.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Line.append(obj_)
            obj_.original_tagname_ = 'Line'
            obj_.polygon_index = node.index(child_)

        elif nodeName_ == 'IrregularLine':
            obj_ = IrregularLine.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.IrregularLine.append(obj_)
            obj_.original_tagname_ = 'IrregularLine'
            obj_.polygon_index = node.index(child_)

        elif nodeName_ == 'Curve':
            obj_ = Curve.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Curve.append(obj_)
            obj_.original_tagname_ = 'Curve'
            obj_.polygon_index = node.index(child_)

# end class CoordGeom


class Line(GeneratedsSuper):
    """A straight section of a line"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, desc=None, Start=None, End=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.desc = _cast(None, desc)
        self.desc_nsprefix_ = None
        self.Start = Start
        self.Start_nsprefix_ = None
        self.End = End
        self.End_nsprefix_ = None
        self.polygon_index = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Line)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Line.subclass:
            return Line.subclass(*args_, **kwargs_)
        else:
            return Line(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Start(self):
        return self.Start

    def set_Start(self, Start):
        self.Start = Start

    def get_End(self):
        return self.End

    def set_End(self, End):
        self.End = End

    def get_desc(self):
        return self.desc

    def set_desc(self, desc):
        self.desc = desc

    def hasContent_(self):
        if (
                self.Start is not None or
                self.End is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
               name_='Line', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Line')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Line':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Line')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Line',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Line'):
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            outfile.write(
                ' desc=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.desc), input_name='desc')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
                       name_='Line', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Start is not None:
            namespaceprefix_ = self.Start_nsprefix_ + ':' if (UseCapturedNS_ and self.Start_nsprefix_) else ''
            self.Start.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Start',
                              pretty_print=pretty_print)
        if self.End is not None:
            namespaceprefix_ = self.End_nsprefix_ + ':' if (UseCapturedNS_ and self.End_nsprefix_) else ''
            self.End.export(outfile, level, namespaceprefix_, namespacedef_='', name_='End', pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            self.desc = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Start':
            class_obj_ = self.get_class_obj_(child_, PntRefPointType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Start = obj_
            obj_.original_tagname_ = 'Start'
        elif nodeName_ == 'End':
            class_obj_ = self.get_class_obj_(child_, PntRefPointType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.End = obj_
            obj_.original_tagname_ = 'End'


# end class Line


class Units(GeneratedsSuper):
    """Sets up unit defaults, All Jurisdictions are using the same units."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, Metric=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Metric = Metric
        self.Metric_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Units)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Units.subclass:
            return Units.subclass(*args_, **kwargs_)
        else:
            return Units(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Metric(self):
        return self.Metric

    def set_Metric(self, Metric):
        self.Metric = Metric

    def hasContent_(self):
        if (
                self.Metric is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
               name_='Units', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Units')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Units':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Units')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Units',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Units'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
                       name_='Units', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Metric is not None:
            namespaceprefix_ = self.Metric_nsprefix_ + ':' if (UseCapturedNS_ and self.Metric_nsprefix_) else ''
            self.Metric.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Metric',
                               pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Metric':
            obj_ = Metric.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Metric = obj_
            obj_.original_tagname_ = 'Metric'


# end class Units


class Metric(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, areaUnit=None, linearUnit=None, volumeUnit=None, temperatureUnit=None, pressureUnit=None,
                 angularUnit=None, directionUnit=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.areaUnit = _cast(None, areaUnit)
        self.areaUnit_nsprefix_ = None
        self.linearUnit = _cast(None, linearUnit)
        self.linearUnit_nsprefix_ = None
        self.volumeUnit = _cast(None, volumeUnit)
        self.volumeUnit_nsprefix_ = None
        self.temperatureUnit = _cast(None, temperatureUnit)
        self.temperatureUnit_nsprefix_ = None
        self.pressureUnit = _cast(None, pressureUnit)
        self.pressureUnit_nsprefix_ = None
        self.angularUnit = _cast(None, angularUnit)
        self.angularUnit_nsprefix_ = None
        self.directionUnit = _cast(None, directionUnit)
        self.directionUnit_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Metric)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Metric.subclass:
            return Metric.subclass(*args_, **kwargs_)
        else:
            return Metric(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_areaUnit(self):
        return self.areaUnit

    def set_areaUnit(self, areaUnit):
        self.areaUnit = areaUnit

    def get_linearUnit(self):
        return self.linearUnit

    def set_linearUnit(self, linearUnit):
        self.linearUnit = linearUnit

    def get_volumeUnit(self):
        return self.volumeUnit

    def set_volumeUnit(self, volumeUnit):
        self.volumeUnit = volumeUnit

    def get_temperatureUnit(self):
        return self.temperatureUnit

    def set_temperatureUnit(self, temperatureUnit):
        self.temperatureUnit = temperatureUnit

    def get_pressureUnit(self):
        return self.pressureUnit

    def set_pressureUnit(self, pressureUnit):
        self.pressureUnit = pressureUnit

    def get_angularUnit(self):
        return self.angularUnit

    def set_angularUnit(self, angularUnit):
        self.angularUnit = angularUnit

    def get_directionUnit(self):
        return self.directionUnit

    def set_directionUnit(self, directionUnit):
        self.directionUnit = directionUnit

    def validate_metArea(self, value):
        # Validate type metArea, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['squareMeter']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on metArea' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_metLinear(self, value):
        # Validate type metLinear, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['meter']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on metLinear' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_metVolume(self, value):
        # Validate type metVolume, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['cubicMeter']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on metVolume' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_metTemperature(self, value):
        # Validate type metTemperature, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['celsius']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on metTemperature' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_metPressure(self, value):
        # Validate type metPressure, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['milliBars']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on metPressure' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_angularType(self, value):
        # Validate type angularType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['decimal dd.mm.ss']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on angularType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='Metric',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Metric')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Metric':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Metric')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Metric',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Metric'):
        if self.areaUnit is not None and 'areaUnit' not in already_processed:
            already_processed.add('areaUnit')
            outfile.write(' areaUnit=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.areaUnit), input_name='areaUnit')),))
        if self.linearUnit is not None and 'linearUnit' not in already_processed:
            already_processed.add('linearUnit')
            outfile.write(' linearUnit=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.linearUnit), input_name='linearUnit')),))
        if self.volumeUnit is not None and 'volumeUnit' not in already_processed:
            already_processed.add('volumeUnit')
            outfile.write(' volumeUnit=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.volumeUnit), input_name='volumeUnit')),))
        if self.temperatureUnit is not None and 'temperatureUnit' not in already_processed:
            already_processed.add('temperatureUnit')
            outfile.write(' temperatureUnit=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.temperatureUnit), input_name='temperatureUnit')),))
        if self.pressureUnit is not None and 'pressureUnit' not in already_processed:
            already_processed.add('pressureUnit')
            outfile.write(' pressureUnit=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.pressureUnit), input_name='pressureUnit')),))
        if self.angularUnit is not None and 'angularUnit' not in already_processed:
            already_processed.add('angularUnit')
            outfile.write(' angularUnit=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.angularUnit), input_name='angularUnit')),))
        if self.directionUnit is not None and 'directionUnit' not in already_processed:
            already_processed.add('directionUnit')
            outfile.write(' directionUnit=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.directionUnit), input_name='directionUnit')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='Metric',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('areaUnit', node)
        if value is not None and 'areaUnit' not in already_processed:
            already_processed.add('areaUnit')
            self.areaUnit = value
            self.validate_metArea(self.areaUnit)  # validate type metArea
        value = find_attr_value_('linearUnit', node)
        if value is not None and 'linearUnit' not in already_processed:
            already_processed.add('linearUnit')
            self.linearUnit = value
            self.validate_metLinear(self.linearUnit)  # validate type metLinear
        value = find_attr_value_('volumeUnit', node)
        if value is not None and 'volumeUnit' not in already_processed:
            already_processed.add('volumeUnit')
            self.volumeUnit = value
            self.validate_metVolume(self.volumeUnit)  # validate type metVolume
        value = find_attr_value_('temperatureUnit', node)
        if value is not None and 'temperatureUnit' not in already_processed:
            already_processed.add('temperatureUnit')
            self.temperatureUnit = value
            self.validate_metTemperature(self.temperatureUnit)  # validate type metTemperature
        value = find_attr_value_('pressureUnit', node)
        if value is not None and 'pressureUnit' not in already_processed:
            already_processed.add('pressureUnit')
            self.pressureUnit = value
            self.validate_metPressure(self.pressureUnit)  # validate type metPressure
        value = find_attr_value_('angularUnit', node)
        if value is not None and 'angularUnit' not in already_processed:
            already_processed.add('angularUnit')
            self.angularUnit = value
            self.validate_angularType(self.angularUnit)  # validate type angularType
        value = find_attr_value_('directionUnit', node)
        if value is not None and 'directionUnit' not in already_processed:
            already_processed.add('directionUnit')
            self.directionUnit = value
            self.validate_angularType(self.directionUnit)  # validate type angularType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class Metric


class CoordinateSystem(GeneratedsSuper):
    """Simplified coordinate systems"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, desc=None, datum=None, horizontalDatum=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.desc = _cast(None, desc)
        self.desc_nsprefix_ = None
        self.datum = _cast(None, datum)
        self.datum_nsprefix_ = None
        self.horizontalDatum = _cast(None, horizontalDatum)
        self.horizontalDatum_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CoordinateSystem)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CoordinateSystem.subclass:
            return CoordinateSystem.subclass(*args_, **kwargs_)
        else:
            return CoordinateSystem(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_desc(self):
        return self.desc

    def set_desc(self, desc):
        self.desc = desc

    def get_datum(self):
        return self.datum

    def set_datum(self, datum):
        self.datum = datum

    def get_horizontalDatum(self):
        return self.horizontalDatum

    def set_horizontalDatum(self, horizontalDatum):
        self.horizontalDatum = horizontalDatum

    def validate_nonBlankString(self, value):
        # Validate type nonBlankString, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nonBlankString' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_surveyBgDatumType(self, value):
        # Validate type enum:surveyBgDatumType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Approx True North', 'MGA94_Zone54', 'MGA94_Zone55', 'MGA2020_Zone54', 'MGA2020_Zone55',
                            'AMG66_Zone54', 'AMG66_Zone55', 'GDA2020', 'Local']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on surveyBgDatumType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_horzDatumType(self, value):
        # Validate type enum:horzDatumType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Local', 'MGA94_Zone54', 'MGA94_Zone55', 'MGA2020_Zone54', 'MGA2020_Zone55', 'AMG66_Zone54',
                            'AMG66_Zone55', 'GDA2020']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on horzDatumType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='CoordinateSystem',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CoordinateSystem')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CoordinateSystem':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CoordinateSystem')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CoordinateSystem',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CoordinateSystem'):
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            outfile.write(
                ' desc=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.desc), input_name='desc')),))
        if self.datum is not None and 'datum' not in already_processed:
            already_processed.add('datum')
            outfile.write(
                ' datum=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.datum), input_name='datum')),))
        if self.horizontalDatum is not None and 'horizontalDatum' not in already_processed:
            already_processed.add('horizontalDatum')
            outfile.write(' horizontalDatum=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.horizontalDatum), input_name='horizontalDatum')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='CoordinateSystem',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            self.desc = value
            self.validate_nonBlankString(self.desc)  # validate type nonBlankString
        value = find_attr_value_('datum', node)
        if value is not None and 'datum' not in already_processed:
            already_processed.add('datum')
            self.datum = value
            self.validate_surveyBgDatumType(self.datum)  # validate type surveyBgDatumType
        value = find_attr_value_('horizontalDatum', node)
        if value is not None and 'horizontalDatum' not in already_processed:
            already_processed.add('horizontalDatum')
            self.horizontalDatum = value
            self.validate_horzDatumType(self.horizontalDatum)  # validate type horzDatumType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class CoordinateSystem


class Application(GeneratedsSuper):
    """Mandatory element to identify the software used to create the file."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, name=None, version=None, Author=None, valueOf_=None, mixedclass_=None, content_=None,
                 gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.version = _cast(None, version)
        self.version_nsprefix_ = None
        if Author is None:
            self.Author = []
        else:
            self.Author = Author
        self.Author_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Application)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Application.subclass:
            return Application.subclass(*args_, **kwargs_)
        else:
            return Application(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Author(self):
        return self.Author

    def set_Author(self, Author):
        self.Author = Author

    def add_Author(self, value):
        self.Author.append(value)

    def insert_Author_at(self, index, value):
        self.Author.insert(index, value)

    def replace_Author_at(self, index, value):
        self.Author[index] = value

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_version(self):
        return self.version

    def set_version(self, version):
        self.version = version

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def validate_nonBlankString(self, value):
        # Validate type nonBlankString, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nonBlankString' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.Author or
                (1 if type(self.valueOf_) in [int, float] else self.valueOf_) or
                self.content_
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
               name_='Application', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Application')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Application':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Application')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Application',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Application'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))
        if self.version is not None and 'version' not in already_processed:
            already_processed.add('version')
            outfile.write(' version=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.version), input_name='version')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
                       name_='Application', fromsubclass_=False, pretty_print=True):
        # if not fromsubclass_:
        #     for item_ in self.content_:
        #         item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Author_ in self.Author:
            namespaceprefix_ = self.Author_nsprefix_ + ':' if (UseCapturedNS_ and self.Author_nsprefix_) else ''
            Author_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Author',
                           pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
            self.validate_nonBlankString(self.name)  # validate type nonBlankString
        value = find_attr_value_('version', node)
        if value is not None and 'version' not in already_processed:
            already_processed.add('version')
            self.version = value
            self.validate_nonBlankString(self.version)  # validate type nonBlankString

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Author':
            obj_ = Author.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'Author', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Author'):
                self.add_Author(obj_.value)
            elif hasattr(self, 'set_Author'):
                self.set_Author(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)


# end class Application


class Author(GeneratedsSuper):
    """Optional element to identify the source of the file."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, createdBy=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.createdBy = _cast(None, createdBy)
        self.createdBy_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Author)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Author.subclass:
            return Author.subclass(*args_, **kwargs_)
        else:
            return Author(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_createdBy(self):
        return self.createdBy

    def set_createdBy(self, createdBy):
        self.createdBy = createdBy

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def validate_nonBlankString(self, value):
        # Validate type nonBlankString, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nonBlankString' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                (1 if type(self.valueOf_) in [int, float] else self.valueOf_) or
                self.content_
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='Author',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Author')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Author':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Author')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Author'):
        if self.createdBy is not None and 'createdBy' not in already_processed:
            already_processed.add('createdBy')
            outfile.write(' createdBy=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.createdBy), input_name='createdBy')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='Author',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('createdBy', node)
        if value is not None and 'createdBy' not in already_processed:
            already_processed.add('createdBy')
            self.createdBy = value
            self.validate_nonBlankString(self.createdBy)  # validate type nonBlankString

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass


# end class Author


class Survey(GeneratedsSuper):
    """Survey data"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, SurveyHeader=None, InstrumentSetup=None, ObservationGroup=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.SurveyHeader = SurveyHeader
        self.SurveyHeader_nsprefix_ = None
        if InstrumentSetup is None:
            self.InstrumentSetup = []
        else:
            self.InstrumentSetup = InstrumentSetup
        self.InstrumentSetup_nsprefix_ = None
        if ObservationGroup is None:
            self.ObservationGroup = []
        else:
            self.ObservationGroup = ObservationGroup
        self.ObservationGroup_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Survey)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Survey.subclass:
            return Survey.subclass(*args_, **kwargs_)
        else:
            return Survey(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_SurveyHeader(self):
        return self.SurveyHeader

    def set_SurveyHeader(self, SurveyHeader):
        self.SurveyHeader = SurveyHeader

    def get_InstrumentSetup(self):
        return self.InstrumentSetup

    def set_InstrumentSetup(self, InstrumentSetup):
        self.InstrumentSetup = InstrumentSetup

    def add_InstrumentSetup(self, value):
        self.InstrumentSetup.append(value)

    def insert_InstrumentSetup_at(self, index, value):
        self.InstrumentSetup.insert(index, value)

    def replace_InstrumentSetup_at(self, index, value):
        self.InstrumentSetup[index] = value

    def get_ObservationGroup(self):
        return self.ObservationGroup

    def set_ObservationGroup(self, ObservationGroup):
        self.ObservationGroup = ObservationGroup

    def add_ObservationGroup(self, value):
        self.ObservationGroup.append(value)

    def insert_ObservationGroup_at(self, index, value):
        self.ObservationGroup.insert(index, value)

    def replace_ObservationGroup_at(self, index, value):
        self.ObservationGroup[index] = value

    def hasContent_(self):
        if (
                self.SurveyHeader is not None or
                self.InstrumentSetup or
                self.ObservationGroup
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
               name_='Survey', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Survey')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Survey':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Survey')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Survey',
                                pretty_print=pretty_print)

            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Survey'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
                       name_='Survey', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.SurveyHeader is not None:
            namespaceprefix_ = self.SurveyHeader_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.SurveyHeader_nsprefix_) else ''
            self.SurveyHeader.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SurveyHeader',
                                     pretty_print=pretty_print)

        for InstrumentSetup_ in self.InstrumentSetup:
            namespaceprefix_ = self.InstrumentSetup_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.InstrumentSetup_nsprefix_) else ''
            InstrumentSetup_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='InstrumentSetup',
                                    pretty_print=pretty_print)
        for ObservationGroup_ in self.ObservationGroup:
            namespaceprefix_ = self.ObservationGroup_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ObservationGroup_nsprefix_) else ''
            ObservationGroup_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ObservationGroup',
                                     pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'SurveyHeader':
            obj_ = SurveyHeader.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SurveyHeader = obj_
            obj_.original_tagname_ = 'SurveyHeader'
        elif nodeName_ == 'InstrumentSetup':
            obj_ = InstrumentSetup.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.InstrumentSetup.append(obj_)
            obj_.original_tagname_ = 'InstrumentSetup'
        elif nodeName_ == 'ObservationGroup':
            obj_ = ObservationGroup.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ObservationGroup.append(obj_)
            obj_.original_tagname_ = 'ObservationGroup'


# end class Survey


class SurveyHeader(GeneratedsSuper):
    """Metadata about the Survey"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, name=None, surveyorFirm=None, surveyorReference=None, type_=None, jurisdiction=None,
                 surveyFormat=None, Annotation=None, AdministrativeArea=None, AdministrativeDate=None, Personnel=None,
                 FieldNote=None, PurposeOfSurvey=None, HeadOfPower=None, valueOf_=None, mixedclass_=None, content_=None,
                 gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.surveyorFirm = _cast(None, surveyorFirm)
        self.surveyorFirm_nsprefix_ = None
        self.surveyorReference = _cast(None, surveyorReference)
        self.surveyorReference_nsprefix_ = None
        self.type_ = _cast(None, type_)
        self.type__nsprefix_ = None
        self.jurisdiction = _cast(None, jurisdiction)
        self.jurisdiction_nsprefix_ = None
        self.surveyFormat = _cast(None, surveyFormat)
        self.surveyFormat_nsprefix_ = None
        if Annotation is None:
            self.Annotation = []
        else:
            self.Annotation = Annotation
        self.Annotation_nsprefix_ = None
        if AdministrativeArea is None:
            self.AdministrativeArea = []
        else:
            self.AdministrativeArea = AdministrativeArea
        self.AdministrativeArea_nsprefix_ = None
        if AdministrativeDate is None:
            self.AdministrativeDate = []
        else:
            self.AdministrativeDate = AdministrativeDate
        self.AdministrativeDate_nsprefix_ = None
        if Personnel is None:
            self.Personnel = []
        else:
            self.Personnel = Personnel
        self.Personnel_nsprefix_ = None
        if FieldNote is None:
            self.FieldNote = []
        else:
            self.FieldNote = FieldNote
        self.FieldNote_nsprefix_ = None
        if PurposeOfSurvey is None:
            self.PurposeOfSurvey = []
        else:
            self.PurposeOfSurvey = PurposeOfSurvey
        self.PurposeOfSurvey_nsprefix_ = None
        if HeadOfPower is None:
            self.HeadOfPower = []
        else:
            self.HeadOfPower = HeadOfPower
        self.HeadOfPower_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SurveyHeader)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SurveyHeader.subclass:
            return SurveyHeader.subclass(*args_, **kwargs_)
        else:
            return SurveyHeader(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Annotation(self):
        return self.Annotation

    def set_Annotation(self, Annotation):
        self.Annotation = Annotation

    def add_Annotation(self, value):
        self.Annotation.append(value)

    def insert_Annotation_at(self, index, value):
        self.Annotation.insert(index, value)

    def replace_Annotation_at(self, index, value):
        self.Annotation[index] = value

    def get_AdministrativeArea(self):
        return self.AdministrativeArea

    def set_AdministrativeArea(self, AdministrativeArea):
        self.AdministrativeArea = AdministrativeArea

    def add_AdministrativeArea(self, value):
        self.AdministrativeArea.append(value)

    def insert_AdministrativeArea_at(self, index, value):
        self.AdministrativeArea.insert(index, value)

    def replace_AdministrativeArea_at(self, index, value):
        self.AdministrativeArea[index] = value

    def get_AdministrativeDate(self):
        return self.AdministrativeDate

    def set_AdministrativeDate(self, AdministrativeDate):
        self.AdministrativeDate = AdministrativeDate

    def add_AdministrativeDate(self, value):
        self.AdministrativeDate.append(value)

    def insert_AdministrativeDate_at(self, index, value):
        self.AdministrativeDate.insert(index, value)

    def replace_AdministrativeDate_at(self, index, value):
        self.AdministrativeDate[index] = value

    def get_Personnel(self):
        return self.Personnel

    def set_Personnel(self, Personnel):
        self.Personnel = Personnel

    def add_Personnel(self, value):
        self.Personnel.append(value)

    def insert_Personnel_at(self, index, value):
        self.Personnel.insert(index, value)

    def replace_Personnel_at(self, index, value):
        self.Personnel[index] = value

    def get_FieldNote(self):
        return self.FieldNote

    def set_FieldNote(self, FieldNote):
        self.FieldNote = FieldNote

    def add_FieldNote(self, value):
        self.FieldNote.append(value)

    def insert_FieldNote_at(self, index, value):
        self.FieldNote.insert(index, value)

    def replace_FieldNote_at(self, index, value):
        self.FieldNote[index] = value

    def get_PurposeOfSurvey(self):
        return self.PurposeOfSurvey

    def set_PurposeOfSurvey(self, PurposeOfSurvey):
        self.PurposeOfSurvey = PurposeOfSurvey

    def add_PurposeOfSurvey(self, value):
        self.PurposeOfSurvey.append(value)

    def insert_PurposeOfSurvey_at(self, index, value):
        self.PurposeOfSurvey.insert(index, value)

    def replace_PurposeOfSurvey_at(self, index, value):
        self.PurposeOfSurvey[index] = value

    def get_HeadOfPower(self):
        return self.HeadOfPower

    def set_HeadOfPower(self, HeadOfPower):
        self.HeadOfPower = HeadOfPower

    def add_HeadOfPower(self, value):
        self.HeadOfPower.append(value)

    def insert_HeadOfPower_at(self, index, value):
        self.HeadOfPower.insert(index, value)

    def replace_HeadOfPower_at(self, index, value):
        self.HeadOfPower[index] = value

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_surveyorFirm(self):
        return self.surveyorFirm

    def set_surveyorFirm(self, surveyorFirm):
        self.surveyorFirm = surveyorFirm

    def get_surveyorReference(self):
        return self.surveyorReference

    def set_surveyorReference(self, surveyorReference):
        self.surveyorReference = surveyorReference

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_jurisdiction(self):
        return self.jurisdiction

    def set_jurisdiction(self, jurisdiction):
        self.jurisdiction = jurisdiction

    def get_surveyFormat(self):
        return self.surveyFormat

    def set_surveyFormat(self, surveyFormat):
        self.surveyFormat = surveyFormat

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def validate_nonBlankString(self, value):
        # Validate type nonBlankString, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nonBlankString' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_surveyType(self, value):
        # Validate type surveyType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['compiled', 'computed', 'surveyed']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on surveyType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_jurisdictionType(self, value):
        # Validate type enum:jurisdictionType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Victoria']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on jurisdictionType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_surveyFormatType(self, value):
        # Validate type enum:surveyFormatType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Level Land', 'Undulating Land', 'Steep Land', 'Mountainous Land']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on surveyFormatType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.Annotation or
                self.AdministrativeArea or
                self.AdministrativeDate or
                self.Personnel or
                self.FieldNote or
                self.PurposeOfSurvey or
                self.HeadOfPower or
                (1 if type(self.valueOf_) in [int, float] else self.valueOf_) or
                self.content_
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
               name_='SurveyHeader', pretty_print=True):
        if self.eplan_value is True:
            self.surveyorFirm = 'DCM BackCapture'
            self.surveyorReference = 'Not-Supplied-VerNot-Supplied'
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SurveyHeader')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SurveyHeader':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SurveyHeader')

        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SurveyHeader',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)

            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SurveyHeader'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))
        if self.surveyorFirm is not None and 'surveyorFirm' not in already_processed:
            already_processed.add('surveyorFirm')
            outfile.write(' surveyorFirm=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.surveyorFirm), input_name='surveyorFirm')),))
        if self.surveyorReference is not None and 'surveyorReference' not in already_processed:
            already_processed.add('surveyorReference')
            outfile.write(' surveyorReference=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.surveyorReference), input_name='surveyorReference')),))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(
                ' type=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.type_), input_name='type')),))
        if self.jurisdiction is not None and 'jurisdiction' not in already_processed:
            already_processed.add('jurisdiction')
            outfile.write(' jurisdiction=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.jurisdiction), input_name='jurisdiction')),))
        if self.surveyFormat is not None and 'surveyFormat' not in already_processed:
            already_processed.add('surveyFormat')
            outfile.write(' surveyFormat=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.surveyFormat), input_name='surveyFormat')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
                       name_='SurveyHeader', fromsubclass_=False, pretty_print=True):
        # if not fromsubclass_:
        #     for item_ in self.content_:
        #         item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Annotation_ in self.Annotation:
            namespaceprefix_ = self.Annotation_nsprefix_ + ':' if (UseCapturedNS_ and self.Annotation_nsprefix_) else ''
            Annotation_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Annotation',
                               pretty_print=pretty_print)
        for AdministrativeArea_ in self.AdministrativeArea:
            namespaceprefix_ = self.AdministrativeArea_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.AdministrativeArea_nsprefix_) else ''
            AdministrativeArea_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AdministrativeArea',
                                       pretty_print=pretty_print)
        for AdministrativeDate_ in self.AdministrativeDate:
            namespaceprefix_ = self.AdministrativeDate_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.AdministrativeDate_nsprefix_) else ''
            AdministrativeDate_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AdministrativeDate',
                                       pretty_print=pretty_print)
        for Personnel_ in self.Personnel:
            namespaceprefix_ = self.Personnel_nsprefix_ + ':' if (UseCapturedNS_ and self.Personnel_nsprefix_) else ''
            Personnel_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Personnel',
                              pretty_print=pretty_print)
        for FieldNote_ in self.FieldNote:
            namespaceprefix_ = self.FieldNote_nsprefix_ + ':' if (UseCapturedNS_ and self.FieldNote_nsprefix_) else ''
            FieldNote_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='FieldNote',
                              pretty_print=pretty_print)
        for PurposeOfSurvey_ in self.PurposeOfSurvey:
            namespaceprefix_ = self.PurposeOfSurvey_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.PurposeOfSurvey_nsprefix_) else ''
            PurposeOfSurvey_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PurposeOfSurvey',
                                    pretty_print=pretty_print)
        for HeadOfPower_ in self.HeadOfPower:
            namespaceprefix_ = self.HeadOfPower_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.HeadOfPower_nsprefix_) else ''
            HeadOfPower_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='HeadOfPower',
                                pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
            self.validate_nonBlankString(self.name)  # validate type nonBlankString
        value = find_attr_value_('surveyorFirm', node)
        if value is not None and 'surveyorFirm' not in already_processed:
            already_processed.add('surveyorFirm')
            self.surveyorFirm = value
            self.validate_nonBlankString(self.surveyorFirm)  # validate type nonBlankString
        value = find_attr_value_('surveyorReference', node)
        if value is not None and 'surveyorReference' not in already_processed:
            already_processed.add('surveyorReference')
            self.surveyorReference = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
            self.validate_surveyType(self.type_)  # validate type surveyType
        value = find_attr_value_('jurisdiction', node)
        if value is not None and 'jurisdiction' not in already_processed:
            already_processed.add('jurisdiction')
            self.jurisdiction = value
            self.validate_jurisdictionType(self.jurisdiction)  # validate type jurisdictionType
        value = find_attr_value_('surveyFormat', node)
        if value is not None and 'surveyFormat' not in already_processed:
            already_processed.add('surveyFormat')
            self.surveyFormat = value
            self.validate_surveyFormatType(self.surveyFormat)  # validate type surveyFormatType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Annotation':
            obj_ = Annotation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'Annotation', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Annotation'):
                self.add_Annotation(obj_.value)
            elif hasattr(self, 'set_Annotation'):
                self.set_Annotation(obj_.value)
        elif nodeName_ == 'AdministrativeArea':
            obj_ = AdministrativeArea.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'AdministrativeArea', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_AdministrativeArea'):
                self.add_AdministrativeArea(obj_.value)
            elif hasattr(self, 'set_AdministrativeArea'):
                self.set_AdministrativeArea(obj_.value)
        elif nodeName_ == 'AdministrativeDate':
            obj_ = AdministrativeDate.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'AdministrativeDate', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_AdministrativeDate'):
                self.add_AdministrativeDate(obj_.value)
            elif hasattr(self, 'set_AdministrativeDate'):
                self.set_AdministrativeDate(obj_.value)
        elif nodeName_ == 'Personnel':
            obj_ = Personnel.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'Personnel', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Personnel'):
                self.add_Personnel(obj_.value)
            elif hasattr(self, 'set_Personnel'):
                self.set_Personnel(obj_.value)
        elif nodeName_ == 'FieldNote':
            obj_ = FieldNote.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'FieldNote', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_FieldNote'):
                self.add_FieldNote(obj_.value)
            elif hasattr(self, 'set_FieldNote'):
                self.set_FieldNote(obj_.value)
        elif nodeName_ == 'PurposeOfSurvey':
            obj_ = PurposeOfSurvey.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'PurposeOfSurvey', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_PurposeOfSurvey'):
                self.add_PurposeOfSurvey(obj_.value)
            elif hasattr(self, 'set_PurposeOfSurvey'):
                self.set_PurposeOfSurvey(obj_.value)
        elif nodeName_ == 'HeadOfPower':
            obj_ = HeadOfPower.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                                    MixedContainer.TypeNone, 'HeadOfPower', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_HeadOfPower'):
                self.add_HeadOfPower(obj_.value)
            elif hasattr(self, 'set_HeadOfPower'):
                self.set_HeadOfPower(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)


# end class SurveyHeader


class HeadOfPower(GeneratedsSuper):
    """The legislation under which the survey was performed"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, name=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, HeadOfPower)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if HeadOfPower.subclass:
            return HeadOfPower.subclass(*args_, **kwargs_)
        else:
            return HeadOfPower(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def validate_headOfPowerType(self, value):
        # Validate type enum:headOfPowerType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Subdivision Act 1988', 'Owners Corporation Act 2006', 'Transfer of Land Act 1958']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on headOfPowerType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='HeadOfPower',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('HeadOfPower')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'HeadOfPower':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='HeadOfPower')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='HeadOfPower',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='HeadOfPower'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='HeadOfPower',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
            self.validate_headOfPowerType(self.name)  # validate type headOfPowerType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class HeadOfPower


class AdministrativeArea(GeneratedsSuper):
    """Details of an administrative boundary related to a survey"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, adminAreaType=None, adminAreaName=None, adminAreaCode=None, pclRef=None, gds_collector_=None,
                 **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.adminAreaType = _cast(None, adminAreaType)
        self.adminAreaType_nsprefix_ = None
        self.adminAreaName = _cast(None, adminAreaName)
        self.adminAreaName_nsprefix_ = None
        self.adminAreaCode = _cast(None, adminAreaCode)
        self.adminAreaCode_nsprefix_ = None
        self.pclRef = _cast(None, pclRef)
        self.pclRef_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AdministrativeArea)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AdministrativeArea.subclass:
            return AdministrativeArea.subclass(*args_, **kwargs_)
        else:
            return AdministrativeArea(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_adminAreaType(self):
        return self.adminAreaType

    def set_adminAreaType(self, adminAreaType):
        self.adminAreaType = adminAreaType

    def get_adminAreaName(self):
        return self.adminAreaName

    def set_adminAreaName(self, adminAreaName):
        self.adminAreaName = adminAreaName

    def get_adminAreaCode(self):
        return self.adminAreaCode

    def set_adminAreaCode(self, adminAreaCode):
        self.adminAreaCode = adminAreaCode

    def get_pclRef(self):
        return self.pclRef

    def set_pclRef(self, pclRef):
        self.pclRef = pclRef

    def validate_adminAreaTypeType(self, value):
        # Validate type enum:adminAreaTypeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['LGA', 'Locality', 'County', 'Parish', 'Township']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on adminAreaTypeType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_nonBlankString(self, value):
        # Validate type nonBlankString, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nonBlankString' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_parcelNameRefs(self, value):
        # Validate type parcelNameRefs, a restriction on xs:string.
        pass

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='AdministrativeArea',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AdministrativeArea')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AdministrativeArea':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AdministrativeArea')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AdministrativeArea',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AdministrativeArea'):
        if self.adminAreaType is not None and 'adminAreaType' not in already_processed:
            already_processed.add('adminAreaType')
            outfile.write(' adminAreaType=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.adminAreaType), input_name='adminAreaType')),))
        if self.adminAreaName is not None and 'adminAreaName' not in already_processed:
            already_processed.add('adminAreaName')
            outfile.write(' adminAreaName=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.adminAreaName), input_name='adminAreaName')),))
        if self.adminAreaCode is not None and 'adminAreaCode' not in already_processed:
            already_processed.add('adminAreaCode')
            outfile.write(' adminAreaCode=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.adminAreaCode), input_name='adminAreaCode')),))
        if self.pclRef is not None and 'pclRef' not in already_processed:
            already_processed.add('pclRef')
            outfile.write(' pclRef=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.pclRef), input_name='pclRef')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"',
                       name_='AdministrativeArea', fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('adminAreaType', node)
        if value is not None and 'adminAreaType' not in already_processed:
            already_processed.add('adminAreaType')
            self.adminAreaType = value
            self.validate_adminAreaTypeType(self.adminAreaType)  # validate type adminAreaTypeType
        value = find_attr_value_('adminAreaName', node)
        if value is not None and 'adminAreaName' not in already_processed:
            already_processed.add('adminAreaName')
            self.adminAreaName = value
            self.validate_nonBlankString(self.adminAreaName)  # validate type nonBlankString
        value = find_attr_value_('adminAreaCode', node)
        if value is not None and 'adminAreaCode' not in already_processed:
            already_processed.add('adminAreaCode')
            self.adminAreaCode = value
            self.validate_nonBlankString(self.adminAreaCode)  # validate type nonBlankString
        value = find_attr_value_('pclRef', node)
        if value is not None and 'pclRef' not in already_processed:
            already_processed.add('pclRef')
            self.pclRef = value
            self.validate_parcelNameRefs(self.pclRef)  # validate type parcelNameRefs

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class AdministrativeArea


class AdministrativeDate(GeneratedsSuper):
    """Stores individual administrative dates that may vary from jurisdiction
    to jurisdiction."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, adminDateType=None, adminDate=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.adminDateType = _cast(None, adminDateType)
        self.adminDateType_nsprefix_ = None
        if isinstance(adminDate, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(adminDate, '%Y-%m-%d').date()
        else:
            initvalue_ = adminDate
        self.adminDate = initvalue_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AdministrativeDate)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AdministrativeDate.subclass:
            return AdministrativeDate.subclass(*args_, **kwargs_)
        else:
            return AdministrativeDate(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_adminDateType(self):
        return self.adminDateType

    def set_adminDateType(self, adminDateType):
        self.adminDateType = adminDateType

    def get_adminDate(self):
        return self.adminDate

    def set_adminDate(self, adminDate):
        self.adminDate = adminDate

    def validate_adminDateTypeType(self, value):
        # Validate type enum:adminDateTypeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Date of Survey', 'Date of Registration']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on adminDateTypeType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='AdministrativeDate',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AdministrativeDate')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AdministrativeDate':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        if self.eplan_value is False or (self.eplan_value is True and self.adminDateType != 'Date of Registration'):
            showIndent(outfile, level, pretty_print)
            outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
            already_processed = set()
            self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AdministrativeDate')
            if self.hasContent_():
                outfile.write('>%s' % (eol_,))
                self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AdministrativeDate',
                                    pretty_print=pretty_print)
                outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
            else:
                outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AdministrativeDate'):
        if self.adminDateType is not None and 'adminDateType' not in already_processed:
            already_processed.add('adminDateType')
            outfile.write(' adminDateType=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.adminDateType), input_name='adminDateType')),))
        if self.adminDate is not None and 'adminDate' not in already_processed:
            already_processed.add('adminDate')
            outfile.write(' adminDate="%s"' % self.gds_format_date(self.adminDate, input_name='adminDate'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"',
                       name_='AdministrativeDate', fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('adminDateType', node)
        if value is not None and 'adminDateType' not in already_processed:
            already_processed.add('adminDateType')
            self.adminDateType = value
            self.validate_adminDateTypeType(self.adminDateType)  # validate type adminDateTypeType
        value = find_attr_value_('adminDate', node)
        if value is not None and 'adminDate' not in already_processed:
            already_processed.add('adminDate')
            try:
                self.adminDate = self.gds_parse_date(value)
            except ValueError as exp:
                raise ValueError('Bad date attribute (adminDate): %s' % exp)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class AdministrativeDate


class Annotation(GeneratedsSuper):
    """Descriptive string describing an action on survey"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, type_=None, name=None, desc=None, pclRef=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.type_ = _cast(None, type_)
        self.type__nsprefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.desc = _cast(None, desc)
        self.desc_nsprefix_ = None
        self.pclRef = _cast(None, pclRef)
        self.pclRef_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Annotation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Annotation.subclass:
            return Annotation.subclass(*args_, **kwargs_)
        else:
            return Annotation(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_desc(self):
        return self.desc

    def set_desc(self, desc):
        self.desc = desc

    def get_pclRef(self):
        return self.pclRef

    def set_pclRef(self, pclRef):
        self.pclRef = pclRef

    def validate_annotationType(self, value):
        # Validate type enum:annotationType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Section 35 - See Recording of Vesting Table Attached', 'Section 35 Compulsory',
                            'Section 35 Agreement', 'Planning Permit', 'Report on Datum',
                            'Instrument and Calibration Details', 'Crown Section', 'Crown Allotment', 'Crown Portion',
                            'Other Crown Description', 'Parcel with Area by Deduction', 'Restriction Expiry Date',
                            'General Plan Notation', 'Abstract of Field Records Notation', "Surveyor's Report Notation",
                            'Title Closure Justification', 'General Easement Notation', 'Easement Qualification',
                            'Implied Easement Notation', 'Easement Purpose', 'Easement Origin', 'Easement Beneficiary',
                            'Easement Width', 'Supply of Supplementary Field Record Notation',
                            'Building Boundary Notation', 'Owners Corporation Notation', 'Additional Purpose of Plan',
                            'Section 12(2) of the Subdivision Act 1988 applies vide this plan',
                            'Section 12(2) of the Subdivision Act 1988 does not apply vide this plan',
                            'Purpose Of The Owners Corporation',
                            'The Basis For Allocation Of Lot Entitlement And Liability',
                            'Details Of The Limitations Of The Owners Corporation',
                            'Functions Or Obligations Referred By The Limited Owners Corporation',
                            'Functions Or Obligations Referred To The Unlimited Owners Corporation', 'Purpose of Plan',
                            'Grounds for Removal', 'Grounds for Variation', 'Grounds for Vesting', 'Future Plan Number',
                            'Prior Survey', 'Balance Of Existing OC Entitlement', 'Balance Of Existing OC Liability',
                            'Additional Plan Reference', 'Adjustment Exclusion']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on annotationType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_nonBlankString(self, value):
        # Validate type nonBlankString, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nonBlankString' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_parcelNameRefs(self, value):
        # Validate type parcelNameRefs, a restriction on xs:string.
        pass

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='Annotation',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Annotation')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Annotation':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Annotation')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Annotation',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Annotation'):
        if self.eplan_value is True:
            if self.type_ in ['Additional Plan Reference', 'Adjustment Exclusion', 'Rural Adjustment', 'Partial Survey',
                              'Misclose Check Exclusion']:
                self.desc = self.type_ + ': ' + self.desc
                self.type_ = 'General Plan Notation'
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            f = self.gds_encode(self.gds_format_string(quote_attrib(self.type_), input_name='type'))
            outfile.write(
                ' type=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.type_), input_name='type')),))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            outfile.write(
                ' desc=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.desc), input_name='desc')),))
        if self.pclRef is not None and 'pclRef' not in already_processed:
            already_processed.add('pclRef')
            outfile.write(' pclRef=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.pclRef), input_name='pclRef')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='Annotation',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)

        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
            self.validate_annotationType(self.type_)  # validate type annotationType
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            self.desc = value
            self.validate_nonBlankString(self.desc)  # validate type nonBlankString
        value = find_attr_value_('pclRef', node)
        if value is not None and 'pclRef' not in already_processed:
            already_processed.add('pclRef')
            self.pclRef = value
            self.validate_parcelNameRefs(self.pclRef)  # validate type parcelNameRefs

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class Annotation


class PurposeOfSurvey(GeneratedsSuper):
    """The purpose of the survey"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, name=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PurposeOfSurvey)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PurposeOfSurvey.subclass:
            return PurposeOfSurvey.subclass(*args_, **kwargs_)
        else:
            return PurposeOfSurvey(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def validate_purpSurvType(self, value):
        # Validate type enum:purpSurvType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Section 6(1)(K)', 'Section 22-Plan of Subdivision', 'Section 22-Plan of Consolidation',
                            'Section 23-Creation of Easement', 'Section 23-Removal of Easement',
                            'Section 23-Variation of Easement', 'Section 23-Creation and Removal of Easement',
                            'Section 23-Creation and Variation of Easement',
                            'Section 23-Removal and Variation of Easement',
                            'Section 23-Creation and Removal and Variation of Easement',
                            'Section 23-Variation of Condition in Crown Grant',
                            'Section 23-Removal of Condition in Crown Grant', 'Section 23-Creation of Restriction',
                            'Section 23-Removal of Restriction', 'Section 23-Variation of Restriction',
                            'Section 24a-Vesting of a Reserve',
                            'Section 24a-Removal of a Reserve (Plan of Subdivision)',
                            'Section 24a-Removal of a Reserve (Plan of Consolidation)',
                            'Section 24a-Removal and Vesting of a Reserve (Plan of Subdivision)',
                            'Section 24a-Removal and Vesting of a Reserve (Plan of Consolidation)', 'Section 26',
                            'Section 32-Plan to alter land affected by an owners corporation (Plan of Subdivision)',
                            'Section 32-Plan to alter land affected by an owners corporation (Registered Plan)',
                            'Section 32-Plan to alter land affected by an owners corporation (Strata Plan)',
                            'Section 32-Plan to alter land affected by an owners corporation (Cluster Subdivision)',
                            'Section 32a-Plan of Subdivision of land if an owners corporation is affected',
                            'Section 32a-Plan of Consolidation of land if an owners corporation is affected',
                            'Section 32b-Plan to create an owners corporation (Existing Plan)',
                            'Section 32b-Plan to create an owners corporation (New Plan)',
                            'Section 35-Acquisition of land by acquiring authority',
                            'Section 35-Acquisition of land if an owners corporation is affected (Plan of Subdivision)',
                            'Section 35-Acquisition of land if an owners corporation is affected (Registered Plan)',
                            'Section 35-Acquisition of land if an owners corporation is affected (Strata Plan)',
                            'Section 35-Acquisition of land if an owners corporation is affected (Cluster Subdivision)',
                            'Section 35(8)-Subdivision of land vested or registered in authority',
                            'Section 35(8)-Consolidation of land vested or registered in authority',
                            'Section 37-Plan of Subdivision (Staged Plan)',
                            'Section 37-Acquisition of land (Plan of Subdivision (Staged))', 'Section 37(8)']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on purpSurvType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='PurposeOfSurvey',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PurposeOfSurvey')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PurposeOfSurvey':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PurposeOfSurvey')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PurposeOfSurvey',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PurposeOfSurvey'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='PurposeOfSurvey',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
            self.validate_purpSurvType(self.name)  # validate type purpSurvType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class PurposeOfSurvey


class Amendment(GeneratedsSuper):
    """Information about dealings to link a survey document and titling
    system"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, dealingNumber=None, amendmentDate=None, comments=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.dealingNumber = _cast(None, dealingNumber)
        self.dealingNumber_nsprefix_ = None
        if isinstance(amendmentDate, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(amendmentDate, '%Y-%m-%d').date()
        else:
            initvalue_ = amendmentDate
        self.amendmentDate = initvalue_
        self.comments = _cast(None, comments)
        self.comments_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Amendment)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Amendment.subclass:
            return Amendment.subclass(*args_, **kwargs_)
        else:
            return Amendment(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_dealingNumber(self):
        return self.dealingNumber

    def set_dealingNumber(self, dealingNumber):
        self.dealingNumber = dealingNumber

    def get_amendmentDate(self):
        return self.amendmentDate

    def set_amendmentDate(self, amendmentDate):
        self.amendmentDate = amendmentDate

    def get_comments(self):
        return self.comments

    def set_comments(self, comments):
        self.comments = comments

    def validate_nonBlankString(self, value):
        # Validate type nonBlankString, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nonBlankString' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='Amendment',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Amendment')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Amendment':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Amendment')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Amendment',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Amendment'):
        if self.dealingNumber is not None and 'dealingNumber' not in already_processed:
            already_processed.add('dealingNumber')
            outfile.write(' dealingNumber=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.dealingNumber), input_name='dealingNumber')),))
        if self.amendmentDate is not None and 'amendmentDate' not in already_processed:
            already_processed.add('amendmentDate')
            outfile.write(' amendmentDate="%s"' % self.gds_format_date(self.amendmentDate, input_name='amendmentDate'))
        if self.comments is not None and 'comments' not in already_processed:
            already_processed.add('comments')
            outfile.write(' comments=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.comments), input_name='comments')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='Amendment',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('dealingNumber', node)
        if value is not None and 'dealingNumber' not in already_processed:
            already_processed.add('dealingNumber')
            self.dealingNumber = value
            self.validate_nonBlankString(self.dealingNumber)  # validate type nonBlankString
        value = find_attr_value_('amendmentDate', node)
        if value is not None and 'amendmentDate' not in already_processed:
            already_processed.add('amendmentDate')
            try:
                self.amendmentDate = self.gds_parse_date(value)
            except ValueError as exp:
                raise ValueError('Bad date attribute (amendmentDate): %s' % exp)
        value = find_attr_value_('comments', node)
        if value is not None and 'comments' not in already_processed:
            already_processed.add('comments')
            self.comments = value
            self.validate_nonBlankString(self.comments)  # validate type nonBlankString

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class Amendment


class Personnel(GeneratedsSuper):
    """Details of persons related to the survey"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, name=None, role=None, regType=None, regNumber=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.role = _cast(None, role)
        self.role_nsprefix_ = None
        self.regType = _cast(None, regType)
        self.regType_nsprefix_ = None
        self.regNumber = _cast(None, regNumber)
        self.regNumber_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Personnel)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Personnel.subclass:
            return Personnel.subclass(*args_, **kwargs_)
        else:
            return Personnel(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_role(self):
        return self.role

    def set_role(self, role):
        self.role = role

    def get_regType(self):
        return self.regType

    def set_regType(self, regType):
        self.regType = regType

    def get_regNumber(self):
        return self.regNumber

    def set_regNumber(self, regNumber):
        self.regNumber = regNumber

    def validate_nonBlankString(self, value):
        # Validate type nonBlankString, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nonBlankString' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_surveyorRoleType(self, value):
        # Validate type enum:surveyorRoleType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Surveyed By']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on surveyorRoleType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_registrationType(self, value):
        # Validate type enum:registrationType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Licensed Cadastral Surveyor']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on registrationType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='Personnel',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Personnel')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Personnel':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Personnel')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Personnel',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Personnel'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))
        if self.role is not None and 'role' not in already_processed:
            already_processed.add('role')
            outfile.write(
                ' role=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.role), input_name='role')),))
        if self.regType is not None and 'regType' not in already_processed:
            already_processed.add('regType')
            outfile.write(' regType=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.regType), input_name='regType')),))
        if self.regNumber is not None and 'regNumber' not in already_processed:
            already_processed.add('regNumber')
            outfile.write(' regNumber=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.regNumber), input_name='regNumber')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='Personnel',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
            self.validate_nonBlankString(self.name)  # validate type nonBlankString
        value = find_attr_value_('role', node)
        if value is not None and 'role' not in already_processed:
            already_processed.add('role')
            self.role = value
            self.validate_surveyorRoleType(self.role)  # validate type surveyorRoleType
        value = find_attr_value_('regType', node)
        if value is not None and 'regType' not in already_processed:
            already_processed.add('regType')
            self.regType = value
            self.validate_registrationType(self.regType)  # validate type registrationType
        value = find_attr_value_('regNumber', node)
        if value is not None and 'regNumber' not in already_processed:
            already_processed.add('regNumber')
            self.regNumber = value
            self.validate_nonBlankString(self.regNumber)  # validate type nonBlankString

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class Personnel


class FieldNote(GeneratedsSuper):
    """Notes are added as text content between the FieldNote element tags.
    Any valid XML structure may be placed inside this tag."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, FieldNote)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if FieldNote.subclass:
            return FieldNote.subclass(*args_, **kwargs_)
        else:
            return FieldNote(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def hasContent_(self):
        if (
                (1 if type(self.valueOf_) in [int, float] else self.valueOf_) or
                self.content_
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='FieldNote',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('FieldNote')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'FieldNote':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='FieldNote')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='FieldNote'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='FieldNote',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass


# end class FieldNote

# had to add this here as it doesnt exist in the auto build?
class InstrumentPoint(GeneratedsSuper):
    def __init__(self, pntref=None):
        self.pntRef = pntref

    def set_point_ref(self, pntref):
        self.pntRef = pntref


class InstrumentSetup(GeneratedsSuper):
    """An Instrument setup location"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, id=None, stationName=None, instrumentHeight=None, InstrumentPoint=None, gds_collector_=None,
                 **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.stationName = _cast(None, stationName)
        self.stationName_nsprefix_ = None
        self.instrumentHeight = _cast(float, instrumentHeight)
        self.instrumentHeight_nsprefix_ = None

        if InstrumentPoint is None:
            self.InstrumentPoint = []
        else:

            self.InstrumentPoint = InstrumentPoint
        self.InstrumentPoint_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, InstrumentSetup)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InstrumentSetup.subclass:
            return InstrumentSetup.subclass(*args_, **kwargs_)
        else:
            return InstrumentSetup(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_InstrumentPoint(self):
        return self.InstrumentPoint

    def set_InstrumentPoint(self, InstrumentPoint):
        self.InstrumentPoint = InstrumentPoint

    def add_InstrumentPoint(self, value):
        self.InstrumentPoint.append(value)

    def insert_InstrumentPoint_at(self, index, value):
        self.InstrumentPoint.insert(index, value)

    def replace_InstrumentPoint_at(self, index, value):
        self.InstrumentPoint[index] = value

    def get_id(self):
        return self.id

    def set_id(self, id):
        self.id = id

    def get_stationName(self):
        return self.stationName

    def set_stationName(self, stationName):
        self.stationName = stationName

    def get_instrumentHeight(self):
        return self.instrumentHeight

    def set_instrumentHeight(self, instrumentHeight):
        self.instrumentHeight = instrumentHeight

    def validate_instrumentHeightType(self, value):
        # Validate type instrumentHeightType, a restriction on xs:double.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value,
                                                                                                    "lineno": lineno, })
                return False
            value = value
            enumerations = [0.0]
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on instrumentHeightType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.InstrumentPoint
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
               name_='InstrumentSetup', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('InstrumentSetup')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'InstrumentSetup':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='InstrumentSetup')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='InstrumentSetup',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='InstrumentSetup'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')),))
        if self.stationName is not None and 'stationName' not in already_processed:
            already_processed.add('stationName')
            outfile.write(' stationName=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.stationName), input_name='stationName')),))
        if self.instrumentHeight is not None and 'instrumentHeight' not in already_processed:
            already_processed.add('instrumentHeight')
            outfile.write(
                ' instrumentHeight="%s"' % self.gds_format_double(self.instrumentHeight, input_name='instrumentHeight'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
                       name_='InstrumentSetup', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for InstrumentPoint_ in self.InstrumentPoint:
            namespaceprefix_ = self.InstrumentPoint_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.InstrumentPoint_nsprefix_) else ''
            InstrumentPoint_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='InstrumentPoint',
                                    pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('stationName', node)
        if value is not None and 'stationName' not in already_processed:
            already_processed.add('stationName')
            self.stationName = value
        value = find_attr_value_('instrumentHeight', node)
        if value is not None and 'instrumentHeight' not in already_processed:
            already_processed.add('instrumentHeight')
            value = self.gds_parse_double(value, node, 'instrumentHeight')
            self.instrumentHeight = value
            self.validate_instrumentHeightType(self.instrumentHeight)  # validate type instrumentHeightType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'InstrumentPoint':
            class_obj_ = self.get_class_obj_(child_, PntRefPointType)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.InstrumentPoint.append(obj_)
            obj_.original_tagname_ = 'InstrumentPoint'


# end class InstrumentSetup


class ObservationGroup(GeneratedsSuper):
    """Collection of Observation elements"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, id=None, ReducedObservation=None, RedHorizontalPosition=None, ReducedArcObservation=None,
                 RedVerticalObservation=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        if ReducedObservation is None:
            self.ReducedObservation = []
        else:
            self.ReducedObservation = ReducedObservation
        self.ReducedObservation_nsprefix_ = None
        if RedHorizontalPosition is None:
            self.RedHorizontalPosition = []
        else:
            self.RedHorizontalPosition = RedHorizontalPosition
        self.RedHorizontalPosition_nsprefix_ = None
        if ReducedArcObservation is None:
            self.ReducedArcObservation = []
        else:
            self.ReducedArcObservation = ReducedArcObservation
        self.ReducedArcObservation_nsprefix_ = None
        if RedVerticalObservation is None:
            self.RedVerticalObservation = []
        else:
            self.RedVerticalObservation = RedVerticalObservation
        self.RedVerticalObservation_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ObservationGroup)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ObservationGroup.subclass:
            return ObservationGroup.subclass(*args_, **kwargs_)
        else:
            return ObservationGroup(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ReducedObservation(self):
        return self.ReducedObservation

    def set_ReducedObservation(self, ReducedObservation):
        self.ReducedObservation = ReducedObservation

    def add_ReducedObservation(self, value):
        self.ReducedObservation.append(value)

    def insert_ReducedObservation_at(self, index, value):
        self.ReducedObservation.insert(index, value)

    def replace_ReducedObservation_at(self, index, value):
        self.ReducedObservation[index] = value

    def get_RedHorizontalPosition(self):
        return self.RedHorizontalPosition

    def set_RedHorizontalPosition(self, RedHorizontalPosition):
        self.RedHorizontalPosition = RedHorizontalPosition

    def add_RedHorizontalPosition(self, value):
        self.RedHorizontalPosition.append(value)

    def insert_RedHorizontalPosition_at(self, index, value):
        self.RedHorizontalPosition.insert(index, value)

    def replace_RedHorizontalPosition_at(self, index, value):
        self.RedHorizontalPosition[index] = value

    def get_ReducedArcObservation(self):
        return self.ReducedArcObservation

    def set_ReducedArcObservation(self, ReducedArcObservation):
        self.ReducedArcObservation = ReducedArcObservation

    def add_ReducedArcObservation(self, value):
        self.ReducedArcObservation.append(value)

    def insert_ReducedArcObservation_at(self, index, value):
        self.ReducedArcObservation.insert(index, value)

    def replace_ReducedArcObservation_at(self, index, value):
        self.ReducedArcObservation[index] = value

    def get_RedVerticalObservation(self):
        return self.RedVerticalObservation

    def set_RedVerticalObservation(self, RedVerticalObservation):
        self.RedVerticalObservation = RedVerticalObservation

    def add_RedVerticalObservation(self, value):
        self.RedVerticalObservation.append(value)

    def insert_RedVerticalObservation_at(self, index, value):
        self.RedVerticalObservation.insert(index, value)

    def replace_RedVerticalObservation_at(self, index, value):
        self.RedVerticalObservation[index] = value

    def get_id(self):
        return self.id

    def set_id(self, id):
        self.id = id

    def hasContent_(self):
        if (
                self.ReducedObservation or
                self.RedHorizontalPosition or
                self.ReducedArcObservation or
                self.RedVerticalObservation
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
               name_='ObservationGroup', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ObservationGroup')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ObservationGroup':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ObservationGroup')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ObservationGroup',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ObservationGroup'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
                       name_='ObservationGroup', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ReducedObservation_ in self.ReducedObservation:
            namespaceprefix_ = self.ReducedObservation_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ReducedObservation_nsprefix_) else ''
            ReducedObservation_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ReducedObservation',
                                       pretty_print=pretty_print)
        for RedHorizontalPosition_ in self.RedHorizontalPosition:
            namespaceprefix_ = self.RedHorizontalPosition_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.RedHorizontalPosition_nsprefix_) else ''
            RedHorizontalPosition_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                          name_='RedHorizontalPosition', pretty_print=pretty_print)
        for ReducedArcObservation_ in self.ReducedArcObservation:
            namespaceprefix_ = self.ReducedArcObservation_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ReducedArcObservation_nsprefix_) else ''
            ReducedArcObservation_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                          name_='ReducedArcObservation', pretty_print=pretty_print)
        for RedVerticalObservation_ in self.RedVerticalObservation:
            namespaceprefix_ = self.RedVerticalObservation_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.RedVerticalObservation_nsprefix_) else ''
            RedVerticalObservation_.export(outfile, level, namespaceprefix_, namespacedef_='',
                                           name_='RedVerticalObservation', pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ReducedObservation':
            obj_ = ReducedObservation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ReducedObservation.append(obj_)
            obj_.original_tagname_ = 'ReducedObservation'
        elif nodeName_ == 'RedHorizontalPosition':
            obj_ = RedHorizontalPosition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.RedHorizontalPosition.append(obj_)
            obj_.original_tagname_ = 'RedHorizontalPosition'
        elif nodeName_ == 'ReducedArcObservation':
            obj_ = ReducedArcObservation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ReducedArcObservation.append(obj_)
            obj_.original_tagname_ = 'ReducedArcObservation'
        elif nodeName_ == 'RedVerticalObservation':
            obj_ = RedVerticalObservation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.RedVerticalObservation.append(obj_)
            obj_.original_tagname_ = 'RedVerticalObservation'


# end class ObservationGroup


class ReducedObservation(GeneratedsSuper):
    """The reduced value of an observation. Azimuth is in terms of true north
    whereas bearing is the projection north. - maybe this doesn't matter,
    may need to discuss"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, name=None, desc=None, purpose=None, setupID=None, targetSetupID=None, azimuth=None,
                 horizDistance=None, equipmentUsed=None, azimuthAccuracy=None, distanceAccuracy=None,
                 angleAccuracy=None, distanceType=None, azimuthType=None, adoptedAzimuthSurvey=None,
                 adoptedDistanceSurvey=None, azimuthAdoptionFactor=None, distanceAdoptionFactor=None, FieldNote=None,
                 gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.desc = _cast(None, desc)
        self.desc_nsprefix_ = None
        self.purpose = _cast(None, purpose)
        self.purpose_nsprefix_ = None
        self.setupID = _cast(None, setupID)
        self.setupID_nsprefix_ = None
        self.targetSetupID = _cast(None, targetSetupID)
        self.targetSetupID_nsprefix_ = None
        self.azimuth = _cast(float, azimuth)
        self.azimuth_nsprefix_ = None
        self.horizDistance = _cast(float, horizDistance)
        self.horizDistance_nsprefix_ = None
        self.equipmentUsed = _cast(None, equipmentUsed)
        self.equipmentUsed_nsprefix_ = None
        self.azimuthAccuracy = _cast(float, azimuthAccuracy)
        self.azimuthAccuracy_nsprefix_ = None
        self.distanceAccuracy = _cast(float, distanceAccuracy)
        self.distanceAccuracy_nsprefix_ = None
        self.angleAccuracy = _cast(float, angleAccuracy)
        self.angleAccuracy_nsprefix_ = None
        self.distanceType = _cast(None, distanceType)
        self.distanceType_nsprefix_ = None
        self.azimuthType = _cast(None, azimuthType)
        self.azimuthType_nsprefix_ = None
        self.adoptedAzimuthSurvey = _cast(None, adoptedAzimuthSurvey)
        self.adoptedAzimuthSurvey_nsprefix_ = None
        self.adoptedDistanceSurvey = _cast(None, adoptedDistanceSurvey)
        self.adoptedDistanceSurvey_nsprefix_ = None
        self.azimuthAdoptionFactor = _cast(float, azimuthAdoptionFactor)
        self.azimuthAdoptionFactor_nsprefix_ = None
        self.distanceAdoptionFactor = _cast(float, distanceAdoptionFactor)
        self.distanceAdoptionFactor_nsprefix_ = None
        if FieldNote is None:
            self.FieldNote = []
        else:
            self.FieldNote = FieldNote
        self.FieldNote_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ReducedObservation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReducedObservation.subclass:
            return ReducedObservation.subclass(*args_, **kwargs_)
        else:
            return ReducedObservation(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_FieldNote(self):
        return self.FieldNote

    def set_FieldNote(self, FieldNote):
        self.FieldNote = FieldNote

    def add_FieldNote(self, value):
        self.FieldNote.append(value)

    def insert_FieldNote_at(self, index, value):
        self.FieldNote.insert(index, value)

    def replace_FieldNote_at(self, index, value):
        self.FieldNote[index] = value

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_desc(self):
        return self.desc

    def set_desc(self, desc):
        self.desc = desc

    def get_purpose(self):
        return self.purpose

    def set_purpose(self, purpose):
        self.purpose = purpose

    def get_setupID(self):
        return self.setupID

    def set_setupID(self, setupID):
        self.setupID = setupID

    def get_targetSetupID(self):
        return self.targetSetupID

    def set_targetSetupID(self, targetSetupID):
        self.targetSetupID = targetSetupID

    def get_azimuth(self):
        return self.azimuth

    def set_azimuth(self, azimuth):
        self.azimuth = azimuth

    def get_horizDistance(self):
        return self.horizDistance

    def set_horizDistance(self, horizDistance):
        self.horizDistance = horizDistance

    def get_equipmentUsed(self):
        return self.equipmentUsed

    def set_equipmentUsed(self, equipmentUsed):
        self.equipmentUsed = equipmentUsed

    def get_azimuthAccuracy(self):
        return self.azimuthAccuracy

    def set_azimuthAccuracy(self, azimuthAccuracy):
        self.azimuthAccuracy = azimuthAccuracy

    def get_distanceAccuracy(self):
        return self.distanceAccuracy

    def set_distanceAccuracy(self, distanceAccuracy):
        self.distanceAccuracy = distanceAccuracy

    def get_angleAccuracy(self):
        return self.angleAccuracy

    def set_angleAccuracy(self, angleAccuracy):
        self.angleAccuracy = angleAccuracy

    def get_distanceType(self):
        return self.distanceType

    def set_distanceType(self, distanceType):
        self.distanceType = distanceType

    def get_azimuthType(self):
        return self.azimuthType

    def set_azimuthType(self, azimuthType):
        self.azimuthType = azimuthType

    def get_adoptedAzimuthSurvey(self):
        return self.adoptedAzimuthSurvey

    def set_adoptedAzimuthSurvey(self, adoptedAzimuthSurvey):
        self.adoptedAzimuthSurvey = adoptedAzimuthSurvey

    def get_adoptedDistanceSurvey(self):
        return self.adoptedDistanceSurvey

    def set_adoptedDistanceSurvey(self, adoptedDistanceSurvey):
        self.adoptedDistanceSurvey = adoptedDistanceSurvey

    def get_azimuthAdoptionFactor(self):
        return self.azimuthAdoptionFactor

    def set_azimuthAdoptionFactor(self, azimuthAdoptionFactor):
        self.azimuthAdoptionFactor = azimuthAdoptionFactor

    def get_distanceAdoptionFactor(self):
        return self.distanceAdoptionFactor

    def set_distanceAdoptionFactor(self, distanceAdoptionFactor):
        self.distanceAdoptionFactor = distanceAdoptionFactor

    def validate_nonBlankString(self, value):
        # Validate type nonBlankString, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nonBlankString' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_purposeType(self, value):
        # Validate type purposeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['normal', 'traverse', 'sideshot', 'topo']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on purposeType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_direction(self, value):
        # Validate type direction, a restriction on xs:double.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value,
                                                                                                    "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_direction_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (
                encode_str_2_3(value), self.validate_direction_patterns_,))

    validate_direction_patterns_ = [['^(([0-2]?[0-9]?[0-9]|[3][0-5][0-9]).([0-5][0-9])([0-5][0-9]))$']]

    def validate_distanceRestriction(self, value):
        # Validate type distanceRestriction, a restriction on xs:double.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value,
                                                                                                    "lineno": lineno, })
                return False
            if value <= 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minExclusive restriction on distanceRestriction' % {
                        "value": value, "lineno": lineno})
                result = False

    def validate_equipmentType(self, value):
        # Validate type enum:equipmentType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['GNSS (inc. GPS)', 'Level', 'Tape', 'Theodolite and EDM', 'Theodolite and Steel Band',
                            'Total Station']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on equipmentType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_distObservationType(self, value):
        # Validate type enum:distObservationType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Adopt Dimension', 'Computed', 'Derived', 'Measured', 'About', 'ProvidedbyDELWP',
                            'Estimated', 'Ignored']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on distObservationType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_observationType(self, value):
        # Validate type enum:observationType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Adopt Dimension', 'Computed', 'Derived', 'Measured', 'About', 'Assumed', 'ProvidedbyDELWP',
                            'Estimated', 'Ignored']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on observationType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.FieldNote
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
               name_='ReducedObservation', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ReducedObservation')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ReducedObservation':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        if self.eplan_value is True:
            already_processed.add('angleAccuracy')
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ReducedObservation')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ReducedObservation',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ReducedObservation'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            outfile.write(
                ' desc=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.desc), input_name='desc')),))
        if self.purpose is not None and 'purpose' not in already_processed:
            already_processed.add('purpose')
            outfile.write(' purpose=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.purpose), input_name='purpose')),))
        if self.setupID is not None and 'setupID' not in already_processed:
            already_processed.add('setupID')
            outfile.write(' setupID=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.setupID), input_name='setupID')),))
        if self.targetSetupID is not None and 'targetSetupID' not in already_processed:
            already_processed.add('targetSetupID')
            outfile.write(' targetSetupID=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.targetSetupID), input_name='targetSetupID')),))
        if self.azimuth is not None and 'azimuth' not in already_processed:
            already_processed.add('azimuth')
            outfile.write(' azimuth="%s"' % self.gds_format_double_round(self.azimuth, rounder=4, input_name='azimuth'))
        if self.horizDistance is not None and 'horizDistance' not in already_processed:
            already_processed.add('horizDistance')
            outfile.write(
                ' horizDistance="%s"' % self.gds_format_double_round(self.horizDistance, input_name='horizDistance'))
        if self.equipmentUsed is not None and 'equipmentUsed' not in already_processed:
            already_processed.add('equipmentUsed')
            outfile.write(' equipmentUsed=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.equipmentUsed), input_name='equipmentUsed')),))
        if self.azimuthAccuracy is not None and 'azimuthAccuracy' not in already_processed:
            already_processed.add('azimuthAccuracy')
            outfile.write(
                ' azimuthAccuracy="%s"' % self.gds_format_double(self.azimuthAccuracy, input_name='azimuthAccuracy'))
        if self.distanceAccuracy is not None and 'distanceAccuracy' not in already_processed:
            already_processed.add('distanceAccuracy')
            outfile.write(
                ' distanceAccuracy="%s"' % self.gds_format_double(self.distanceAccuracy, input_name='distanceAccuracy'))
        if self.angleAccuracy is not None and 'angleAccuracy' not in already_processed:
            already_processed.add('angleAccuracy')
            outfile.write(
                ' angleAccuracy="%s"' % self.gds_format_double(self.angleAccuracy, input_name='angleAccuracy'))
        if self.distanceType is not None and 'distanceType' not in already_processed:
            already_processed.add('distanceType')
            outfile.write(' distanceType=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.distanceType), input_name='distanceType')),))
        if self.azimuthType is not None and 'azimuthType' not in already_processed:
            already_processed.add('azimuthType')
            outfile.write(' azimuthType=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.azimuthType), input_name='azimuthType')),))
        if self.adoptedAzimuthSurvey is not None and 'adoptedAzimuthSurvey' not in already_processed:
            already_processed.add('adoptedAzimuthSurvey')
            outfile.write(' adoptedAzimuthSurvey=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.adoptedAzimuthSurvey), input_name='adoptedAzimuthSurvey')),))
        if self.adoptedDistanceSurvey is not None and 'adoptedDistanceSurvey' not in already_processed:
            already_processed.add('adoptedDistanceSurvey')
            outfile.write(' adoptedDistanceSurvey=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.adoptedDistanceSurvey), input_name='adoptedDistanceSurvey')),))
        if self.azimuthAdoptionFactor is not None and 'azimuthAdoptionFactor' not in already_processed:
            already_processed.add('azimuthAdoptionFactor')
            outfile.write(' azimuthAdoptionFactor="%s"' % self.gds_format_double(self.azimuthAdoptionFactor,
                                                                                 input_name='azimuthAdoptionFactor'))
        if self.distanceAdoptionFactor is not None and 'distanceAdoptionFactor' not in already_processed:
            already_processed.add('distanceAdoptionFactor')
            outfile.write(' distanceAdoptionFactor="%s"' % self.gds_format_double(self.distanceAdoptionFactor,
                                                                                  input_name='distanceAdoptionFactor'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
                       name_='ReducedObservation', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for FieldNote_ in self.FieldNote:
            namespaceprefix_ = self.FieldNote_nsprefix_ + ':' if (UseCapturedNS_ and self.FieldNote_nsprefix_) else ''
            FieldNote_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='FieldNote',
                              pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            self.desc = value
            self.validate_nonBlankString(self.desc)  # validate type nonBlankString
        value = find_attr_value_('purpose', node)
        if value is not None and 'purpose' not in already_processed:
            already_processed.add('purpose')
            self.purpose = value
            self.validate_purposeType(self.purpose)  # validate type purposeType
        value = find_attr_value_('setupID', node)
        if value is not None and 'setupID' not in already_processed:
            already_processed.add('setupID')
            self.setupID = value
        value = find_attr_value_('targetSetupID', node)
        if value is not None and 'targetSetupID' not in already_processed:
            already_processed.add('targetSetupID')
            self.targetSetupID = value
        value = find_attr_value_('azimuth', node)
        if value is not None and 'azimuth' not in already_processed:
            already_processed.add('azimuth')
            value = self.gds_parse_double(value, node, 'azimuth')
            self.azimuth = value
            self.validate_direction(self.azimuth)  # validate type direction
        value = find_attr_value_('horizDistance', node)
        if value is not None and 'horizDistance' not in already_processed:
            already_processed.add('horizDistance')
            value = self.gds_parse_double(value, node, 'horizDistance')
            self.horizDistance = value
            self.validate_distanceRestriction(self.horizDistance)  # validate type distanceRestriction
        value = find_attr_value_('equipmentUsed', node)
        if value is not None and 'equipmentUsed' not in already_processed:
            already_processed.add('equipmentUsed')
            self.equipmentUsed = value
            self.validate_equipmentType(self.equipmentUsed)  # validate type equipmentType
        value = find_attr_value_('azimuthAccuracy', node)
        if value is not None and 'azimuthAccuracy' not in already_processed:
            already_processed.add('azimuthAccuracy')
            value = self.gds_parse_double(value, node, 'azimuthAccuracy')
            self.azimuthAccuracy = value
        value = find_attr_value_('distanceAccuracy', node)
        if value is not None and 'distanceAccuracy' not in already_processed:
            already_processed.add('distanceAccuracy')
            value = self.gds_parse_double(value, node, 'distanceAccuracy')
            self.distanceAccuracy = value
        value = find_attr_value_('angleAccuracy', node)
        if value is not None and 'angleAccuracy' not in already_processed:
            already_processed.add('angleAccuracy')
            value = self.gds_parse_double(value, node, 'angleAccuracy')
            self.angleAccuracy = value
        value = find_attr_value_('distanceType', node)
        if value is not None and 'distanceType' not in already_processed:
            already_processed.add('distanceType')
            self.distanceType = value
            self.validate_distObservationType(self.distanceType)  # validate type distObservationType
        value = find_attr_value_('azimuthType', node)
        if value is not None and 'azimuthType' not in already_processed:
            already_processed.add('azimuthType')
            self.azimuthType = value
            self.validate_observationType(self.azimuthType)  # validate type observationType
        value = find_attr_value_('adoptedAzimuthSurvey', node)
        if value is not None and 'adoptedAzimuthSurvey' not in already_processed:
            already_processed.add('adoptedAzimuthSurvey')
            self.adoptedAzimuthSurvey = value
            self.validate_nonBlankString(self.adoptedAzimuthSurvey)  # validate type nonBlankString
        value = find_attr_value_('adoptedDistanceSurvey', node)
        if value is not None and 'adoptedDistanceSurvey' not in already_processed:
            already_processed.add('adoptedDistanceSurvey')
            self.adoptedDistanceSurvey = value
            self.validate_nonBlankString(self.adoptedDistanceSurvey)  # validate type nonBlankString
        value = find_attr_value_('azimuthAdoptionFactor', node)
        if value is not None and 'azimuthAdoptionFactor' not in already_processed:
            already_processed.add('azimuthAdoptionFactor')
            value = self.gds_parse_double(value, node, 'azimuthAdoptionFactor')
            self.azimuthAdoptionFactor = value
        value = find_attr_value_('distanceAdoptionFactor', node)
        if value is not None and 'distanceAdoptionFactor' not in already_processed:
            already_processed.add('distanceAdoptionFactor')
            value = self.gds_parse_double(value, node, 'distanceAdoptionFactor')
            self.distanceAdoptionFactor = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'FieldNote':
            obj_ = FieldNote.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.FieldNote.append(obj_)
            obj_.original_tagname_ = 'FieldNote'


# end class ReducedObservation


class ReducedArcObservation(GeneratedsSuper):
    """Measurement information for an arc. A ReducedArcObservation has very
    different information to a Curve element."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, name=None, desc=None, purpose=None, setupID=None, targetSetupID=None, chordAzimuth=None,
                 radius=None, length=None, rot=None, equipmentUsed=None, arcAzimuthAccuracy=None,
                 arcLengthAccuracy=None, arcAngleAccuracy=None, arcType=None, adoptedSurvey=None,
                 azimuthAdoptionFactor=None, lengthAdoptionFactor=None, FieldNote=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.desc = _cast(None, desc)
        self.desc_nsprefix_ = None
        self.purpose = _cast(None, purpose)
        self.purpose_nsprefix_ = None
        self.setupID = _cast(None, setupID)
        self.setupID_nsprefix_ = None
        self.targetSetupID = _cast(None, targetSetupID)
        self.targetSetupID_nsprefix_ = None
        self.chordAzimuth = _cast(float, chordAzimuth)
        self.chordAzimuth_nsprefix_ = None
        self.radius = _cast(float, radius)
        self.radius_nsprefix_ = None
        self.length = _cast(float, length)
        self.length_nsprefix_ = None
        self.rot = _cast(None, rot)
        self.rot_nsprefix_ = None
        self.equipmentUsed = _cast(None, equipmentUsed)
        self.equipmentUsed_nsprefix_ = None
        self.arcAzimuthAccuracy = _cast(float, arcAzimuthAccuracy)
        self.arcAzimuthAccuracy_nsprefix_ = None
        self.arcLengthAccuracy = _cast(float, arcLengthAccuracy)
        self.arcLengthAccuracy_nsprefix_ = None
        self.arcAngleAccuracy = _cast(float, arcAngleAccuracy)
        self.arcAngleAccuracy_nsprefix_ = None
        self.arcType = _cast(None, arcType)
        self.arcType_nsprefix_ = None
        self.adoptedSurvey = _cast(None, adoptedSurvey)
        self.adoptedSurvey_nsprefix_ = None
        self.azimuthAdoptionFactor = _cast(float, azimuthAdoptionFactor)
        self.azimuthAdoptionFactor_nsprefix_ = None
        self.lengthAdoptionFactor = _cast(float, lengthAdoptionFactor)
        self.lengthAdoptionFactor_nsprefix_ = None
        if FieldNote is None:
            self.FieldNote = []
        else:
            self.FieldNote = FieldNote
        self.FieldNote_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ReducedArcObservation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReducedArcObservation.subclass:
            return ReducedArcObservation.subclass(*args_, **kwargs_)
        else:
            return ReducedArcObservation(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_FieldNote(self):
        return self.FieldNote

    def set_FieldNote(self, FieldNote):
        self.FieldNote = FieldNote

    def add_FieldNote(self, value):
        self.FieldNote.append(value)

    def insert_FieldNote_at(self, index, value):
        self.FieldNote.insert(index, value)

    def replace_FieldNote_at(self, index, value):
        self.FieldNote[index] = value

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_desc(self):
        return self.desc

    def set_desc(self, desc):
        self.desc = desc

    def get_purpose(self):
        return self.purpose

    def set_purpose(self, purpose):
        self.purpose = purpose

    def get_setupID(self):
        return self.setupID

    def set_setupID(self, setupID):
        self.setupID = setupID

    def get_targetSetupID(self):
        return self.targetSetupID

    def set_targetSetupID(self, targetSetupID):
        self.targetSetupID = targetSetupID

    def get_chordAzimuth(self):
        return self.chordAzimuth

    def set_chordAzimuth(self, chordAzimuth):
        self.chordAzimuth = chordAzimuth

    def get_radius(self):
        return self.radius

    def set_radius(self, radius):
        self.radius = radius

    def get_length(self):
        return self.length

    def set_length(self, length):
        self.length = length

    def get_rot(self):
        return self.rot

    def set_rot(self, rot):
        self.rot = rot

    def get_equipmentUsed(self):
        return self.equipmentUsed

    def set_equipmentUsed(self, equipmentUsed):
        self.equipmentUsed = equipmentUsed

    def get_arcAzimuthAccuracy(self):
        return self.arcAzimuthAccuracy

    def set_arcAzimuthAccuracy(self, arcAzimuthAccuracy):
        self.arcAzimuthAccuracy = arcAzimuthAccuracy

    def get_arcLengthAccuracy(self):
        return self.arcLengthAccuracy

    def set_arcLengthAccuracy(self, arcLengthAccuracy):
        self.arcLengthAccuracy = arcLengthAccuracy

    def get_arcAngleAccuracy(self):
        return self.arcAngleAccuracy

    def set_arcAngleAccuracy(self, arcAngleAccuracy):
        self.arcAngleAccuracy = arcAngleAccuracy

    def get_arcType(self):
        return self.arcType

    def set_arcType(self, arcType):
        self.arcType = arcType

    def get_adoptedSurvey(self):
        return self.adoptedSurvey

    def set_adoptedSurvey(self, adoptedSurvey):
        self.adoptedSurvey = adoptedSurvey

    def get_azimuthAdoptionFactor(self):
        return self.azimuthAdoptionFactor

    def set_azimuthAdoptionFactor(self, azimuthAdoptionFactor):
        self.azimuthAdoptionFactor = azimuthAdoptionFactor

    def get_lengthAdoptionFactor(self):
        return self.lengthAdoptionFactor

    def set_lengthAdoptionFactor(self, lengthAdoptionFactor):
        self.lengthAdoptionFactor = lengthAdoptionFactor

    def validate_purposeType(self, value):
        # Validate type purposeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['normal', 'traverse', 'sideshot', 'topo']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on purposeType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_direction(self, value):
        # Validate type direction, a restriction on xs:double.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value,
                                                                                                    "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_direction_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (
                encode_str_2_3(value), self.validate_direction_patterns_,))

    validate_direction_patterns_ = [['^(([0-2]?[0-9]?[0-9]|[3][0-5][0-9]).([0-5][0-9])([0-5][0-9]))$']]

    def validate_distanceRestriction(self, value):
        # Validate type distanceRestriction, a restriction on xs:double.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value,
                                                                                                    "lineno": lineno, })
                return False
            if value <= 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minExclusive restriction on distanceRestriction' % {
                        "value": value, "lineno": lineno})
                result = False

    def validate_clockwise(self, value):
        # Validate type clockwise, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['cw', 'ccw']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on clockwise' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_equipmentType(self, value):
        # Validate type enum:equipmentType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['GNSS (inc. GPS)', 'Level', 'Tape', 'Theodolite and EDM', 'Theodolite and Steel Band',
                            'Total Station']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on equipmentType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_observationType(self, value):
        # Validate type enum:observationType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Adopt Dimension', 'Computed', 'Derived', 'Measured', 'About', 'Assumed', 'ProvidedbyDELWP',
                            'Estimated', 'Ignored']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on observationType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_nonBlankString(self, value):
        # Validate type nonBlankString, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nonBlankString' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.FieldNote
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
               name_='ReducedArcObservation', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ReducedArcObservation')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ReducedArcObservation':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        if self.eplan_value is True:
            already_processed.add('arcAngleAccuracy')
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ReducedArcObservation')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ReducedArcObservation',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ReducedArcObservation'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            outfile.write(
                ' desc=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.desc), input_name='desc')),))
        if self.purpose is not None and 'purpose' not in already_processed:
            already_processed.add('purpose')
            outfile.write(' purpose=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.purpose), input_name='purpose')),))
        if self.setupID is not None and 'setupID' not in already_processed:
            already_processed.add('setupID')
            outfile.write(' setupID=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.setupID), input_name='setupID')),))
        if self.targetSetupID is not None and 'targetSetupID' not in already_processed:
            already_processed.add('targetSetupID')
            outfile.write(' targetSetupID=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.targetSetupID), input_name='targetSetupID')),))
        if self.chordAzimuth is not None and 'chordAzimuth' not in already_processed:
            already_processed.add('chordAzimuth')
            outfile.write(' chordAzimuth="%s"' % self.gds_format_double(self.chordAzimuth, input_name='chordAzimuth'))
        if self.radius is not None and 'radius' not in already_processed:
            already_processed.add('radius')
            outfile.write(' radius="%s"' % self.gds_format_double(self.radius, input_name='radius'))
        if self.length is not None and 'length' not in already_processed:
            already_processed.add('length')
            outfile.write(' length="%s"' % self.gds_format_double(self.length, input_name='length'))
        if self.rot is not None and 'rot' not in already_processed:
            already_processed.add('rot')
            outfile.write(
                ' rot=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.rot), input_name='rot')),))
        if self.equipmentUsed is not None and 'equipmentUsed' not in already_processed:
            already_processed.add('equipmentUsed')
            outfile.write(' equipmentUsed=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.equipmentUsed), input_name='equipmentUsed')),))
        if self.arcAzimuthAccuracy is not None and 'arcAzimuthAccuracy' not in already_processed:
            already_processed.add('arcAzimuthAccuracy')
            outfile.write(' arcAzimuthAccuracy="%s"' % self.gds_format_double(self.arcAzimuthAccuracy,
                                                                              input_name='arcAzimuthAccuracy'))
        if self.arcLengthAccuracy is not None and 'arcLengthAccuracy' not in already_processed:
            already_processed.add('arcLengthAccuracy')
            outfile.write(' arcLengthAccuracy="%s"' % self.gds_format_double(self.arcLengthAccuracy,
                                                                             input_name='arcLengthAccuracy'))
        if self.arcAngleAccuracy is not None and 'arcAngleAccuracy' not in already_processed:
            already_processed.add('arcAngleAccuracy')
            outfile.write(
                ' arcAngleAccuracy="%s"' % self.gds_format_double(self.arcAngleAccuracy, input_name='arcAngleAccuracy'))
        if self.arcType is not None and 'arcType' not in already_processed:
            already_processed.add('arcType')
            outfile.write(' arcType=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.arcType), input_name='arcType')),))
        if self.adoptedSurvey is not None and 'adoptedSurvey' not in already_processed:
            already_processed.add('adoptedSurvey')
            outfile.write(' adoptedSurvey=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.adoptedSurvey), input_name='adoptedSurvey')),))
        if self.azimuthAdoptionFactor is not None and 'azimuthAdoptionFactor' not in already_processed:
            already_processed.add('azimuthAdoptionFactor')
            outfile.write(' azimuthAdoptionFactor="%s"' % self.gds_format_double(self.azimuthAdoptionFactor,
                                                                                 input_name='azimuthAdoptionFactor'))
        if self.lengthAdoptionFactor is not None and 'lengthAdoptionFactor' not in already_processed:
            already_processed.add('lengthAdoptionFactor')
            outfile.write(' lengthAdoptionFactor="%s"' % self.gds_format_double(self.lengthAdoptionFactor,
                                                                                input_name='lengthAdoptionFactor'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
                       name_='ReducedArcObservation', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for FieldNote_ in self.FieldNote:
            namespaceprefix_ = self.FieldNote_nsprefix_ + ':' if (UseCapturedNS_ and self.FieldNote_nsprefix_) else ''
            FieldNote_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='FieldNote',
                              pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            self.desc = value
        value = find_attr_value_('purpose', node)
        if value is not None and 'purpose' not in already_processed:
            already_processed.add('purpose')
            self.purpose = value
            self.validate_purposeType(self.purpose)  # validate type purposeType
        value = find_attr_value_('setupID', node)
        if value is not None and 'setupID' not in already_processed:
            already_processed.add('setupID')
            self.setupID = value
        value = find_attr_value_('targetSetupID', node)
        if value is not None and 'targetSetupID' not in already_processed:
            already_processed.add('targetSetupID')
            self.targetSetupID = value
        value = find_attr_value_('chordAzimuth', node)
        if value is not None and 'chordAzimuth' not in already_processed:
            already_processed.add('chordAzimuth')
            value = self.gds_parse_double(value, node, 'chordAzimuth')
            self.chordAzimuth = value
            self.validate_direction(self.chordAzimuth)  # validate type direction
        value = find_attr_value_('radius', node)
        if value is not None and 'radius' not in already_processed:
            already_processed.add('radius')
            value = self.gds_parse_double(value, node, 'radius')
            self.radius = value
            self.validate_distanceRestriction(self.radius)  # validate type distanceRestriction
        value = find_attr_value_('length', node)
        if value is not None and 'length' not in already_processed:
            already_processed.add('length')
            value = self.gds_parse_double(value, node, 'length')
            self.length = value
            self.validate_distanceRestriction(self.length)  # validate type distanceRestriction
        value = find_attr_value_('rot', node)
        if value is not None and 'rot' not in already_processed:
            already_processed.add('rot')
            self.rot = value
            self.validate_clockwise(self.rot)  # validate type clockwise
        value = find_attr_value_('equipmentUsed', node)
        if value is not None and 'equipmentUsed' not in already_processed:
            already_processed.add('equipmentUsed')
            self.equipmentUsed = value
            self.validate_equipmentType(self.equipmentUsed)  # validate type equipmentType
        value = find_attr_value_('arcAzimuthAccuracy', node)
        if value is not None and 'arcAzimuthAccuracy' not in already_processed:
            already_processed.add('arcAzimuthAccuracy')
            value = self.gds_parse_double(value, node, 'arcAzimuthAccuracy')
            self.arcAzimuthAccuracy = value
        value = find_attr_value_('arcLengthAccuracy', node)
        if value is not None and 'arcLengthAccuracy' not in already_processed:
            already_processed.add('arcLengthAccuracy')
            value = self.gds_parse_double(value, node, 'arcLengthAccuracy')
            self.arcLengthAccuracy = value
        value = find_attr_value_('arcAngleAccuracy', node)
        if value is not None and 'arcAngleAccuracy' not in already_processed:
            already_processed.add('arcAngleAccuracy')
            value = self.gds_parse_double(value, node, 'arcAngleAccuracy')
            self.arcAngleAccuracy = value
        value = find_attr_value_('arcType', node)
        if value is not None and 'arcType' not in already_processed:
            already_processed.add('arcType')
            self.arcType = value
            self.validate_observationType(self.arcType)  # validate type observationType
        value = find_attr_value_('adoptedSurvey', node)
        if value is not None and 'adoptedSurvey' not in already_processed:
            already_processed.add('adoptedSurvey')
            self.adoptedSurvey = value
            self.validate_nonBlankString(self.adoptedSurvey)  # validate type nonBlankString
        value = find_attr_value_('azimuthAdoptionFactor', node)
        if value is not None and 'azimuthAdoptionFactor' not in already_processed:
            already_processed.add('azimuthAdoptionFactor')
            value = self.gds_parse_double(value, node, 'azimuthAdoptionFactor')
            self.azimuthAdoptionFactor = value
        value = find_attr_value_('lengthAdoptionFactor', node)
        if value is not None and 'lengthAdoptionFactor' not in already_processed:
            already_processed.add('lengthAdoptionFactor')
            value = self.gds_parse_double(value, node, 'lengthAdoptionFactor')
            self.lengthAdoptionFactor = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'FieldNote':
            obj_ = FieldNote.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.FieldNote.append(obj_)
            obj_.original_tagname_ = 'FieldNote'


# end class ReducedArcObservation


class RedHorizontalPosition(GeneratedsSuper):
    """The reduced horizontal position. The coordinates may be derived using
    various of means."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, desc=None, name=None, oID=None, setupID=None, date=None, horizontalDatum=None,
                 horizontalAdjustment=None, latitude=None, longitude=None, horizontalFix=None, currencyDate=None,
                 order=None, positionalUncertainity=None, FieldNote=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.desc = _cast(None, desc)
        self.desc_nsprefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.oID = _cast(None, oID)
        self.oID_nsprefix_ = None
        self.setupID = _cast(None, setupID)
        self.setupID_nsprefix_ = None
        self.date = _cast(None, date)
        self.date_nsprefix_ = None
        self.horizontalDatum = _cast(None, horizontalDatum)
        self.horizontalDatum_nsprefix_ = None
        self.horizontalAdjustment = _cast(None, horizontalAdjustment)
        self.horizontalAdjustment_nsprefix_ = None
        self.latitude = _cast(None, latitude)
        self.latitude_nsprefix_ = None
        self.longitude = _cast(None, longitude)
        self.longitude_nsprefix_ = None
        self.horizontalFix = _cast(None, horizontalFix)
        self.horizontalFix_nsprefix_ = None
        self.currencyDate = _cast(None, currencyDate)
        self.currencyDate_nsprefix_ = None
        self.order = _cast(None, order)
        self.order_nsprefix_ = None
        self.positionalUncertainity = _cast(float, positionalUncertainity)
        self.positionalUncertainity_nsprefix_ = None
        if FieldNote is None:
            self.FieldNote = []
        else:
            self.FieldNote = FieldNote
        self.FieldNote_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, RedHorizontalPosition)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RedHorizontalPosition.subclass:
            return RedHorizontalPosition.subclass(*args_, **kwargs_)
        else:
            return RedHorizontalPosition(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_FieldNote(self):
        return self.FieldNote

    def set_FieldNote(self, FieldNote):
        self.FieldNote = FieldNote

    def add_FieldNote(self, value):
        self.FieldNote.append(value)

    def insert_FieldNote_at(self, index, value):
        self.FieldNote.insert(index, value)

    def replace_FieldNote_at(self, index, value):
        self.FieldNote[index] = value

    def get_desc(self):
        return self.desc

    def set_desc(self, desc):
        self.desc = desc

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_oID(self):
        return self.oID

    def set_oID(self, oID):
        self.oID = oID

    def get_setupID(self):
        return self.setupID

    def set_setupID(self, setupID):
        self.setupID = setupID

    def get_date(self):
        return self.date

    def set_date(self, date):
        self.date = date

    def get_horizontalDatum(self):
        return self.horizontalDatum

    def set_horizontalDatum(self, horizontalDatum):
        self.horizontalDatum = horizontalDatum

    def get_horizontalAdjustment(self):
        return self.horizontalAdjustment

    def set_horizontalAdjustment(self, horizontalAdjustment):
        self.horizontalAdjustment = horizontalAdjustment

    def get_latitude(self):
        return self.latitude

    def set_latitude(self, latitude):
        self.latitude = latitude

    def get_longitude(self):
        return self.longitude

    def set_longitude(self, longitude):
        self.longitude = longitude

    def get_horizontalFix(self):
        return self.horizontalFix

    def set_horizontalFix(self, horizontalFix):
        self.horizontalFix = horizontalFix

    def get_currencyDate(self):
        return self.currencyDate

    def set_currencyDate(self, currencyDate):
        self.currencyDate = currencyDate

    def get_order(self):
        return self.order

    def set_order(self, order):
        self.order = order

    def get_positionalUncertainity(self):
        return self.positionalUncertainity

    def set_positionalUncertainity(self, positionalUncertainity):
        self.positionalUncertainity = positionalUncertainity

    def validate_dateOrEmpty(self, value):
        # Validate type dateOrEmpty, a restriction on ltype.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if len(str(value)) > 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on dateOrEmpty' % {
                        "value": value, "lineno": lineno})
                result = False

    def validate_horzDatumTypeOrEmpty(self, value):
        # Validate type enum:horzDatumTypeOrEmpty, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['MGA2020_Zone54', 'MGA2020_Zone55', 'GDA2020', '']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on horzDatumTypeOrEmpty' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_horzFixType(self, value):
        # Validate type enum:horzFixType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Adjustment', 'Cadastral', 'Digitised', 'GPS(Differential)', 'GPS(Kinematics)',
                            'GPS(Single Point)', 'Intersection', 'Plot', 'Radiation', 'Resection', 'Transformed',
                            'Traverse', 'Triangulation', 'Unchecked Radiation', 'Unknown', '']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on horzFixType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_horzOrderType(self, value):
        # Validate type enum:horzOrderType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '99']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on horzOrderType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.FieldNote
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
               name_='RedHorizontalPosition', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('RedHorizontalPosition')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'RedHorizontalPosition':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        if self.eplan_value is True:
            if self.horizontalDatum is None:
                datum = self.parent_object_.parent_object_.parent_object_.CoordinateSystem[0].datum
                self.horizontalDatum = datum
            elif len(self.horizontalDatum) == 0:
                try:
                    datum = self.parent_object_.parent_object_.parent_object_.CoordinateSystem[0].datum
                    self.horizontalDatum = datum
                except Exception as err:
                    self.horizontalDatum = 'MGA2020_Zone55'
            if self.date is not None:
                if isinstance(self.date, datetime_.date):
                    date = self.date.strftime('%Y-%m-%d')
                else:
                    date = self.date
                if len(date) == 0:
                    already_processed.add('date')
            if len(self.latitude) == 0:
                self.latitude = 'Not-Supplied'
            if len(self.longitude) == 0:
                self.longitude = 'Not-Supplied'
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='RedHorizontalPosition')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='RedHorizontalPosition',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='RedHorizontalPosition'):
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            outfile.write(
                ' desc=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.desc), input_name='desc')),))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))
        if self.oID is not None and 'oID' not in already_processed:
            already_processed.add('oID')
            outfile.write(
                ' oID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.oID), input_name='oID')),))
        if self.setupID is not None and 'setupID' not in already_processed:
            already_processed.add('setupID')
            outfile.write(' setupID=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.setupID), input_name='setupID')),))
        if self.date is not None and 'date' not in already_processed:
            already_processed.add('date')
            outfile.write(' date=%s' % (quote_attrib(self.date),))
        if self.horizontalDatum is not None and 'horizontalDatum' not in already_processed:
            already_processed.add('horizontalDatum')
            outfile.write(' horizontalDatum=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.horizontalDatum), input_name='horizontalDatum')),))
        if self.horizontalAdjustment is not None and 'horizontalAdjustment' not in already_processed:
            already_processed.add('horizontalAdjustment')
            outfile.write(' horizontalAdjustment=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.horizontalAdjustment), input_name='horizontalAdjustment')),))
        if self.latitude is not None and 'latitude' not in already_processed:
            already_processed.add('latitude')
            outfile.write(' latitude=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.latitude), input_name='latitude')),))
        if self.longitude is not None and 'longitude' not in already_processed:
            already_processed.add('longitude')
            outfile.write(' longitude=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.longitude), input_name='longitude')),))
        if self.horizontalFix is not None and 'horizontalFix' not in already_processed:
            already_processed.add('horizontalFix')
            outfile.write(' horizontalFix=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.horizontalFix), input_name='horizontalFix')),))
        if self.currencyDate is not None and 'currencyDate' not in already_processed:
            already_processed.add('currencyDate')
            outfile.write(' currencyDate=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.currencyDate), input_name='currencyDate')),))
        if self.order is not None and 'order' not in already_processed:
            already_processed.add('order')
            outfile.write(
                ' order=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.order), input_name='order')),))
        if self.positionalUncertainity is not None and 'positionalUncertainity' not in already_processed:
            already_processed.add('positionalUncertainity')
            outfile.write(' positionalUncertainity="%s"' % self.gds_format_double(self.positionalUncertainity,
                                                                                  input_name='positionalUncertainity'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
                       name_='RedHorizontalPosition', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for FieldNote_ in self.FieldNote:
            namespaceprefix_ = self.FieldNote_nsprefix_ + ':' if (UseCapturedNS_ and self.FieldNote_nsprefix_) else ''
            FieldNote_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='FieldNote',
                              pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            self.desc = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('oID', node)
        if value is not None and 'oID' not in already_processed:
            already_processed.add('oID')
            self.oID = value
        value = find_attr_value_('setupID', node)
        if value is not None and 'setupID' not in already_processed:
            already_processed.add('setupID')
            self.setupID = value
        value = find_attr_value_('date', node)
        if value is not None and 'date' not in already_processed:
            already_processed.add('date')
            try:
                self.date = self.gds_parse_date(value)
            except ValueError as exp:
                raise ValueError('Bad date attribute (date): %s' % exp)
            self.validate_dateOrEmpty(self.date)  # validate type dateOrEmpty
        value = find_attr_value_('horizontalDatum', node)
        if value is not None and 'horizontalDatum' not in already_processed:
            already_processed.add('horizontalDatum')
            self.horizontalDatum = value
            self.validate_horzDatumTypeOrEmpty(self.horizontalDatum)  # validate type horzDatumTypeOrEmpty
        value = find_attr_value_('horizontalAdjustment', node)
        if value is not None and 'horizontalAdjustment' not in already_processed:
            already_processed.add('horizontalAdjustment')
            self.horizontalAdjustment = value
        value = find_attr_value_('latitude', node)
        if value is not None and 'latitude' not in already_processed:
            already_processed.add('latitude')
            self.latitude = value
        value = find_attr_value_('longitude', node)
        if value is not None and 'longitude' not in already_processed:
            already_processed.add('longitude')
            self.longitude = value
        value = find_attr_value_('horizontalFix', node)
        if value is not None and 'horizontalFix' not in already_processed:
            already_processed.add('horizontalFix')
            self.horizontalFix = value
            self.validate_horzFixType(self.horizontalFix)  # validate type horzFixType
        value = find_attr_value_('currencyDate', node)
        if value is not None and 'currencyDate' not in already_processed:
            already_processed.add('currencyDate')
            self.currencyDate = value
        value = find_attr_value_('order', node)
        if value is not None and 'order' not in already_processed:
            already_processed.add('order')
            self.order = value
            self.validate_horzOrderType(self.order)  # validate type horzOrderType
        value = find_attr_value_('positionalUncertainity', node)
        if value is not None and 'positionalUncertainity' not in already_processed:
            already_processed.add('positionalUncertainity')
            value = self.gds_parse_double(value, node, 'positionalUncertainity')
            self.positionalUncertainity = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'FieldNote':
            obj_ = FieldNote.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.FieldNote.append(obj_)
            obj_.original_tagname_ = 'FieldNote'


# end class RedHorizontalPosition


class RedVerticalObservation(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, desc=None, name=None, oID=None, setupID=None, date=None, height=None, verticalAdjustment=None,
                 verticalFix=None, geosphoid=None, gsDatum=None, gsModel=None, verticalDatum=None, order=None,
                 positionalUncertainity=None, FieldNote=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.desc = _cast(None, desc)
        self.desc_nsprefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.oID = _cast(None, oID)
        self.oID_nsprefix_ = None
        self.setupID = _cast(None, setupID)
        self.setupID_nsprefix_ = None
        if isinstance(date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(date, '%Y-%m-%d').date()
        else:
            initvalue_ = date
        self.date = initvalue_
        self.height = _cast(float, height)
        self.height_nsprefix_ = None
        self.verticalAdjustment = _cast(None, verticalAdjustment)
        self.verticalAdjustment_nsprefix_ = None
        self.verticalFix = _cast(None, verticalFix)
        self.verticalFix_nsprefix_ = None
        self.geosphoid = _cast(float, geosphoid)
        self.geosphoid_nsprefix_ = None
        self.gsDatum = _cast(None, gsDatum)
        self.gsDatum_nsprefix_ = None
        self.gsModel = _cast(None, gsModel)
        self.gsModel_nsprefix_ = None
        self.verticalDatum = _cast(None, verticalDatum)
        self.verticalDatum_nsprefix_ = None
        self.order = _cast(None, order)
        self.order_nsprefix_ = None
        self.positionalUncertainity = _cast(float, positionalUncertainity)
        self.positionalUncertainity_nsprefix_ = None
        if FieldNote is None:
            self.FieldNote = []
        else:
            self.FieldNote = FieldNote
        self.FieldNote_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, RedVerticalObservation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RedVerticalObservation.subclass:
            return RedVerticalObservation.subclass(*args_, **kwargs_)
        else:
            return RedVerticalObservation(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_FieldNote(self):
        return self.FieldNote

    def set_FieldNote(self, FieldNote):
        self.FieldNote = FieldNote

    def add_FieldNote(self, value):
        self.FieldNote.append(value)

    def insert_FieldNote_at(self, index, value):
        self.FieldNote.insert(index, value)

    def replace_FieldNote_at(self, index, value):
        self.FieldNote[index] = value

    def get_desc(self):
        return self.desc

    def set_desc(self, desc):
        self.desc = desc

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_oID(self):
        return self.oID

    def set_oID(self, oID):
        self.oID = oID

    def get_setupID(self):
        return self.setupID

    def set_setupID(self, setupID):
        self.setupID = setupID

    def get_date(self):
        return self.date

    def set_date(self, date):
        self.date = date

    def get_height(self):
        return self.height

    def set_height(self, height):
        self.height = height

    def get_verticalAdjustment(self):
        return self.verticalAdjustment

    def set_verticalAdjustment(self, verticalAdjustment):
        self.verticalAdjustment = verticalAdjustment

    def get_verticalFix(self):
        return self.verticalFix

    def set_verticalFix(self, verticalFix):
        self.verticalFix = verticalFix

    def get_geosphoid(self):
        return self.geosphoid

    def set_geosphoid(self, geosphoid):
        self.geosphoid = geosphoid

    def get_gsDatum(self):
        return self.gsDatum

    def set_gsDatum(self, gsDatum):
        self.gsDatum = gsDatum

    def get_gsModel(self):
        return self.gsModel

    def set_gsModel(self, gsModel):
        self.gsModel = gsModel

    def get_verticalDatum(self):
        return self.verticalDatum

    def set_verticalDatum(self, verticalDatum):
        self.verticalDatum = verticalDatum

    def get_order(self):
        return self.order

    def set_order(self, order):
        self.order = order

    def get_positionalUncertainity(self):
        return self.positionalUncertainity

    def set_positionalUncertainity(self, positionalUncertainity):
        self.positionalUncertainity = positionalUncertainity

    def validate_vertFixType(self, value):
        # Validate type enum:vertFixType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['2nd Order', '3rd Order', '4th Order', 'GPS', 'Trig Heighting', 'Unknown',
                            'Vertical Angles', 'Zeroth Order']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on vertFixType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_horzDatumType(self, value):
        # Validate type enum:horzDatumType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Local', 'MGA94_Zone54', 'MGA94_Zone55', 'MGA2020_Zone54', 'MGA2020_Zone55', 'AMG66_Zone54',
                            'AMG66_Zone55', 'GDA2020']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on horzDatumType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_gsModelType(self, value):
        # Validate type enum:gsModelType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['AUSGEOID93', 'AUSGEOID96', 'AUSGEOID98', 'GEM8', 'OSU89', 'OSU89A']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on gsModelType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_vertDatumType(self, value):
        # Validate type enum:vertDatumType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['AHD']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on vertDatumType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_vertOrderType(self, value):
        # Validate type enum:vertOrderType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '1', '2', '3', '4', '5', '99']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on vertOrderType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.FieldNote
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
               name_='RedVerticalObservation', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('RedVerticalObservation')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'RedVerticalObservation':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='RedVerticalObservation')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='RedVerticalObservation',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='RedVerticalObservation'):
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            outfile.write(
                ' desc=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.desc), input_name='desc')),))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))
        if self.oID is not None and 'oID' not in already_processed:
            already_processed.add('oID')
            outfile.write(
                ' oID=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.oID), input_name='oID')),))
        if self.setupID is not None and 'setupID' not in already_processed:
            already_processed.add('setupID')
            outfile.write(' setupID=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.setupID), input_name='setupID')),))
        if self.date is not None and 'date' not in already_processed:
            already_processed.add('date')
            outfile.write(' date="%s"' % self.gds_format_date(self.date, input_name='date'))
        if self.height is not None and 'height' not in already_processed:
            already_processed.add('height')
            outfile.write(' height="%s"' % self.gds_format_double(self.height, input_name='height'))
        if self.verticalAdjustment is not None and 'verticalAdjustment' not in already_processed:
            already_processed.add('verticalAdjustment')
            outfile.write(' verticalAdjustment=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.verticalAdjustment), input_name='verticalAdjustment')),))
        if self.verticalFix is not None and 'verticalFix' not in already_processed:
            already_processed.add('verticalFix')
            outfile.write(' verticalFix=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.verticalFix), input_name='verticalFix')),))
        if self.geosphoid is not None and 'geosphoid' not in already_processed:
            already_processed.add('geosphoid')
            outfile.write(' geosphoid="%s"' % self.gds_format_double(self.geosphoid, input_name='geosphoid'))
        if self.gsDatum is not None and 'gsDatum' not in already_processed:
            already_processed.add('gsDatum')
            outfile.write(' gsDatum=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.gsDatum), input_name='gsDatum')),))
        if self.gsModel is not None and 'gsModel' not in already_processed:
            already_processed.add('gsModel')
            outfile.write(' gsModel=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.gsModel), input_name='gsModel')),))
        if self.verticalDatum is not None and 'verticalDatum' not in already_processed:
            already_processed.add('verticalDatum')
            outfile.write(' verticalDatum=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.verticalDatum), input_name='verticalDatum')),))
        if self.order is not None and 'order' not in already_processed:
            already_processed.add('order')
            outfile.write(
                ' order=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.order), input_name='order')),))
        if self.positionalUncertainity is not None and 'positionalUncertainity' not in already_processed:
            already_processed.add('positionalUncertainity')
            outfile.write(' positionalUncertainity="%s"' % self.gds_format_double(self.positionalUncertainity,
                                                                                  input_name='positionalUncertainity'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
                       name_='RedVerticalObservation', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for FieldNote_ in self.FieldNote:
            namespaceprefix_ = self.FieldNote_nsprefix_ + ':' if (UseCapturedNS_ and self.FieldNote_nsprefix_) else ''
            FieldNote_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='FieldNote',
                              pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            self.desc = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('oID', node)
        if value is not None and 'oID' not in already_processed:
            already_processed.add('oID')
            self.oID = value
        value = find_attr_value_('setupID', node)
        if value is not None and 'setupID' not in already_processed:
            already_processed.add('setupID')
            self.setupID = value
        value = find_attr_value_('date', node)
        if value is not None and 'date' not in already_processed:
            already_processed.add('date')
            try:
                self.date = self.gds_parse_date(value)
            except ValueError as exp:
                raise ValueError('Bad date attribute (date): %s' % exp)
        value = find_attr_value_('height', node)
        if value is not None and 'height' not in already_processed:
            already_processed.add('height')
            value = self.gds_parse_double(value, node, 'height')
            self.height = value
        value = find_attr_value_('verticalAdjustment', node)
        if value is not None and 'verticalAdjustment' not in already_processed:
            already_processed.add('verticalAdjustment')
            self.verticalAdjustment = value
        value = find_attr_value_('verticalFix', node)
        if value is not None and 'verticalFix' not in already_processed:
            already_processed.add('verticalFix')
            self.verticalFix = value
            self.validate_vertFixType(self.verticalFix)  # validate type vertFixType
        value = find_attr_value_('geosphoid', node)
        if value is not None and 'geosphoid' not in already_processed:
            already_processed.add('geosphoid')
            value = self.gds_parse_double(value, node, 'geosphoid')
            self.geosphoid = value
        value = find_attr_value_('gsDatum', node)
        if value is not None and 'gsDatum' not in already_processed:
            already_processed.add('gsDatum')
            self.gsDatum = value
            self.validate_horzDatumType(self.gsDatum)  # validate type horzDatumType
        value = find_attr_value_('gsModel', node)
        if value is not None and 'gsModel' not in already_processed:
            already_processed.add('gsModel')
            self.gsModel = value
            self.validate_gsModelType(self.gsModel)  # validate type gsModelType
        value = find_attr_value_('verticalDatum', node)
        if value is not None and 'verticalDatum' not in already_processed:
            already_processed.add('verticalDatum')
            self.verticalDatum = value
            self.validate_vertDatumType(self.verticalDatum)  # validate type vertDatumType
        value = find_attr_value_('order', node)
        if value is not None and 'order' not in already_processed:
            already_processed.add('order')
            self.order = value
            self.validate_vertOrderType(self.order)  # validate type vertOrderType
        value = find_attr_value_('positionalUncertainity', node)
        if value is not None and 'positionalUncertainity' not in already_processed:
            already_processed.add('positionalUncertainity')
            value = self.gds_parse_double(value, node, 'positionalUncertainity')
            self.positionalUncertainity = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'FieldNote':
            obj_ = FieldNote.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.FieldNote.append(obj_)
            obj_.original_tagname_ = 'FieldNote'


# end class RedVerticalObservation


class Monuments(GeneratedsSuper):
    """A collection of Monument elements"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, Monument=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if Monument is None:
            self.Monument = []
        else:
            self.Monument = Monument
        self.Monument_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Monuments)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Monuments.subclass:
            return Monuments.subclass(*args_, **kwargs_)
        else:
            return Monuments(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Monument(self):
        return self.Monument

    def set_Monument(self, Monument):
        self.Monument = Monument

    def add_Monument(self, value):
        self.Monument.append(value)

    def insert_Monument_at(self, index, value):
        self.Monument.insert(index, value)

    def replace_Monument_at(self, index, value):
        self.Monument[index] = value

    def hasContent_(self):
        if (
                self.Monument
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
               name_='Monuments', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Monuments')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Monuments':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Monuments')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Monuments',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Monuments'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
                       name_='Monuments', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Monument_ in self.Monument:
            namespaceprefix_ = self.Monument_nsprefix_ + ':' if (UseCapturedNS_ and self.Monument_nsprefix_) else ''
            Monument_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Monument',
                             pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Monument':
            obj_ = Monument.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Monument.append(obj_)
            obj_.original_tagname_ = 'Monument'


# end class Monuments


class Monument(GeneratedsSuper):
    """Information about the monument placed to mark a survey point. The survey
    point must be represented by a CgPoint and is linked by the pntRef
    attribute."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, name=None, pntRef=None, desc=None, state=None, condition=None, type_=None, originSurvey=None,
                 gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.pntRef = _cast(None, pntRef)
        self.pntRef_nsprefix_ = None
        self.desc = _cast(None, desc)
        self.desc_nsprefix_ = None
        self.state = _cast(None, state)
        self.state_nsprefix_ = None
        self.condition = _cast(None, condition)
        self.condition_nsprefix_ = None
        self.type_ = _cast(None, type_)
        self.type__nsprefix_ = None
        self.originSurvey = _cast(None, originSurvey)
        self.originSurvey_nsprefix_ = None

    def map_monument_to_eplan(self):
        mon_dict = {'Brick Base': 'Other',
                    'Brick Corner': 'Other',
                    'Corner': 'Other',
                    'Etch': 'Chisel Cut',
                    'Hole': 'Drill Hole',
                    'Instrument Point': 'Other',
                    'Nail': 'G.I. Nail',
                    'Pit Cover': 'Other',
                    'PM': 'Plaque',
                    'Post': 'Other',
                    'SSM': 'SSM (Standard Survey Mark)',
                    'Stone Base': 'Other',
                    'Trenches': 'Other',
                    'Unknown': 'Other',
                    'Cement faced Brick': 'Other'}

        new_type = mon_dict.get(self.type_)
        if new_type is not None:
            if self.desc is not None:
                self.desc += f', {self.type_}'
            else:
                self.desc = self.type_
            self.type_ = new_type

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Monument)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Monument.subclass:
            return Monument.subclass(*args_, **kwargs_)
        else:
            return Monument(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_pntRef(self):
        return self.pntRef

    def set_pntRef(self, pntRef):
        self.pntRef = pntRef

    def get_desc(self):
        return self.desc

    def set_desc(self, desc):
        self.desc = desc

    def get_state(self):
        return self.state

    def set_state(self, state):
        self.state = state

    def get_condition(self):
        return self.condition

    def set_condition(self, condition):
        self.condition = condition

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_originSurvey(self):
        return self.originSurvey

    def set_originSurvey(self, originSurvey):
        self.originSurvey = originSurvey

    def validate_nonBlankString(self, value):
        # Validate type nonBlankString, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nonBlankString' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_monumentState(self, value):
        # Validate type enum:monumentState, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Existing', 'New']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on monumentState' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_monumentCondition(self, value):
        # Validate type enum:monumentCondition, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Abandoned', 'Damaged', 'Destroyed', 'Disturbed', 'Found', 'Leaning', 'Loose',
                            'Nipple Damaged', 'Not Found', 'Not Used', 'OK', 'Origin', 'Placed', 'Plaque Missing',
                            'Removed', 'Replaced', 'Suspect', 'Unknown', 'Unstable']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on monumentCondition' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_monumentType(self, value):
        # Validate type enum:monumentType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Bolt', 'Chisel Cut', 'Cross Head Nail', 'Deep Driven Rod', 'Drill Hole',
                            'Drill Hole with Wings', 'Dumpy', 'G.I. Nail', 'G.I. Pipe', 'Nail in Join', 'Nail in Peg',
                            'Nail in Post', 'Nail in Rail', 'Not Marked', 'Other', 'Peg', 'Peg and Trench', 'Pin',
                            'Plaque', 'Reference Tree', 'Rivet', 'Rod', 'Round Post', 'SSM (Standard Survey Mark)',
                            'Screw', 'Spike', 'Split Post', 'Square Post', 'Star Picket', 'Survey Nail', 'Tree',
                            'Unknown', 'Brick Base', 'Brick Corner', 'Cement faced Brick', 'Corner', 'Etch',
                            'Instrument Point', 'Nail', 'Pipe', 'Pit Cover', 'Post', 'SSM', 'Stone Base', 'Hole', 'PM',
                            'Trenches']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on monumentType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='Monument',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Monument')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.eplan_value is True:
            self.map_monument_to_eplan()
        if self.original_tagname_ is not None and name_ == 'Monument':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Monument')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Monument',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Monument'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))
        if self.pntRef is not None and 'pntRef' not in already_processed:
            already_processed.add('pntRef')
            outfile.write(' pntRef=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.pntRef), input_name='pntRef')),))
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            outfile.write(
                ' desc=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.desc), input_name='desc')),))
        if self.state is not None and 'state' not in already_processed:
            already_processed.add('state')
            outfile.write(
                ' state=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.state), input_name='state')),))
        if self.condition is not None and 'condition' not in already_processed:
            already_processed.add('condition')
            outfile.write(' condition=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.condition), input_name='condition')),))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(
                ' type=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.type_), input_name='type')),))
        if self.originSurvey is not None and 'originSurvey' not in already_processed:
            already_processed.add('originSurvey')
            outfile.write(' originSurvey=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.originSurvey), input_name='originSurvey')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='Monument',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('pntRef', node)
        if value is not None and 'pntRef' not in already_processed:
            already_processed.add('pntRef')
            self.pntRef = value
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            self.desc = value
            self.validate_nonBlankString(self.desc)  # validate type nonBlankString
        value = find_attr_value_('state', node)
        if value is not None and 'state' not in already_processed:
            already_processed.add('state')
            self.state = value
            self.validate_monumentState(self.state)  # validate type monumentState
        value = find_attr_value_('condition', node)
        if value is not None and 'condition' not in already_processed:
            already_processed.add('condition')
            self.condition = value
            self.validate_monumentCondition(self.condition)  # validate type monumentCondition
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
            self.validate_monumentType(self.type_)  # validate type monumentType
        value = find_attr_value_('originSurvey', node)
        if value is not None and 'originSurvey' not in already_processed:
            already_processed.add('originSurvey')
            self.originSurvey = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class Monument


class Parcels(GeneratedsSuper):
    """A collection of Parcel elements"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, Parcel=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if Parcel is None:
            self.Parcel = []
        else:
            self.Parcel = Parcel
        self.Parcel_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Parcels)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Parcels.subclass:
            return Parcels.subclass(*args_, **kwargs_)
        else:
            return Parcels(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_Parcel(self):
        return self.Parcel

    def set_Parcel(self, Parcel):
        self.Parcel = Parcel

    def add_Parcel(self, value):
        self.Parcel.append(value)

    def insert_Parcel_at(self, index, value):
        self.Parcel.insert(index, value)

    def replace_Parcel_at(self, index, value):
        self.Parcel[index] = value

    def hasContent_(self):
        if (
                self.Parcel
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
               name_='Parcels', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Parcels')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Parcels':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Parcels')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Parcels',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Parcels'):
        pass

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
                       name_='Parcels', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Parcel_ in self.Parcel:
            namespaceprefix_ = self.Parcel_nsprefix_ + ':' if (UseCapturedNS_ and self.Parcel_nsprefix_) else ''
            Parcel_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Parcel',
                           pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Parcel':
            obj_ = ParcelType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Parcel.append(obj_)
            obj_.original_tagname_ = 'Parcel'


# end class Parcels


class Title(GeneratedsSuper):
    """Information about an interest."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, name=None, titleType=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None,
                 **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.titleType = _cast(None, titleType)
        self.titleType_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Title)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Title.subclass:
            return Title.subclass(*args_, **kwargs_)
        else:
            return Title(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_titleType(self):
        return self.titleType

    def set_titleType(self, titleType):
        self.titleType = titleType

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def validate_nonBlankString(self, value):
        # Validate type nonBlankString, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minLength restriction on nonBlankString' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_titleTypeType(self, value):
        # Validate type enum:titleTypeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Alpine Lease', 'Crown Grant', 'Crown Grant(Part)', 'Crown Land', 'Crown Lease', 'Freehold',
                            'Freehold(Part)', 'Identified', "Mineral 'Includes'", "Mineral 'Excludes'",
                            "Treasurer's Receipt", 'Easement Benefit', 'Restriction Benefit', 'Restriction Burden',
                            'Depth Limitation', 'Depth Limitation(Part)']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on titleTypeType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                (1 if type(self.valueOf_) in [int, float] else self.valueOf_) or
                self.content_
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='Title', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Title')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Title':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Title')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Title'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))
        if self.titleType is not None and 'titleType' not in already_processed:
            already_processed.add('titleType')
            outfile.write(' titleType=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.titleType), input_name='titleType')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='Title',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
            self.validate_nonBlankString(self.name)  # validate type nonBlankString
        value = find_attr_value_('titleType', node)
        if value is not None and 'titleType' not in already_processed:
            already_processed.add('titleType')
            self.titleType = value
            self.validate_titleTypeType(self.titleType)  # validate type titleTypeType

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass


# end class Title


class LocationAddress(GeneratedsSuper):
    """Defines the location or positional address of a parcel. LocationAddress
    is not designed to be a postal address (e.g. it has no post or zip
    code). The element must handle primary addresses and aliases if
    required."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, addressType=None, flatType=None, flatNumber=None, floorLevelType=None, floorLevelNumber=None,
                 numberFirst=None, numberSuffixFirst=None, numberLast=None, numberSuffixLast=None, ComplexName=None,
                 RoadName=None, AdministrativeArea=None, AddressPoint=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.addressType = _cast(None, addressType)
        self.addressType_nsprefix_ = None
        self.flatType = _cast(None, flatType)
        self.flatType_nsprefix_ = None
        self.flatNumber = _cast(None, flatNumber)
        self.flatNumber_nsprefix_ = None
        self.floorLevelType = _cast(None, floorLevelType)
        self.floorLevelType_nsprefix_ = None
        self.floorLevelNumber = _cast(None, floorLevelNumber)
        self.floorLevelNumber_nsprefix_ = None
        self.numberFirst = _cast(int, numberFirst)
        self.numberFirst_nsprefix_ = None
        self.numberSuffixFirst = _cast(None, numberSuffixFirst)
        self.numberSuffixFirst_nsprefix_ = None
        self.numberLast = _cast(int, numberLast)
        self.numberLast_nsprefix_ = None
        self.numberSuffixLast = _cast(None, numberSuffixLast)
        self.numberSuffixLast_nsprefix_ = None
        if ComplexName is None:
            self.ComplexName = []
        else:
            self.ComplexName = ComplexName
        self.ComplexName_nsprefix_ = None
        if RoadName is None:
            self.RoadName = []
        else:
            self.RoadName = RoadName
        self.RoadName_nsprefix_ = None
        if AdministrativeArea is None:
            self.AdministrativeArea = []
        else:
            self.AdministrativeArea = AdministrativeArea
        self.AdministrativeArea_nsprefix_ = None
        if AddressPoint is None:
            self.AddressPoint = []
        else:
            self.AddressPoint = AddressPoint
        self.AddressPoint_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LocationAddress)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LocationAddress.subclass:
            return LocationAddress.subclass(*args_, **kwargs_)
        else:
            return LocationAddress(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_ComplexName(self):
        return self.ComplexName

    def set_ComplexName(self, ComplexName):
        self.ComplexName = ComplexName

    def add_ComplexName(self, value):
        self.ComplexName.append(value)

    def insert_ComplexName_at(self, index, value):
        self.ComplexName.insert(index, value)

    def replace_ComplexName_at(self, index, value):
        self.ComplexName[index] = value

    def get_RoadName(self):
        return self.RoadName

    def set_RoadName(self, RoadName):
        self.RoadName = RoadName

    def add_RoadName(self, value):
        self.RoadName.append(value)

    def insert_RoadName_at(self, index, value):
        self.RoadName.insert(index, value)

    def replace_RoadName_at(self, index, value):
        self.RoadName[index] = value

    def get_AdministrativeArea(self):
        return self.AdministrativeArea

    def set_AdministrativeArea(self, AdministrativeArea):
        self.AdministrativeArea = AdministrativeArea

    def add_AdministrativeArea(self, value):
        self.AdministrativeArea.append(value)

    def insert_AdministrativeArea_at(self, index, value):
        self.AdministrativeArea.insert(index, value)

    def replace_AdministrativeArea_at(self, index, value):
        self.AdministrativeArea[index] = value

    def get_AddressPoint(self):
        return self.AddressPoint

    def set_AddressPoint(self, AddressPoint):
        self.AddressPoint = AddressPoint

    def add_AddressPoint(self, value):
        self.AddressPoint.append(value)

    def insert_AddressPoint_at(self, index, value):
        self.AddressPoint.insert(index, value)

    def replace_AddressPoint_at(self, index, value):
        self.AddressPoint[index] = value

    def get_addressType(self):
        return self.addressType

    def set_addressType(self, addressType):
        self.addressType = addressType

    def get_flatType(self):
        return self.flatType

    def set_flatType(self, flatType):
        self.flatType = flatType

    def get_flatNumber(self):
        return self.flatNumber

    def set_flatNumber(self, flatNumber):
        self.flatNumber = flatNumber

    def get_floorLevelType(self):
        return self.floorLevelType

    def set_floorLevelType(self, floorLevelType):
        self.floorLevelType = floorLevelType

    def get_floorLevelNumber(self):
        return self.floorLevelNumber

    def set_floorLevelNumber(self, floorLevelNumber):
        self.floorLevelNumber = floorLevelNumber

    def get_numberFirst(self):
        return self.numberFirst

    def set_numberFirst(self, numberFirst):
        self.numberFirst = numberFirst

    def get_numberSuffixFirst(self):
        return self.numberSuffixFirst

    def set_numberSuffixFirst(self, numberSuffixFirst):
        self.numberSuffixFirst = numberSuffixFirst

    def get_numberLast(self):
        return self.numberLast

    def set_numberLast(self, numberLast):
        self.numberLast = numberLast

    def get_numberSuffixLast(self):
        return self.numberSuffixLast

    def set_numberSuffixLast(self, numberSuffixLast):
        self.numberSuffixLast = numberSuffixLast

    def validate_addressTypeType(self, value):
        # Validate type enum:addressTypeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Primary', 'Secondary']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on addressTypeType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_flatTypeType(self, value):
        # Validate type enum:flatTypeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Antenna', 'Apartment', 'Auto Teller Machine', 'Barbeque', 'Bathing Box', 'Berth',
                            'Boatshed', 'Building', 'Bungalow', 'Cage', 'Carpark', 'Carspace', 'Carwash', 'Club',
                            'Coolroom', 'Cottage', 'Courtyard', 'Duplex', 'Factory', 'Flat', 'Garage', 'Gate', 'Hall',
                            'Hangar', 'Heliport', 'Hostel', 'House', 'Jetty', 'Kiosk', 'Lease', 'Lobby', 'Loft', 'Lot',
                            'Maisonette', 'Marine Berth', 'Office', 'Passageway', 'Penthouse', 'Reception', 'Reserve',
                            'Restaurant', 'Room', 'Shed', 'Shop', 'Showcase', 'Showroom', 'Sign', 'Site', 'Stall',
                            'Store', 'Strata Unit', 'Studio', 'Studio Apartment', 'Substation', 'Suite', 'Tenancy',
                            'Toilet', 'Tower', 'Townhouse', 'Unit', 'Vault', 'Villa', 'Ward', 'Warehouse', 'Workshop']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on flatTypeType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_floorLevelTypeType(self, value):
        # Validate type enum:floorLevelTypeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Basement', 'Floor', 'Ground', 'Level', 'Lobby', 'Lower Ground Floor', 'Lower Level',
                            'Mezzanine', 'Observation Deck', 'Parking', 'Platform', 'Podium', 'Rooftop', 'Sub-basement',
                            'Upper Ground Floor']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on floorLevelTypeType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                self.ComplexName or
                self.RoadName or
                self.AdministrativeArea or
                self.AddressPoint
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
               name_='LocationAddress', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('LocationAddress')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'LocationAddress':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='LocationAddress')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='LocationAddress',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='LocationAddress'):
        if self.addressType is not None and 'addressType' not in already_processed:
            already_processed.add('addressType')
            outfile.write(' addressType=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.addressType), input_name='addressType')),))
        if self.flatType is not None and 'flatType' not in already_processed:
            already_processed.add('flatType')
            outfile.write(' flatType=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.flatType), input_name='flatType')),))
        if self.flatNumber is not None and 'flatNumber' not in already_processed:
            already_processed.add('flatNumber')
            outfile.write(' flatNumber=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.flatNumber), input_name='flatNumber')),))
        if self.floorLevelType is not None and 'floorLevelType' not in already_processed:
            already_processed.add('floorLevelType')
            outfile.write(' floorLevelType=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.floorLevelType), input_name='floorLevelType')),))
        if self.floorLevelNumber is not None and 'floorLevelNumber' not in already_processed:
            already_processed.add('floorLevelNumber')
            outfile.write(' floorLevelNumber=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.floorLevelNumber), input_name='floorLevelNumber')),))
        if self.numberFirst is not None and 'numberFirst' not in already_processed:
            already_processed.add('numberFirst')
            outfile.write(' numberFirst="%s"' % self.gds_format_integer(self.numberFirst, input_name='numberFirst'))
        if self.numberSuffixFirst is not None and 'numberSuffixFirst' not in already_processed:
            already_processed.add('numberSuffixFirst')
            outfile.write(' numberSuffixFirst=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.numberSuffixFirst), input_name='numberSuffixFirst')),))
        if self.numberLast is not None and 'numberLast' not in already_processed:
            already_processed.add('numberLast')
            outfile.write(' numberLast="%s"' % self.gds_format_integer(self.numberLast, input_name='numberLast'))
        if self.numberSuffixLast is not None and 'numberSuffixLast' not in already_processed:
            already_processed.add('numberSuffixLast')
            outfile.write(' numberSuffixLast=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.numberSuffixLast), input_name='numberSuffixLast')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
                       name_='LocationAddress', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ComplexName_ in self.ComplexName:
            namespaceprefix_ = self.ComplexName_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.ComplexName_nsprefix_) else ''
            ComplexName_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ComplexName',
                                pretty_print=pretty_print)
        for RoadName_ in self.RoadName:
            namespaceprefix_ = self.RoadName_nsprefix_ + ':' if (UseCapturedNS_ and self.RoadName_nsprefix_) else ''
            RoadName_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='RoadName',
                             pretty_print=pretty_print)
        for AdministrativeArea_ in self.AdministrativeArea:
            namespaceprefix_ = self.AdministrativeArea_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.AdministrativeArea_nsprefix_) else ''
            AdministrativeArea_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AdministrativeArea',
                                       pretty_print=pretty_print)
        for AddressPoint_ in self.AddressPoint:
            namespaceprefix_ = self.AddressPoint_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.AddressPoint_nsprefix_) else ''
            AddressPoint_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AddressPoint',
                                 pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('addressType', node)
        if value is not None and 'addressType' not in already_processed:
            already_processed.add('addressType')
            self.addressType = value
            self.validate_addressTypeType(self.addressType)  # validate type addressTypeType
        value = find_attr_value_('flatType', node)
        if value is not None and 'flatType' not in already_processed:
            already_processed.add('flatType')
            self.flatType = value
            self.validate_flatTypeType(self.flatType)  # validate type flatTypeType
        value = find_attr_value_('flatNumber', node)
        if value is not None and 'flatNumber' not in already_processed:
            already_processed.add('flatNumber')
            self.flatNumber = value
        value = find_attr_value_('floorLevelType', node)
        if value is not None and 'floorLevelType' not in already_processed:
            already_processed.add('floorLevelType')
            self.floorLevelType = value
            self.validate_floorLevelTypeType(self.floorLevelType)  # validate type floorLevelTypeType
        value = find_attr_value_('floorLevelNumber', node)
        if value is not None and 'floorLevelNumber' not in already_processed:
            already_processed.add('floorLevelNumber')
            self.floorLevelNumber = value
        value = find_attr_value_('numberFirst', node)
        if value is not None and 'numberFirst' not in already_processed:
            already_processed.add('numberFirst')
            self.numberFirst = self.gds_parse_integer(value, node, 'numberFirst')
        value = find_attr_value_('numberSuffixFirst', node)
        if value is not None and 'numberSuffixFirst' not in already_processed:
            already_processed.add('numberSuffixFirst')
            self.numberSuffixFirst = value
        value = find_attr_value_('numberLast', node)
        if value is not None and 'numberLast' not in already_processed:
            already_processed.add('numberLast')
            self.numberLast = self.gds_parse_integer(value, node, 'numberLast')
        value = find_attr_value_('numberSuffixLast', node)
        if value is not None and 'numberSuffixLast' not in already_processed:
            already_processed.add('numberSuffixLast')
            self.numberSuffixLast = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ComplexName':
            obj_ = ComplexName.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ComplexName.append(obj_)
            obj_.original_tagname_ = 'ComplexName'
        elif nodeName_ == 'RoadName':
            obj_ = RoadName.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.RoadName.append(obj_)
            obj_.original_tagname_ = 'RoadName'
        elif nodeName_ == 'AdministrativeArea':
            obj_ = AdministrativeArea.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AdministrativeArea.append(obj_)
            obj_.original_tagname_ = 'AdministrativeArea'
        elif nodeName_ == 'AddressPoint':
            obj_ = AddressPoint.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AddressPoint.append(obj_)
            obj_.original_tagname_ = 'AddressPoint'


# end class LocationAddress


class ComplexName(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, desc=None, priority=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.desc = _cast(None, desc)
        self.desc_nsprefix_ = None
        self.priority = _cast(int, priority)
        self.priority_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ComplexName)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ComplexName.subclass:
            return ComplexName.subclass(*args_, **kwargs_)
        else:
            return ComplexName(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_desc(self):
        return self.desc

    def set_desc(self, desc):
        self.desc = desc

    def get_priority(self):
        return self.priority

    def set_priority(self, priority):
        self.priority = priority

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='ComplexName',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ComplexName')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ComplexName':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ComplexName')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ComplexName',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ComplexName'):
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            outfile.write(
                ' desc=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.desc), input_name='desc')),))
        if self.priority is not None and 'priority' not in already_processed:
            already_processed.add('priority')
            outfile.write(' priority="%s"' % self.gds_format_integer(self.priority, input_name='priority'))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='ComplexName',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            self.desc = value
        value = find_attr_value_('priority', node)
        if value is not None and 'priority' not in already_processed:
            already_processed.add('priority')
            self.priority = self.gds_parse_integer(value, node, 'priority')

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class ComplexName


class RoadName(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, roadNameType=None, roadName=None, roadNameSuffix=None, roadType=None, pclRef=None,
                 gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.roadNameType = _cast(None, roadNameType)
        self.roadNameType_nsprefix_ = None
        self.roadName = _cast(None, roadName)
        self.roadName_nsprefix_ = None
        self.roadNameSuffix = _cast(None, roadNameSuffix)
        self.roadNameSuffix_nsprefix_ = None
        self.roadType = _cast(None, roadType)
        self.roadType_nsprefix_ = None
        self.pclRef = _cast(None, pclRef)
        self.pclRef_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, RoadName)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RoadName.subclass:
            return RoadName.subclass(*args_, **kwargs_)
        else:
            return RoadName(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_roadNameType(self):
        return self.roadNameType

    def set_roadNameType(self, roadNameType):
        self.roadNameType = roadNameType

    def get_roadName(self):
        return self.roadName

    def set_roadName(self, roadName):
        self.roadName = roadName

    def get_roadNameSuffix(self):
        return self.roadNameSuffix

    def set_roadNameSuffix(self, roadNameSuffix):
        self.roadNameSuffix = roadNameSuffix

    def get_roadType(self):
        return self.roadType

    def set_roadType(self, roadType):
        self.roadType = roadType

    def get_pclRef(self):
        return self.pclRef

    def set_pclRef(self, pclRef):
        self.pclRef = pclRef

    def validate_roadNameTypeType(self, value):
        # Validate type enum:roadNameTypeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Access', 'Alley', 'Alleyway', 'Amble', 'Anchorage', 'Apartments', 'Approach', 'Arcade',
                            'Arch', 'Arterial', 'Artery', 'Avenue', 'Banan', 'Bank', 'Basin', 'Bay', 'Beach', 'Belt',
                            'Bend', 'Block', 'Bluff', 'Boardwalk', 'Boulevard', 'Boulevarde', 'Bowl', 'Brace', 'Brae',
                            'Branchline', 'Break', 'Bridge', 'Broadway', 'Brow', 'Bypass', 'Byway', 'Causeway',
                            'Centre', 'Centreway', 'Chase', 'Circle', 'Circlet', 'Circuit', 'Circus', 'Claim', 'Close',
                            'Cluster', 'Colonnade', 'Common', 'Concourse', 'Connection', 'Connector', 'Copse', 'Corner',
                            'Corseo', 'Corso', 'Course', 'Court', 'Courts', 'Courtyard', 'Cove', 'Crescent', 'Crest',
                            'Crief', 'Crook', 'Cross', 'Crossing', 'Crossroad', 'Crossway', 'Cruiseway', 'Cul',
                            'Cul-De-Sac', 'Cutting', 'Dale', 'Dash', 'Dell', 'Dene', 'Deviation', 'Dip', 'Distributor',
                            'Divide', 'Dock', 'Domain', 'Down', 'Downs', 'Drift', 'Drive', 'Driveway', 'Edge', 'Elbow',
                            'Elm', 'End', 'Entrance', 'Esplanade', 'Estate', 'Expressway', 'Extension', 'Fairway',
                            'Fall', 'Fare', 'Farms', 'Fen', 'Fern', 'Firebreak', 'Fireline', 'Firetrack', 'Firetrail',
                            'Flat', 'Flats', 'Follow', 'Footway', 'Ford', 'Foreshore', 'Fork', 'Formation', 'Freeway',
                            'Front', 'Frontage', 'Gap', 'Garden', 'Gardens', 'Gate', 'Gates', 'Gateway', 'Glade',
                            'Glades', 'Glen', 'Grange', 'Green', 'Ground', 'Grove', 'Gully', 'Haven', 'Head', 'Heath',
                            'Heights', 'Highroad', 'Highway', 'Hill', 'Hollow', 'Hub', 'Interchange', 'Intersection',
                            'Island', 'Junction', 'Key', 'Keys', 'Knob', 'Ladder', 'Lagoon', 'Landing', 'Lane',
                            'Laneway', 'Lea', 'Leader', 'Lees', 'Leigh', 'Line', 'Link', 'Lookout', 'Loop', 'Loops',
                            'Mall', 'Manor', 'Mead', 'Meander', 'Mew', 'Mews', 'Mile', 'Motorway', 'Motu', 'Mount',
                            'Neaves', 'Nook', 'Oaks', 'Outlet', 'Outlook', 'Overbridge', 'Paddock', 'Paku', 'Parade',
                            'Park', 'Parklands', 'Parkway', 'Part', 'Pass', 'Passage', 'Path', 'Pathway', 'Piazza',
                            'Place', 'Plateau', 'Plaza', 'Pocket', 'Point', 'Port', 'Priors', 'Promenade', 'Pursuit',
                            'Quad', 'Quadrangle', 'Quadrant', 'Quay', 'Quays', 'Ramble', 'Ramp', 'Ranae', 'Range',
                            'Reach', 'Reef', 'Reserve', 'Rest', 'Retreat', 'Return', 'Ride', 'Ridge', 'Ridgeway',
                            'Right Of Way', 'Ring', 'Rise', 'Rising', 'River', 'Riverway', 'Riviera', 'Road', 'Roads',
                            'Roadside', 'Roadway', 'Ronde', 'Rosebowl', 'Rotary', 'Round', 'Route', 'Row', 'Rua', 'Rue',
                            'Run', 'Serviceway', 'Shore', 'Shunt', 'Siding', 'Slope', 'Sound', 'Spa', 'Spur', 'Square',
                            'Stairs', 'State High', 'Steep', 'Steps', 'Straat', 'Straight', 'Strand', 'Street', 'Strip',
                            'Subway', 'Tarn', 'Tee', 'Terrace', 'Thoroughfair', 'Thoroughwa', 'Throughway', 'Tollway',
                            'Top', 'Tor', 'Tower', 'Towers', 'Track', 'Trail', 'Trailer', 'Tram', 'Tramway', 'Traverse',
                            'Trees', 'Triangle', 'Trunkway', 'Tunnel', 'Turn', 'Twist', 'Underpass', 'Vale', 'Valley',
                            'Venus', 'Viaduct', 'View', 'Views', 'Village', 'Villas', 'Vista', 'Vue', 'Wade', 'Walk',
                            'Walkway', 'Waters', 'Waterway', 'Way', 'Wharf', 'Whenua', 'Wood', 'Woods', 'Wynd', 'Yard']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on roadNameTypeType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_roadNameSuffixType(self, value):
        # Validate type enum:roadNameSuffixType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['A', 'B', 'Branch', 'C', 'Central', 'Deviation', 'East', 'Extension', 'Inner', 'Lower',
                            'Mall', 'North', 'North East', 'North West', 'Off', 'On', 'Outer', 'South', 'South East',
                            'South West', 'Upper', 'West']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on roadNameSuffixType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_roadTypeType(self, value):
        # Validate type enum:roadTypeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Private', 'Public']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on roadTypeType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def validate_parcelNameRefs(self, value):
        # Validate type parcelNameRefs, a restriction on xs:string.
        pass

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='RoadName',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('RoadName')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'RoadName':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='RoadName')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='RoadName',
                                pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='RoadName'):
        if self.roadNameType is not None and 'roadNameType' not in already_processed:
            already_processed.add('roadNameType')
            outfile.write(' roadNameType=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.roadNameType), input_name='roadNameType')),))
        if self.roadName is not None and 'roadName' not in already_processed:
            already_processed.add('roadName')
            outfile.write(' roadName=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.roadName), input_name='roadName')),))
        if self.roadNameSuffix is not None and 'roadNameSuffix' not in already_processed:
            already_processed.add('roadNameSuffix')
            outfile.write(' roadNameSuffix=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.roadNameSuffix), input_name='roadNameSuffix')),))
        if self.roadType is not None and 'roadType' not in already_processed:
            already_processed.add('roadType')
            outfile.write(' roadType=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.roadType), input_name='roadType')),))
        if self.pclRef is not None and 'pclRef' not in already_processed:
            already_processed.add('pclRef')
            outfile.write(' pclRef=%s' % (
            self.gds_encode(self.gds_format_string(quote_attrib(self.pclRef), input_name='pclRef')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='RoadName',
                       fromsubclass_=False, pretty_print=True):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('roadNameType', node)
        if value is not None and 'roadNameType' not in already_processed:
            already_processed.add('roadNameType')
            self.roadNameType = value
            self.validate_roadNameTypeType(self.roadNameType)  # validate type roadNameTypeType
        value = find_attr_value_('roadName', node)
        if value is not None and 'roadName' not in already_processed:
            already_processed.add('roadName')
            self.roadName = value
        value = find_attr_value_('roadNameSuffix', node)
        if value is not None and 'roadNameSuffix' not in already_processed:
            already_processed.add('roadNameSuffix')
            self.roadNameSuffix = value
            self.validate_roadNameSuffixType(self.roadNameSuffix)  # validate type roadNameSuffixType
        value = find_attr_value_('roadType', node)
        if value is not None and 'roadType' not in already_processed:
            already_processed.add('roadType')
            self.roadType = value
            self.validate_roadTypeType(self.roadType)  # validate type roadTypeType
        value = find_attr_value_('pclRef', node)
        if value is not None and 'pclRef' not in already_processed:
            already_processed.add('pclRef')
            self.pclRef = value
            self.validate_parcelNameRefs(self.pclRef)  # validate type parcelNameRefs

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass


# end class RoadName


class AddressPoint(PntRefPointType):
    """Represents a 2D or 3D Address Point. An AddressPoint is a geocoded
    address reference."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = PntRefPointType

    def __init__(self, pntRef=None, addressPointType=None, valueOf_=None, mixedclass_=None, content_=None,
                 gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(AddressPoint, self).__init__(pntRef, valueOf_, mixedclass_, content_, **kwargs_)
        self.addressPointType = _cast(None, addressPointType)
        self.addressPointType_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AddressPoint)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AddressPoint.subclass:
            return AddressPoint.subclass(*args_, **kwargs_)
        else:
            return AddressPoint(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_addressPointType(self):
        return self.addressPointType

    def set_addressPointType(self, addressPointType):
        self.addressPointType = addressPointType

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def validate_addressPointTypeType(self, value):
        # Validate type enum:addressPointTypeType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value,
                                                                                                  "lineno": lineno, })
                return False
            value = value
            enumerations = ['Entrance', 'Virtual']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on addressPointTypeType' % {
                        "value": encode_str_2_3(value), "lineno": lineno})
                result = False

    def hasContent_(self):
        if (
                (1 if type(self.valueOf_) in [int, float] else self.valueOf_) or
                self.content_ or
                super(AddressPoint, self).hasContent_()
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='AddressPoint',
               pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AddressPoint')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AddressPoint':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AddressPoint')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AddressPoint'):
        super(AddressPoint, self).exportAttributes(outfile, level, already_processed, namespaceprefix_,
                                                   name_='AddressPoint')
        if self.addressPointType is not None and 'addressPointType' not in already_processed:
            already_processed.add('addressPointType')
            outfile.write(' addressPointType=%s' % (self.gds_encode(
                self.gds_format_string(quote_attrib(self.addressPointType), input_name='addressPointType')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"', name_='AddressPoint',
                       fromsubclass_=False, pretty_print=True):
        super(AddressPoint, self).exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True,
                                                 pretty_print=pretty_print)
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('addressPointType', node)
        if value is not None and 'addressPointType' not in already_processed:
            already_processed.add('addressPointType')
            self.addressPointType = value
            self.validate_addressPointTypeType(self.addressPointType)  # validate type addressPointTypeType
        super(AddressPoint, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                                    MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass


# end class AddressPoint


class PlanFeatures(GeneratedsSuper):
    """A collection of PlanFeature elementsTypically a PlanFeatures element
    will contain a collection of similar items."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, name=None, desc=None, PlanFeature=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.desc = _cast(None, desc)
        self.desc_nsprefix_ = None
        if PlanFeature is None:
            self.PlanFeature = []
        else:
            self.PlanFeature = PlanFeature
        self.PlanFeature_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PlanFeatures)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PlanFeatures.subclass:
            return PlanFeatures.subclass(*args_, **kwargs_)
        else:
            return PlanFeatures(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_PlanFeature(self):
        return self.PlanFeature

    def set_PlanFeature(self, PlanFeature):
        self.PlanFeature = PlanFeature

    def add_PlanFeature(self, value):
        self.PlanFeature.append(value)

    def insert_PlanFeature_at(self, index, value):
        self.PlanFeature.insert(index, value)

    def replace_PlanFeature_at(self, index, value):
        self.PlanFeature[index] = value

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_desc(self):
        return self.desc

    def set_desc(self, desc):
        self.desc = desc

    def hasContent_(self):
        if (
                self.PlanFeature
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
               name_='PlanFeatures', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PlanFeatures')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PlanFeatures':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PlanFeatures')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PlanFeatures',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PlanFeatures'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            outfile.write(
                ' desc=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.desc), input_name='desc')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
                       name_='PlanFeatures', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for PlanFeature_ in self.PlanFeature:
            namespaceprefix_ = self.PlanFeature_nsprefix_ + ':' if (
                        UseCapturedNS_ and self.PlanFeature_nsprefix_) else ''
            PlanFeature_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PlanFeature',
                                pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            self.desc = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'PlanFeature':
            obj_ = PlanFeature.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PlanFeature.append(obj_)
            obj_.original_tagname_ = 'PlanFeature'


# end class PlanFeatures


class PlanFeature(GeneratedsSuper):
    """A plan feature not otherwise defined by the schema, such as building
    footprints, guard rails, tree lines, lightpoles or signs."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None

    def __init__(self, desc=None, name=None, CoordGeom=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.desc = _cast(None, desc)
        self.desc_nsprefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.CoordGeom = CoordGeom
        self.CoordGeom_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PlanFeature)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PlanFeature.subclass:
            return PlanFeature.subclass(*args_, **kwargs_)
        else:
            return PlanFeature(*args_, **kwargs_)

    factory = staticmethod(factory)

    def get_ns_prefix_(self):
        return self.ns_prefix_

    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix

    def get_CoordGeom(self):
        return self.CoordGeom

    def set_CoordGeom(self, CoordGeom):
        self.CoordGeom = CoordGeom

    def get_desc(self):
        return self.desc

    def set_desc(self, desc):
        self.desc = desc

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def hasContent_(self):
        if (
                self.CoordGeom is not None
        ):
            return True
        else:
            return False

    def export(self, outfile, level, namespaceprefix_='',
               namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
               name_='PlanFeature', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PlanFeature')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PlanFeature':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '',))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PlanFeature')
        if self.hasContent_():
            outfile.write('>%s' % (eol_,))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PlanFeature',
                                pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_,))

    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PlanFeature'):
        if self.desc is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            outfile.write(
                ' desc=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.desc), input_name='desc')),))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(
                ' name=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.name), input_name='name')),))

    def exportChildren(self, outfile, level, namespaceprefix_='',
                       namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2" xmlns:None="urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12" ',
                       name_='PlanFeature', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CoordGeom is not None:
            namespaceprefix_ = self.CoordGeom_nsprefix_ + ':' if (UseCapturedNS_ and self.CoordGeom_nsprefix_) else ''
            self.CoordGeom.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CoordGeom',
                                  pretty_print=pretty_print)

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        if 'prefix' in node.attrib:
            self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('desc', node)
        if value is not None and 'desc' not in already_processed:
            already_processed.add('desc')
            self.desc = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CoordGeom':
            obj_ = CoordGeom.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CoordGeom = obj_
            obj_.original_tagname_ = 'CoordGeom'


# end class PlanFeature


GDSClassesMapping = {
    'Center': PntRefPointType,
    'End': PntRefPointType,
    'InstrumentPoint': PntRefPointType,
    'Start': PntRefPointType,
}

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print(USAGE_TEXT)
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def get_required_ns_prefix_defs(rootNode):
    '''Get all name space prefix definitions required in this XML doc.
    Return a dictionary of definitions and a char string of definitions.
    '''
    nsmap = {
        prefix: uri
        for node in rootNode.iter()
            if 'nsmap' in node.attrib
                for (prefix, uri) in node.nsmap.items()
                    if prefix is not None
    }
    namespacedefs = ' '.join([
        'xmlns:{}="{}"'.format(prefix, uri)
        for prefix, uri in nsmap.items()
    ])
    return nsmap, namespacedefs


def parse(inFileName, silence=True, print_warnings=False):
    global CapturedNsmap_
    gds_collector = GdsCollector_()
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'LandXML'
        rootClass = LandXML
    rootObj = rootClass.factory()
    rootObj.build(rootNode, gds_collector_=gds_collector)
    CapturedNsmap_, namespacedefs = get_required_ns_prefix_defs(rootNode)
    if not SaveElementTreeNode:
        doc = None
        rootNode = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_=namespacedefs,
            pretty_print=True)
    if print_warnings and len(gds_collector.get_messages()) > 0:
        separator = ('-' * 50) + '\n'
        sys.stderr.write(separator)
        sys.stderr.write('----- Warnings -- count: {} -----\n'.format(
            len(gds_collector.get_messages()), ))
        gds_collector.write_messages(sys.stderr)
        sys.stderr.write(separator)
    return rootObj


def parseEtree(inFileName, silence=False, print_warnings=True,
               mapping=None, nsmap=None):
    parser = None
    doc = parsexml_(inFileName, parser)
    gds_collector = GdsCollector_()
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'LandXML'
        rootClass = LandXML
    rootObj = rootClass.factory()
    rootObj.build(rootNode, gds_collector_=gds_collector)
    # Enable Python to collect the space used by the DOM.
    if mapping is None:
        mapping = {}
    rootElement = rootObj.to_etree(
        None, name_=rootTag, mapping_=mapping, nsmap_=nsmap)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
    if not SaveElementTreeNode:
        doc = None
        rootNode = None
    if not silence:
        content = etree_.tostring(
            rootElement, pretty_print=True,
            xml_declaration=True, encoding="utf-8")
        sys.stdout.write(str(content))
        sys.stdout.write('\n')
    if print_warnings and len(gds_collector.get_messages()) > 0:
        separator = ('-' * 50) + '\n'
        sys.stderr.write(separator)
        sys.stderr.write('----- Warnings -- count: {} -----\n'.format(
            len(gds_collector.get_messages()), ))
        gds_collector.write_messages(sys.stderr)
        sys.stderr.write(separator)
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString, silence=False, print_warnings=True):
    '''Parse a string, create the object tree, and export it.

    Arguments:
    - inString -- A string.  This XML fragment should not start
      with an XML declaration containing an encoding.
    - silence -- A boolean.  If False, export the object.
    Returns -- The root object in the tree.
    '''
    parser = None
    rootNode = parsexmlstring_(inString, parser)
    gds_collector = GdsCollector_()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'LandXML'
        rootClass = LandXML
    rootObj = rootClass.factory()
    rootObj.build(rootNode, gds_collector_=gds_collector)
    if not SaveElementTreeNode:
        rootNode = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='xmlns:vic="http://www.landxml.org/schema/LandXML-1.2"')
    if print_warnings and len(gds_collector.get_messages()) > 0:
        separator = ('-' * 50) + '\n'
        sys.stderr.write(separator)
        sys.stderr.write('----- Warnings -- count: {} -----\n'.format(
            len(gds_collector.get_messages()), ))
        gds_collector.write_messages(sys.stderr)
        sys.stderr.write(separator)
    return rootObj


def parseLiteral(inFileName, silence=False, print_warnings=True):
    parser = None
    doc = parsexml_(inFileName, parser)
    gds_collector = GdsCollector_()
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'LandXML'
        rootClass = LandXML
    rootObj = rootClass.factory()
    rootObj.build(rootNode, gds_collector_=gds_collector)
    # Enable Python to collect the space used by the DOM.
    if not SaveElementTreeNode:
        doc = None
        rootNode = None
    if not silence:
        sys.stdout.write('#from landxml import *\n\n')
        sys.stdout.write('import landxml as model_\n\n')
        sys.stdout.write('rootObj = model_.rootClass(\n')
        rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
        sys.stdout.write(')\n')
    if print_warnings and len(gds_collector.get_messages()) > 0:
        separator = ('-' * 50) + '\n'
        sys.stderr.write(separator)
        sys.stderr.write('----- Warnings -- count: {} -----\n'.format(
            len(gds_collector.get_messages()), ))
        gds_collector.write_messages(sys.stderr)
        sys.stderr.write(separator)
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    # import pdb; pdb.set_trace()
    main()

RenameMappings_ = {
}

#
# Mapping of namespaces to types defined in them
# and the file in which each is defined.
# simpleTypes are marked "ST" and complexTypes "CT".
NamespaceToDefMappings_ = {'http://www.landxml.org/schema/LandXML-1.2': [('nonBlankString',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('blankOrDouble',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('latLongAngularType',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('latLongAngle',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('direction',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('distanceRestriction',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('parcelNameRef',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('parcelNameRefs',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('clockwise',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('metArea',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('metLinear',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('metPressure',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('metTemperature',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('metVolume',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('parcelStateType',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('purposeType',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('cgPointID',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('stateType',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('ptype',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('ltype',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('dateOrEmpty',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('surveyType',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('survPntType',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('zoneNumberType',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('Point',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('Point3dOpt',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('Point3dReq',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('Point2dReq',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('instrumentHeightType',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('angularType',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'ST'),
                                                                         ('ParcelType',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'CT'),
                                                                         ('AllocationsParcelsType',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'CT'),
                                                                         ('AllocationsParcelType',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'CT'),
                                                                         ('PntRefPointType',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'CT'),
                                                                         ('PointType',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'CT'),
                                                                         ('PointType3dReq',
                                                                          'xml-gov-au-vic-icsm-eplan-cif-protocol-1.10.xsd',
                                                                          'CT')],
                           'urn:xml-gov-au:vic:icsm:eplan:cif:enumerated-types-ext:1.12': [('addressTypeType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('adminAreaTypeType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('addressPointTypeType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('adminDateTypeType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('annotationType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('equipmentType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('flatTypeType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('floorLevelTypeType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('headOfPowerType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('jurisdictionType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('monumentCondition',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('monumentState',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('monumentType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('observationType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('distObservationType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('parcelClass',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('purpSurvType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('registrationType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('roadNameSuffixType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('roadNameTypeType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('roadTypeType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('surveyFormatType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('surveyorRoleType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('titleTypeType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('useOfParcelType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('horzDatumType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('horzDatumTypeOrEmpty',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('surveyBgDatumType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('vertDatumType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('vertOrderType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('gsModelType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('gsMethodType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('horzOrderType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('horzFixType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('vertFixType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('parcelTypeType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('parcelFormat',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('lineDescType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST'),
                                                                                           ('planFeatureType',
                                                                                            'xml-gov-au-vic-icsm-eplan-cif-enumerated-types-ext-1.12-r1.xsd',
                                                                                            'ST')]}

__all__ = [
    "AddressPoint",
    "AdministrativeArea",
    "AdministrativeDate",
    "AllocationsParcelType",
    "AllocationsParcelsType",
    "Amendment",
    "Annotation",
    "Application",
    "Author",
    "CgPoint",
    "CgPoints",
    "ComplexName",
    "CoordGeom",
    "CoordinateSystem",
    "Curve",
    "FeatureDictionary",
    "FieldNote",
    "HeadOfPower",
    "InstrumentSetup",
    "InstrumentPoint",
    "IrregularLine",
    "LandXML",
    "Line",
    "LocationAddress",
    "Metric",
    "Monument",
    "Monuments",
    "ObservationGroup",
    "ParcelType",
    "Parcels",
    "Personnel",
    "PlanFeature",
    "PlanFeatures",
    "PntList2D",
    "PntList3D",
    "PntRefPointType",
    "PointType",
    "PointType3dReq",
    "PurposeOfSurvey",
    "RedHorizontalPosition",
    "RedVerticalObservation",
    "ReducedArcObservation",
    "ReducedObservation",
    "RoadName",
    "Survey",
    "SurveyHeader",
    "Title",
    "Units"
]
