import networkx as nx
import math
import shapely.geometry as sg
from copy import deepcopy

from utilities.dcmgeometrysdk.geometryfunctions.bearingdistancefunctions import calc_distance, \
    calc_new_point, calc_bearing, calc_inside_360
from utilities.dcmgeometrysdk.geometryfunctions.conversionsfunctions import dd2hp
from utilities.dcmgeometrysdk.geometryfunctions.otherfunctions import previous_and_next


class Misclose:
    def __init__(self, line_order):
        if isinstance(line_order, list):
            line_order = {'ring-0': line_order}
        self.misclose_distance = None
        self.misclose_bearing = None
        self.irregular_line = False
        self.natural_boundary = False
        self.sum_of_distances = 0
        self.calculated_polygon = self.set_calculated_polygon(line_order)
        self.calculated_area = self.set_calcluated_area()
        self.misclose_tolerance = None
        self.closed = self.set_polygon_closed(line_order)
        self.missing_lines = []
        self.has_misclose = False
        self.calculate_misclose(line_order)

    def set_calcluated_area(self):
        if self.calculated_polygon is not None:
            a = self.calculated_polygon.area
        else:
            a = None
        return a

    def calculate_misclose(self, line_order):
        start_e, start_n = 0, 0
        end_e, end_n = 0, 0
        orders = line_order.get('ring-0')
        for line in orders:
            if line.is_nb is True:
                self.natural_boundary = True
            if line.line_type == 'irregular line':
                self.irregular_line = True

            self.sum_of_distances += line.distance
            delta_e, delta_n = calc_new_point(line.dd_bearing, line.distance)
            end_e += delta_e
            end_n += delta_n

        s = sg.Point([start_e, start_n])
        e = sg.Point([end_e, end_n])
        self.misclose_distance = calc_distance(s, e)
        self.misclose_bearing = dd2hp(calc_inside_360(math.degrees(calc_bearing(s, e))))
        self.misclose_tolerance = (.015 + self.sum_of_distances) / 10000

        if ((self.misclose_tolerance < self.misclose_distance) and self.natural_boundary is False
            and self.irregular_line is False and self.closed is True):
            self.has_misclose = True

    @staticmethod
    def set_polygon_closed(line_order):
        line_order = line_order.get('ring-0', [])
        if len(line_order) > 1 and line_order[0].setup_point.point_oid == line_order[-1].target_point.point_oid:
            closed = True
        else:
            closed = False
        return closed

    @staticmethod
    def set_calculated_polygon(line_order):
        polygon = []
        for orders in line_order.values():
            for line in orders:
                for point in line.geometry.coords[:-1]:
                    polygon.append(point)
        if len(polygon) > 2:
            return sg.Polygon(polygon)
        else:
            return None


def loop_checker(geom, start_node, mis_tol=None, line_types=('Ignored', 'Generated')):
    bad_loops = []
    good_loops = []
    bad_candy = {}
    line_lookups = deepcopy(geom.lines)
    ll = {}
    for k, v in line_lookups.items():
        z = deepcopy(v)
        z.flip_direction()
        ll[(k[1], k[0])] = z
    line_lookups = {**line_lookups, **ll}

    from datetime import datetime
    start = datetime.now()
    G = geom.survey_graph.ignore_line_type(line_types=line_types)
    #print(datetime.now() - start, 'graph')
    start = datetime.now()
    if start_node not in G:
        start_node = [i for i in G.nodes][0]
    connection_loops = nx.cycle_basis(G, start_node)
    import numpy as np
    #print(datetime.now() - start, 'cycle')

    start = datetime.now()
    connection_loops = [i for i in connection_loops if len(i) > 1]
    bad_obs = []
    for point_order in connection_loops:
        start = datetime.now()
        reduced_obs = []
        line_order = []
        line_points = []

        i = np.array(point_order)
        j = np.array(point_order)
        j = np.roll(j, -1)
        j = np.vstack((i, j)).transpose().tolist()
        #print(datetime.now() - start, 'transpose')
        start = datetime.now()
        for line_point, nxt in j:
            line = (line_point, nxt)
            line_points.append(line)
            line_id = line_lookups.get(line)
            line_order.append(line_id)
            reduced_obs.append(line_id.name)
        #print(datetime.now() - start, 'line order')
        start = datetime.now()

        f = Misclose({'ring-0':line_order})
        #print(datetime.now() - start, 'misclose')
        start = datetime.now()
        mis_dist = f.misclose_distance
        mis_bearing = f.misclose_bearing

        if mis_tol is None:

            mis_tol = f.misclose_tolerance

        if mis_dist > mis_tol:
            bad_loop = reduced_obs
            good_loop = None
        else:
            good_loop = reduced_obs
            bad_loop = None

        if good_loop is not None:
            good_loops += good_loop
        else:
            if mis_dist > .05:
                rounded_value = ("%.1f" % mis_dist)
            elif mis_dist > .005:
                rounded_value = ("%.2f" % mis_dist)
            else:
                rounded_value = ("%.3f" % mis_dist)

            bad_loops += bad_loop
            bc = bad_candy.get(rounded_value, {})
            value = bc.get('loop', [])
            distances = bc.get('distances', [])
            angles = bc.get('angles', [])

            red_loops = reduced_obs

            value.append(red_loops)
            angles.append(mis_bearing)
            distances.append(mis_dist)
            bad_candy[rounded_value] = {'loop': value, 'angles': angles,
                                        'distances': distances, 'mis_tol': f.misclose_tolerance}

        if len(bad_candy) > 0:
            bad_loops = list(set(bad_loops))
            good_loops = list(set(good_loops))
            bad_obs = []
            for item in bad_loops:
                if item not in good_loops:
                    bad_obs.append(item)
    #print(datetime.now() - start, 'loops')
    start = datetime.now()
    likely_candy = {}
    for key, value in bad_candy.items():
        likely_candy[key] = get_likely_candy(bad_obs, value)

    return likely_candy


def get_likely_candy(bad_obs, value):
    likely = []
    count_of_items = {}
    for item in value.get('loop', []):
        for red_ob in item:
            count = count_of_items.get(red_ob, 0)
            count += 1
            count_of_items[red_ob] = count
    for key1, value1 in count_of_items.items():
        if key1 in bad_obs and value1 == len(value.get('loop', [])):
            likely.append(key1)
    value['likely'] = likely
    return value


def area_tolerances(area, calc_area):
    error = 'Pass'
    difference = abs(area - calc_area)

    percentage = (difference / area) * 100
    # check if difference is greater than 5%
    if percentage >= 5:
        error = 'Warning'

    return error
