from utilities.dcmgeometrysdk.dcmgeometry.points import PointGeom
from utilities.dcmgeometrysdk.dna.dnawriters import DNADirection, DNADirectionSets, DNAAngle, DNADistances, \
    DNAPQMeasure, DNAGXYMeasure, DNAGXYMeasureSet
from utilities.dcmgeometrysdk.dcmgeometry.lines import LineGeom
from utilities.dcmgeometrysdk.geometryfunctions.conversionsfunctions import hp2dd


def generate_lines(direction_sets=None, distances=None, pqs=None, stns=None):
    def count_use(point_name, point_use):
        count = point_use.get(point_name, 0)
        point_use[point_name] = count + 1
        return point_use
    line_info = {}
    for direction_set in direction_sets:
        for direction in direction_set.direction_set:
            direction: DNADirection
            line = LineGeom()
            sp = PointGeom()
            sp.name = direction.ip
            tp = PointGeom()
            tp.name = direction.to_station
            line.setup_point = sp
            line.target_point = tp
            line.hp_bearing = direction.hp_bearing
            line.dd_bearing = hp2dd(line.hp_bearing)
            line.azimuth_type = 'DNA Measure'
            key = (line.setup_point.name, line.target_point.name)
            ex_line = line_info.get(key)
            rev = False
            if ex_line is None:
                ex_line = line_info.get((key[1], key[0]), [])
                rev = True
            if rev is False or len(ex_line) == 0:
                ex_line.append(line)
                line_info[key] = ex_line
            else:
                ex_line.append(line)
                line_info[(key[1], key[0])] = ex_line

    used_distance = set()
    for distance in distances:
        distance: DNADistances
        sp = distance.setup
        tp = distance.target
        if (sp, tp) in used_distance or (tp, sp) in used_distance:
            pass
        rev = False
        ex_line = line_info.get((sp, tp))
        if ex_line is None:
            ex_line = line_info.get((tp, sp))
            rev = True
        if ex_line is None:
            ex_line = []
        processed = False
        for line in ex_line:
            if line.distance is None:
                line.distance = distance.distance
                line.distance_type = 'DNA Measure'
                processed = True
                break
        if processed is False:
            line = LineGeom()
            ssp = PointGeom()
            ssp.name = sp
            ttp = PointGeom()
            ttp.name = tp
            line.setup_point = ssp
            line.target_point = ttp
            ex_line.append(line)
        if rev is False:
            line_info[(sp, tp)] = ex_line
            used_distance.add((sp, tp))
        else:
            line_info[(tp, sp)] = ex_line
            used_distance.add((tp, sp))
    #line_info = {k: v for k, v in line_info.items() if v.distance is not None and v.dd_bearing is not None}
    return line_info

class ReadMSRFiles:
    def __init__(self, msrs, process=False, area_id=None, aws=False):
        # area id is the block or zone that the file is coming from.
        self.y_measures = []
        self.msrs = msrs
        self.direction_sets = []
        self.distances = []
        self.pqs = []
        self.angles = []
        self.area_id = area_id
        self.stations_used = set()
        if process is True:
            self.process_file(aws)
            for item in self.y_measures:
                for i in item.stations:
                    self.stations_used.add(i)

    def process_file(self, aws=False):
        dirset = None
        for msr in self.msrs:
            if aws is False:
                with open(msr, 'r') as open_file:
                    lines = open_file.readlines()
            else:
                lines = (msr[u'Body']).read().decode('utf-8').splitlines(True)
            order = 0
            prev_line = None
            for line in lines:
                oline = line
                line = line.ljust(200)
                if line[0] == 'D':
                    prev_line = line[0]
                    ip = line[2:21].strip()
                    if len(ip) > 0:
                        oip = ip
                        order = 0
                        nd = 1
                        if dirset is not None:
                            self.direction_sets.append(dirset)
                        dirset = DNADirectionSets()
                    else:
                        order += 1
                    dirset, nd = self.process_direction(line, order, dirset=dirset, nd=nd, ip=oip)

                elif line[0] == 'S':
                    if prev_line == 'D' and dirset is not None and dirset not in self.direction_sets:
                        self.direction_sets.append(dirset)
                    prev_line = line[0]
                    self.process_distance(line)

                elif line[0] in ['P', 'Q']:
                    if prev_line == 'D' and dirset is not None and dirset not in self.direction_sets:
                        self.direction_sets.append(dirset)
                    prev_line = line[0]
                    self.process_pqs(line)

                elif line[0] in ['Y']:
                    self.process_y_measures(oline, lines)
                else:
                    prev_line = line[0]


            if prev_line == 'D' and dirset is not None and dirset not in self.direction_sets:
                self.direction_sets.append(dirset)

    def process_direction(self, line, order=0, dirset=None, nd=1, ip=''):
        dir_type = line[0]
        ignore = line[1].strip()
        sp = line[21:40].strip()
        lip = line[2:21].strip()
        if len(lip) > 0:
            nd = line[40:61].strip()
        else:
            sp = line[42:61].strip()

        degrees = line[76:80].strip()
        minutes = line[80:82].strip()
        seconds = line[82:90].strip().replace('.', '')
        hp_bearing = degrees + '.' + minutes + seconds
        std = line[90:99].strip()
        epoch = line[122:142].strip()
        # extending this out past limit, due to output bug in dynadjust
        db_id = line[142:154].strip()

        direction = DNADirection(ip, sp, nd, std, hp_bearing, order, ignore, db_id)
        self.stations_used.add(ip)
        self.stations_used.add(sp)
        dirset.add_direction_to_dir_set(direction)
        return dirset, nd

    def process_distance(self, line):
        dir_type = line[0]
        ignore = line[1].strip()
        ip = line[2:22].strip()
        sp = line[22:42].strip()
        dist = line[62:76].strip()
        std = line[90:102].strip().split(' ')[0].strip()
        extra = 0
        if len(std) > 9:
            extra = len(std) - 9
        ins_height = line[99 + extra:106 + extra].strip()
        targ_height = line[106 + extra:113 + extra].strip()
        epoch = line[122 + extra:142 + extra].strip()
        # extending this out past limit, due to output bug in dynadjust
        db_id = line[142 + extra:154 + extra].strip()
        distance = DNADistances(ins_height=ins_height, targ_height=targ_height, ignore=ignore)
        distance.set_distance_from_values(dist, std, ip, sp, db_id=db_id)
        self.distances.append(distance)
        self.stations_used.add(ip)
        self.stations_used.add(sp)

    def process_pqs(self, line):
        pq = DNAPQMeasure()
        pq.measure = line[0]
        pq.ignore = line[1].strip()
        pq.station_name = line[2:21].strip()
        pq.coordinate = line[61:76].strip()
        pq.std = line[90:99].strip()
        # extending this out past limit, due to output bug in dynadjust
        pq.db_id = line[142:154].strip()
        self.pqs.append(pq)
        self.stations_used.add(pq.station_name)

    def process_y_measures_first(self, line):
        gxy = DNAGXYMeasureSet()
        gxy.measure_type = line[0]
        gxy.ignore = line[1].strip()
        gxy.coordsys = line[22:42].strip()
        gxy.cluster_count = line[42:62]
        gxy.stations = []
        gxy.v_scale = line[62:72].strip()
        gxy.p_scale = line[72:82].strip()
        gxy.l_scale = line[82:92].strip()
        gxy.h_scale = line[92:102].strip()
        gxy.reference_frame = line[102:122].strip()
        gxy.epoch = line[122:142].strip()
        gxy.db_id = line[142:154].strip()
        return gxy

    def process_y_measure(self, line, xyz, xcovs, ycovs, zcovs):
        coord = line[62:82].strip()
        if len(coord) > 0:
            xyz.append(coord)
        xcov = line[82:102].strip()
        ycov = line[102:122].strip()
        zcov = line[122:142].strip()
        if len(xcov) > 0:
            xcovs.append(xcov)
        if len(ycov) > 0:
            ycovs.append(ycov)
        if len(zcov) > 0:
            zcovs.append(zcov)
        return xyz, xcovs, ycovs, zcovs

    def process_y_measures(self, oline, lines):
        def update_station(station, xyz_, xcovs_, ycovs_, zcovs_):
            station.xyz = xyz_
            station.xcovs = xcovs_
            station.ycovs = ycovs_
            station.zcovs = zcovs_
            return station


        xcovs = []
        ycovs = []
        zcovs = []
        xyz = []
        new_station = None
        y_measure = None
        for nl in lines[lines.index(oline):]:
            onl = nl
            nl = nl.ljust(200)
            stn_name = nl[2:21].strip()
            if nl[0] in ['Y'] and len(stn_name) > 0:
                if y_measure is not None:
                    self.y_measures.append(y_measure)
                new_station = DNAGXYMeasure()
                new_station.station = stn_name
                new_station.ignore = nl[1].strip()
                y_measure = self.process_y_measures_first(nl)
            elif nl[0] == ' ' and len(stn_name) == 0 and len(nl.strip()) > 0:
                xyz, xcovs, ycovs, zcovs = self.process_y_measure(nl, xyz, xcovs, ycovs, zcovs)

            elif nl[0] == ' ' and len(stn_name) > 0:
                if y_measure and new_station:
                    update_station(new_station, xyz, xcovs, ycovs, zcovs)
                    xcovs = []
                    ycovs = []
                    zcovs = []
                    xyz = []
                    new_station = DNAGXYMeasure()
                    new_station.station = stn_name
                    new_station.ignore = nl[1].strip()
            elif onl == lines[-1]:
                if y_measure is not None:
                    if new_station is not None:
                        new_station = update_station(new_station, xyz, xcovs, ycovs, zcovs)
                        if new_station not in y_measure.stations:
                            y_measure.stations.append(new_station)
                    self.y_measures.append(y_measure)
            else:
                if y_measure is not None:
                    if new_station is not None:
                        new_station = update_station(new_station, xyz, xcovs, ycovs, zcovs)
                        if new_station not in y_measure.stations:
                            y_measure.stations.append(new_station)
                    self.y_measures.append(y_measure)
                    break

    def generate_lines(self):
        return generate_lines(self.direction_sets, self.distances )





