from utilities.dcmgeometrysdk.landxml.landxml import ParcelType, Line, Curve, IrregularLine
from utilities.dcmgeometrysdk.geometryfunctions.otherfunctions import previous_and_next
from utilities.dcmgeometrysdk.geometryfunctions.bearingdistancefunctions import process_angles
from utilities.dcmgeometrysdk.geometryfunctions.transformationfunctions import cm_line_in_crs, \
                                                                                transform_coordinates, estimate_zone
from utilities.dcmgeometrysdk.dcmgeometry.points import PointGeom
from utilities.dcmgeometrysdk.dcmgeometry.lines import LineGeom
from utilities.dcmgeometrysdk.geometryfunctions.misclosefunctions import Misclose
from utilities.dcmgeometrysdk.landxml.landxml import Curve
import shapely.geometry as sg
import shapely.ops as so
from copy import deepcopy


class PolygonGeom:
    def __init__(self, polygon=None, lines=None, points=None, irregular_lines=None):
        self.all_children = []
        self.geometry = None
        self.closed = True
        self.part = False
        self.multipart = False
        self.parent = None
        self.children = {}
        self.valid_geom = None
        self.crs = None
        self.easement = False
        self.contains_nat_bdy = False
        self.polygon_points = {}
        self.inner_angles = {}
        self.coord_lookup = None
        self.point_lookup = None
        self.original_geom = None
        self.coord_decimals = None
        self.polygon_notations = []
        self.parcel_arcs = {}
        self.arc_rot_errors = []
        self.arc_rad_errors = []
        self.null_geometry = False
        self.generated_line_order = {}
        self.circle_estimates = True
        self.irregular_lines = irregular_lines

        if isinstance(polygon, ParcelType):
            self.line_order = self.set_line_order(polygon, lines)
            self.stated_area = polygon.area
            self.parcel_class = polygon.class_
            self.parcel_state = polygon.state
            self.parcel_type = polygon.parcelType
            self.parcel_use = polygon.useOfParcel
            self.parcel_format = polygon.parcelFormat
            self.calc_area = self.get_area()
            self.name = polygon.name
            self.desc = polygon.desc
            self.misclose = self.get_misclose()

            polygon_centre = polygon.Center
            if len(polygon_centre) > 0:
                self.centre_point = polygon_centre[0].pntRef
            else:
                self.centre_point = None

        else:
            self.centre_point = None
            self.stated_area = None
            self.parcel_class = None
            self.parcel_state = None
            self.parcel_format = None
            self.parcel_type = None
            self.calc_area = None
            self.name = None
            self.id = None
            self.desc = None
            self.misclose = None
            self.line_order = {}

    def set_geometry(self, geometry, points=None, reset_lookup=True):
        if self.geometry is None:
            self.original_geom = geometry
        self.geometry = geometry
        self.set_inner_angles(points, reset_lookup=reset_lookup)
        self.calc_area = self.get_area()
        self.closed = self.set_is_closed()

    def create_polygon(self, geometry, points=None, name=None, crs=None, coord_decimals=None, reset_lookup=False):
        self.crs = crs
        if coord_decimals is not None:
            self.coord_decimals = coord_decimals
        self.set_geometry(geometry, points, reset_lookup)
        self.calc_area = self.get_area()
        self.closed = self.set_is_closed()
        self.set_polygon_name(name)

        if self.line_order is None or len(self.line_order) == 0:
            self.line_order = self.generated_line_order

    # def set_original_geometry(self):
    #     return self.geometry

    def set_polygon_name(self, name):
        if name is not None:
            self.name = name
        # else:
        #     raise TypeError()

    def set_is_closed(self):
        if self.geometry is not None:
            return self.geometry.is_valid
        else:
            return False

    def get_area(self):
        if self.geometry is not None:
            return self.geometry.area
        # else:
        #     raise TypeError()

    def reset_geometry(self):
        # this probably needs to update everything?
        self.geometry = self.original_geom
        self.closed = self.set_is_closed()
        self.calc_area = self.get_area()

    def set_coord_lookup(self, points, reset=True):
        if self.coord_lookup is None or reset is True:
            if self.coord_decimals is None:
                self.coord_lookup = {tuple(v.geometry.coords)[0]: v.name for v in points.values()}
            else:
                self.coord_lookup = {}
                for v in points.values():
                    x = round(v.geometry.x, self.coord_decimals)
                    y = round(v.geometry.y, self.coord_decimals)
                    self.coord_lookup[(x, y)] = v.name
        if self.point_lookup is None or reset is True:
            self.point_lookup = {v.name: v.geometry for v in points.values()}

    def set_polygon_points(self, ring, start=0, points=None):
        if points is None:
            points = {}
        e = 0
        for e, i in enumerate(ring):
            point = PointGeom()
            point.point_oid = e + start
            point.name = 'CGPNT-' + str(point.point_oid)
            point.original_point_oid = e + start
            if self.coord_decimals is not None:
                i = (round(i[0], self.coord_decimals), round(i[1], self.coord_decimals))
            point.geometry = sg.Point(i)
            point.original_geom = sg.Point(i)
            points[point.point_oid] = point

        return e + start, points

    def generate_polygon_points(self, points=None, reset_lookup=True):
        # generate point objects for polygon that does not have points
        # TODO this should use the point class will impact some other functions before we change it
        if points is None:
            exterior = self.geometry.exterior.coords[:]
            start, points = self.set_polygon_points(exterior)
            interiors = self.geometry.interiors
            for ring in interiors:
                for i in ring.coords[:]:
                    if not isinstance(i, list):
                        i = [i]
                    start, points = self.set_polygon_points(i, start, points)

        self.set_coord_lookup(points, reset=reset_lookup)

        # exterior
        exterior = []
        all_points = []
        last_i = None
        if hasattr(self.geometry, 'exterior'):
            for i in self.geometry.exterior.coords[:]:
                if self.coord_decimals is not None:
                    i = (round(i[0], self.coord_decimals), round(i[1], self.coord_decimals))
                point_name = self.coord_lookup.get(i)
                if point_name is not None and i != last_i:
                    exterior.append(point_name)
                last_i = i

        all_points += exterior
        # interiors
        interiors = []
        if hasattr(self.geometry, 'interiors'):
            for ring in self.geometry.interiors[:]:
                interior = []
                last_i = None
                for i in ring.coords[:]:
                    if self.coord_decimals is not None:
                        i = (round(i[0], self.coord_decimals), round(i[1], self.coord_decimals))
                    point_name = self.coord_lookup.get(i)
                    if point_name is not None and i != last_i:
                        interior.append(point_name)
                    last_i = i
                all_points += exterior
                interiors.append(list(interior))
        self.polygon_points = {'exterior': exterior, 'interiors': interiors, 'all': all_points}

    def set_values(self, p, i, n, ring, ring_no, line_order):
        ia = process_angles(p, i, n, ring, self.point_lookup, circle_estimates=self.circle_estimates)
        self.inner_angles[i] = ia
        line = LineGeom()
        sp = PointGeom()
        tp = PointGeom()
        sp.geometry = self.point_lookup.get(i)
        if n is not None:
            tp.geometry = self.point_lookup.get(n)
            tp.name = n
        elif ring[0] != i:
            tp.geometry = self.point_lookup.get(ring[0])
            tp.name = ring[0]
        else:
            tp = None
        if tp is not None:
            sp.crs = self.crs
            tp.crs = self.crs
            sp.name = i

            line.create_line_from_coords(setup_point=sp, target_point=tp,
                                         name=str(len(line_order)), line_type='Generated', crs=self.crs)

            line.create_bearing_distance_from_geometry()

            line_order.append(line)

        self.generated_line_order[f'ring-{str(ring_no)}'] = line_order

    def set_inner_angles(self, points=None, reset_lookup=True):
        self.generate_polygon_points(points, reset_lookup)
        exterior = self.polygon_points.get('exterior')
        interiors = self.polygon_points.get('interiors')
        ring_no = 0
        line_order = []
        for prev, item, nxt in previous_and_next(exterior):
            self.set_values(prev, item, nxt, exterior, ring_no, line_order)

        for interior in interiors:
            ring_no += 1
            for prev, item, nxt in previous_and_next(interior):
                self.set_values(prev, item, nxt, interior, ring_no, line_order)

    def get_misclose(self, lines=None, points=None):
        if self.line_order is None:
            self.set_line_order(lines=lines, points=points)

        if self.line_order is not None:
            misclose = Misclose(self.line_order)
            return misclose

    def set_line_order(self, polygon=None, lines=None):
        lo = []
        if polygon is not None:
            if polygon.parcelType != 'Multipart':
                if (polygon.class_ == 'Easement' and polygon.parcelFormat == 'Standard') is False and len(
                        polygon.CoordGeom) > 0:
                    if len(polygon.CoordGeom) > 0:
                        coord_geom = polygon.CoordGeom[0]
                        # lo = sorted([(x.polygon_index, x) for x in coord_geom.Line +
                        #       coord_geom.Curve + coord_geom.IrregularLine])

                        lo = []

                        for x in coord_geom.Line + coord_geom.Curve + coord_geom.IrregularLine:
                            lls = []
                            if isinstance(x, IrregularLine):
                                index = coord_geom.IrregularLine.index(x)
                                irregular_lines = self.irregular_lines.get(index)
                                for i in irregular_lines:
                                    s = i.setupID.replace('IS', 'CGPNT')
                                    t = i.targetSetupID.replace('IS', 'CGPNT')
                                    lls.append(lines.get((s, t)))
                            else:
                                line = lines.get((x.Start.pntRef, x.End.pntRef))
                                if line is None or \
                                        (line.is_arc is False and isinstance(x, Curve)) or \
                                        (line.is_arc is True and isinstance(x, (Line, IrregularLine))):

                                    line = deepcopy(lines.get((x.End.pntRef, x.Start.pntRef)))
                                    if line is not None:
                                        line.flip_direction()
                                    else:
                                        print((x.End.pntRef, x.Start.pntRef))
                                lls = [line]
                            c = 0
                            for line in lls:
                                if line is not None:
                                    if isinstance(x, Curve):
                                        self.parcel_arcs[(x.Start.pntRef, x.End.pntRef)] = x
                                        if x.rot != line.rot:
                                            self.arc_rot_errors.append((line, polygon))
                                        if x.radius != line.radius:
                                            self.arc_rad_errors.append((line,polygon))
                                    pindex = x.polygon_index + c
                                    c += .0001
                                    lo.append((pindex, line))
                        lo = [l[1] for l in sorted(lo)]
        else:
            x = self.geometry
            # TODO need to handle manually setting a line order here. Will involve generating lines for the polygon....
            pass

        return {'ring-0':lo}

    def add_polygon_notation(self, notation_type, notation):
        n = {'notation_type': notation_type,
             'notation': notation}
        self.polygon_notations.append(n)

    def update_line_order(self, lines):
        if self.line_order is None:
            print(self.name)
        for k, v in self.line_order.items():
            nv = []
            for line in v:
                s = line.setup_point
                t = line.target_point
                nl = lines.get((s.name, t.name))
                if nl is None:
                    nl = deepcopy(lines.get((t.name, s.name)))
                    nl.flip_direction()
                nv.append(nl)
            self.line_order[k] = nv

    def update_polygon_geom_from_lines(self):
        interiors = []
        exterior = []

        for ring, lo in self.line_order.items():
            value = []
            for l in lo:
                if l == lo[0]:
                    value.extend(l.geometry.coords[:])
                else:
                    value.extend(l.geometry.coords[1:])
            if ring == 'ring-0':
                exterior = value
            else:
                if len(value) > 2:
                    interiors.append(value)

        if len(exterior) == 2:
            bd = cm_line_in_crs(self.crs)
            exterior = sg.LineString(exterior).buffer(bd).exterior.coords[:]
        elif len(exterior) == 1:
            bd = cm_line_in_crs(self.crs)
            exterior = sg.Point(exterior).buffer(bd).exterior.coords[:]

        if len(interiors) > 0:
            self.geometry = sg.Polygon(shell=exterior, holes=interiors)
        else:
            self.geometry = sg.Polygon(shell=exterior)

    def find_all_children(self, some_dict=None, clear_existing=True):
        if some_dict is None:
            some_dict = self.children
        if clear_existing is True:
            self.all_children = []

        for key, value in some_dict.items():
            self.all_children.append(key)
            if len(value.children) > 0:
                self.find_all_children(value.children, clear_existing=False)
        return self.all_children

    def set_geometry_from_children(self, existing_polygons):
        if len(self.children) > 0:
            self.original_geom = self.geometry
            geoms = []
            self.find_all_children()
            for i in self.all_children:
                geom = existing_polygons.get(i).geometry
                if geom is not None:
                    if isinstance(geom, sg.MultiPolygon):
                        for g in geom.geoms:
                            geoms.append(g)
                    elif geom.is_empty is False:
                        geoms.append(geom)
            self.geometry = so.unary_union(geoms)
            self.calc_area = self.geometry.area




