"""
/***************************************************************************
 LandXML2QGIS
                                 A QGIS plugin
 Import Vic, NSW LandXML into QGIS temp layers
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-08-22
        git sha              : $Format:%H$
        copyright            : (C) 2019 by James Leversha, Department of Environment, Land, Water and Planning
        email                : james.k.leversha@delwp.vic.gov.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis.core import QgsGeometry, QgsField, QgsVectorLayer, QgsFeature, QgsProject, QgsCoordinateReferenceSystem, \
    QgsMapLayerStyleManager, QgsMapLayerStyle
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog, QMessageBox
from qgis.PyQt import QtWidgets
from qgis.PyQt import QtCore
from PyQt5.QtCore import QVariant
from PyQt5.QtCore import Qt

import sys
import platform
import csv
import os.path
import os
from inspect import getsourcefile
import pickle
import requests
import time

if '..' not in sys.path:
    sys.path.append("..")

if os.path.split(os.path.abspath(getsourcefile(lambda: 0)))[0] not in sys.path:
    sys.path.append(os.path.split(os.path.abspath(getsourcefile(lambda: 0)))[0])

from add_wheels import add_wheels

add_wheels()

import boto3
import botocore
import s3transfer
from utilities.dcmgeometrysdk.landxml import landxml
from utilities.dcmgeometrysdk.dcmgeometry.geometry import Geometries
from utilities.dcmgeometrysdk.dna.dnawriters import DNAWriters
from utilities.dcmgeometrysdk.dna.dnarunner import DNARunner
from utilities.dcmgeometrysdk.dna.dnareaders import DNAReaders
from qgiswriters import *

# Initialize Qt resources from file resources.py
from resources import *

# Import the code for the dialog
from landxml2qgis_dialog import LandXML2QGISDialog

from pathlib import Path
from copy import deepcopy
from datetime import datetime


class LandXML2QGIS:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'LandXML2QGIS_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&LandXML2QGIS')
        self.cwd = os.path.split(os.path.abspath(getsourcefile(lambda: 0)))[0]
        self.swing = None
        self.swing_value = None
        self.download_only = None
        self.recalc = None
        self.dna = None
        self.dna_dir = None
        self.only_dna = None
        self.loops = None
        self.points = None
        self.polygons = None
        self.lines = None
        self.out_crs = 7899
        self.filenames = []
        self.out_paths = {}
        self.main_plan = None
        self.max_iter = 100
        self.it_thresh = .0005
        self.multi_thread = False
        self.apu = False
        self.mis_tol = .1
        self.starting_point = None
        this_dir = os.path.dirname(os.path.realpath(__file__))
        self.profile_loc = os.path.join(this_dir, 'utilities/dcmgeometrysdk/resources/aprioris.json')
        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('LandXML2QGIS', message)

    def add_action(
            self,
            icon_path,
            text,
            callback,
            enabled_flag=True,
            add_to_menu=True,
            add_to_toolbar=True,
            status_tip=None,
            whats_this=None,
            parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToVectorMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/landxml2qgis/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'LandXML2QGIS'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginVectorMenu(
                self.tr(u'&LandXML2QGIS'),
                action)
            self.iface.removeToolBarIcon(action)

    def get_zone(self):
        pass

    def run_dna(self, xid, ref, geom):
        pass

    def set_starting_point(self):
        sp = self.dlg.startingPointEdit.text()
        try:
            return int(sp)
        except Exception:
            return None

    def save_settings(self):
        self.dlg.my_settings.setValue('xml_location', self.dlg.lineEdit.text())
        self.dlg.my_settings.setValue('dna_dir', self.dlg.lineEdit_2.text())
        self.dlg.my_settings.setValue('credentials_file', self.dlg.lineEdit_5.text())
        self.dlg.my_settings.setValue('dna_outputs', self.dlg.lineEdit_3.text())
        self.dlg.my_settings.setValue('max_iter', self.dlg.lineEdit_8.text())
        self.dlg.my_settings.setValue('iter_thresh', self.dlg.lineEdit_9.text())
        self.dlg.my_settings.setValue("recalc", self.dlg.recalcCheckBox.isChecked())
        self.dlg.my_settings.setValue("multi-thread", self.dlg.multiThreadCheckBox.isChecked())
        self.dlg.my_settings.setValue("docker", self.dlg.dockerCheckBox.isChecked())

        # style files

    def set_styles(self):

        poly_style = Path(self.cwd, 'styles', 'polygon.qml')
        admin_style = Path(self.cwd, 'styles', 'admin.qml')
        dna_poly_style = Path(self.cwd, 'styles', 'polygon_dna.qml')
        point_style = Path(self.cwd, 'styles', 'point.qml')
        dna_point_style = Path(self.cwd, 'styles', 'point_dna.qml')
        line_style_m = Path(self.cwd, 'styles', 'line.qml')
        line_style_lf = Path(self.cwd, 'styles', 'line_lf.qml')
        arc_style_m = Path(self.cwd, 'styles', 'arc.qml')
        arc_style_lf = Path(self.cwd, 'styles', 'arc_lf.qml')
        loop_style = Path(self.cwd, 'styles', 'loop.qml')
        outlier_style = Path(self.cwd, 'styles', 'out.qml')
        dna_out_style = Path(self.cwd, 'styles', 'out_dna.qml')
        line_adj_style = Path(self.cwd, 'styles', 'line_adj.qml')
        point_adj_style = Path(self.cwd, 'styles', 'line_adj.qml')
        dna_easement_style = Path(self.cwd, 'styles', 'dna_easement.qml')
        easement_style = Path(self.cwd, 'styles', 'easement.qml')

        styles = {'vl_poi': point_style, 'vl_lin_m': line_style_m, 'vl_arc': arc_style_m, 'vl_pol': poly_style,
                  'vl_loop': loop_style, 'vl_lin_lf': line_style_lf, 'vl_arc_lf': arc_style_lf, 'vl_admin': admin_style,
                  'vl_pol_dnaadj': dna_poly_style, 'vl_poi_dnaadj': dna_point_style,
                  'vl_lin_dnaadj': line_style_m, 'vl_arc_dnaadj': arc_style_m, 'vl_loop_dnaadj': loop_style,
                  'vl_out_dnaadj': dna_out_style, 'vl_lin_dnaadj_lf': line_style_lf, 'vl_arc_dnaadj_lf': arc_style_lf,
                  'vl_lin_adj': line_adj_style, 'vl_poi_adj': point_adj_style, 'vl_ease_dnaadj': dna_easement_style,
                  'vl_ease': easement_style}
        for k, v in styles.items():
            if v.exists() is False:
                styles[k] = None
        return styles

    def set_box_values(self):
        self.swing = self.dlg.swingCheckBox.isChecked()
        if self.swing is True:
            swing_value = self.dlg.swingValue.text()
            if swing_value == 'approximate':
                swing_value = None
            else:
                try:
                    swing_value = float(swing_value)
                except (ValueError, TypeError):
                    QMessageBox.information(None, "Swing Value",
                                            'Swing Value needs to be the word "approximate" or a number, '
                                            'setting to "approximate"')
                    swing_value = None
            self.swing_value = swing_value

        # self.download_only = self.dlg.downloadOnlyCheckBox.isChecked()
        self.recalc = self.dlg.recalcCheckBox.isChecked()
        self.dna = self.dlg.runDNACheckBox.isChecked()
        self.only_dna = self.dlg.onlyDNACheckBox.isChecked()
        self.multi_dna = self.dlg.multiDNACheckBox.isChecked()
        self.loops = self.dlg.loopCheckBox.isChecked()
        self.points = self.dlg.pointCheckBox.isChecked()
        self.polygons = self.dlg.polygonCheckBox.isChecked()
        self.lines = self.dlg.lineCheckBox.isChecked()
        self.export_eplan = self.dlg.exportCheckBox.isChecked()
        self.export_only = self.dlg.exportOnlyCheckBox.isChecked()
        self.constrained_select = None
        self.starting_point = self.set_starting_point()
        self.set_out_zone()

    def set_out_zone(self):
        out_text = str(self.dlg.zoneComboBox.currentText())
        if out_text == '55 - MGA2020':
            self.out_crs = 7855
        elif out_text == '54 - MGA2020':
            self.out_crs = 7854
        elif out_text == '56 - MGA2020':
            self.out_crs = 7856
        elif out_text == '53 - MGA2020':
            self.out_crs = 7853
        elif out_text == 'VicGrid - MGA2020':
            self.out_crs = 7899
        elif out_text == 'GDA2020':
            self.out_crs = 7844

    def download_file(self, s3, item, filename, suf):
        item = item.split(r'/object/')[-1]
        bucket, sep, key = (item.partition('/'))
        try:
            s3.Bucket(bucket).download_file(key, str(Path(filename + suf)))
        except Exception as e:
            QMessageBox.information(None, "DEBUG:", f'{key} doesnt exist in AWS {e}')

    def get_plan_from_spi(self, f, dynamodb):

        spi_table_name = 'dcm-prd-spiDetails'
        spi_table = dynamodb.Table(spi_table_name)

        response = spi_table.get_item(Key={'spi': f})
        filename = response.get('Item', {}).get('diagram_location')

        return filename

    def download_from_s3(self, awsnames=None):

        cf = self.dlg.lineEdit_5.text()
        with open(cf, 'r') as open_csv:
            a = csv.DictReader(open_csv)
            row = [row for row in a][0]
            awsid = row['Access key ID']
            awssk = row['Secret access key']


        plans = []
        region = 'ap-southeast-2'
        out_path_text = Path(self.dlg.lineEdit_3.text())
        session = boto3.Session(aws_access_key_id=awsid,
                                aws_secret_access_key=awssk, region_name=region)
        dynamodb = session.resource('dynamodb', region)

        filenames = []
        if awsnames is not None:
            for f in awsnames:
                if '\\' in f:
                    f = self.get_plan_from_spi(f, dynamodb)
                filenames.append(f)

        s3 = session.resource('s3')
        table_name = 'dcm-prd-planBasedonSPI'
        table = dynamodb.Table(table_name)

        missing_xmls = []
        for filename in filenames:
            afr = None
            if '_AFR' in filename:
                filename, sep, afr = filename.rpartition('_')

            out_path = Path(out_path_text, filename)
            out_path.mkdir(exist_ok=True, parents=True)

            response = table.get_item(Key={'planNumber': filename})

            if afr is not None:
                xml = response.get('Item', {}).get('afr_additional_records', {}).get(afr.upper())
                xml = xml.get('current_xml_object_url')

                path_name = Path(str(out_path), 'AFRs', f'{afr}')
                path_name.mkdir(exist_ok=True, parents=True)
                file_details = str(Path(path_name, filename + f'_{afr}'))
            else:
                xml = response.get('Item', {}).get('current_xml_object_url')
                file_details = str(Path(out_path, filename))

            over = self.dlg.overwriteCheckBox.isChecked()

            if xml is not None:
                if over is True or Path(file_details + '.xml').exists() is False:
                    self.download_file(s3, xml, file_details, '.xml')
            else:
                missing_xmls.append(filename)

            plans.append(str(Path(file_details + '.xml')))

        if len(missing_xmls) > 0:
            missing_xmls = '\n'.join(missing_xmls)
            QMessageBox.information(None, "DEBUG:", f'No Plan PDF Available for {missing_xmls}')

        return plans

    def get_file_names(self):
        repo = True
        fname = None
        fnames = []
        if fname is None:
            fname = self.dlg.lineEdit.text()

        if len(fname) > 0:
            fnames.append(fname)

        folders = self.dlg.lineEdit_4.text()
        if len(folders) > 0:
            for directory, fs, filenames in os.walk(str(folders)):
                fnames.extend([str(Path(directory, f)) for f in filenames if f.endswith(('.xml', '.adj'))])

        cf = self.dlg.lineEdit_5.text().strip()
        aws_names = [i for i in self.dlg.AWS_LineEdit.text().split(',') if len(i) > 0]

        if len(aws_names) > 0:
            fnames = []
            if len(cf) > 0:
                fnames.extend(self.download_from_s3(aws_names))
            else:
                QMessageBox.information(None, "No credendial csv",
                                        'Please put a location of your credentials file')
                repo = False

        elif len(fnames) == 0:
            QMessageBox.information(None, "No plan",
                                    'Couldnt find plan in the repository')
            repo = False


        if len(fnames) > 0:
            self.filenames = fnames
            self.main_plan = os.path.split(fnames[0])[-1][:-4]
        elif repo is True:
            self.filenames = []
            self.main_plan = None
            QMessageBox.information(None, "No plan", 'You need to type in a plan')

    def set_outpaths(self):
        self.out_paths = {}
        out_path_text = Path(self.dlg.lineEdit_3.text())
        for fname in self.filenames:
            xml_name = os.path.split(fname)[-1][:-4]
            if '_AFR' in xml_name:
                xml_name, sep, afr = xml_name.partition('_')
                out_path = Path(out_path_text, xml_name, 'AFRs', afr,
                                datetime.now().strftime('%Y-%m-%d_%H%M%S'))
            else:
                out_path = Path(out_path_text, xml_name,
                                datetime.now().strftime('%Y-%m-%d_%H%M%S'))
            self.out_paths[fname] = out_path

        out_path = Path(out_path_text, 'grouped', datetime.now().strftime('%Y-%m-%d_%H%M%S'))
        self.out_paths['grouped'] = out_path

    def get_dna_settings(self):

        if self.dlg.lineEdit_7.text() != 'default':
            self.profile_loc = self.dlg.lineEdit_8.text()

        if os.path.exists(self.profile_loc) is False:
            QMessageBox.information(None, "Apriori",
                                    f'Apriori Profile location does not exist {self.profile_loc}')
        try:
            if self.dlg.lineEdit_8.text() != 'default':
                self.max_iter = int(self.dlg.lineEdit_8.text())
        except ValueError:
            QMessageBox.information(None, "Iterations",
                                    f'Iterations needs to be a number setting to {self.max_iter}')

        try:
            if self.dlg.lineEdit_9.text() != 'default':
                self.it_thresh = float(self.dlg.lineEdit_9.text())
        except ValueError:
            QMessageBox.information(None, "Iteration Threshold",
                                    f'Iteration threshold needs to be a number setting to {self.it_thresh}')

        self.multi_thread = self.dlg.multiThreadCheckBox.isChecked()
        self.apu = self.dlg.apuCheckBox.isChecked()
        self.dna_dir = self.dlg.lineEdit_2.text()
        self.docker = self.dlg.dockerCheckBox.isChecked()
        if self.docker is True:
            self.mount_dir = self.dlg.mount_directory_le.text()
            self.container = self.dlg.container_le.text()
        else:
            self.mount_dir = None
            self.container = None

    def set_misclose_value(self):
        try:
            if self.dlg.lineEdit_10.text() != 'default':
                self.mis_tol = float(self.dlg.lineEdit_10.text())
            else:
                self.mis_tol = .1

        except ValueError as e:
            QMessageBox.information(None, "Misclose Tolerance", "Misclose must be a "
                                                                f"number\nSetting to {self.mis_tol}")

    def process_stn_msr(self, geom, outpath, constrainted_marks=None):
        self.get_dna_settings()
        dna_object = DNAWriters(geom,
                                output_dir=outpath, profile_location=self.profile_loc,
                                constrained_marks=constrainted_marks)
        return dna_object.write_stn_msr_file()

    def process_multi_dna(self, geoms, outpath):
        for fn in self.filenames:
            geom = geoms.get(fn)
            if self.constrained_select is not None:
                for k, v in geom.points:
                    if k not in self.constrained_select and v.ccc is True:
                        v.ccc = False
            self.process_stn_msr(geom, outpath)

        stns = sorted([os.path.join(outpath, fn) for fn in os.listdir(outpath) if fn.endswith('.stn')])
        msrs = sorted([os.path.join(outpath, fn) for fn in os.listdir(outpath) if fn.endswith('.msr')])
        dna_runner = DNARunner(self.dna_dir, multi_thread=self.multi_thread, max_iter=self.max_iter,
                               iter_thresh=self.it_thresh, output_dir=outpath, filename='grouped',
                               mount_dir=self.mount_dir, docker=self.docker, container_name=self.container,
                               host_directory=self.dlg.lineEdit_3.text(), apu=self.apu)
        dna_adj_fp = dna_runner.run_dna_via_subprocesses(msr_locations=msrs, stn_locations=stns)
        return dna_adj_fp

    def process_dna(self, geom, outpath, dna_adj_fp=None):
        self.get_dna_settings()
        if dna_adj_fp is None:
            stn_file, msr_file = self.process_stn_msr(geom, outpath)

            dna_runner = DNARunner(self.dna_dir, multi_thread=self.multi_thread, max_iter=self.max_iter,
                                   iter_thresh=self.it_thresh, output_dir=outpath, filename=geom.survey_number,
                                   mount_dir=self.mount_dir, docker=self.docker, container_name=self.container,
                                   host_directory=self.dlg.lineEdit_3.text(), apu=self.apu)
            dna_adj_fp = dna_runner.run_dna_via_subprocesses(msr_locations=msr_file, stn_locations=stn_file)

        dna_results = DNAReaders(dna_adj_fp, stn_corrections=True)
        dna_coords = dna_results.coordinates
        dna_outliers = dna_results.get_outliers()
        result = dna_results.global_stats.chi_squared_test
        dna_geom = deepcopy(geom)
        new_points = {}

        for k, v in dna_geom.points.items():
            point = dna_coords.get(k)
            if point is not None:
                v.set_new_geometry(point.geometry)
                v.crs = dna_results.crs
                new_points[k] = v
        dna_geom.crs = dna_results.crs
        dna_geom.points = new_points
        dna_geom.update_geometries()
        return dna_geom, dna_outliers, result

    def process_geoms(self):
        geoms = {}
        for fn in self.filenames:
            if fn.endswith('.xml'):
                data = landxml.parse(fn, silence=True, print_warnings=False)
                geom = Geometries(data, self.mis_tol)
                if self.recalc is True:
                    point_oids = {v.point_oid: k for k, v in geom.points.items()}
                    if self.starting_point in geom.points.keys():
                        sp = self.starting_point
                    elif str(self.starting_point) in geom.points.keys():
                        sp = str(self.starting_point)
                    elif self.starting_point in point_oids and self.starting_point is not None:
                        sp = point_oids.get(self.starting_point)
                    else:
                        sp = geom.ccc
                    geom.recalc_geometries(ref_point=sp, swing=self.swing, swing_value=self.swing_value,
                                           ignore_line_types=(
                                           'Ignored', 'Generated', 'GraphGenerated', 'BranchConnection'))

                geoms[fn] = geom
        return geoms

    def split_easements(self, polygons):
        all_ease = {}
        all_poly = {}
        for plan, polys in polygons.items():
            easements = {}
            pols = {}
            for k, v in polys.items():
                if hasattr(v, 'parcel_class'):
                    if v.parcel_class == 'Easement':
                        easements[k] = v
                    else:
                        pols[k] = v
                else:
                    pols[k] = v
            if len(pols) > 0:
                all_poly[plan] = pols
            if len(easements) > 0:
                all_ease[plan] = easements
        return all_poly, all_ease

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        # if self.first_start == True:
        #     self.first_start = False
        self.dlg = LandXML2QGISDialog()

        self.dlg.setWindowFlags(Qt.WindowStaysOnTopHint)

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()

        # See if OK was pressed
        if result:
            self.set_box_values()
            self.get_file_names()
            if len(self.filenames) > 0:
                styles = self.set_styles()
                self.set_outpaths()
                self.set_misclose_value()
                lines = {}
                arcs = {}
                dna_lines = {}
                dna_arcs = {}
                points = {}
                dna_points = {}
                polygons = {}
                admin = {}
                dna_polygons = {}
                loops = {}
                dna_loops = {}
                outliers = {}
                dna_adj_coords = {}
                dna_adj_measures = {}
                dna_adj_measures_points = {}
                result = ''

                geoms = self.process_geoms()


                if self.multi_dna is True and len(geoms) > 1:
                    outpath = self.out_paths.get('grouped')
                    outpath.mkdir(parents=True, exist_ok=True)
                    fp = self.process_multi_dna(geoms, outpath)
                else:
                    fp = None

                if self.export_eplan is True:
                    for fn in self.filenames:
                        geom = deepcopy(geoms.get(fn))
                        outpath = self.out_paths.get(fn)
                        outpath.mkdir(parents=True, exist_ok=True)
                        o = os.path.join(str(outpath), os.path.split(fn)[-1].replace('.xml', '_eplan.xml'))
                        geom.write_to_eplan_compliant_file(o)
                    QMessageBox.information(None, "Completed",
                                            'Converted to ePlan')
                if self.export_only is False:
                    for fn in self.filenames:
                        if fn.endswith('.xml'):
                            geom = deepcopy(geoms.get(fn))
                            if geom.crs != self.out_crs:
                                geom.transform_geometries(self.out_crs)
                            if self.dlg.parentGeometryCheckBox.isChecked() is True:
                                for k, polygon in geom.polygons.items():
                                    polygon.set_geometry_from_children(geom.polygons)
                                    geom.polygons[k] = polygon
                            outpath = self.out_paths.get(fn)
                            outpath.mkdir(parents=True, exist_ok=True)
                            dna_geom = None
                            dna_outliers = []
                            if self.dna is True:
                                dna_geom, dna_outliers, result = self.process_dna(geom, outpath, dna_adj_fp=fp)
                                if dna_geom.crs != self.out_crs:
                                    dna_geom.transform_geometries(self.out_crs)
                                if self.dlg.parentGeometryCheckBox.isChecked() is True:
                                    for polygon in dna_geom.polygons.values():
                                        polygon.set_geometry_from_children(dna_geom.polygons)
                                if self.dlg.lineCheckBox.isChecked() is False:
                                    dna_outliers = []
                            qgis_geoms = QGISAllObjects(geom, dna_geom, dna_outliers)
                            if self.dlg.lineCheckBox.isChecked() is True:
                                if len(qgis_geoms.lines) > 0:
                                    lines[geom.survey_number] = qgis_geoms.lines
                                if len(qgis_geoms.arcs) > 0:
                                    arcs[geom.survey_number] = qgis_geoms.arcs
                                if self.dna is True:
                                    if len(qgis_geoms.dna_lines) > 0:
                                        dna_lines[geom.survey_number] = qgis_geoms.dna_lines
                                    if len(qgis_geoms.dna_arcs) > 0:
                                        dna_arcs[geom.survey_number] = qgis_geoms.dna_arcs

                            if self.dlg.pointCheckBox.isChecked() is True:
                                if len(qgis_geoms.points) > 0:
                                    points[geom.survey_number] = qgis_geoms.points
                                if self.dna is True:
                                    dna_points[geom.survey_number] = qgis_geoms.dna_points

                            if self.dlg.adminCheckBox.isChecked() is True:
                                if len(qgis_geoms.admin) > 0:
                                    admin[geom.survey_number] = qgis_geoms.admin

                            if self.dlg.polygonCheckBox.isChecked() is True:
                                if len(qgis_geoms.polygons) > 0:
                                    polygons[geom.survey_number] = qgis_geoms.polygons
                                if self.dna is True:
                                    dna_polygons[geom.survey_number] = qgis_geoms.dna_polygons

                            if self.dlg.loopCheckBox.isChecked() is True:
                                if len(qgis_geoms.loops) > 0:
                                    loops[geom.survey_number] = qgis_geoms.loops
                                    if self.dna is True:
                                        dna_loops[geom.survey_number] = qgis_geoms.dna_loops

                            if self.dlg.outlierCheckBox.isChecked() is True:
                                if len(dna_outliers) > 0:
                                    outliers[geom.survey_number] = qgis_geoms.outliers

                        elif fn.endswith('.adj'):
                            adj_name = os.path.split(fn)[-1][:-4]
                            adj_name = adj_name.split('.')[0]
                            dna_result = DNAReaders(fn)
                            crs = dna_result.crs
                            self.out_crs = crs
                            qgis_geoms = QGISAllObjects(outliers=dna_result.get_outliers(), dna_measures=dna_result)
                            if qgis_geoms.dna_adj_coords is not None:
                                dna_adj_coords[adj_name] = qgis_geoms.dna_adj_coords
                            if qgis_geoms.dna_adj_measures is not None:
                                dna_adj_measures[adj_name] = qgis_geoms.dna_adj_measures
                            if qgis_geoms.dna_adj_measures_points is not None:
                                dna_adj_measures_points[adj_name] = qgis_geoms.dna_adj_measures_points

                    p = None
                    if len(admin) > 0 and self.only_dna is False:
                        layer_styles = [v for k, v in styles.items() if 'admin' in k and 'dna' not in k]
                        QGISLayer(admin, layer_type='MultiPolygon', styles=layer_styles, process=True, suffix='Admin',
                                  crs=self.out_crs)

                    poly_fields = ['key', 'ob_name', 'polygon_notations', 'parcel_use',
                                                       'parcel_type', 'parcel_state', 'stated_area', 'parcel_class',
                                                       'misclose_distance', 'misclose_bearing', 'name', 'calc_area',
                                                       'sum_of_distances', 'misclose_tolerance', 'closed']
                    if len(polygons) > 0 and self.only_dna is False:
                        all_poly, all_ease = self.split_easements(polygons)
                        if len(all_poly) > 0:
                            layer_styles = [v for k, v in styles.items() if 'pol' in k and 'dna' not in k]
                            QGISLayer(all_poly, layer_type='MultiPolygon', styles=layer_styles,
                                      process=True, suffix='Polygons', fields_to_keep=poly_fields,
                                  crs=self.out_crs)
                        if len(all_ease) > 0:
                            layer_styles = [v for k, v in styles.items() if 'ease' in k and 'dna' not in k]
                            QGISLayer(all_ease, layer_type='MultiPolygon', styles=layer_styles, process=True,
                                      suffix='Easements',
                                      fields_to_keep=poly_fields,
                                  crs=self.out_crs)
                    if len(loops) > 0 and self.only_dna is False:
                        layer_styles = [v for k, v in styles.items() if 'loop' in k and 'dna' not in k]
                        QGISLayer(loops, layer_type='MultiLineString', styles=layer_styles,
                                  process=True, suffix='Loops', crs=self.out_crs)
                    if len(lines) > 0 and self.only_dna is False:
                        layer_styles = [v for k, v in styles.items() if 'lin' in k and 'dna' not in k]
                        QGISLayer(lines, layer_type='LineString', styles=layer_styles, process=True, suffix='Lines',
                                  crs=self.out_crs)
                    if len(arcs) > 0 and self.only_dna is False:
                        layer_styles = [v for k, v in styles.items() if 'arc' in k and 'dna' not in k]
                        QGISLayer(arcs, layer_type='LineString', styles=layer_styles, process=True, suffix='Arcs',
                                  crs=self.out_crs)
                    if len(points) > 0 and self.only_dna is False:
                        layer_styles = [v for k, v in styles.items() if 'poi' in k and 'dna' not in k]
                        QGISLayer(points, layer_type='Point', styles=layer_styles, process=True, suffix='Points',
                                  crs=self.out_crs, fields_to_remove=['vertical_position', 'horizontal_position'])

                    if len(outliers) > 0:
                        layer_styles = [v for k, v in styles.items() if 'out' in k and 'dna' in k]
                        QGISLayer(outliers, layer_type='LineString', styles=layer_styles, process=True,
                                  suffix=f'DNA_Outliers_{result}', crs=self.out_crs)

                    if len(dna_loops) > 0:
                        layer_styles = [v for k, v in styles.items() if 'loop' in k and 'dna' not in k]
                        QGISLayer(dna_loops, layer_type='MultiLineString', styles=layer_styles, process=True,
                                  suffix='DNA_Loops', crs=self.out_crs)

                    if len(dna_lines) > 0:
                        layer_styles = [v for k, v in styles.items() if 'lin' in k and 'dna' in k]
                        QGISLayer(dna_lines, layer_type='LineString', styles=layer_styles, process=True,
                                  suffix=f'DNA_Lines_{result}', crs=self.out_crs)
                    if len(dna_arcs) > 0:
                        layer_styles = [v for k, v in styles.items() if 'arc' in k and 'dna' in k]
                        QGISLayer(dna_arcs, layer_type='LineString', styles=layer_styles, process=True,
                                  suffix=f'DNA_Arcs_{result}', crs=self.out_crs)
                    if len(dna_points) > 0:
                        layer_styles = [v for k, v in styles.items() if 'poi' in k and 'dna' in k]
                        QGISLayer(dna_points, layer_type='Point', styles=layer_styles, process=True,
                                  suffix=f'DNA_Points_{result}', crs=self.out_crs)
                    if len(dna_polygons) > 0:
                        dna_pols, dna_easements = self.split_easements(dna_polygons)
                        layer_styles = [v for k, v in styles.items() if 'pol' in k and 'dna' in k]
                        QGISLayer(dna_pols, layer_type='MultiPolygon', styles=layer_styles, process=True,
                                  suffix=f'DNA_Polygons_{result}', crs=self.out_crs, fields_to_keep=poly_fields)
                        if len(dna_easements) > 0:
                            layer_styles = [v for k, v in styles.items() if 'ease' in k and 'dna' in k]
                            QGISLayer(dna_easements, layer_type='MultiPolygon', styles=layer_styles, process=True,
                                      suffix=f'DNA_Easements_{result}', crs=self.out_crs, fields_to_keep=poly_fields)

                    if len(dna_adj_coords) > 0:
                        layer_styles = [v for k, v in styles.items() if 'poi' in k and 'adj' in k]
                        QGISLayer(dna_adj_coords, layer_type='Point', styles=layer_styles, process=True,
                                  suffix=f'DNA_AdjCoords', crs=self.out_crs)

                    if len(dna_adj_measures) > 0:
                        layer_styles = [v for k, v in styles.items() if 'lin' in k and 'adj' in k]
                        QGISLayer(dna_adj_measures, layer_type='LineString', styles=layer_styles, process=True,
                                  suffix=f'DNA_AdjMeasures', crs=self.out_crs)

                    if len(dna_adj_measures_points) > 0:
                        layer_styles = [v for k, v in styles.items() if 'poi' in k and 'adj' in k]
                        QGISLayer(dna_adj_measures_points, layer_type='Point', styles=layer_styles, process=True,
                                  suffix=f'DNA_AdjMeasuresPoints_PQs', crs=self.out_crs,
                                  fields_to_remove=['vertical_position', 'horizontal_position'])

                    # self.iface.mapCanvas().refresh()
                    # if p is not None:
                    #     ext = p.vl.extent()
                    #     self.iface.mapCanvas().setExtent(ext)
                    #     self.iface.mapCanvas().refresh()
                    del geoms
        self.save_settings()
