import os
from enum import Enum


class LandsklimLayerType(Enum):
    """
    Enumerate the Landsklim Layer Types used to tag QgsMapLayer
    """
    ExplicativeVariable = 'expl_variables'
    """
    Layer who represents a regressor
    """
    Polygons = 'polygons'
    """
    Layer who represents polygons
    """
    AdditionalLayer = 'additional_layer'
    """
    Layer who represents intermediate raster used to compute regressors
    """
    Interpolation = 'interpolation'
    """
    Layer who represents an interpolation
    """
    Kriging = 'kriging'
    """
    Layer who represents kriging
    """
    NotDefined = ''
    """
    Undefined layer
    """

    def __str__(self):
        return str(self.value)


LANDSKLIM_ANALYSIS_PATH = "{0}{1}{2}{1}{3}".format("interpolations", os.sep, "{0}", "{1}")  # Placeholders for Configuration, Analysis
"""
Represents the relative path of an analysis 
"""

LAYER_TYPE_PATH = {
    LandsklimLayerType.ExplicativeVariable: "regressors{0}source{0}".format(os.sep),
    LandsklimLayerType.Polygons:            LANDSKLIM_ANALYSIS_PATH, # "regressors{0}Fich_Polygons{0}".format(os.sep),
    LandsklimLayerType.AdditionalLayer:     "regressors{0}additional{0}".format(os.sep),
    LandsklimLayerType.Interpolation:       "{0}{1}{2}{1}{3}".format(LANDSKLIM_ANALYSIS_PATH.format("{0}", "{1}"), os.sep, "{2}", "{3}"),  # Placeholders for Configuration, Analysis, Interpolation, Phase
    LandsklimLayerType.Kriging:             "{0}".format(LANDSKLIM_ANALYSIS_PATH.format("{0}", "{1}")),  # Placeholders for Configuration, Analysis
    LandsklimLayerType.NotDefined:          ""
}
"""
Store path where layers are saved for each layer types
"""

DATASET_RESPONSE_VARIABLE = "Response"
"""
Name of the dataframe columns containing response variable
"""
DATASET_COLUMN_X = "X"
"""
Name of the dataframe columns containing X coordinates of points for prediction.
These coordinates are optional and are now only used for kriging
"""
DATASET_COLUMN_Y = "Y"
"""
Name of the dataframe columns containing Y coordinates of points for prediction
These coordinates are optional and are now only used for kriging
"""
