import abc
from landsklim.processing.landsklim_processing_algorithm import LandsklimProcessingAlgorithm


class LandsklimProcessingToolAlgorithm(LandsklimProcessingAlgorithm):
    """
    Abstract processing algorithm specifying algorithm as a tool
    """

    @abc.abstractmethod
    def createInstance(self):
        raise NotImplementedError()

    @abc.abstractmethod
    def name(self) -> str:
        """
        Unique name of the algorithm
        """
        raise NotImplementedError()

    @abc.abstractmethod
    def displayName(self) -> str:
        """
        Displayed name of the algorithm
        """
        raise NotImplementedError()

    def group(self) -> str:
        return self.tr('Tools')

    def groupId(self) -> str:
        return 'tools'

    @abc.abstractmethod
    def shortHelpString(self) -> str:
        raise NotImplementedError()

    @abc.abstractmethod
    def initAlgorithm(self, config=None):
        raise NotImplementedError()

    @abc.abstractmethod
    def processAlgorithm(self, parameters, context, feedback):
        raise NotImplementedError()
