from typing import List, Optional
import os

from qgis.core import QgsApplication
from qgis.core import QgsRasterLayer
from qgis.core import QgsProject

from landsklim.lk.regressor import Regressor
from landsklim.processing.algorithm_altitude import AltitudeProcessingAlgorithm
from landsklim.lk.map_layer import RasterLayer


class RegressorRasterVariable(Regressor):

    @staticmethod
    def class_name() -> str:
        return "REGRESSOR_RASTER_VARIABLE"

    @staticmethod
    def min_window() -> int:
        return 1

    def __init__(self, windows: int, polynomial_degree: int, source_raster: RasterLayer):
        super().__init__(windows, polynomial_degree)
        self.__source_raster: RasterLayer = source_raster
        self.__prefix: str = source_raster.qgis_layer().name()

    def specific_source_raster(self) -> Optional[RasterLayer]:
        return self.__source_raster

    def prefix(self) -> str:
        return self.__prefix

    def name(self) -> str:
        return self.__prefix

    def compute(self, source_raster: QgsRasterLayer):
        from qgis import processing

        raster_path, exists = self._create_path()

        if not exists:
            params = {
                'INPUT': source_raster,
                'INPUT_WINDOW': self.get_windows(),
                'INPUT_CUSTOM_NO_DATA': None,
                'OUTPUT': raster_path
            }
            processing.run("landsklim:altitude", params)

