from typing import List
import os

import numpy as np
from PyQt5.QtCore import QDate
from qgis.core import QgsRasterLayer, QgsProject
from qgis import processing

from landsklim.lk.regressor import Regressor
from landsklim.lk.landsklim_constants import LAYER_TYPE_PATH, LandsklimLayerType
from landsklim.lk.regressor_orientation import RegressorOrientation
from landsklim.lk.regressor_slope import RegressorSlope
from landsklim.processing.algorithm_radiation import RadiationProcessingAlgorithm


class RegressorRadiation(Regressor):

    def __init__(self, windows: int, polynomial_degree: int):
        super().__init__(windows, polynomial_degree, [])

    @staticmethod
    def class_name() -> str:
        return "REGRESSOR_RADIATION"

    @staticmethod
    def min_window() -> int:
        return 5

    def prefix(self) -> str:
        return "rglob"

    def name(self) -> str:
        return Regressor.tr("Solar irradiance")

    def compute(self, source_raster: QgsRasterLayer):
        raster_path, exists = self._create_path()

        project_path = self.project_path()

        #TODO: meh
        from landsklim.landsklim import Landsklim
        year, month, day = Landsklim.instance().get_landsklim_project().get_date()

        if not exists:
            from landsklim.lk.regressor_factory import RegressorFactory
            source_orientation = RegressorFactory.get_regressor(RegressorOrientation.class_name(), self.get_windows(), 1).get_path()
            source_slope = RegressorFactory.get_regressor(RegressorSlope.class_name(), self.get_windows(), 1).get_path()

            params = {
                'INPUT': source_raster,
                RadiationProcessingAlgorithm.INPUT_ORIENTATION: source_orientation,
                RadiationProcessingAlgorithm.INPUT_SLOPE: source_slope,
                'INPUT_WINDOW': self.get_windows(),
                'INPUT_CUSTOM_NO_DATA': None,
                'ADDITIONAL_VARIABLES_FOLDER': os.path.join(project_path, LAYER_TYPE_PATH[LandsklimLayerType.AdditionalLayer]),
                'INPUT_DATE': QDate(year, month, day),
                'OUTPUT': raster_path
            }
            processing.run("landsklim:radiation", params)
