from typing import List
import os
import numpy as np

from qgis.core import QgsApplication
from qgis.core import QgsRasterLayer
from qgis.core import QgsProject

from landsklim.lk.landsklim_constants import LAYER_TYPE_PATH, LandsklimLayerType
from landsklim.lk.regressor import Regressor
from landsklim.processing.algorithm_ampl import AmplitudeProcessingAlgorithm


class RegressorAmplitudeThalweg(Regressor):

    @staticmethod
    def class_name() -> str:
        return "REGRESSOR_AMPLITUDE_THALWEG"

    @staticmethod
    def min_window() -> int:
        return 5

    def __init__(self, windows: int, polynomial_degree: int):
        super().__init__(windows, polynomial_degree)

    def prefix(self) -> str:
        return "amplc"

    def name(self) -> str:
        return Regressor.tr("Amplitude of thalweg")

    def compute(self, source_raster: QgsRasterLayer):
        from qgis import processing

        raster_path, exists = self._create_path()
        project_path = self.project_path()
        cb_path: str = os.path.join(project_path, LAYER_TYPE_PATH[LandsklimLayerType.AdditionalLayer], "CB_{0}.tif".format(self.get_windows()))
        if not exists:
            if not os.path.exists(cb_path):
                params = {
                    'INPUT': source_raster,
                    'INPUT_WINDOW': self.get_windows(),
                    'INPUT_CUSTOM_NO_DATA': None,
                    'OUTPUT': cb_path
                }
                processing.run("landsklim:crestthalweg", params)

            params = {
                'INPUT': source_raster,
                'INPUT_WINDOW': self.get_windows(),
                'INPUT_CUSTOM_NO_DATA': None,
                AmplitudeProcessingAlgorithm.INPUT_CREST_THALWEG: cb_path,
                AmplitudeProcessingAlgorithm.INPUT_CODE: AmplitudeProcessingAlgorithm.CODE_THALWEG,
                'OUTPUT': raster_path
            }
            processing.run("landsklim:amplitude", params)
