from typing import List, Optional, Type

from landsklim.lk.phase import IPhase
from landsklim.lk.phase_polynomial import PhasePolynomial
from landsklim.lk.phase_multiple_regression import PhaseMultipleRegression
from landsklim.lk.phase_kriging import PhaseKriging
from landsklim.lk.phase_composite import PhaseComposite


class PhaseFactory:

    @staticmethod
    def get_phase(phase_name: str, **kwargs) -> IPhase:
        registered_classes: List[Type[IPhase]] = [PhaseMultipleRegression, PhasePolynomial, PhaseKriging, PhaseComposite]
        phase: Optional[IPhase] = None
        for phase_class in registered_classes:  # type: IPhase
            if phase_name == phase_class.class_name():
                phase = phase_class(**kwargs)
        return phase
