# -*- coding: utf-8 -*-

import logging

from qgis._core import QgsMessageLog, QgsApplication, Qgis

logger = logging.getLogger(__name__)
logger.setLevel(logging.INFO)


class Log:
    """
    Gives Landsklim logs functions
    """

    # 1: Through Logger
    # 2: Through print
    output_mode: int = 2
    qgs_logger = None
    tag_name: str = "Landsklim"
    level_map = {Qgis.MessageLevel.Info: logging.INFO,
                 Qgis.MessageLevel.Warning: logging.WARNING,
                 Qgis.MessageLevel.Critical: logging.CRITICAL,
                 Qgis.MessageLevel.NoLevel: logging.DEBUG}

    @staticmethod
    def __qgs_logger() -> QgsMessageLog:
        if Log.qgs_logger is None:
            Log.qgs_logger = QgsApplication.messageLog()
        return Log.qgs_logger

    @staticmethod
    def __log(level: int, *messages: str):
        if Log.output_mode == 1:
            try:
                Log.__qgs_logger().logMessage(Log.__message(*messages), tag=Log.tag_name, level=level, notifyUser=False)
            except AttributeError as ae:
                print(*messages)
        elif Log.output_mode == 2:
            print(*messages)

    @staticmethod
    def __message(*messages: str) -> str:
        pr: str = ""
        if len(messages) == 1 and not isinstance(type(messages[0]), str):
            pr = "\n"
        items = [str(message) for message in messages]
        return pr + " ".join(items)

    @staticmethod
    def info(*messages: str):
        Log.__log(Qgis.MessageLevel.Info, *messages)

    @staticmethod
    def warning(*messages: str):
        Log.__log(Qgis.MessageLevel.Warning, *messages)

    @staticmethod
    def critical(*messages: str):
        Log.__log(Qgis.MessageLevel.Critical, *messages)

    @staticmethod
    def on_message(message, tag, level):
        if tag == Log.tag_name:
            logger.log(Log.level_map[level], message)
