import os

from typing import List, Dict, Tuple

from qgis.PyQt import uic
from landsklim.lk.regressor_factory import RegressorFactory, RegressorDefinition
from landsklim.ui.utils import LandsklimTableModel, LandsklimTableColumnType
from landsklim.ui.landsklim_dialog import LandsklimDialog

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'view_new_configuration.ui'))


class ViewNewConfiguration(LandsklimDialog, FORM_CLASS):
    """
    Represents the new configuration dialog
    """
    def __init__(self, parent=None):
        """Constructor."""
        super(ViewNewConfiguration, self).__init__(parent)

    def get_regressors_data(self):
        table = []
        for regressor in self.get_plugin_instance().get_available_regressors():  # type: RegressorDefinition
            table.append([regressor.regressor_name, ", ".join([str(i) for i in regressor.windows])])
        return table

    def init_ui(self):
        """
        Init UI components
        """
        table = self.get_regressors_data()
        headers = [self.tr("Variable"), self.tr("Window sizes (in pixels)")]
        columns_type = [LandsklimTableColumnType.COLUMN_LABEL, LandsklimTableColumnType.COLUMN_WINDOWS]
        table_model = LandsklimTableModel(labels=table, data=table, headers=headers, columns_type=columns_type)
        self.table_windows.setModel(table_model)
        self.groupBoxVariables.hide()  # TODO: Remove self.table_windows from ui

    def input_are_valid(self) -> Tuple[bool, List[str]]:
        """
        Check if user inputs are valid
        """
        errors = []
        is_ok = True
        if self.get_configuration_name() == "" or "[" in self.get_configuration_name() or "]" in self.get_configuration_name():
            is_ok = False
            errors.append("ERROR_INVALID_NAME")
        return is_ok, errors

    def refresh_ui(self):
        """
        Refresh UI components after a specific action was triggered
        """
        pass

    def get_configuration_name(self) -> str:
        """
        Name of the configuration
        """
        return self.le_name.text()
