from typing import List
import os

from qgis.core import QgsRasterLayer, QgsProject
from qgis import processing

from landsklim.lk.regressor import Regressor
from landsklim.lk.landsklim_constants import LAYER_TYPE_PATH, LandsklimLayerType


class RegressorSlope(Regressor):

    def __init__(self, windows: int, polynomial_degree: int):
        super().__init__(windows, polynomial_degree, ["local_min", "local_max", "a0", "a1"])
        # super(Regressor).__init__(windows)

    @staticmethod
    def class_name() -> str:
        return "REGRESSOR_SLOPE"

    @staticmethod
    def min_window() -> int:
        return 3

    def prefix(self) -> str:
        return "slope"

    def name(self) -> str:
        return Regressor.tr("Slope")

    def compute(self, source_raster: QgsRasterLayer):
        raster_path, exists = self._create_path()

        project_path = self.project_path()

        if not exists:
            params = {
                'INPUT': source_raster,
                'INPUT_WINDOW': self.get_windows(),
                'INPUT_CUSTOM_NO_DATA': None,
                'ADDITIONAL_VARIABLES_FOLDER': os.path.join(project_path, LAYER_TYPE_PATH[LandsklimLayerType.AdditionalLayer]),
                'OUTPUT': raster_path
            }
            processing.run("landsklim:slope", params)
