from typing import Dict, Any, Union, Optional

import numpy as np
from PyQt5.QtCore import QCoreApplication

from landsklim.lk.logger import Log

try:
    import pandas as pd
except ImportError:
    Log.critical("pandas not available")

from landsklim.lk.phase import IPhase


class PhasePolynomial(IPhase):
    """
    :param degree: polynomial degree
    :type degree: int
    """

    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        self._degree: int = kwargs["degree"]

    @staticmethod
    def class_name() -> str:
        return "PHASE_POLYNOMIAL"

    @staticmethod
    def name() -> str:
        return QCoreApplication.translate("Landsklim", "Polynomial")

    def get_adjusted_r2(self) -> float:
        raise NotImplementedError

    def get_formula(self, unstandardized: bool) -> str:
        raise NotImplementedError

    def get_residuals_standard_deviation(self) -> float:
        raise NotImplementedError

    def compute_each_variable_correlation(self) -> float:
        raise NotImplementedError

    def construct_model(self, dataset: "pd.DataFrame"):
        self._dataset = dataset

    def predict(self, points: "pd.DataFrame", extrapolation_margin: Optional[float] = None, no_data: Union[int, float] = None) -> np.ndarray:
        raise NotImplementedError

    def get_kwargs(self) -> Dict[str, Any]:
        return {"degree": self._degree}
